#include "XMLparser.h"
#include <dbg.h>

void InitTag(char *name, tag_t *tag) 
{
    if (name != NULL) {
        strcpy(tag->name, "<");
        strcat(tag->name, name);
    }

    tag->ptag = NULL;
}

void CloseTag(tag_t *tag) 
{
    if (tag->ptag != NULL) {
        suFreeMem(tag->ptag);
        tag->ptag = NULL;
    }
}

char* ReadTag(char *buffer, tag_t *tag)
{
	char	*buf;
	UINT32  i=0, j=0, n=0, k=0;
	UINT8	parse_mode=MODE_NAME;
    INT32   err;
    

    if (buffer == NULL || buffer[0] == 0) return NULL;
	
	buf = strstr( buffer, tag->name );
    if (buf == buffer ) return NULL; //  

	buf = buf + strlen(tag->name);


	tag->count_ptags = 0;
	
	//  - 
	while (buf[i] != '>') {
		if (buf[i] == '=') tag->count_ptags++;
		i++;
	}

    dbg("tag->count_ptags = %d\n", tag->count_ptags);
	
	tag->ptag = (ptag_t*)suAllocMem(sizeof(ptag_t)*tag->count_ptags, &err);
    if (err != 0) return NULL;

	
	for (k=0; k < i; k++) {
		if (buf[k] == ' ' || buf[k] == '/') continue; // 
	
		if (parse_mode == MODE_NAME) {
			if (buf[k] == '=') {j=0; parse_mode = MODE_STRING; continue;}
				tag->ptag[n].name[j] = buf[k];
				tag->ptag[n].name[j+1] = 0;
                dbg("name = %s\n", tag->ptag[n].name);
				j++;
		} else if (parse_mode == MODE_STRING) {
			if (buf[k] == '"' && j==0) continue;
			if (buf[k] == '"') { j=0; parse_mode = MODE_NAME; n++; continue;}
			tag->ptag[n].string[j] = buf[k];
			tag->ptag[n].string[j+1] = 0;
            dbg("string = %s\n", tag->ptag[n].string);
			j++;
		}
	}
	
	return buf+k;
}

char* GetPTagString(tag_t tag, char *name_ptag) 
{	
	INT32	i;

    if (tag.ptag == NULL || name_ptag == NULL) return NULL;
	
	for (i=0; i < tag.count_ptags; i++) {
		if (!strcmp(tag.ptag[i].name, name_ptag)) return tag.ptag[i].string;
	}
	
	return NULL;
} 
