#ifndef ELFAPP_H
#define ELFAPP_H


#include <apps.h>
#include <synsock_api.h>
#include <weather_api.h>
#include "XMLparser.h"

#define TIME_CHECK   60000 //    

typedef struct
{ 
	APPLICATION_T	apt; /*   ,   */

} APP_ELF;

/*   */
typedef enum
{
	HW_STATE_ANY, /* ANY-state   */

	HW_STATE_MAIN,

	HW_STATE_MAX /*   */
} HW_STATES_T;



#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 


UINT32 Register( char* file_uri,  char* param,  UINT32 reserve );

UINT32 ELF_Start( EVENT_STACK_T *ev_st, REG_ID_T reg_id, void * reg_hdl );
UINT32 ELF_Exit( EVENT_STACK_T *ev_st,  void *app );

UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app );

UINT32 HandleAPIAnsw( EVENT_STACK_T *ev_st, void *app );
UINT32 HandleSockAnsw( EVENT_STACK_T *ev_st, void *app );

UINT32 HandleIfaceReq( EVENT_STACK_T * ev_st, void * app );

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app );

UINT32 LoadFile(void);
UINT32 Update(void);
UINT32 NetworkReg( EVENT_STACK_T *ev_st, void *app );
UINT32 Weather_getForecast(WCHAR *buf, UINT8 num);
UINT32 Weather_getTemperature(WCHAR *buf, UINT8 num);
UINT32 Weather_getPhenomena(WCHAR *buf, UINT8 num);
UINT32 Weather_getWind(WCHAR *buf, UINT8 num);


#ifdef __cplusplus
}
#endif /* __cplusplus */ 


#endif