
#define DEBUG_APP_NAME				"Weather"

#include "Weather.h"
#include "INIparser.h"
#include "LNGparser.h"
#include <dbg.h>

//    
BOOL update1;
BOOL update2;
BOOL update3;


#define HTTP_HOST			"informer.gismeteo.ru"
#define HTTP_USER_AGENT		"WeatherApp/1.1"

//    
socket_f *				socket = NULL;
socket_connect_f *		socket_connect = NULL;
socket_write_f *		socket_write = NULL;
socket_read_f *			socket_read = NULL;
socket_bind_f *			socket_bind = NULL;
socket_close_f *		socket_close = NULL;
socket_delete_f *		socket_delete = NULL;

FILE_HANDLE_T   f;
HSOCK			g_socket;

char    *buffer=NULL;
UINT32  rlen=0; //  
UINT32  content_len=1024*3; //   

WCHAR   ELF_folder[256]; //  
char    ID[8] =  "27612"; //  - 
BOOL    AutoUpdate = false; // 
BOOL    update=false; //  

/*  .        */
const char app_name[APP_NAME_LEN] = DEBUG_APP_NAME;

//   http  2   ,     ,
//     GET  ,    
//  POST       "Content-Length",    
//char sock_write_data[128];


//     state-

/*    HW_STATE_ANY (   state) */
static EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{
	{ EV_KEY_PRESS,			         HandleKeypress },
    { WEATHER_MGR_MAIN_REGISTER,     HandleIfaceReq },


	//      
	{ STATE_HANDLERS_END,		NULL				},
};

static EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
	{ STATE_HANDLERS_RESERVED,	HandleAPIAnsw		},	//      socket api. (evcode_base + 0)
	{ STATE_HANDLERS_RESERVED,	HandleSockAnsw		},	//      . (evcode_base + 1)
    { EV_TIMER_EXPIRED,       	Timer               },
    { EV_REG_NETWORK,           NetworkReg          },
    { STATE_HANDLERS_END,		NULL				},
};

/*   ,    -  .
	   ,   enum-e */
const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
	{ HW_STATE_ANY,			// State
	  NULL,					//    state
	  NULL,					//    state
	  any_state_handlers	//   
	},

	{ HW_STATE_MAIN,
	  MainStateEnter,
	  NULL,
	  main_state_handlers
	}
};

UINT32 LdrFindEventHandlerTbl( EVENT_HANDLER_ENTRY_T *tbl,  EVENT_HANDLER_T *hfn )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].hfunc==hfn)	
			return tbl[i].code;

		i++;
	}

	return 0;
}

UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T *tbl,  UINT32 *base )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].code==STATE_HANDLERS_RESERVED)	
			tbl[i].code = (*base)++;

		i++;
	}
	return *base;
}

/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char * file_uri, char * param, UINT32 reserve )
{
	UINT32          status = RESULT_OK;
    WCHAR		    c_ini_uri[256];
    UINT32			evcode_base;
    UINT32          i;
    char            tmp_buf[2];

    u_atou(file_uri, ELF_folder);
    for (i=u_strlen(ELF_folder)-1; i > 0 ; i--){
            if (ELF_folder[i] == '/') break;
            ELF_folder[i] = 0;
    }

    //   
    u_atou(file_uri, c_ini_uri);
	c_ini_uri[u_strlen(c_ini_uri)-3] = 0;
	u_strcat(c_ini_uri, L"ini");	

    OpenINI(c_ini_uri);
    setSeparator('=');
    ReadParamINI("ID", ID, 8, "27612");
    dbg("ID = %s", ID);
    ReadParamINI("AutoUpdate", tmp_buf, 2, "0");
     dbg("AutoUpdate = %s", tmp_buf);
    if (tmp_buf[0] == '1') {
        AutoUpdate = true;
    }
    
    CloseINI();

    //    
    c_ini_uri[u_strlen(c_ini_uri)-3] = 0;
	u_strcat(c_ini_uri, L"lng");

    ReadLang(c_ini_uri);

    //  
	evcode_base = reserve; 
	LdrInitEventHandlersTbl((EVENT_HANDLER_ENTRY_T *)main_state_handlers, &evcode_base);

    /*   */
	status = APP_Register( &evcode_base,			//      
						   1,						// - ,     
						   state_handling_table,	//  
						   HW_STATE_MAX,			//  
						   (void*)ELF_Start );		// ,   


	LdrStartApp(evcode_base);	//  

	
	return 1;				//    ,  
}


UINT32 ELF_Start( EVENT_STACK_T *ev_st, REG_ID_T reg_id, void * reg_hdl )
{
	APP_ELF	*	app = NULL;
	UINT32		status = RESULT_OK;
	
	dbg("ELF_Start: Enter", NULL);
	
	if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK ) {
		return RESULT_FAIL; //     
	} else {


		app = (APP_ELF *)APP_InitAppData( (void *)APP_HandleEventPrepost,	//    
												sizeof(APP_ELF),			//   
												reg_id,
												0, 1,
												0,
												2, 0, 0 );

		dbg("ELF_Start: APP_InitAppData DONE, app = 0x%p", app);
		status = APP_Start( ev_st,
							&app->apt,
							HW_STATE_MAIN, //  
							state_handling_table,
							ELF_Exit,
							app_name,
							0 );
		dbg("ELF_Start: APP_Start DONE, status = %d", status);

            if (AutoUpdate) {
                APP_UtilStopTimer(app);
                APP_UtilStartCyclicalTimer( TIME_CHECK,  0,  app );
            }
		
		g_socket = HSOCK_INVALID;
	}

	dbg("ELF_Start: END", NULL);
	
	return RESULT_OK;
}


/*     */
UINT32 ELF_Exit( EVENT_STACK_T *ev_st, void *app )
{
	UINT32 status;

	dbg("ELF_Exit: Enter", NULL);

    APP_UtilStopTimer(app);

    rlen = 0;
    free(buffer);
    if ( g_socket != HSOCK_INVALID ) {
            //  
            status = socket_close( g_socket );
			dbg("socket_close DONE, status = %d", status);
			status = socket_delete( g_socket );
			dbg("socket_delete DONE, status = %d", status);
	}
    DL_FsCloseFile(f);

    CloseLang();
	
	/*    */
	status = APP_Exit( ev_st,(APPLICATION_T*) app, NULL );
	dbg("ELF_Exit: APP_Exit DONE, status = %d", status);
	
	dbg("ELF_Exit: call LdrUnloadELF... END", NULL);
	/*   */
	LdrUnloadELF(&Lib); // &Lib    
	
	return status;
}

//     
UINT32 HandleIfaceReq( EVENT_STACK_T * ev_st, void * app )
{
	EVENT_T *			event = AFW_GetEv(ev_st);
	ADD_EVENT_DATA_T	add_data;
	UINT32				ev_cb;
	
	ev_cb = event->data.params[0];
	if ( ev_cb != 0 ) {
		add_data.data_tag = 0;
		add_data.data.params[0] = (UINT32)Weather_getForecast;
		add_data.data.params[1] = (UINT32)Weather_getTemperature;
        add_data.data.params[2] = (UINT32)Weather_getPhenomena;
        add_data.data.params[3] = (UINT32)Weather_getWind;
       

		AFW_CreateInternalQueuedEvAuxD(ev_cb,&add_data,FBF_LEAVE,0,NULL);
	}
	
	return RESULT_OK;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T * ev_st, void * app, ENTER_STATE_TYPE_T type )
{
	ADD_EVENT_DATA_T	add_data;
	dbg("MainStateEnter: type = %d, app = 0x%p", type, app);


	
	//  API  SynSock
	add_data.data_tag = 0;
	add_data.data.params[0] = LdrFindEventHandlerTbl( main_state_handlers, HandleAPIAnsw );		//      
	SockReqAPI(add_data);

    
	
	return RESULT_OK;
}


UINT32 HandleAPIAnsw( EVENT_STACK_T * ev_st, void * app )
{
	EVENT_T *	event = AFW_GetEv(ev_st);
	int			i;
	
	dbg("APIAnsw: Enter", NULL);
	
	APP_ConsumeEv( ev_st, app );
	
	socket = (socket_f *)(event->data.params[0]);
	socket_connect = (socket_connect_f *)(event->data.params[1]);
	socket_write = (socket_write_f *)(event->data.params[2]);
	socket_read = (socket_read_f *)(event->data.params[3]);
	socket_bind = (socket_bind_f *)(event->data.params[4]);
	socket_close = (socket_close_f *)(event->data.params[5]);
	socket_delete = (socket_delete_f *)(event->data.params[6]);
	
	// ,    .  ,    
	for ( i=0; i<7; i++ ) {
		if ( event->data.params[i] == NULL ) {
			return ELF_Exit(ev_st,app);
		}
	}

    //
    LoadFile();
	
	return RESULT_OK;
}

UINT32 HandleSockAnsw( EVENT_STACK_T *ev_st, void *app )
{
    UINT32      status;
	EVENT_T *	event = AFW_GetEv(ev_st);
	UINT32		answ = event->data.params[0];
    char        request[128];
	char 		*data;
    UINT32		wr, w;
    INT32       len;
    char        cont_len[16];
    UINT32      i;

	
	if ( answ == SOCK_ANSW_CREATE ) {
		//  
		dbg("SockAnsw: CREATE, status = %d", event->data.params[1]);

        //    
        free(buffer);
        rlen=0;
        content_len = 1024*3;
        buffer = (char*)malloc(content_len);
        memset(buffer , 0, content_len);

        //  
        if ( g_socket != HSOCK_INVALID ) {
				if ( socket_connect(g_socket, HTTP_HOST, 80) != -1 ) {
					dbg("socket_connect OK...", NULL);
				} else {
					dbg("socket_connect ERROR", NULL);
				}
		}
		
	} else if ( answ == SOCK_ANSW_READY ) {
		//    
		dbg("SockAnsw: READY", NULL);

        //    
        if ( g_socket != HSOCK_INVALID ) {

            strcpy(request, "GET /xml/");
            strcat(request, ID); //  
            strcat(request, "_1.xml HTTP/1.1\r\n");
            strcat(request, "Host: " HTTP_HOST "\r\n");
            strcat(request, "User-Agent: " HTTP_USER_AGENT "\r\n\r\n");
            data = (char*)request;

                len = strlen(data);		//  
				while ( len > 0 ) {
					wr = socket_write(g_socket, data, len);
					dbg("socket_write DONE, %d", wr);
					if ( wr == -1 ) {
						//   
						dbg("socket is not ready %d", g_socket);
						break;
					} else if ( wr == 0 && len > 0 ) {
						//  ...
						dbg("can't write to socket", NULL);
						break;
					}
					len -= wr;
					data+= wr;
				}
		}
		
	} else if ( answ == SOCK_ANSW_DATA ) {
		//  
		dbg("SockAnsw: DATA", NULL);
		
		if ( g_socket != HSOCK_INVALID ) {
            rlen=0;
			len = content_len;
			while ( len > 0 ) {
				len = socket_read( g_socket, buffer+rlen, content_len );
                data = buffer+rlen;
                
				if ( len > 0 ) {
                    if (strncmp(data, "HTTP/1.1 200 OK", 15)) {
                        DL_FsWriteFile( data, 1, len, f, &w);
                        dbg("write = %d", w);
                        rlen += len;
                        dbg("rlen = %d", rlen);
                    } else {
                        setBuffer(data);
                        setSeparator(':');
                        //  ,      
                        //   <?xml
                        ReadParamINI("Content-Length", cont_len, 16, "0");
                        content_len = strtoul(cont_len, NULL, 10);
                        dbg("content_len = %d", content_len);

                        for (i=0; i+3 < len; i++) {
                            if (data[i] == 0x0D && data[i+1] == 0x0A && data[i+2] == 0x0D && data[i+3] == 0x0A) {
                                DL_FsWriteFile( data+i+4, 1, len-(i+3), f, &w);
                                dbg("write = %d", w);
                                rlen += len-(i+3);
                                dbg("rlen = %d", rlen);
                            }
                        }

                    }

                        dbg("socket_read DONE, len = %d\n", len);
                        dbg("data:\n%s\n", data);
                }

                if (rlen >= content_len ) {
                            DL_FsCloseFile(f);
                            //  
                            status = socket_close( g_socket );
                			dbg("socket_close DONE, status = %d", status);
                			status = socket_delete( g_socket );
                			dbg("socket_delete DONE, status = %d", status);
                            g_socket = HSOCK_INVALID;
                }
			}
        }
		
	} else if ( answ == SOCK_ANSW_DELETE ) {
		//   - 
		dbg("SockAnsw: DELETE", NULL);
		g_socket = HSOCK_INVALID;
        DL_FsCloseFile(f);
        
		
	} else if ( answ == SOCK_ANSW_ERROR ) {
		// 
		dbg("SockAnsw: ERROR", NULL);
	}
	
	return RESULT_OK;
}


UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )                
{
    tag_t               tag;
    INT32               tmp=0;
    CLK_DATE_T          date;
    CLK_TIME_T          time;

	if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 0)
	{
        DL_ClkGetDate( &date);

        InitTag("FORECAST", &tag);
        if (ReadTag(buffer, &tag)== NULL) return RESULT_OK;

        tmp=strtol(GetPTagString(tag, "year"), NULL, 10);
        if (tmp < date.year) {
            Update();
            return RESULT_OK;
        } else if (tmp  > date.year) return RESULT_OK;

        tmp=strtol(GetPTagString(tag, "day"), NULL, 10);
        if (tmp < date.day) {
            Update();
            return RESULT_OK;
        } else if (tmp  > date.day) return RESULT_OK;

        tmp=strtol(GetPTagString(tag, "month"), NULL, 10);
        if (tmp < date.month) {
            Update();
            return RESULT_OK;
        } else if (tmp  > date.month) return RESULT_OK;

        DL_ClkGetTime( &time);

        tmp = strtol(GetPTagString(tag, "hour"), NULL, 10);
        if (tmp < time.hour) {
            Update();
            return RESULT_OK;
        }

        CloseTag(&tag);

    }

    return RESULT_OK;
}


UINT32 HandleKeypress( EVENT_STACK_T *ev_st, void *app )
{
	UINT8                keypress = (AFW_GetEv(ev_st))->data.key_pressed;
	UINT8 keyupdate1=2;
    UINT8 keyupdate2=3;
    UINT8 keyupdate3=KEY_RED;

	if ( socket == NULL ) {
		//   Socket API
		return RESULT_OK;
	}



	if (keyupdate1 != 0 && keyupdate2 != 0 && keyupdate3 != 0) {

       if (keypress == keyupdate1 || keypress == keyupdate2 || keypress == keyupdate3 ){
    
            if (update1) {
                if (update2) {
                    if (!update3) if (keypress == keyupdate3) update3 = true;
                } else {
                    if (keypress == keyupdate2) update2 = true;
                }
            } else {
                if (keypress == keyupdate1) update1 = true;
            }
       } else {
           	update1 = false;
			update2 = false;
			update3 = false;
       }
	}	
	
	if(update1 & update2 & update3 ) {
        update1 = false;
		update2 = false;
		update3 = false;
        return Update();
    }
	
	return RESULT_OK;
}

UINT32 LoadFile(void)
{
    WCHAR   uri[256];
    UINT32  fSize;
    UINT32  r;

    u_strcpy(uri, ELF_folder);
    u_atou(ID, uri+u_strlen(uri));
    u_strcat(uri, L".xml");

    dbg("load file", NULL);

    if (DL_FsFFileExist(uri)) {
        dbg("exist file", NULL);
        f = DL_FsOpenFile( uri,  FILE_READ_MODE,  0 );
        if (f != FILE_INVALID) {
            fSize = DL_FsGetFileSize(f);
            if (fSize == 0) {
                DL_FsCloseFile(f);
                update=true;
            } else {
                rlen = 0;
                free(buffer);
                buffer = (char*)malloc(fSize);
                DL_FsReadFile( buffer, 1, fSize, f, &r );
                dbg("read = %d b", r);
                DL_FsCloseFile(f);
            }
        }
    } else {
        update=true;
    }

    return RESULT_OK;
}

UINT32 Update() 
{
    WCHAR   uri[256];

    u_strcpy(uri, ELF_folder);
    u_atou(ID, uri+u_strlen(uri));
    u_strcat(uri, L".xml");

    DL_FsDeleteFile( uri,  0 );

    dbg("update", NULL);

     if ( g_socket != HSOCK_INVALID ) 
            return RESULT_OK; //   

     dbg("create socket...", NULL);
    
                //  ,  ,     
                //        ,         
        g_socket = socket(SOCK_TCP, LdrFindEventHandlerTbl( main_state_handlers, HandleSockAnsw ));

        //      ,        
        //  -     8
        if ( g_socket == HSOCK_INVALID ) {
            dbg("can't create socket", NULL);
            return RESULT_FAIL;
        }



        f = DL_FsOpenFile( uri,  FILE_WRITE_MODE,  0 );

        return RESULT_OK;
}

UINT32 NetworkReg( EVENT_STACK_T *ev_st, void *app ) 
{
    if (update) {
        update = false;
        Update();
    }

    return RESULT_OK;
}

UINT32 Weather_getForecast(WCHAR *buf, UINT8 num) //   
{
    tag_t               tag;
    INT32               tmp=9;

    buf[0] = 0;

    InitTag("FORECAST", &tag);
    if (ReadTag(buffer, &tag)== NULL) return RESULT_FAIL;

    dbg("FORECAST", NULL);

    u_atou(GetPTagString(tag, "day"), buf+u_strlen(buf));
    u_strcat(buf, L"/");
    u_atou(GetPTagString(tag, "month"), buf+u_strlen(buf));

    u_strcat(buf, L" ");
    tmp = strtol(GetPTagString(tag, "tod"), NULL, 10);

    switch (tmp) {
    case 0:
        u_strcat(buf, Lang.str[LNG_NIGHT]);
        break;

    case 1:
        u_strcat(buf, Lang.str[LNG_MORNING]);
        break;

    case 2:
        u_strcat(buf, Lang.str[LNG_DAY]);
        break;

    case 3:
        u_strcat(buf, Lang.str[LNG_EVENING]);
        break;
    }

    CloseTag(&tag);

    return RESULT_OK;
}

UINT32 Weather_getTemperature(WCHAR *buf, UINT8 num) // ,   
{
    tag_t               tag;

    InitTag("TEMPERATURE", &tag);
    if (ReadTag(buffer, &tag)== NULL) return RESULT_FAIL;

    //   
    u_ltou((strtol(GetPTagString(tag, "min"), NULL, 10) + strtol(GetPTagString(tag, "max"), NULL, 10))/2, buf);
    u_strcat(buf, L"C");

    CloseTag(&tag);

    return RESULT_OK;
}

UINT32 Weather_getPhenomena(WCHAR *buf, UINT8 num) // 
{
    tag_t               tag;
    UINT8               tmp=9;

    buf[0] = 0;

    InitTag("PHENOMENA", &tag);
    if (ReadTag(buffer, &tag) == NULL) return RESULT_FAIL;


    //  
    tmp = strtoul(GetPTagString(tag, "cloudiness"), NULL, 10);
    dbg("cloudiness = %d", tmp);

    switch (tmp) {
    case 0:
        u_strcpy(buf, Lang.str[LNG_CLEAR]);
        break;
    case 1:
        u_strcpy(buf, Lang.str[LNG_LITTLECLOUDY]);
        break;
    case 2:
        u_strcpy(buf, Lang.str[LNG_CLOUDY]);
        break;
    case 3:
        u_strcpy(buf, Lang.str[LNG_DULL]);
        break;
    }

    u_strcat(buf, L",");

    //  
    if (!strncmp(GetPTagString(tag, "rpower"), "1", 1) || !strncmp(GetPTagString(tag, "spower"), "1", 1)) u_strcat(buf, Lang.str[LNG_PERHAPS]);

    tmp = strtoul(GetPTagString(tag, "precipitation"), NULL, 10);
    dbg("precipitation = %d", tmp);

    switch (tmp) {
    case 4:
        u_strcat(buf, Lang.str[LNG_RAIN]);
        break;
    case 5:
        u_strcat(buf, Lang.str[LNG_DOWNPOUR]);
        break;
    case 6:
    case 7:
        u_strcat(buf, Lang.str[LNG_SNOW]);
        break;
    case 8:
        u_strcat(buf, Lang.str[LNG_THUNDERSTORM]);
        break;
    case 10:
        u_strcat(buf, Lang.str[LNG_WITHOUTPRECIPITATION]);
        break;
    }

    CloseTag(&tag);

    return RESULT_OK;
}

UINT32 Weather_getWind(WCHAR *buf, UINT8 num) //  
{
    tag_t               tag;
    UINT8               tmp=9;

     buf[0] = 0;

    InitTag("WIND", &tag);
    if (ReadTag(buffer, &tag) == NULL) return RESULT_FAIL;

    //  
    tmp = strtoul(GetPTagString(tag, "direction"), NULL, 10);
    //   
    if (tmp==0 || tmp==1 || tmp==7 || tmp==8) {
        u_strcat(buf, Lang.str[LNG_N]);
    } else if (tmp==3 || tmp==4 || tmp==5) {
        u_strcat(buf, Lang.str[LNG_S]);
    }

    if (tmp==1 || tmp==3 || tmp==5 || tmp==7) u_strcat(buf, L"-");

    //   
    if (tmp==5 || tmp==6 || tmp==7) {
        u_strcat(buf, Lang.str[LNG_W]);
    } else if (tmp==1 || tmp==2 || tmp==3) {
        u_strcat(buf, Lang.str[LNG_O]);
    }

    u_strcat(buf, L",");
    u_ltou((strtol(GetPTagString(tag, "min"), NULL, 10) + strtol(GetPTagString(tag, "max"), NULL, 10))/2, buf+u_strlen(buf));
    u_strcat(buf, Lang.str[LNG_MS]);

    CloseTag(&tag);

    return RESULT_OK;
}







