#include "Unzip.h"
#include <dbg.h>

FILE				zip_file, out_file;
WCHAR               curfolder[256]; //   
WCHAR				dst_file[256]; //  
char *				rbuf=NULL;							//   
char *				wbuf=NULL;							//   
UINT32				len, read, wr;

UINT32		        total_read = 0;
UINT32		        total_write = 0;

UINT32				pack_sz,
					unpack_sz,
					file_name_len;

int			        err = 0;
z_stream	        d_stream;

UINT8        prg;

//    ARM BigEndian
// * UINT32     4 ,  x86   
UINT32 getint( const char * ptr )
{	//    4 
	return (UINT32)( (ptr[0] <<  0) |
					(ptr[1] <<  8) |
					(ptr[2] << 16) |
					(ptr[3] << 24) );
}


/*   zcalloc & zcfree  ,
 *     (  44R),    
 */
void * zcalloc( void * opaque, UINT32 items, UINT32 size )
{
	INT32	err;
	void *	ptr;
	UINT32	sz = items * size;
	ptr = suAllocMem(sz, &err);
	if ( err == 0 )	// OK
		return ptr;
	return NULL; // ERR
}

void zcfree( void * opaque, void * ptr )
{
	suFreeMem(ptr);
}

// .     CP866 (DOS),      
UINT32 CP866toUCS2(char *src, WCHAR *trg) {
	UINT16  i;

	for(i=0; i <= strlen(src); i++) {
		if (src[i] < 0x80) { //  
			trg[i]= src[i];
		} else if (src[i] > 0x80 && src[i] < 0xB0) { //  (-)
			trg[i] = src[i] + 0x390;
		} else if (src[i] > 0xDF && src[i] < 0xF0) { //  (-)
			trg[i] = src[i] + 0x360;
		} else if (src[i] == 0xf1){ // 
			trg[i] = 0x451;
		} else if (src[i] == 0xf0){ // 
			trg[i] = 0x401;
		} else {
			trg[i] = '?'; // ? -  
		}
	}

	return RESULT_OK;
}

UINT32 OpenZip(WCHAR * uri) 
{
    
    UINT32  i;

    if ( uri == NULL ) return RESULT_FAIL;

    zip_file = DL_FsOpenFile(uri, FILE_READ_MODE, 0);
	if ( zip_file == FILE_INVALID ) return RESULT_FAIL;

        u_strcpy(curfolder, uri);
		for (i=u_strlen(curfolder)-1; i > 0; i--) if (curfolder[i] == '.') { curfolder[i] = '/'; curfolder[i+1] = 0; break; } //  
		DL_FsMkDir( curfolder,  0 ); //  

        return RESULT_OK;
}

UINT32 UnPackZip(void)
{

    char				header[ZIP_HEADER_SIZE];

			//  
			DL_FsReadFile(header, 1, ZIP_HEADER_SIZE, zip_file, &read);
			dbg("UnPackZip: Read header DONE, read = %d", read);
			if ( read != ZIP_HEADER_SIZE ) return RESULT_STOP;

			dbg("UnPackZip: Magic = 0x%x", getint(header + ZIP_HEADER_OFF_MAGIC));
			if ( getint(header + ZIP_HEADER_OFF_MAGIC) != ZIP_HEADER_MAGIC_DATA ) return RESULT_FAIL;

			pack_sz = getint(header + ZIP_HEADER_OFF_PACK_SIZE);
			unpack_sz = getint(header + ZIP_HEADER_OFF_UNPACK_SIZE);
			file_name_len = getint(header + ZIP_HEADER_OFF_FILENAME_LEN);
			dbg("UnPackZip: pack_sz = %d, unpack_sz = %d, file_name_len = %d", pack_sz, unpack_sz, file_name_len);
			//   
			rbuf = (char *) malloc(file_name_len+1);
			DL_FsReadFile(rbuf, 1, file_name_len, zip_file, &read);
			rbuf[file_name_len] = 0;
			dbg("UnPackZip: file \"%s\"", rbuf);

			//  ,   
            len = u_strlen(curfolder);
			u_strcpy(dst_file, curfolder);
            CP866toUCS2(rbuf, dst_file + len);
			free(rbuf);

			//   
			if ( dst_file[file_name_len + len - 1] == '/' ) {
				dbg("UnPackZip: *****************************************************************\n", NULL);
				//udbg("UnPackZip: is dir! call MkDir \"%s\"", dst_file);
				DL_FsMkDir(dst_file, 0);
			} else {
				dbg("UnPackZip: *****************************************************************\n", NULL);
				dbg("UnPackZip: is file, unpacking...", NULL);
				
				//  ,   
				out_file = DL_FsOpenFile(dst_file, FILE_WRITE_MODE, 0);
				
				if ( out_file == FILE_INVALID ) {
					dbg("UnPackZip: out file handle is invalid", NULL);
                    return RESULT_FAIL;
					/* TODO:
						     
						   (DL_FsSeekFile)
						    ("continue")
					*/
				}
				
				if ( pack_sz == unpack_sz ) {	// no compression
                    rbuf = (char *) malloc(ZLIB_IN_BUF_SIZE);
                    return RESULT_NOCOMPRESSION;
					
				} else {
                    rbuf = (char *) malloc(ZLIB_IN_BUF_SIZE);			// 4  8
					wbuf = (char *) malloc(ZLIB_OUT_BUF_SIZE);		//    ,   ...
															//   ,  
					
					//   ( )  zlib
					d_stream.zalloc_func	= (void *)zcalloc;
					d_stream.zfree_func		= (void *)zcfree;
					d_stream.opaque_func	= NULL;
					
					//  z_stream
					read = ZLIB_IN_BUF_SIZE;
					DL_FsReadFile(rbuf, 1, read, zip_file, &read);
					d_stream.next_in	= (BYTE *) rbuf;
					d_stream.avail_in	= read;
					err = inflateInit2(&d_stream,-MAX_WBITS);
					dbg("UnPackZip: inflateInit2 DONE, err = %d", err);

                        d_stream.next_out	= (BYTE *) wbuf;
						d_stream.avail_out	= ZLIB_OUT_BUF_SIZE;
						if ( ZLIB_OUT_BUF_SIZE > unpack_sz ) {
							d_stream.avail_out	= unpack_sz;
						}
						
						//   =)
						dbg("UnPackZip: call inflate ------------------------", NULL);
						dbg("UnPackZip: avail_in = %d, next_in = 0x%p", d_stream.avail_in, d_stream.next_in);
						dbg("UnPackZip: avail_out = %d, next_out = 0x%p", d_stream.avail_out, d_stream.next_out);
						err = inflate(&d_stream, Z_SYNC_FLUSH);
						dbg("UnPackZip: inflate DONE, err = %d", err);
						dbg("UnPackZip: avail_in = %d, total_in = %d", d_stream.avail_in, d_stream.total_in);
						dbg("UnPackZip: avail_out = %d, total_out = %d", d_stream.avail_out, d_stream.total_out);
						
						//  DONE
						if ( err >= 0 ) {
							DL_FsWriteFile(wbuf, 1, d_stream.total_out-total_write, out_file, &wr);
							total_write = d_stream.total_out;
						}
						
						//      
						//      
						if ( d_stream.avail_in > 0 )		//   
							DL_FsFSeekFile(zip_file, -d_stream.avail_in, SEEK_WHENCE_CUR );


                    return RESULT_COMPRESSION;
                }
				
			}

        return RESULT_OK;
}

UINT32 NoCompressing(void) 
{
    /*   ,
	    rbuf
	     4*1024 (4 )  
	*/
	if ( total_read < pack_sz ) {		//     
			read = ZLIB_IN_BUF_SIZE;			//   
			if ( total_read + read > pack_sz )	//     , 
				read = pack_sz - total_read;	// 
			DL_FsReadFile(rbuf, 1, read, zip_file, &read);
			DL_FsWriteFile(rbuf, 1, read, out_file, &wr);
	// TODO:     wr == read,   !
			total_read += read;
            prg = (total_read*100) / pack_sz;
	} else {
        free(rbuf);
        total_read = 0;
        return RESULT_STOP;
    }

    return RESULT_OK;
}

UINT32 Compressing(void) 
{
    		/*   ,
							 2  - rbuf  wbuf
							   4*1024 (4 )  
							 wbuf   2     rbuf,    
							         rbuf  wbuf,
							   
							...
						*/
				
					if ( err != Z_STREAM_END && err >= 0 ) {		//  err  " "   
						//    read   
						//  ,    , inflate   
						//     ,      
						read = ZLIB_IN_BUF_SIZE;
						DL_FsReadFile(rbuf, 1, read, zip_file, &read);
						
						// using zlib's z_stream
						d_stream.next_in	= (BYTE *) rbuf;	//   
						d_stream.avail_in	= read;

                        d_stream.next_out	= (BYTE *) wbuf;
						d_stream.avail_out	= ZLIB_OUT_BUF_SIZE;
						if ( ZLIB_OUT_BUF_SIZE > unpack_sz ) {
							d_stream.avail_out	= unpack_sz;
						}
						
						//   =)
						dbg("UnPackZip: call inflate ------------------------", NULL);
						dbg("UnPackZip: avail_in = %d, next_in = 0x%p", d_stream.avail_in, d_stream.next_in);
						dbg("UnPackZip: avail_out = %d, next_out = 0x%p", d_stream.avail_out, d_stream.next_out);
						err = inflate(&d_stream, Z_SYNC_FLUSH);
						dbg("UnPackZip: inflate DONE, err = %d", err);
						dbg("UnPackZip: avail_in = %d, total_in = %d", d_stream.avail_in, d_stream.total_in);
						dbg("UnPackZip: avail_out = %d, total_out = %d", d_stream.avail_out, d_stream.total_out);
						
						//  DONE
						if ( err >= 0 ) {
							DL_FsWriteFile(wbuf, 1, d_stream.total_out-total_write, out_file, &wr);
							total_write = d_stream.total_out;
                            prg = (total_write*100) / unpack_sz;
						}
						
						//      
						//      
						if ( d_stream.avail_in > 0 )		//   
							DL_FsFSeekFile(zip_file, -d_stream.avail_in, SEEK_WHENCE_CUR );
					} else {
                        dbg("UnPackZip: call inflateEnd", NULL);
                        inflateEnd(&d_stream);		// zlib       ,
                                                    //        d_stream
                        
                        free(rbuf);
                        free(wbuf);
    
                        DL_FsCloseFile(out_file);
                        total_write = 0;

                        return RESULT_STOP;
                    }

   return RESULT_OK;
}

UINT32 CloseZip(void)
{
    DL_FsCloseFile(out_file);
    DL_FsCloseFile(zip_file);

    return RESULT_OK;
}

