#include "GUI.h"

UIS_DIALOG_T            dialog;
DRAWING_BUFFER_T		bufd; //   

/*  .        */
const char app_name[APP_NAME_LEN] = "unzip"; 


const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    /* GUI-     */
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    /*   ,      UI */
    { EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};

EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
   
    { EV_INK_KEY_PRESS,             HandleKeypress },
    { EV_TIMER_EXPIRED,       	             Timer },
    { STATE_HANDLERS_END,                     NULL },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { UZ_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { UZ_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },
    
    { UZ_STATE_MAIN,
      MainStateEnter,
      StateExit,
      main_state_handlers
    }
};


UINT32 util_asc2ul( const char * s, UINT32 count )
{
	char    b;
	UINT32    res = 0;
	
	while ( count > 0 ) {
		b = *s++;
		if ( b >= '0' && b <= '9' ) {
			b -= '0';
		} else if ( b >= 'A' && b <= 'F' ) {
			b = b - 'A' + 10;
		} else if ( b >= 'a' && b <= 'f' ) {
			b = b - 'a' + 10;
		} else
		b = 0;
		res = res << 4;
		res |= b;
		count--;
	}
	
	return res;
}

UINT32 param2uri(char *param, WCHAR *uri)
{
	_u64                    tmp;
	DL_FS_MID_T             fid;

	tmp.R0 = util_asc2ul(param+0, 8);
	tmp.R1 = util_asc2ul(param+8, 8);

	if (tmp.R0==0 && tmp.R1==0) {
		u_atou(param, uri);
	} else {
		memcpy(&fid, &tmp, sizeof(UINT64));
		DL_FsGetURIFromID( &fid, uri );
	}
	return RESULT_OK;
}

/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32      status = RESULT_OK;
    /*       ""  */
    UINT32      evcode_base= reserve; //  reserve
    WCHAR	    file[256];

    /*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           UZ_STATE_MAX,            //  
                           (void*)startApp );   // ,   
    
	
	if (strlen(param)) {
		param2uri(param, file);
	
        if (OpenZip(file) == RESULT_OK) LdrStartApp(evcode_base);   //  
	} else {
        LdrUnloadELF(&Lib);
    }
    	
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_UNZIP_T     *app = NULL;
    UINT32          status = RESULT_OK;

    /*     */
    app = (APP_UNZIP_T*)APP_InitAppData( (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_UNZIP_T), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );
    dst_file[0] = '/';
    dst_file[1] = 0;

   

    status = APP_Start( ev_st,
                        &app->apt,
                        UZ_STATE_INIT, //  
                        state_handling_table,
                        destroyApp,
                        app_name,
                        0 );


    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32              status;
    APPLICATION_T       *papp = (APPLICATION_T*) app;

    CloseZip();

    APP_UtilUISDialogDelete(  &papp->dialog ); //  

    /*    */
    status = APP_Exit( ev_st, app, 0 );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    //    
    status = APP_HandleUITokenGranted( ev_st, app );

    //   ,   state
    if( (status == RESULT_OK) && (papp->token_status == 2) )
        status = APP_UtilChangeState( UZ_STATE_MAIN, ev_st, app );


    return status;
}

/*    main state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    
	if(type!=ENTER_STATE_ENTER) return RESULT_OK;

      bufd.w = 176;
      bufd.h = 220;
      bufd.buf = NULL;

	dialog = UIS_CreateColorCanvas ( &port, &bufd, TRUE ); //  

    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;

    APP_UtilStartTimer( TIME_PAINT, 0, app );
	paint();

    return RESULT_OK;
}

UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}

UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);


    APP_ConsumeEv( ev_st, app );

    switch (event->data.key_pressed)
	{
    case KEY_LSOFT:
    case KEY_RED:
        return destroyApp(ev_st,app);
        break;
    }

    paint();

    return RESULT_OK;
}

void paint()
{
    WCHAR   str[16];
    UINT16  x;


    // 
	SetFillColor(0xFFFFFF00);
    FillRect(0, 0, bufd.w, bufd.h);
    
    //  
    SetForegroundColor(0x00000000);
    DrawRect(9, 179, 176-19, 30);

    //  
    x = ((bufd.w-21) * prg)/100;
    SetFillColor(0x00FF0000);
    FillRect(10, 180, x, 28);

    SetBackgroundColor(0xFFFFFFFF);

    //     
    SetForegroundColor(0x00000000);
    DrawText(curfolder, 10, 125, ANCHOR_LEFT | ANCHOR_TOP);
    DrawText(u_strrchr(dst_file, (WCHAR)('/'))+1, 10, 150, ANCHOR_LEFT | ANCHOR_TOP);
    // 
    u_ltou(prg, str);
    u_strcat(str, L" %");
    DrawText(str, bufd.w/2-5, 180+8, ANCHOR_LEFT | ANCHOR_TOP);

}

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32         t_id = ((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID;
    UINT32         status;


	switch (t_id) {
    case 0:
        status = UnPackZip();
        switch (status) 
        {
        case RESULT_STOP:
            CloseZip();
            u_strcpy(dst_file, L"/!");
            paint();
            break;

        case RESULT_NOCOMPRESSION:
            if (NoCompressing() == RESULT_STOP) {
                paint();
                APP_UtilStartTimer( TIME_PAINT, 0, app );
            } else {
                paint();
                APP_UtilStartTimer( TIME_PAINT, 1, app );
            }
            break;

        case RESULT_COMPRESSION:
             if (Compressing() == RESULT_STOP) {
                paint();
                APP_UtilStartTimer( TIME_PAINT, 0, app );
            } else {
                paint();
                APP_UtilStartTimer( TIME_PAINT, 2, app );
            }
            break;

        default:
            paint();
            APP_UtilStartTimer( TIME_PAINT, 0, app );
            break;
        } 
        break;

    case 1:
        if (NoCompressing() == RESULT_STOP) {
            paint();
           APP_UtilStartTimer( TIME_PAINT, 0, app );
        } else {
            paint();
           APP_UtilStartTimer( TIME_PAINT, 1, app );
        }
        break;

    case 2:
        if (Compressing() == RESULT_STOP) {
            paint();
           APP_UtilStartTimer( TIME_PAINT, 0, app );
        } else {
            paint();
           APP_UtilStartTimer( TIME_PAINT, 2, app );
        }
        break;
    }

    return RESULT_OK;
}

