
#include "ELF.h"

/*       ""  */
UINT32              evcode_base;

/*  .        */
const char app_name[APP_NAME_LEN] = "ToneDBKiller"; 

//     state-

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    // GUI     
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    //   ,      UI
    { EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { EV_DIALOG_DONE,                   destroyApp },
	{ EV_NO,            					    No },
	{ EV_YES,            					   Yes },
	{ EV_TIMER_EXPIRED,       		     	 Timer },
    { STATE_HANDLERS_END,           NULL           },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },
    
    { HW_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }
};

/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 status = RESULT_OK;
    evcode_base = reserve;    //  reserve
    

/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)startApp );   // ,   
                   

    
    LdrStartApp(reserve);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;
    


    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
        return RESULT_FAIL; //     

    //    
    app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_HELLOWORLD_T), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );
    status = APP_Start( ev_st,
                        &app->apt,
                        HW_STATE_INIT, //  
                        state_handling_table,
                        destroyApp,
                        app_name,
                        0 );


    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

    /*    */
    status = APP_Exit( ev_st, (APPLICATION_T*)app, 0 );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    main state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    CONTENT_T               content;
    UIS_DIALOG_T            dialog = 0;
	WCHAR msg[64] ;
	u_atou( " ToneDB ?\nTo remove ToneDB ?",  msg );
	if(type!=ENTER_STATE_ENTER) return RESULT_OK;
    
    UIS_MakeContentFromString("MCq0", &content, msg); //   
    
    dialog = UIS_CreateConfirmation( &port, &content);
    
    
    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;

    return RESULT_OK;
}

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    //    
    status = APP_HandleUITokenGranted( ev_st, app );

    //   ,   state
    if( (status == RESULT_OK) && (papp->token_status == 2) )
    {
        status = APP_UtilChangeState( HW_STATE_MAIN, ev_st, app );
    }

    return status;
}

//   
UINT32 Yes( EVENT_STACK_T *ev_st,  void *app )
{
	WCHAR buf[64];
	
	//  
	DL_FsDeleteFile(u_atou("file://a/mobile/audio/MyToneDB.db", buf), 0 );
	DL_FsDeleteFile(u_atou("file://a/mobile/audio/TempToneDB.db", buf), 0 );
	
	APP_UtilStartTimer( 1500,  1,  app );
    return RESULT_OK;
}

//   
UINT32 No( EVENT_STACK_T *ev_st,  void *app )
{
	destroyApp( ev_st, app );
    return RESULT_OK;
}

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
	if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 1) HAPI_WATCHDOG_soft_reset();
	 return RESULT_OK;
}	
  