#ifndef NOTEPAD_H
#define NOTEPAD_H

#include <apps.h>


/*    .      */
typedef struct
{ 
    APPLICATION_T           apt; /*   ,   */

} APP_NOTEPAD_T;

/*   */
typedef enum
{
    NP_STATE_ANY, /* ANY-state   */
    NP_STATE_INIT,
    NP_STATE_MAIN,
    NP_STATE_MAX /*   */
} NP_STATES_T;

typedef enum{
    CODE_NULL,
    CODE_ANSI, //  
    CODE_CP1251, // win
    CODE_CP866,  // dos
    CODE_KOI8,   // mac
    CODE_UCS2_BE,
    CODE_UCS2_LE,
    CODE_UTF8

}CODE_TYPE_T;

#define BUFFER_SIZE         512 //  

#define STATUS_LINE_HEIGHT  20 //   

typedef struct 
{
    UINT32          file_size;

    WCHAR           buffer[BUFFER_SIZE+1]; // .     ,   UCS2 BE
    FILE            handle;
    UINT16          page_size; // -   
    UINT16          s_page_size; //  -    

    CODE_TYPE_T     code_type; //  
    UINT8           pad[3];

    INT32           cur_position; //    
    UINT32          count_pages; // - 
    UINT32          num_page; // 
    
} FILE_T;

typedef struct 
{
    
    UINT32  ColorText; //  
    UINT32  ColorBackground; //  
    UINT8   wFontID; //   
    UINT8   sFontID; //    
    INT8    xSize; //   
    INT8    ySize; //  
    
} SETTING_T;

UINT32 util_asc2ul( const char * s, UINT32 count );
UINT32 param2uri(char *param, WCHAR *uri);

UINT32 Register( char* file_uri,  char* param,  UINT32 reserve );
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 );
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app );

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app );
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type );
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app );
UINT32 Timer( EVENT_STACK_T *ev_st,  void *app );

void paint(void);
UINT32 DrawTextInFullDisplay(WCHAR *str, INT32 x, INT32 y);
UINT8 Symbol2Byte(WCHAR symbol);
UINT32 SizePrevPage(WCHAR *str, INT32 x, INT32 y);

UINT32 OpenFile(WCHAR *uri);
CODE_TYPE_T getCodeType(char* str);
UINT32 LoadBuffer(INT32 off_set);
UINT32 Convert(UINT8 *str, UINT32 str_len);
UINT16 Char_convCP866toUCS2String(UINT8   *src_ptr, UINT16  src_len, WCHAR *trg_ptr, UINT16  trg_len);
UINT16 UCS2_LE2BE(WCHAR  *ptr, UINT16  str_len);
#endif