#include "Notepad.h"
#include "Graphics.h"
#include "INIparser.h"
#include <dbg.h>

UIS_DIALOG_T            dialog;
DRAWING_BUFFER_T		bufd; //   

SETTING_T               Setting; // 
FILE_T                  file; //   

BOOL                    isStatusLine=true; //   


/*  .        */
const char app_name[APP_NAME_LEN] = "TextReader"; 

/*     state- */

/*    NP_STATE_ANY (   state) */
static EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    /* GUI-     */
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    { STATE_HANDLERS_END,           NULL           },
};

 EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    /*   ,      UI */
    { EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};

static EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { EV_INK_KEY_PRESS,             HandleKeypress },
    { EV_TIMER_EXPIRED,       		         Timer },
    { STATE_HANDLERS_END,                     NULL },
};




/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { NP_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { NP_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },
    
    { NP_STATE_MAIN,
      MainStateEnter,
      StateExit,
      main_state_handlers
    }
};

// Util

UINT32 util_asc2ul( const char * s, UINT32 count )
{
    char    b;
    UINT32    res = 0;
    
    while ( count > 0 ) {
        b = *s++;
        if ( b >= '0' && b <= '9' ) {
            b -= '0';
        } else if ( b >= 'A' && b <= 'F' ) {
            b = b - 'A' + 10;
        } else if ( b >= 'a' && b <= 'f' ) {
            b = b - 'a' + 10;
        } else
            b = 0;
        res = res << 4;
        res |= b;
        count--;
    }
    
    return res;
}

UINT32 param2uri(char *param, WCHAR *uri)
{
    _u64                    tmp;
    DL_FS_MID_T             fid;

    if (strlen(param) > 16) { //  
        u_atou(param, uri);
    } else { // id
        tmp.R0 = util_asc2ul(param+0, 8);
        tmp.R1 = util_asc2ul(param+8, 8);
    
        if (tmp.R0==0 && tmp.R1==0) {
            u_atou(param, uri);
        } else {
            memcpy(&fid, &tmp, sizeof(UINT64));
            DL_FsGetURIFromID( &fid, uri );
        }
    }
    return RESULT_OK;
}


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32          status = RESULT_OK;
    UINT32          evcode_base = reserve; /*       ""  */
    WCHAR           file_open[256];
    WCHAR		    c_ini_uri[256];
    char            buf[128]; //   ini 

    //   
    u_atou(file_uri, c_ini_uri);
	c_ini_uri[u_strlen(c_ini_uri)-3] = 0;
	u_strcat(c_ini_uri, L"ini");	

    if (OpenINI(c_ini_uri) == RESULT_OK) {
	    setSeparator('=');
	    ReadParamINI("ColorText", buf, 16, "0x00000000");
        Setting.ColorText = (UINT32)strtoul( buf,  NULL,  16 ); 
        ReadParamINI("ColorBackground", buf, 16, "0xFFFFFF00");
        Setting.ColorBackground = (UINT32)strtoul( buf,  NULL,  16 ); 
        ReadParamINI("wFontID", buf, 4, "1");
        Setting.wFontID = (UINT8)strtoul( buf,  NULL,  10 ); 
        ReadParamINI("sFontID", buf, 4, "1");
        Setting.sFontID = (UINT8)strtoul( buf,  NULL,  10 );
        ReadParamINI("xSize", buf, 4, "1");
        Setting.xSize = (UINT8)strtoul( buf,  NULL,  10 );
        ReadParamINI("ySize", buf, 4, "0");
        Setting.ySize = (UINT8)strtoul( buf,  NULL,  10 );

		CloseINI();
	}

    //   
    if (strlen(param)) {
        param2uri(param, file_open);
        OpenFile(file_open);
        LoadBuffer(0);
    }
    


/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           NP_STATE_MAX,            //  
                           (void*)startApp );   // ,   
                   
    
    LdrStartApp(evcode_base);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_NOTEPAD_T       *app = NULL;
    UINT32              status = RESULT_OK;


    /*     */
    app = (APP_NOTEPAD_T*)APP_InitAppData( (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_NOTEPAD_T), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );


    status = APP_Start( ev_st,
                        &app->apt,
                        NP_STATE_INIT, //  
                        state_handling_table,
                        destroyApp,
                        app_name,
                        0 );

    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                  status;
    APPLICATION_T           *papp = (APPLICATION_T*) app;


    APP_UtilUISDialogDelete(  &papp->dialog ); //  
    DL_FsCloseFile(file.handle);
    APP_UtilStopTimer( app );

    /*    */
    status = APP_Exit( ev_st, app, 0 );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    //    
    status = APP_HandleUITokenGranted( ev_st, app );

    //   ,   state
    if( (status == RESULT_OK) && (papp->token_status == 2) )
    {
        status = APP_UtilChangeState( NP_STATE_MAIN, ev_st, app );
    }

    return status;
}


/*    main state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    GRAPHIC_POINT_T         display_size; //  

    
	if(type!=ENTER_STATE_ENTER) return RESULT_OK;


    display_size = UIS_CanvasGetDisplaySize();
    bufd.w = display_size.x+1;
    bufd.h = display_size.y+1;
    bufd.buf = NULL;

		
	dialog = UIS_CreateColorCanvas ( &port, &bufd, TRUE ); //  

    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;
	

    SetBackgroundColor(0xFFFFFFFF);
    paint();
    APP_UtilStartCyclicalTimer( 30000,  1,  app );

    return RESULT_OK;
}

UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

    if ( type == EXIT_STATE_SUSPEND ) return RESULT_OK;

	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}

UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    UINT8       keycode = AFW_GetEv(ev_st)->data.key_pressed;
    UINT32      status=RESULT_OK, b;


    APP_ConsumeEv( ev_st, app );

    if (keycode == KEY_RED) return destroyApp(ev_st,app);

    switch (keycode) {
    case KEY_DOWN:
        status=LoadBuffer(file.cur_position+file.page_size);
        if (status != RESULT_FAIL) file.num_page++;
        break;

    case KEY_UP:
        status=LoadBuffer(file.cur_position-BUFFER_SIZE); 
        if (file.cur_position != 0) {
            b = SizePrevPage(file.buffer, 10, 2);
            status=LoadBuffer(file.cur_position+BUFFER_SIZE - b);
        }
        if (status != RESULT_FAIL && file.num_page > 1) file.num_page--;

        break;

    case KEY_STAR: //  
        status=LoadBuffer(0);
        if (status != RESULT_FAIL) file.num_page = 1;
        break;

    case KEY_POUND: //  
        status=LoadBuffer((file.file_size-file.s_page_size)%2 == 0 ? file.file_size - file.s_page_size:(file.file_size - file.s_page_size)-1);
        if (status != RESULT_FAIL) file.num_page = file.count_pages - 1;
        break;

    case KEY_0:
        isStatusLine = !isStatusLine;
        break;
    }

    if (status != RESULT_FAIL) paint();

    return RESULT_OK;
}

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
	UINT32	id=((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID;
	
	if (id == 1)
	{
		//APP_ConsumeEv( ev_st, app );
        paint();
	}
	
	return RESULT_OK;
}

//     
UINT32 SizePrevPage(WCHAR *str, INT32 x, INT32 y)
{
    GRAPHIC_POINT_T     anchor_point;
    WCHAR               wchr[2];
    UINT32              i, b=0;
    GRAPHIC_METRIC_T    char_size; //  
    UINT16              str_width=x; //      
    UINT16              h; //   

    if (isStatusLine) {
        h = bufd.h-STATUS_LINE_HEIGHT;
    } else {
        h = bufd.h;
    }

    anchor_point.x = x;
    anchor_point.y = y;

    
    for (i=u_strlen(str)-1; i > 0; i--) {

        wchr[0] = str[i];
        wchr[1] = 0;
        
        UIS_CanvasGetStringSize ( wchr, &char_size, Setting.wFontID );
        char_size.width += Setting.xSize;

        if (str_width + char_size.width > bufd.w-STATUS_LINE_HEIGHT || wchr[0] == '\n' ) {
            
            str_width = x;
            anchor_point.y += char_size.height + Setting.ySize;
            if (anchor_point.y + char_size.height > h) break; //      
            if (wchr[0] == ' ') { 
                 b+=Symbol2Byte(wchr[0]);
                continue;
            }
        } 

            anchor_point.x = str_width;
            str_width += char_size.width;

        b+=Symbol2Byte(wchr[0]);

    }

    dbg("Draw %d bytes", b);
    return b; //  -  
}



void paint(void) 
{
    WCHAR   str[64];
    CLK_TIME_T  t;

    // 
	SetFillColor(Setting.ColorBackground); //  
    SetForegroundColor(Setting.ColorText); //   
    FillRect(0, 0, bufd.w, bufd.h);
    SetFont(Setting.wFontID);

    file.page_size = DrawTextInFullDisplay(file.buffer, 10, 2);
    if (file.s_page_size==0)  file.s_page_size = file.page_size;
    file.s_page_size = (file.s_page_size + file.page_size)/2;
    file.count_pages = ((file.file_size-file.cur_position)/file.s_page_size) + file.num_page - 1; // - 
    if (file.file_size%(file.cur_position+file.page_size) != 0) file.count_pages++;
    if (file.count_pages < file.num_page) file.count_pages = file.num_page;

    u_ltou(file.num_page, str);
    u_strcat(str, L"/");
    u_ltou(file.count_pages, str+u_strlen(str));

    //  
    if (isStatusLine) {
        SetFillColor(Setting.ColorText); //  
        SetForegroundColor(Setting.ColorBackground); //   
        FillRect(0, bufd.h-STATUS_LINE_HEIGHT, bufd.w, STATUS_LINE_HEIGHT); //   
        SetFont(Setting.sFontID);
        DrawText(str, 5, bufd.h-1, ANCHOR_LEFT | ANCHOR_BOTTOM);
    
        // 
        DL_ClkGetTime(&t);
        u_ltou(t.hour, str);
        u_strcat(str+u_strlen(str), L":");
        if(t.minute < 10) u_strcat(str+u_strlen(str), L"0");
        u_ltou(t.minute, str+u_strlen(str));
        DrawText(str, bufd.w-5, bufd.h-1, ANCHOR_RIGHT | ANCHOR_BOTTOM);
    }
}



UINT32 DrawTextInFullDisplay(WCHAR *str, INT32 x, INT32 y)
{
    GRAPHIC_POINT_T     anchor_point;
    WCHAR               wchr[2];
    UINT32              i, b=0;
    GRAPHIC_METRIC_T    char_size; //  
    UINT16              str_width=x; //               
	UINT32				result;
    UINT16              h; //   

    if (isStatusLine) {
        h = bufd.h-STATUS_LINE_HEIGHT;
    } else {
        h = bufd.h;
    }

    anchor_point.x = x;
    anchor_point.y = y;

    for (i=0; i < u_strlen(str); i++) {

        wchr[0] = str[i];
        wchr[1] = 0;
        
        result = UIS_CanvasGetStringSize ( wchr, &char_size, Setting.wFontID );
        char_size.width += Setting.xSize;

        if (str_width + char_size.width > bufd.w-10 || wchr[0] == '\n' ) {
            if (wchr[0] > 0x40 && str[i-1] > 0x40) {
                anchor_point.x = str_width;
                UIS_CanvasDrawColorText (L"-",
                                 0,
                                 1,  	//  
                                 anchor_point,              //   
                                 ANCHOR_LEFT | ANCHOR_TOP,	    //   
                                 dialog);
				
            }
            str_width = x;
            anchor_point.y += char_size.height + Setting.ySize;
            if (anchor_point.y + char_size.height > h) break; //      
            if (wchr[0] == ' ') { 
                 b+=Symbol2Byte(wchr[0]);
                continue;
            }
        } 

            anchor_point.x = str_width;
            str_width += char_size.width;

        b+=Symbol2Byte(wchr[0]);
        
        UIS_CanvasDrawColorText (wchr,
                                 0,
                                 1,  	//  
                                 anchor_point,              //   
                                 ANCHOR_LEFT | ANCHOR_TOP,	    //   
                                 dialog);
    }

    dbg("Draw %d bytes", b);
    return b; //  -  
}


UINT8 Symbol2Byte(WCHAR symbol) // -   
{
        if (file.code_type == CODE_UCS2_BE || file.code_type == CODE_UCS2_LE) {
            return 2;
        } else if(file.code_type == CODE_UTF8) {
            if (symbol < 128) return 1;
            else return 2;
        } else {
            return 1;
        }
}


UINT32 OpenFile(WCHAR *uri) //  
{
    UINT32  r, i;
    char    buf[1024];
    int     d=0, k=0, w=0;

    udbg("Open file \"%s\"", uri);

    DL_FsCloseFile(file.handle);
    file.handle = DL_FsOpenFile( uri,  FILE_READ_MODE,  0 );
    if (file.handle == FILE_HANDLE_INVALID  ) return RESULT_FAIL;

    DL_FsReadFile( buf, 1, 3, file.handle, &r );
    file.code_type = getCodeType(buf);
    if (file.code_type == CODE_ANSI) {
        DL_FsReadFile( buf, 1, 1024, file.handle, &r );
		//   	
        for (i=0; i < r; i++) {
            switch (buf[i])
            {
               case 0x80: {d++; break;}
               case 0xa0: {d++; break;}
               case 0x8e: {d++; break;}
               case 0xae: {d++; break;}
               case 0x88: {d++; break;}
               case 0xa8: {d++; break;}
               case 0x92: {d++; break;}
               case 0xe2: {d++; break;}
               case 0xe1: {k++; break;}
               case 0xc1: {k++; break;}
               case 0xef: {k++; break;}
               case 0xcf: {k++; break;}
               case 0xe9: {k++; break;}
               case 0xc9: {k++; break;}
               case 0xf4: {k++; break;}
               case 0xd4: {k++; break;}
               case 0xc0: {w++; break;}
               case 0xe0: {w++; break;}
               case 0xce: {w++; break;}
               case 0xee: {w++; break;}
               case 0xc8: {w++; break;}
               case 0xe8: {w++; break;}
               case 0xd2: {w++; break;}
               case 0xf2: {w++; break;}
             }
        }

        
        if ((d>k) && (d>w)) {
            file.code_type = CODE_CP866;
        } else if ((k>d) && (k>w)) {
            file.code_type = CODE_KOI8;
        } else {
            file.code_type = CODE_CP1251;
        }

    }

    dbg("Code type = %d", file.code_type);

    file.cur_position=-1;
    file.page_size = 0;
    file.s_page_size = 0;
    file.file_size = DL_FsGetFileSize(file.handle);
    file.num_page = 1;

    return RESULT_OK;
}

CODE_TYPE_T getCodeType(char* str) //   
{
    if (!str || (str[0] == 0 && str[1] == 0)) return CODE_NULL;

  
    if (str[0] == 0xff && str[1] == 0xfe) {
        return CODE_UCS2_LE;
    } else if (str[0] == 0xfe && str[1] == 0xff) {
        return CODE_UCS2_BE;
    } else if (str[0] == 0xef && str[1] == 0xbb && str[2] == 0xbf) {
        return CODE_UTF8;
    } else {
        return CODE_ANSI;
    }
}

UINT32 LoadBuffer(INT32 off_set) //  c   
{
    UINT32  r;
    UINT8   tmp_buffer[BUFFER_SIZE*2];

    dbg("Load buffer:", NULL);
    if (file.handle == FILE_HANDLE_INVALID) {
        dbg("file.handle invalid", NULL);
        return RESULT_FAIL; //   
    }

    if (off_set <= 0) { //  magic  
        if (file.code_type == CODE_UCS2_BE || file.code_type == CODE_UCS2_LE) {
           off_set = 2;
        } else if (file.code_type == CODE_UTF8) {
           off_set = 3;
        } else {
           off_set = 0;
        }
    }  

    if (file.cur_position == off_set) return RESULT_FAIL; //    

    DL_FsFSeekFile( file.handle, off_set, SEEK_WHENCE_SET ); //   
    dbg(" - set Offset file = 0x%x", off_set);
    
    if (file.code_type == CODE_UCS2_BE || file.code_type == CODE_UCS2_LE) {
        DL_FsReadFile( file.buffer,  1,  BUFFER_SIZE*sizeof(WCHAR), file.handle, &r );
        if (r == 0) return RESULT_FAIL;
        file.buffer[r/2] = 0; //    
        if (file.code_type == CODE_UCS2_LE) UCS2_LE2BE(file.buffer, r/sizeof(WCHAR));
    } else if (file.code_type == CODE_UTF8) {
        DL_FsReadFile( tmp_buffer,  1,  BUFFER_SIZE*sizeof(WCHAR), file.handle, &r );
        if (r == 0) return RESULT_FAIL;
        Convert(tmp_buffer, r);
    } else {
        DL_FsReadFile( tmp_buffer,  1,  BUFFER_SIZE, file.handle, &r );
        if (r == 0) return RESULT_FAIL;
        Convert(tmp_buffer, r);
    }
    dbg(" - Read %d b", r);
    

    file.cur_position = off_set;

    return RESULT_OK;
}

UINT32 Convert(UINT8 *str, UINT32 str_len) //   UCS2 BE
{
    UINT32 status;
    switch (file.code_type) {
    case CODE_CP1251:
        DL_Char_convCP1251toUCS2String(str, str_len, file.buffer, BUFFER_SIZE*sizeof(WCHAR));
        break;

    case CODE_CP866:
        Char_convCP866toUCS2String(str, str_len, file.buffer, BUFFER_SIZE*sizeof(WCHAR));
        break;

    case CODE_KOI8:
        DL_Char_convKOI8RtoUCS2String(str, str_len, file.buffer, BUFFER_SIZE*sizeof(WCHAR));
        break;

    case CODE_UTF8:
        DL_Char_convUTF8toUCS2String(str,  str_len, file.buffer,  BUFFER_SIZE*sizeof(WCHAR));
        break;
    }
    return status;
}

UINT16 Char_convCP866toUCS2String(UINT8   *src_ptr, UINT16  src_len, WCHAR *trg_ptr, UINT16  trg_len)
{
    UINT16  i;

    for(i=0; i <= src_len && i <= trg_len; i++) {
        if (src_ptr[i] < 128) { //  128
            trg_ptr[i] = src_ptr[i];
        } else if (src_ptr[i] == 0xF1){ // 
            trg_ptr[i] = 0x451;
        } else if (src_ptr[i] == 0xF0){ // 
            trg_ptr[i] = 0x401;
        } else if (src_ptr[i] >= 128 && src_ptr[i] < 0xB0) { //   ''
            trg_ptr[i] = src_ptr[i] + 0x390;
        } else if (src_ptr[i] >= 0xE0 && src_ptr[i] < 0xF0) { //  
            trg_ptr[i] = src_ptr[i] + 0x360;
        } else {
            trg_ptr[i] = 0x3F; // ? -  
        }
    }

    return RESULT_OK;
}

UINT16 UCS2_LE2BE(WCHAR  *ptr, UINT16  str_len)
{
    UINT16  i;

    for(i=0; i < str_len; i++) {
        ptr[i] =((ptr[i] & 0x00FF) << 8) | ((ptr[i] & 0xFF00) >> 8);
    }

    return RESULT_OK;
}


