#include "TalkClock.h"


extern const UINT32 *DATEBOOK_REMINDER; //  
extern const UINT16 *ALMCLK_REMINDER_START; // 

UINT8 	volMedia;
UINT8 	mode=0;

//   
BOOL exitN1;
BOOL exitN2;
BOOL exitN3;

// 
    UINT8 keyexitN1=KEY_STAR;
    UINT8 keyexitN2=KEY_POUND;
    UINT8 keyexitN3=KEY_RED;

    UINT8 keyclock=KEY_RSOFT;

    UINT8 WT = 0; // 0 - , 1 -   
    UINT8 AlarmON = 0; //  
    UINT8 DateBookON = 0; //  

UINT8 bAlarm = 0; // 0 -   , 1 -  
UINT8 kAlarm = 0; //0 -     ,  1 -   

UINT16 bDateBook = 0;

BOOL allowPlay = FALSE; //    
                        // (       )

//UINT8 bCall = 0;

BOOL LongPress = FALSE;


SU_PORT_T     		port;
CLK_TIME_T   		timeSystem;  //  

UINT8 size;
UINT8 *attach=NULL;



//extern const UINT32 *CALL_ALERT;

WCHAR 	dir_Sound[256];

MME_GC_MEDIA_FILE 	mme_media_file = NULL; // id  

/*  .        */
const char app_name[APP_NAME_LEN] = "TalkClock"; 

//     state-

/*    HW_STATE_ANY (   state) */
EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    { EV_KEY_PRESS,             HandleKeypress},
    { EV_KEY_RELEASE,         HandleKeyrelease},
    { EV_TIMER_EXPIRED,                  Timer},

    { EV_MME_OPEN_SUCCESS,                Play},
    { EV_MME_PLAY_COMPLETE,             Delete},
    { NULL,                              Alarm},
    { NULL,                           DateBook},
    //{ NULL,								  Call },
    //      
    { STATE_HANDLERS_END,           NULL},
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { STATE_HANDLERS_END,           NULL},
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
        NULL,                       //    state
        NULL,                       //    state
        any_state_handlers          //   
    },

    { HW_STATE_MAIN,
        MainStateEnter,
        NULL,
        main_state_handlers
    }
};



/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
	UINT32          evcode_base;
    UINT32 			status = RESULT_OK;
    int 			i, j;
	WCHAR 			nameCfgFile[256];
	UINT8 			bufR[16];
    UINT32 			readen;
    FILE_HANDLE_T 	f;

    any_state_handlers[5].code = (UINT32)*ALMCLK_REMINDER_START;
    any_state_handlers[6].code = *DATEBOOK_REMINDER;
    //any_state_handlers[6].code = *CALL_ALERT;

//PFprintf("EVENT = 0x%x\n", *CALL_ALERT);

    evcode_base = reserve;    //  reserve



    /*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)startApp );   // ,   

    //   
        u_atou(file_uri, nameCfgFile);
        nameCfgFile[u_strlen(nameCfgFile)-3] = 0;
		u_strcat(nameCfgFile, L"cfg");

    for (i=u_strlen(nameCfgFile)-1; i > 0 ; i--)
		if (file_uri[i] == 47) break;

    for (j=0; j <= i ; j++)
        dir_Sound[j] = nameCfgFile[j];
    dir_Sound[j] = 0;

    u_strcat(dir_Sound, L"sound/");
	
	u_PFprintf("nameCfgFile = %s\n", nameCfgFile); 
	u_PFprintf("dirSound = %s\n", dir_Sound); 
	
	
        //    		
        if (DL_FsFFileExist(nameCfgFile) ) //    
        {
            f = DL_FsOpenFile(nameCfgFile, FILE_READ_MODE, 0);
            DL_FsReadFile( bufR, 9, 1, f, &readen );
            DL_FsCloseFile(f);
			
            keyclock = bufR[0];
            WT = bufR[1];
            AlarmON = bufR[2];
            DateBookON = bufR[3];


            keyexitN1 = bufR[6];
            keyexitN2 = bufR[7];
            keyexitN3 = bufR[8];
        }



    LdrStartApp(reserve);   //  


    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;


    /* ,    ? */
    if ( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
    {
        return RESULT_FAIL; //     
    } 
    else
    {
        //    
        app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEventPrepost, //    
                                                  sizeof(APP_HELLOWORLD_T), //   
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                                  2, 0, 0 );


        status = APP_Start( ev_st,
                            &app->apt,
                            HW_STATE_MAIN, //  
                            state_handling_table,
                            destroyApp,
                            app_name,
                            0 );


    }

    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

    APP_UtilStopTimer( app );
    /*    */
    status = APP_Exit( ev_st, app, NULL );

    PFprintf( "*ELF TalkClock* Exit\n");

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    port=((APPLICATION_T*)(app))->port; //   
    PFprintf( "*ELF TalkClock* PORT = 0x%x\n", port);
    return RESULT_OK;
}



/*  , EV_KEY_PRESS    */
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
    UINT8       keypress;


    keypress = event->data.key_pressed;


    if (keyexitN1 != 0 && keyexitN2 != 0 && keyexitN3 != 0)
    {
        if (exitN1)
        {
            if (exitN2)
            {
                if (!exitN3) if (keypress == keyexitN3) exitN3 = TRUE;
            } else
            {
                if (keypress == keyexitN2) exitN2 = TRUE;
            }
        } else
        {
            if (keypress == keyexitN1) exitN1 = TRUE;
        }
        if (keypress != keyexitN1 && keypress != keyexitN2 && keypress != keyexitN3 )
        {
            exitN1 = FALSE;
            exitN2 = FALSE;
            exitN3 = FALSE;
        }
    }

    if (exitN1 & exitN2 & exitN3 ) return destroyApp(ev_st, app);


    if (keypress == keyclock)
    {
		
        if (WT == 1)
        {
            if (WorkingTable())
            {
                APP_UtilStopTimer( app );
                APP_UtilStartCyclicalTimer(1000,  0,  app );
            }
        } else
        {
            APP_UtilStopTimer( app );
            APP_UtilStartCyclicalTimer(1000,  0,  app );
        }
    }

    if (keypress == KEY_RED) mode=0;

    return RESULT_OK;
}

UINT32 HandleKeyrelease( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);  
    UINT8       keypress;
    keypress = event->data.key_pressed;
    if (keypress  == keyclock)
    {
        APP_UtilStopTimer( app );
        if (LongPress)
        {
            APP_ConsumeEv(ev_st, app);
            LongPress = FALSE;
        }
    }
    return RESULT_OK;
}


UINT32 Talk()
{
    WCHAR hour[8];
    WCHAR minute[8];
	

   // if (!allowPlay) mode=0;

    switch (mode)
    {
    case 0:
        if (kAlarm == 0 )
        {
            if (bAlarm == 1)
               AFW_CreateInternalQueuedEvAux( *ALMCLK_REMINDER_START, FBF_FREE, size, attach );


            if (bDateBook == 1)
                AFW_CreateInternalQueuedEvAux( *DATEBOOK_REMINDER, FBF_FREE, size, attach );
        } 
        else
        {
            if (WorkingTable())
                DL_KeyInjectKeyPress(KEY_RED,1,0);
        }

		if (namecmp((char*)LdrGetPlatformName(), "LTE")) {
			DL_AudSetVolumeSetting(2, volMedia);
		} else {
			DL_AudSetVolumeSetting(4, volMedia);
		}

        allowPlay = FALSE;


        break;

    case 1: //  
        if (timeSystem.hour <= 20)
        {
            u_ltou( timeSystem.hour,  hour);
            mode = 3;
            Create(hour);
        } 
        else
        {
            mode = 2;
            Create(L"20");
        }
        break;

    case 2: //   2
        u_ltou( timeSystem.hour-20,  hour);
        mode = 3;
        Create(hour);
        break;

    case 3: //  
        if (timeSystem.hour > 20) timeSystem.hour = timeSystem.hour - 20;
		
        if (timeSystem.hour == 1)
			u_strcpy( hour, L"1h");
		if (timeSystem.hour > 1 && timeSystem.hour < 5) 
			u_strcpy(hour, L"2h");
		if (timeSystem.hour >= 5 || timeSystem.hour == 0) u_strcpy(hour, L"5h");
		
        if (timeSystem.minute != 0)
        {
            if (timeSystem.minute <= 20 || timeSystem.minute == 30 || timeSystem.minute == 40 || timeSystem.minute == 50)
            {
                mode = 5;
            } else
            {
                mode = 4;
            }
        } else
        {
            mode = 7;
        }
        Create(hour);

        break;

    case 4: // 
        u_ltou( ((timeSystem.minute)/10)*10,  minute);
        timeSystem.minute = timeSystem.minute - ((timeSystem.minute)/10)*10;
        mode = 5;
        Create(minute);
        break;

    case 5: //  2
        if (timeSystem.minute == 1) 
			u_strcpy( minute, L"1a");
		if (timeSystem.minute == 2) 
			u_strcpy( minute, L"2e");
		if (timeSystem.minute > 2) 
            u_ltou( timeSystem.minute,  minute);

        mode = 6;
        Create(minute);
        break;

    case 6: //   
        if (timeSystem.minute == 1) 
			u_strcpy( minute, L"1m");
		if (timeSystem.minute >= 2 && timeSystem.minute < 5) 
		    u_strcpy( minute, L"2m");
		if (timeSystem.minute >= 5) 
			u_strcpy( minute, L"5m");
		

        mode = 0;
        Create(minute);
        break;

    case 7: // 
        mode = 0;
        Create(L"eq");
        break;
    }
    return RESULT_OK;
}



UINT32 Create(WCHAR *name)
{       
    WCHAR uri[256]; 
	IFACE_DATA_T if_data;
	
	if_data.port = port;

    u_strcpy(uri, dir_Sound);
	u_strcat(uri, name);
	u_strcat(uri, L".amr");
    //u_PFprintf("*ELF TalkClock* Sound = %s\n", uri);


    if (mme_media_file == 0 && DL_FsFFileExist(uri))
    {
		u_PFprintf("URI = %s\n", uri); 
        mme_media_file = MME_GC_playback_create(&if_data, uri, 0, 0, 0, 0, 0, 0); //  

        //PFprintf( "*ELF TalkClock* mme_media_file = 0x%x\n", mme_media_file);
		allowPlay = TRUE;
    } 
	else
	{
		Talk();
	}


    return RESULT_OK;
}

UINT32 Delete( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32 Error=0;

    if (mme_media_file != 0 && allowPlay)
    {
        MME_GC_playback_delete(mme_media_file); // ,  
        mme_media_file = (MME_GC_MEDIA_FILE *) NULL; //  id
        PFprintf( "*ELF TalkClock* Error_Delete = %d \n", Error );
        Talk();
    }

    return Error;
}


UINT32 Play( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32 Error=0;
	

    if (mme_media_file != 0 && allowPlay)
    {
        Error = MME_GC_playback_start(mme_media_file, 0, 0);   // 
        PFprintf( "*ELF TalkClock* Error_Play = %d \n", Error );
    }

    return Error;
}


UINT32 Alarm( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);  

    if (AlarmON == 1)
    {
        if (bAlarm == 1 )
        {
            bAlarm = 0;
        }
         else
        {
            size = event->att_size;
            attach = suAllocMem(size, NULL);
            *attach = *((UINT8*)event->attachment);

            PFprintf("*ELF TalkClock*  size = %d\n", size);
            PFprintf("*ELF TalkClock*  attach = %d\n", *attach);

            APP_ConsumeEv( ev_st,  app );
            
            DL_ClkGetTime( &timeSystem ); //   

            mode = 1;
            bAlarm = 1;
            kAlarm = 0;
            SynVol();
            Talk();
        }   
    }
    return RESULT_OK;
}

UINT32 DateBook( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);  
    int i;

    if (DateBookON == 1)
    {
        if (bDateBook == 1 )
        {
            bDateBook = 0;
        }
        else
        {
            size = event->att_size;
            attach = suAllocMem(size, NULL);


            for (i=0; i < size; i++)
            {
                attach[i] = ((UINT8 *)(event->attachment))[i];
            }


            PFprintf("*ELF TalkClock*  size = %d\n", size);
            PFprintf("*ELF TalkClock*  attach = %d\n", *attach);
            
            APP_ConsumeEv(ev_st, app);

            DL_ClkGetTime( &timeSystem ); //   

            mode = 1;
            bDateBook = 1;
            bAlarm = 0;
            kAlarm = 0;

            SynVol();
            Talk();
        }   
    }

    return RESULT_OK;
}

/*
UINT32 Call( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);	
    
    if (bCall == 1 )
    {
        bCall = 0;
    }
    else
    { 
         attach = *((UINT8 *)event->attachment);
        size = event->att_size;
        
        APP_ConsumeEv( ev_st,  app );
            mode = 1;
            bCall = 1;
            kAlarm = 0;
            Talk(); 
    }		
    return RESULT_OK;
}
*/

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
    if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 0) 
    {

        APP_UtilStopTimer( app );
        DL_ClkGetTime( &timeSystem ); //   
        LongPress = TRUE;

        mode = 1;
        bAlarm = 0;
        bDateBook = 0;
        //bCall = 0;
        kAlarm = 1;
        
        SynVol();
        Talk();
    }

    return RESULT_OK;
}

UINT32 SynVol(void) //  
{
    UINT8 volume;
	UINT8 volumeMM;
	
	if (namecmp((char*)LdrGetPlatformName(), "LTE")) {
		volumeMM = 2;
	} else {
		volumeMM = 4;
	}

    DL_AudGetVolumeSetting(0, &volume);
    DL_AudGetVolumeSetting(volumeMM, &volMedia);
    //PFprintf("*ELF TalkClock* Volume = id_%d -> id_%d\n", volumeMM, 0);
    DL_AudSetVolumeSetting(volumeMM, volume);

    return RESULT_OK;
}

BOOL WorkingTable(void)
{
	UINT8 res;
	
	UIS_GetActiveDialogType(&res);
	
	if (res == 0xE) {
		return TRUE;
	} else {
		return FALSE;
	}	
}

void u_PFprintf(char* format, WCHAR* s1) 
{
	char* t = suAllocMem(u_strlen(s1)+1, NULL);
	u_utoa(s1, t);
	PFprintf(format, t);
	suFreeMem(t);
}
