#include "SmartKey.h"
#include <dbg.h>

BOOL exitN1;
BOOL exitN2;
BOOL exitN3;

UINT8 keyexitN1;
UINT8 keyexitN2;
UINT8 keyexitN3;

BOOL LongPress = false; //  
BOOL SkipKeys = false; //      
BOOL AD = false; //  

/*  .        */
const char app_name[APP_NAME_LEN] = "SmartKeys"; 


//     state-

/*    HW_STATE_ANY (   state) */
static EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    { NULL,                     ActiveDisplay },

    { EV_KEY_PRESS,             HandleKeypress },
	{ EV_KEY_RELEASE,         HandleKeyrelease },
	{ EV_TIMER_EXPIRED,       			 Timer },


    //      
    { STATE_HANDLERS_END,           NULL           },
};

static EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { STATE_HANDLERS_END,           NULL           },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }

};


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 status = RESULT_OK;
	UINT32 evcode_base=reserve;
    WCHAR				nameCfgFile[256];

    UINT8 bufR[3];
    UINT32 readen;
    FILE_HANDLE_T f;

    
	any_state_handlers[0].code = EV_DISPLAY_NO_ACTIVE;

/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)startApp );   // ,   


        u_atou(file_uri, nameCfgFile);
		nameCfgFile[u_strlen(nameCfgFile)-3] = 0;
		u_strcat(nameCfgFile, L"cfg");	

        if (DL_FsFFileExist( nameCfgFile)) //    
        {
            f = DL_FsOpenFile(nameCfgFile, FILE_READ_MODE, 0);
            DL_FsReadFile( bufR, 3, 1, f, &readen );
            DL_FsCloseFile(f);


                keyexitN1 = bufR[0];
                keyexitN2 = bufR[1];
                keyexitN3 = bufR[2];
        }	

		
    LdrStartApp(reserve);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;
    



        //    
        app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEventPrepost, //    
                                                  sizeof(APP_HELLOWORLD_T), //   
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                                  2, 0, 0 );
                                                  

        status = APP_Start( ev_st,
                            &app->apt,
                            HW_STATE_MAIN, //  
                            state_handling_table,
                            destroyApp,
                            app_name,
                            0 );


    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;
	
	dbg("exit", NULL);

	
	APP_UtilStopTimer( app );
    /*    */
    status = APP_Exit( ev_st, app, NULL );
	
	
    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    return RESULT_OK;
}


	
/*  , EV_KEY_PRESS    */
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
   UINT8       keypress = (AFW_GetEv(ev_st))->data.key_pressed;


    if (keyexitN1 != 0 && keyexitN2 != 0 && keyexitN3 != 0)
    {
        if (exitN1)
        {
            if (exitN2)
            {
                if (!exitN3) if (keypress == keyexitN3) exitN3 = TRUE;
            }
            else
            {
                if (keypress == keyexitN2) exitN2 = TRUE;
            }
        }
        else
        {
            if (keypress == keyexitN1) exitN1 = TRUE;
        }

        if (keypress != keyexitN1 && keypress != keyexitN2 && keypress != keyexitN3 )
        {
            exitN1 = FALSE;
            exitN2 = FALSE;
            exitN3 = FALSE;
        }
    }		

    if(exitN1 & exitN2 & exitN3 ) return destroyApp(ev_st, app);


			if (SkipKeys) {
				dbg("skip key", NULL);
				//SkipKeys = false;
			} else {

                
    
                if (keypress == KEY_SMART)
    		    {
                    if (AD) {
                        UIS_SetBacklightWithIntensity(255, 3);
                        return APP_ConsumeEv(ev_st, app);
                    }
                    APP_ConsumeEv(ev_st, app);
    				APP_UtilStopTimer( app );
    				APP_UtilStartCyclicalTimer( 1600,  1,  app );
    			} else if (keypress == KEY_CAM) {
                    APP_ConsumeEv(ev_st, app);
                    APP_UtilStopTimer( app );
    				APP_UtilStartCyclicalTimer( 1500,  2,  app );
                }

                AD = false;

		}

    return RESULT_OK;
}

UINT32 HandleKeyrelease( EVENT_STACK_T *ev_st,  void *app )
{
   UINT8       keypress = (AFW_GetEv(ev_st))->data.key_pressed;
/*
       UINT32 sequence_number;

//  79 R,    
   if (*((char*)0x12607C34) == 0) {
       sequence_number = DL_AudPlayTone( 0,  0 ); //Current volume = 0xFF
       DL_AudStopTone(0, sequence_number);
   }
*/
   
        		
			if (SkipKeys) {
				dbg("skip key", NULL);
				SkipKeys = false;
		    } else {
			
				
				
				APP_UtilStopTimer( app );
				
				if (LongPress) 
				{
                    if (keypress == KEY_SMART)
                    {
                        APP_ConsumeEv(ev_st, app);
    					dbg("release VOICE", NULL);
    					DL_KeyInjectKeyPress(KEY_VOICE,1,0); // keyrelease
    					LongPress = false;
                    } else if (keypress == KEY_CAM) {
                        APP_ConsumeEv(ev_st, app);
                        APP_UtilStopTimer( app );
                        LongPress = false;
                    }
				}
				else 
				{
                    if (keypress == KEY_SMART) {
                        if (AD) {
                        UIS_SetBacklightWithIntensity(255, 0);
                        return APP_ConsumeEv(ev_st, app);
                        }
                        APP_ConsumeEv(ev_st, app);
                        dbg("press SMART", NULL);
                        SkipKeys = true;
                        DL_KeyInjectKeyPress(KEY_SMART,0,0);
                        dbg("release SMART", NULL);
                        //SkipKeys = true;
                        DL_KeyInjectKeyPress(KEY_SMART,1,0);
                    } else if (keypress == KEY_CAM) {
                        APP_ConsumeEv(ev_st, app);
                        SkipKeys = true;
                        DL_KeyInjectKeyPress(KEY_CAM,0,0);
        				DL_KeyInjectKeyPress(KEY_CAM,1,0);
                    }
				}
			}	



		
	return RESULT_OK;
}

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
	
	if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 1) 
	{
            APP_UtilStopTimer( app );
			LongPress = true;
			dbg("press VOICE", NULL);
			DL_KeyInjectKeyPress(KEY_VOICE,0,0); // keypress
			APP_ConsumeEv(ev_st, app );
	} else if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 2) {

			APP_UtilStopTimer( app );
			LongPress = true;
			dbg("press VOICE", NULL);
            AFW_CreateInternalQueuedEvAux( 1021, FBF_FREE, 0, 0 );
	}
	
	return RESULT_OK;
}	
	

UINT32 ActiveDisplay( EVENT_STACK_T *ev_st,  void *app )
{
    AD = true;
    return RESULT_OK;
}


