#include "SeemEditor.h"

#define ENTRIES_NUM 4       // ,    

/*       ""  */


UINT32 siItem; //   
SEEM_ELEMENT_DATA_CONTROL_T seems;
UINT16	value; //  
		
	
/*  .        */
const char app_name[APP_NAME_LEN] = "SeemEditor";

/*     state- */

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{
    /* GUI-     */
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    /*   ,      UI */
    { EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};

EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{

    { EV_DIALOG_DONE,               HelloWorldExit },
    { EV_REQUEST_LIST_ITEMS,        HandleListReq  },
    /* STATE_HANDLERS_RESERVED ,   - ,  
          ,      
        . LdrInitEventHandlersTbl, LdrFindEventHandlerTbl */
    { STATE_HANDLERS_RESERVED,     		ReadAction },
	{ STATE_HANDLERS_RESERVED,     		WriteAction },
    { EV_DONE,                      HelloWorldExit },
    { EV_SELECT,                        SelectItem },

    { STATE_HANDLERS_END,           NULL           },
};

 EVENT_HANDLER_ENTRY_T edit_state_handlers[] =
{
    /*   ,      UI */
    { EV_GRANT_TOKEN,             	  HandleUITokenGranted },
    { EV_DATA,                               	 EditData  },
    { EV_DONE,                       		       EditOk  },
	{ EV_CANCEL,                 				 EditExit  },
    { STATE_HANDLERS_END,         			     	  NULL },
};

 EVENT_HANDLER_ENTRY_T notice_state_handlers[] =
{
    /*   ,      UI */
    { EV_GRANT_TOKEN,             	  HandleUITokenGranted },
    { EV_DIALOG_DONE,                           NoticeExit },
    { STATE_HANDLERS_END,         			     	  NULL },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },

    { HW_STATE_MAIN,
      MainStateEnter,
      StateExit,
      main_state_handlers
    },

    { HW_STATE_EDIT,
      EditStateEnter,
      StateExit,
      edit_state_handlers
    },
	
	{ HW_STATE_NOTICE,
      NoticeStateEnter,
      StateExit,
      notice_state_handlers
    }
};

/*      elfpack- */
UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T *tbl,  UINT32 *base )
{
    UINT32          i=0;
    while( tbl[i].code!=STATE_HANDLERS_END )
    {
        if(tbl[i].code==STATE_HANDLERS_RESERVED)
        {
            tbl[i].code = (*base)++;
        }
        i++;
    }
    return *base;
}

UINT32 LdrFindEventHandlerTbl( EVENT_HANDLER_ENTRY_T *tbl,  EVENT_HANDLER_T *hfn )
{
    UINT32          i=0;
    while( tbl[i].code!=STATE_HANDLERS_END )
    {
        if(tbl[i].hfunc==hfn)
        {
            return tbl[i].code;
        }
        i++;
    }

    return 0;
}


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 		status = RESULT_OK;
	UINT32      evcode_base;


    evcode_base = reserve;    //  reserve
    //    ,   STATE_HANDLERS_RESERVED
    LdrInitEventHandlersTbl( main_state_handlers, &evcode_base );


/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)HelloWorldStart );   // ,   



    LdrStartApp(evcode_base);   //  

    return 1;   //    ,  
}


/*      */
UINT32 HelloWorldStart( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;


    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
        return RESULT_FAIL; //     

    /*     */
    app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_HELLOWORLD_T), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );

    /*   */
    status = InitResources();

    status = APP_Start( ev_st,
                        &app->apt,
                        HW_STATE_INIT, //  
                        state_handling_table,
                        HelloWorldExit,
                        app_name,
                        0 );
						
			
						

    return RESULT_OK;
}


/*     */
UINT32 HelloWorldExit( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;
	APPLICATION_T           *papp = (APPLICATION_T*) app;
	
	 APP_UtilUISDialogDelete(  &papp->dialog );
    /*   */
    RemoveResources();

    /*    */
    status = APP_Exit( ev_st, app, 0 );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    main state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    UIS_DIALOG_T            dialog = 0;
    UINT32                  starting_num = 4;
    ACTIONS_T               action_list; // 

    if(type!=ENTER_STATE_ENTER) return RESULT_OK;

    InitDlgActions( &action_list );

    dialog = UIS_CreateList( &port,
                             0,
                             ENTRIES_NUM,
                             0,
                             &starting_num,
                             0,
                             2,
                             &action_list,
                             Resources[RES_LIST_CAPTION] );

   

    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;


    //   ,     starting_num 
    SendListItems(ev_st, app, 1, starting_num);
	
	if (siItem != 0)
	{
		APP_UtilAddEvUISListChange( ev_st,
                                app,
                                0, // = 0
                                siItem,
                                starting_num,
                                FALSE,
                                2,          // = 2
                                NULL,
                                NULL,
                                NULL );	
								
		UIS_HandleEvent( dialog,  ev_st );		
	}	
    return RESULT_OK;
}

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    //    
    status = APP_HandleUITokenGranted( ev_st, app );

    //   ,   state
    if( (status == RESULT_OK) && (papp->token_status == 2) )
    {
        status = APP_UtilChangeState( HW_STATE_MAIN, ev_st, app );
    }
 
    return status;
}


/* -  EV_REQUEST_LIST_ITEMS -   List    
          */
UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    EVENT_T                 *event;
    UINT32                  start, num;

    //      "",      
    if( !papp->focused ) return RESULT_OK;

    //      
    event = AFW_GetEv( ev_st );

    start = 0;
    num = 4;

    //   ,     - ,      
    APP_ConsumeEv( ev_st, app );

    return SendListItems( ev_st, app, start, num );
}

UINT32 ReadAction( EVENT_STACK_T *ev_st,  void *app )
{
	UINT8  data_buf=0;	
    APP_ConsumeEv( ev_st, app );
	//   
	seems.seem_size = 1;
	
	SEEM_ELEMENT_DATA_read 	( 	&seems,
								&data_buf,
								TRUE 
							);
	value = data_buf;
	
	APP_UtilChangeState( HW_STATE_NOTICE, ev_st, app );
    return RESULT_OK;
} 

UINT32 WriteAction( EVENT_STACK_T *ev_st,  void *app )
{
	UINT8  data_buf=0;	
    APP_ConsumeEv( ev_st, app );
	//   
	  data_buf = (UINT8)value;

	  SEEM_ELEMENT_DATA_write	(  	&seems,
									&data_buf
								);		
	APP_UtilChangeState( HW_STATE_NOTICE, ev_st, app );
    return RESULT_OK;
} 


/*            */
UINT32 SendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    LIST_ENTRY_T            *plist; //    
    UINT32                   index, status=RESULT_OK;


    if( num==0 ) return RESULT_FAIL; //  ,   

    plist = (LIST_ENTRY_T*) suAllocMem( sizeof(LIST_ENTRY_T)*num, NULL ); // malloc
    if( plist==NULL ) return RESULT_FAIL;

    //  

    for (index=0; index < 4; index ++)
    {
        plist[index].editable = FALSE;          //  
        plist[index].content.static_entry.unk6 = 1;
    }
	


        UIS_MakeContentFromString( "Mq0Sg1", &(plist[0].content.static_entry.text), L"seem:", seems.seem_element_id);
        UIS_MakeContentFromString( "Mq0Sg1", &(plist[1].content.static_entry.text), L"record:", seems.seem_record_number);
		UIS_MakeContentFromString( "Mq0Sg1", &(plist[2].content.static_entry.text), L"offset:", seems.seem_offset);
        UIS_MakeContentFromString( "Mq0Sg1", &(plist[3].content.static_entry.text), L"value:", value);
       
    //       ,    
    status = APP_UtilAddEvUISListData( ev_st, app, 0,
                                       start, num,
                                       FBF_LEAVE,
                                       sizeof(LIST_ENTRY_T)*num,
                                       plist );
									   	
    if( status!=RESULT_FAIL )
    {
        //        
        status = UIS_HandleEvent(papp->dialog, ev_st);
    }

    suFreeMem(plist);

    return status;

}

/*           */
UINT32 InitResources( )
{
    RES_ACTION_LIST_ITEM_T      action[2];
    UINT32                      status;
    WCHAR buf[32];

    //const WCHAR list_caption[64] = u_atou("List", buf);

    /*     */
    status = DRM_CreateResource( &Resources[RES_LIST_CAPTION], RES_TYPE_STRING, (void*)(u_atou("Seem Editor", buf)), (u_strlen((WCHAR*)(u_atou("Seem Editor", buf)))+1)*sizeof(WCHAR) );
    if( status!=RESULT_OK ) return status;

     status = DRM_CreateResource( &Resources[RES_EDIT_CAPTION1], RES_TYPE_STRING, (void*)(u_atou("seem", buf)), (u_strlen((WCHAR*)(u_atou("seem", buf)))+1)*sizeof(WCHAR) );
    if( status!=RESULT_OK ) return status;
	
	     status = DRM_CreateResource( &Resources[RES_EDIT_CAPTION2], RES_TYPE_STRING, (void*)(u_atou("record", buf)), (u_strlen((WCHAR*)(u_atou("record", buf)))+1)*sizeof(WCHAR) );
    if( status!=RESULT_OK ) return status;
	
	     status = DRM_CreateResource( &Resources[RES_EDIT_CAPTION3], RES_TYPE_STRING, (void*)(u_atou("offset", buf)), (u_strlen((WCHAR*)(u_atou("offset", buf)))+1)*sizeof(WCHAR) );
    if( status!=RESULT_OK ) return status;

		status = DRM_CreateResource( &Resources[RES_EDIT_CAPTION4], RES_TYPE_STRING, (void*)(u_atou("value", buf)), (u_strlen((WCHAR*)(u_atou("value", buf)))+1)*sizeof(WCHAR) );
    if( status!=RESULT_OK ) return status;


    /*    */
	action[0].softkey_label = 0;           //      
    action[0].list_label = 0x01000211;     // 
    action[0].softkey_priority = 0;
    action[0].list_priority = 1;           //     , ..        ,   0,     
    action[0].isExit = FALSE;
    action[0].sendDlgDone = FALSE;
	
	/*    */
	action[1].softkey_label = 0;           //      
    action[1].list_label = 0x010001F9;     //  
    action[1].softkey_priority = 0;
    action[1].list_priority = 2;           //     , ..        ,   0,     
    action[1].isExit = FALSE;
    action[1].sendDlgDone = FALSE;

    status = DRM_CreateResource( &Resources[RES_ACTION1], RES_TYPE_ACTION, (void*)&action[0], sizeof(RES_ACTION_LIST_ITEM_T));
    if( status!=RESULT_OK ) DRM_ClearResource( Resources[RES_LIST_CAPTION] ); 
	
	status = DRM_CreateResource( &Resources[RES_ACTION2], RES_TYPE_ACTION, (void*)&action[1], sizeof(RES_ACTION_LIST_ITEM_T));
    if( status!=RESULT_OK ) DRM_ClearResource( Resources[RES_LIST_CAPTION] );
	
    return status;
}

/*        */
UINT32 RemoveResources( )
{
    UINT32              status = RESULT_OK;
    UINT32              i;

    for(i=0;i<RES_MAX;i++)
    {
        status |= DRM_ClearResource( Resources[i] );
    }

    return status;

}

/*   */
UINT32 InitDlgActions( ACTIONS_T *action_list )
{
    /*  -           */

    /*    -    ,     
              . */

    /*     (,   ) */
    /*   List       .  - ""  "",
        EV_DONE  EV_SELECT .        . */


    /*          */
    action_list->action[0].operation = ACTION_OP_ADD;
    /*         STATE_HANDLERS_RESERVED,        */
    action_list->action[0].event = LdrFindEventHandlerTbl( main_state_handlers, WriteAction ); //       
    action_list->action[0].action_res = Resources[RES_ACTION1]; // ,  

	 /*          */
    action_list->action[1].operation = ACTION_OP_ADD;
    /*         STATE_HANDLERS_RESERVED,        */
    action_list->action[1].event = LdrFindEventHandlerTbl( main_state_handlers,  ReadAction); //       
    action_list->action[1].action_res = Resources[RES_ACTION2]; // ,  
	
	
    /*   2  */
    action_list->count = 2;

    return RESULT_OK;
}

UINT32 SelectItem (EVENT_STACK_T *ev_st,  void *app )
{
     UINT32                  status;
       // APP_HELLOWORLD_T           *papp = (APP_HELLOWORLD_T*) app;

    EVENT_T     *event = AFW_GetEv(ev_st);
	
	siItem = event->data.index;

    status = APP_UtilChangeState( HW_STATE_EDIT, ev_st, app );

	APP_ConsumeEv( ev_st, app );
    return RESULT_OK;

}

UINT32 EditStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
        APP_HELLOWORLD_T           *papp = (APP_HELLOWORLD_T*) app;
      	RESOURCE_ID             CaptionEditor;
		WCHAR hex[4];

		
		switch (siItem)
		{
			case 1: // seem
				dec2hex(seems.seem_element_id, hex);
				CaptionEditor = Resources[RES_EDIT_CAPTION1];
			break;
			
			case 2: // record
				dec2hex( seems.seem_record_number, hex);
				CaptionEditor = Resources[RES_EDIT_CAPTION2];
			break;
			
			case 3: // offset
				dec2hex(seems.seem_offset, hex);
				CaptionEditor = Resources[RES_EDIT_CAPTION3];
			break;
			
			case 4: // value
				dec2hex( value,  hex);
				CaptionEditor = Resources[RES_EDIT_CAPTION4];
			break;
			
		}
		

        papp->apt.dialog = UIS_CreateCharacterEditor( &papp->port,
                                            hex,
                                            5,
                                            4,
                                            FALSE,
                                            NULL,            //&action_list,
                                            CaptionEditor
                                            );



        if(papp->apt.dialog == 0)
            return RESULT_FAIL;


        return RESULT_OK;
}



UINT32 EditData( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                  status = 0;
    EVENT_T      *event = AFW_GetEv(ev_st);
	char buf[8];


    if (event->attachment != 0)
    {

		PFprintf( "*ELF*SeemEditor*  DATA = %d\n", (UINT8)u_atol(event->attachment));
		
		u_utoa( event->attachment, buf);
		
		switch (siItem)
		{
			case 1: // seem

				seems.seem_element_id = strtoul( buf, NULL, 16 );//    long
			break;
			
			case 2: // record
				seems.seem_record_number = strtoul( buf, NULL, 16 );//    long
			break;
			
			case 3: // offset
				seems.seem_offset = strtoul( buf, NULL, 16 ); //    long
			break;
			
			case 4: // value
				value = strtoul( buf, NULL, 16 ); //    long
			break;
        }
    }

	
    status = APP_UtilChangeState( HW_STATE_MAIN, ev_st, app );

    return status;

}

UINT32 EditOk( EVENT_STACK_T *ev_st,  void *app )
{
     UINT32                  status = 0;
     ADD_EVENT_DATA_T *ev_data;

     APP_HELLOWORLD_T           *papp = (APP_HELLOWORLD_T*) app;
     AFW_AddEvEvD(ev_st, EV_REQUEST_DATA,ev_data);
	 UIS_HandleEvent( papp->apt.dialog,  ev_st );

    return status;
}

UINT32 EditExit( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                		 status = 0;
	APP_HELLOWORLD_T          	 *papp = (APP_HELLOWORLD_T*) app;
	
	APP_UtilUISDialogDelete( &papp->apt.dialog );
    status = APP_UtilChangeState( HW_STATE_MAIN, ev_st, app );

    return status;
}

UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	 APP_HELLOWORLD_T           *papp = (APP_HELLOWORLD_T*) app;
	APP_UtilUISDialogDelete( &papp->apt.dialog );
	return RESULT_OK;
}

UINT32 NoticeStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    CONTENT_T               content;
    UIS_DIALOG_T            dialog = 0;
	
	WCHAR msg[64];

	if(type!=ENTER_STATE_ENTER) return RESULT_OK;
    
    UIS_MakeContentFromString("MCq0", &content, u_atou (" \nIt is executed", msg)); //   
    
    dialog = UIS_CreateTransientNotice( &port, &content, NOTICE_TYPE_OK );
      
    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;

    return RESULT_OK;
}

UINT32 NoticeExit( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                		 status = 0;
	APP_HELLOWORLD_T          	 *papp = (APP_HELLOWORLD_T*) app;

	APP_UtilUISDialogDelete( &papp->apt.dialog );
    status = APP_UtilChangeState( HW_STATE_MAIN, ev_st, app );

    return status;
}

WCHAR * dec2hex( UINT16 dec, WCHAR *hex )
{

	UINT16 hex_buf[4]; // 	
	UINT16 len=0; // -  hex_buf
	INT16 i; //  

	if(dec==0)
	{	
		hex[0]='0';
		hex[1]= 0;

		return hex;
	}	

	while (dec != 0)
	{
		hex_buf[len] = dec%16;
		dec = dec/16;
		len ++;
	}
	
	len--;
	
	for (i=len; i >= 0; i--)
	{
	    if(hex_buf[i]<10) hex[len-i] = '0'+hex_buf[i];
	    else hex[len-i] = 'A'+hex_buf[i]-10;
	}   
	
	
	hex[len+1] = 0;

	return hex;
}


