#include "ELF.h"
#include <dbg.h>



/*  .        */
const char app_name[APP_NAME_LEN] = "SaveAttach"; 

BOOL 	destroy=false;
UINT32 	event_code;
WCHAR	ElfFolder[256];

//     state-

/*    HW_STATE_ANY (   state) */
 EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
	{ NULL,       		      		SaveAtt },
	{ EV_KEY_PRESS,          HandleKeypress },

    //      
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { STATE_HANDLERS_END,           NULL           },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }

};


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 	status = RESULT_OK;
	UINT32  evcode_base = reserve;    //  reserve;
	int i;

	WCHAR nameCfgFile[64];
	
	UINT32 readen;
	FILE_HANDLE_T f;
	
	u_atou(file_uri, nameCfgFile);
	nameCfgFile[u_strlen(nameCfgFile)-3] = 0;
	u_strcat(nameCfgFile, L"cfg");			
	u_strcpy(ElfFolder, nameCfgFile);
	for (i=u_strlen(ElfFolder)-1; i > 0 ; i--){
        if (ElfFolder[i] == '/') { ElfFolder[i+1] = 0; break;}
    }

	udbg("nameCfgFile = %s\n", nameCfgFile);		
		
		//    		
		if (DL_FsFFileExist( nameCfgFile)) //    
		{
			f = DL_FsOpenFile(nameCfgFile, FILE_READ_MODE, 0);
			DL_FsReadFile( &event_code, sizeof(UINT32), 1, f, &readen );
			DL_FsCloseFile(f);
			dbg("event code = 0x%x\n", event_code);
		}	
	
	
	any_state_handlers[0].code = event_code;
    

/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)startApp );   // ,   
                   
		
    LdrStartApp(reserve);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;
    


    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
    {
        return RESULT_FAIL; //     
    }
    else
    {
        //    
        app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEventPrepost, //    
                                                  sizeof(APP_HELLOWORLD_T), //   
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                                  2, 0, 0 );
                                                  

        status = APP_Start( ev_st,
                            &app->apt,
                            HW_STATE_MAIN, //  
                            state_handling_table,
                            destroyApp,
                            app_name,
                            0 );
		

		


    }

    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

	if (destroy) {
	    /*    */
	    status = APP_Exit( ev_st, app, NULL );
		
		APP_UtilStopTimer(app );
		
	    /*   */
	    LdrUnloadELF(&Lib); // &Lib    
	}	
    return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    return RESULT_OK;
}

	
/*  , EV_KEY_PRESS    */
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
	
	switch (event->data.key_pressed)
	{
	
		case KEY_STAR:
			destroy = true;
			destroyApp(ev_st, app);
		break;
		
	}
	
    return RESULT_OK;
}




UINT32 SaveAtt( EVENT_STACK_T *ev_st,  void *app )
{
	FILE_HANDLE_T f;
	EVENT_T  *ev =  AFW_GetEv(ev_st);
	WCHAR  uri[256];
	WCHAR  buf[32];
	UINT32 written;

	dbg("AT_SIZE = %d\n", ev->att_size);
	
	if (ev->att_size > 0) {
	
		u_strcpy(uri, ElfFolder);
		u_ltou( ev->code,  buf );
		u_strcat(uri, buf);
		
		
		f =  DL_FsOpenFile( uri,  1,  0 );
		DL_FsWriteFile( ev->attachment,
	                      ev->att_size,
	                      1, 
	                      f,
	                      &written);
						  
		DL_FsCloseFile( f );
		
		dbg("Save Attach event 0x%x", event_code);
	}
	
	//APP_ConsumeEv( ev_st, app );
	return RESULT_OK;
}
