// by om2804
// Save As v1.3 

#include "BTSaveAs.h"
#include <dbg.h>

void *att_tmp=NULL; //   
UINT32 att_tmp_size=0;

FILEINFO            *fname=NULL;
WCHAR               cur_folder[256]; //  
UINT32              ENTRIES_NUM = 0;

WCHAR               file_name[256];
WCHAR               temp_name[128];
UINT32				fsize=0;
UINT32				foffset=0;

BOOL                send_event=false;

/*  .        */
const char app_name[APP_NAME_LEN] = "SaveAs"; 

/*     state- */


/*    HW_STATE_ANY (   state) */
 EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    /* GUI-     */
    { NULL,                         SendComplete },
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    { STATE_HANDLERS_END,           NULL           },
};

static const EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    /*   ,      UI */
    //{ EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};

EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { EV_DIALOG_DONE,                   appHide },
    { EV_REQUEST_LIST_ITEMS,        HandleListReq  },
    /* STATE_HANDLERS_RESERVED ,   - ,  
          ,      
        . LdrInitEventHandlersTbl, LdrFindEventHandlerTbl */
    { STATE_HANDLERS_RESERVED,           Fb_Action },
    { EV_SELECT,                        SelectItem },
    { EV_LIST_NAVIGATE,					  Navigate },
    { EV_DONE,                                Back },
    { STATE_HANDLERS_END,                     NULL },
};

static const EVENT_HANDLER_ENTRY_T edit_state_handlers[] =
{
    { EV_DATA,                               	 EditData  },
    { EV_DONE,                       		       EditOk  },
	{ EV_CANCEL,                 				 EditExit  },
    { STATE_HANDLERS_END,                             NULL },
};

static const EVENT_HANDLER_ENTRY_T notice_state_handlers[] =
{
    { EV_DIALOG_DONE,                              appHide },
    { STATE_HANDLERS_END,         			     	  NULL },
};

static const EVENT_HANDLER_ENTRY_T confirmation_state_handlers[] =
{
    { EV_YES,                                          Yes },
    { EV_NO,                                            No },
    { STATE_HANDLERS_END,         			     	  NULL },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { BT_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { BT_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },
    
    { BT_STATE_MAIN,
      MainStateEnter,
      MainStateExit,
      main_state_handlers
    },

    { BT_STATE_EDIT,
      EditStateEnter,
      EditStateExit,
      edit_state_handlers
    },

    { BT_STATE_NOTICE,
      NoticeStateEnter,
      NoticeStateExit,
      notice_state_handlers
    },

    { BT_STATE_CONFIRMATION,
      ConfirmationStateEnter,
      ConfirmationStateExit,
      confirmation_state_handlers
    }
};

/*      elfpack- */
UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T *tbl,  UINT32 *base )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].code==STATE_HANDLERS_RESERVED)	
		{
			tbl[i].code = (*base)++;
		}
		i++;
	}
	return *base;
}

UINT32 LdrFindEventHandlerTbl( EVENT_HANDLER_ENTRY_T *tbl,  EVENT_HANDLER_T *hfn )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].hfunc==hfn)	
		{
			return tbl[i].code;
		}
		i++;
	}

	return 0;
}


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 status = RESULT_OK;
    /*       ""  */
	UINT32 evcode_base = reserve;    //  reserve

    //    
    any_state_handlers[0].code = EV_START_PREVIEW;

    //    STATE_HANDLERS_RESERVED
	LdrInitEventHandlersTbl( main_state_handlers, &reserve );

    

    /*   demon */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           BT_STATE_MAX,            //  
                           (void*)startApp );   // ,   

   
    
    LdrStartApp(evcode_base);   //   demon
    
    return status;
}

UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_BTSAVEAS_T     *app = NULL;
    UINT32 status = RESULT_OK;


        app = (APP_BTSAVEAS_T*)APP_InitAppData( (void *)APP_HandleEventPrepost, 
                                                  sizeof(APP_BTSAVEAS_T), 
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                                  1, 0, 0 );

        app->isShow = false;

        /*   */
        status = InitResources();
                                                  

        status = APP_Start( ev_st,
                            &app->apt,
                            BT_STATE_INIT, 
                            state_handling_table,
                            appHide,
                            app_name,
                            0 );
		

    return RESULT_OK;
}



UINT32 SendComplete( EVENT_STACK_T *ev_st,  void *app )
{
	EVENT_T				*event=AFW_GetEv(ev_st);
    PREVIEW_RECORD_T    *prev_rec = event->attachment;
	
   

    dbg("Start SaveAs", NULL);

    if (send_event) {
        send_event = false;
    } else {

        //  
        att_tmp_size=event->att_size;
        att_tmp=malloc(att_tmp_size);
        memcpy(att_tmp, event->attachment, att_tmp_size);

        APP_ConsumeEv(ev_st, app);
   
       if (event->att_size != 0) {
           u_strcpy(file_name, prev_rec->name );
           u_strcpy(temp_name, prev_rec->temp_name);
		   fsize =  prev_rec->size;
		   foffset = prev_rec->offset;
       }

	
       udbg("file_name = %s", file_name);
       udbg("temp_name = %s", temp_name);
	   dbg("fsize = %d", fsize);
	   dbg("foffset = %d", foffset);
    
       appShow(ev_st,app);
    }

    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                  status;
    APPLICATION_T           *papp = (APPLICATION_T*) app;

    
    dbg("Exit", NULL);

	/*   */
	RemoveResources();
    APP_UtilUISDialogDelete( &papp->dialog );
    free(att_tmp);
    
    /*    */
    status = APP_Exit( ev_st, app, 0 );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}


UINT32 Show( EVENT_STACK_T *ev_st,  void *app, BOOL show )
{
    UINT32  status=RESULT_FAIL;
    APP_BTSAVEAS_T  *papp=(APP_BTSAVEAS_T*)app;

    if (papp->isShow != show  ) {

        papp->isShow = show;


        status=APP_ChangeRoutingStack( app, ev_st,
                                (void *)(papp->isShow ? APP_HandleEvent : APP_HandleEventPrepost),
                                (papp->isShow ? 1 : 0),
                                 0, 1, 1); 
        
    }

    return status;
}


UINT32 appHide( EVENT_STACK_T *ev_st,  void *app )
{
    dbg("hide", NULL);

    Show(ev_st, app, false);

    if (send_event) {
        //  , -     :)
        dbg("Send event 0x%x", EV_START_PREVIEW);


        AFW_CreateInternalQueuedEvAux( EV_START_PREVIEW,
                                       FBF_FREE, 
									   att_tmp_size, 
									   att_tmp ); 
    } else {
        //  
        AFW_CreateInternalQueuedEvAux( EV_START_PREVIEW+1,
                                       FBF_LEAVE, 
									   0, 
									   0 ); 

    }

    return RESULT_OK;
}

UINT32 appShow( EVENT_STACK_T *ev_st,  void *app )
{    
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    dbg("show", NULL);

    
    if (papp->state != BT_STATE_MAIN) 
    APP_UtilChangeState( BT_STATE_MAIN, ev_st, app );
    status=Show(ev_st, app, true);
    if (status == RESULT_OK) send_event = true;
    

    return RESULT_OK;
}
/*    main state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    UIS_DIALOG_T            dialog = 0;
	UINT32					starting_num;
	ACTIONS_T				action_list; // 



	if(type!=ENTER_STATE_ENTER) return RESULT_OK;

	
    u_strcpy(cur_folder, L"/"); 
    FindFile( cur_folder, L"*" ); 

    InitDlgActions( &action_list );
    DRM_SetResource(Resources[RES_LIST_CAPTION],  (void*)cur_folder, (u_strlen(cur_folder)+1)*sizeof(WCHAR));

	
	dialog = UIS_CreateList( &port,
							 0,
							 ENTRIES_NUM,
							 0,
							 &starting_num,
							 0,
							 2,
							 &action_list,
							 Resources[RES_LIST_CAPTION] );
  
   
    if(dialog == 0) return RESULT_FAIL;
    papp->dialog = dialog;

    UIS_SetCenterSelectAction (papp->dialog, LdrFindEventHandlerTbl( main_state_handlers, Fb_Action ) );


	//   ,     starting_num 
	SendListItems(ev_st, app, 1, starting_num);

    return RESULT_OK;
}

UINT32 MainStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

    if ( type == EXIT_STATE_SUSPEND )
      return RESULT_OK;

	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}

UINT32 EditStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UIS_DIALOG_T            dialog = NULL;


    if(type!=ENTER_STATE_ENTER) 
		return RESULT_OK;


        dialog = UIS_CreateCharacterEditor( &papp->port,
                                            file_name,
                                            1,
                                            255,
                                            FALSE,
                                            NULL,            
                                            LANG_SAVE_AS
                                            );

        if(dialog == NULL) return RESULT_FAIL;

        papp->dialog = dialog;

        return RESULT_OK;
}

UINT32 EditStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

    if ( type == EXIT_STATE_SUSPEND )
      return RESULT_OK;

	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}

UINT32 EditData( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32              status = 0;
    EVENT_T             *event = AFW_GetEv(ev_st);
    APP_BTSAVEAS_T      *papp=(APP_BTSAVEAS_T*)app;
    WCHAR               dst[256];
    WCHAR               src[128];


    u_strcpy(file_name, (WCHAR*)(event->attachment));

    u_strcpy(dst, L"file:/");
    u_strcat(dst, cur_folder);
    if (papp->item > 1 || !u_strcmp(cur_folder, L"/")){
        u_strcat(dst, fname[papp->item-1].name);
        u_strcat(dst, L"/");
    }
    u_strcat(dst, file_name);

    // ?
    if ( DL_FsFFileExist(dst)){
            return APP_UtilChangeState( BT_STATE_CONFIRMATION , ev_st, app );
    }

    u_strcpy(src, L"file:/" );
    u_strcat(src, temp_name );
    	

    status = CopyFile( src, dst, foffset, fsize);


    if (status == RESULT_OK) {
        send_event = false;
        APP_UtilChangeState( BT_STATE_NOTICE, ev_st, app );
    } else {
        send_event = true;
        APP_UtilChangeState( BT_STATE_MAIN, ev_st, app );
    }
    
    return status;
}

UINT32 EditOk( EVENT_STACK_T *ev_st,  void *app )
{
     UINT32                  status = 0;
     ADD_EVENT_DATA_T        *ev_data;
     APPLICATION_T           *papp = (APPLICATION_T*) app;

     status = AFW_AddEvEvD(ev_st, EV_REQUEST_DATA, ev_data);
	 UIS_HandleEvent( papp->dialog,  ev_st );

    return status;
}

UINT32 EditExit( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                	    status = 0;

    status = APP_UtilChangeState(BT_STATE_MAIN, ev_st, app );
    
    return status;
}

UINT32 NoticeStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UIS_DIALOG_T            dialog = NULL;
    CONTENT_T               content;


    if(type!=ENTER_STATE_ENTER) 
        return RESULT_OK;

    UIS_MakeContentFromString( "s0",  &content,  LANG_STORED );
    dialog = UIS_CreateTransientNotice( &papp->port, &content,  NOTICE_TYPE_OK );


        if(dialog == NULL) return RESULT_FAIL;

        papp->dialog = dialog;

        return RESULT_OK;
}

UINT32 NoticeStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	//APPLICATION_T           *papp = (APPLICATION_T*) app;

	//APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}


UINT32 ConfirmationStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UIS_DIALOG_T            dialog = NULL;
    CONTENT_T               content;


    if(type!=ENTER_STATE_ENTER) 
        return RESULT_OK;
#ifdef L9
    UIS_MakeContentFromString( "s0",  &content,  0x01001CF8 );
#else
    UIS_MakeContentFromString( "s0",  &content,  0x01001CDB ); //  . ?
#endif
    dialog = UIS_CreateConfirmation( &papp->port, &content );


        if(dialog == NULL) return RESULT_FAIL;

        papp->dialog = dialog;

        return RESULT_OK;
}

UINT32 ConfirmationStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

    if ( type == EXIT_STATE_SUSPEND )
      return RESULT_OK;

	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}

UINT32 Yes (EVENT_STACK_T *ev_st,  void *app ) 
{
    UINT32              status;
    APP_BTSAVEAS_T      *papp=(APP_BTSAVEAS_T*)app;
    WCHAR               dst[256];
    WCHAR               src[128];


    u_strcpy(dst, L"file:/");
    u_strcat(dst, cur_folder);

    if (papp->item > 1 || !u_strcmp(cur_folder, L"/")){
        u_strcat(dst, fname[papp->item-1].name);
        u_strcat(dst, L"/");
    }
    u_strcat(dst, file_name);

    u_strcpy(src, L"file:/" );
    u_strcat(src, temp_name );

    status = CopyFile( src, dst, foffset, fsize );

    if (status == RESULT_OK) {
        send_event = false;
        APP_UtilChangeState( BT_STATE_NOTICE, ev_st, app );
    } else {
        //send_event = true;
        APP_UtilChangeState( BT_STATE_MAIN, ev_st, app );
    }

    return RESULT_OK;
}

UINT32 No (EVENT_STACK_T *ev_st,  void *app ) 
{
    APP_UtilChangeState( BT_STATE_EDIT, ev_st, app );
    return RESULT_OK;
}



UINT32 Navigate (EVENT_STACK_T *ev_st,  void *app )
{
    APP_BTSAVEAS_T   *papp=(APP_BTSAVEAS_T*)app;

	papp->item = (AFW_GetEv(ev_st))->data.index;
	return RESULT_OK;
}


/* -  EV_REQUEST_LIST_ITEMS -   List    
          */
UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app )
{
	APPLICATION_T			*papp = (APPLICATION_T*) app;
	EVENT_T					*event;
	UINT32					start, num;

	//      "",      
	if( !papp->focused ) return RESULT_OK;

	//      
	event = AFW_GetEv( ev_st );

	start = event->data.list_items_req.begin_idx;
	num = event->data.list_items_req.count;

	//   ,     - ,      
	APP_ConsumeEv( ev_st, app );
	
	return SendListItems( ev_st, app, start, num );
}

UINT32 Fb_Action( EVENT_STACK_T *ev_st,  void *app )
{
    APP_BTSAVEAS_T   *papp=(APP_BTSAVEAS_T*)app;



	APP_ConsumeEv( ev_st, app );

     if (papp->item == 1 && u_strcmp(cur_folder, L"/")) {
         // 
         Back(ev_st,app);
      }
      else
      {
          if (fname[papp->item-1].attrib & FS_ATTR_DIRECTORY)
          {
              //   
              papp->prev_item = papp->item; 

              u_strcat(cur_folder, fname[papp->item-1].name);
              u_strcat(cur_folder, L"/");

              FindFile(cur_folder, L"*");

              Update(ev_st, app, 1);
           }
           else
           {

           }
      }

	return RESULT_OK;
}

UINT32 SelectItem(EVENT_STACK_T *ev_st,  void *app)
{
    APP_UtilChangeState( BT_STATE_EDIT, ev_st, app );

    return RESULT_OK;
}

UINT32 Back( EVENT_STACK_T *ev_st,  void *app )
{
    APP_BTSAVEAS_T          *papp = (APP_BTSAVEAS_T*) app;
    UINT32                  i;


         if (!u_strcmp(cur_folder, L"/")) {
             appHide(ev_st,app);
         } else {
             // 
             if (cur_folder[u_strlen(cur_folder)-1] == '/') cur_folder[u_strlen(cur_folder)-1] = 0;
    
             for (i=u_strlen(cur_folder)-1; i > 0 ; i--)  {
                 if (cur_folder[i] == '/') {
                     break;
                 } else {
                     cur_folder[i] = 0;
                 }
             }
                  FindFile(cur_folder, L"*");

                  papp->item = papp->prev_item;
                  papp->prev_item=1;
                  Update(ev_st, app, papp->item);
         }


    return RESULT_OK;
}

//  
UINT32 Update( EVENT_STACK_T *ev_st,  void *app, UINT32 sItem )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    ACTIONS_T				action_list; // 

    DRM_SetResource(Resources[RES_LIST_CAPTION],  (void*)cur_folder, (u_strlen(cur_folder)+1)*sizeof(WCHAR));
   
	if (sItem != 0)
	{
        InitDlgActions( &action_list );
        UIS_SetActionList(papp->dialog, &action_list);   

		APP_UtilAddEvUISListChange( ev_st,
                                app,
                                0, // = 0
                                sItem,
                                ENTRIES_NUM,
                                TRUE,
                                2,          // = 2
                                FBF_LEAVE,
                                NULL,
                                NULL );	
								
		UIS_HandleEvent( papp->dialog,  ev_st );

        
	}

    UIS_Refresh();

	return RESULT_OK;
}

/*            */
UINT32 SendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
	APPLICATION_T			*papp = (APPLICATION_T*) app;
	LIST_ENTRY_T			*plist; //    
	UINT32					i, index, status=RESULT_OK;
    
    if( num==0 ) return RESULT_FAIL; //  ,   

	plist = (LIST_ENTRY_T*) suAllocMem( sizeof(LIST_ENTRY_T)*num, NULL ); // malloc
	if( plist==NULL ) return RESULT_FAIL;

	//  
	for( index=0, i=start; (i<start+num) && (i<=ENTRIES_NUM); i++, index++)
	{
		plist[index].editable = FALSE;			//  
		plist[index].content.static_entry.unk6 = 1;

		//        
		 UIS_MakeContentFromString( "p1q0", &(plist[index].content.static_entry.text), fname[i-1].name, DRMRES_FOLDER);
	}

	//       ,    
	status = APP_UtilAddEvUISListData( ev_st, app, 0,
									   start, num,
									   FBF_LEAVE,
									   sizeof(LIST_ENTRY_T)*num,
									   plist );
	if( status!=RESULT_FAIL )
	{
		//        
		status = UIS_HandleEvent(papp->dialog, ev_st);
	}

	suFreeMem(plist);

	return status;

}

/*           */
UINT32 InitResources( )
{
    RES_ACTION_LIST_ITEM_T		action[3];
    UINT32						status;

	const WCHAR list_caption[] = L"Save As";

	/*     */
    status = DRM_CreateResource( &Resources[RES_LIST_CAPTION], RES_TYPE_STRING, (void*)list_caption, (u_strlen((WCHAR*)list_caption)+1)*sizeof(WCHAR) );
	if( status!=RESULT_OK ) return status;
  

	/*    */
    action[0].softkey_label = LANG_SAVE;			//      
    action[0].list_label = 0;		
    action[0].softkey_priority = 1;
    action[0].list_priority = 0;			//     , ..        ,   0,     
    action[0].isExit = FALSE;
    action[0].sendDlgDone = FALSE;


    /*    */
    action[1].softkey_label = LANG_EXIT;			
    action[1].list_label = 0;		
    action[1].softkey_priority = -1;
    action[1].list_priority = 0;			
    action[1].isExit = FALSE;
    action[1].sendDlgDone = FALSE;

    /*    */
    action[2].softkey_label = LANG_BACK;			
    action[2].list_label = 0;		
    action[2].softkey_priority = -1;
    action[2].list_priority = 0;			
    action[2].isExit = FALSE;
    action[2].sendDlgDone = FALSE;


    status |= DRM_CreateResource( &Resources[RES_ACTION0], RES_TYPE_ACTION, (void*)&action[0], sizeof(RES_ACTION_LIST_ITEM_T));
	if( status!=RESULT_OK ) return status;

    status |= DRM_CreateResource( &Resources[RES_ACTION1], RES_TYPE_ACTION, (void*)&action[1], sizeof(RES_ACTION_LIST_ITEM_T));
	if( status!=RESULT_OK ) return status;

    status |= DRM_CreateResource( &Resources[RES_ACTION2], RES_TYPE_ACTION, (void*)&action[2], sizeof(RES_ACTION_LIST_ITEM_T));
	if( status!=RESULT_OK ) return status;

    return status;
}

/*        */
UINT32 RemoveResources( )
{
	UINT32				status = RESULT_OK;
	UINT32				i;

	for(i=0;i<RES_MAX;i++)
	{
		status |= DRM_ClearResource( Resources[i] );
	}

	return status;
}

/*   */
UINT32 InitDlgActions( ACTIONS_T *action_list )
{
	/*  -           */
	
	/*    -    ,     
		      . */

	/*     (,   ) */
	/*   List       .  - ""  "",
		EV_DONE  EV_SELECT .        . */

    action_list->action[0].operation = ACTION_OP_UPDATE; 
	/*         STATE_HANDLERS_RESERVED,        */
    action_list->action[0].event = EV_SELECT; //       
    action_list->action[0].action_res = Resources[RES_ACTION0]; // ,  
	

    if (!u_strcmp(cur_folder, L"/")) {
        dbg("root action_list", NULL);
        action_list->action[1].operation = ACTION_OP_UPDATE; 
        /*         STATE_HANDLERS_RESERVED,        */
        action_list->action[1].event = EV_DONE; //       
        action_list->action[1].action_res = Resources[RES_ACTION1]; // ,  
    } else {
        action_list->action[1].operation = ACTION_OP_UPDATE; 
        /*         STATE_HANDLERS_RESERVED,        */
        action_list->action[1].event = EV_DONE; //       
        action_list->action[1].action_res = Resources[RES_ACTION2]; // ,  
    }

    action_list->count = 2;

    return RESULT_OK;
}



UINT32 FindFile( WCHAR *folder, WCHAR *filtr ) //  
{
    INT32                   err=RESULT_OK;
     FS_SEARCH_PARAMS_T		sp;
     FS_SEARCH_RESULT_T		hResult;
     FS_SEARCH_HANDLE_T		hSearch;
    
    
     UINT16		count_files=0, count_res=1;
     UINT32		status = RESULT_OK;
     INT32		i=0, j=0;

     WCHAR       volumes[12];
    
     WCHAR       search_string[256];


     if ( folder==NULL || !u_strcmp(folder, L"/")) {
             u_strcpy(search_string, L"/");
     } else {
         //    file://
         if(u_strncmp(folder, L"file:/", 6))
         {
             u_strcpy(search_string, L"file:/");
             u_strcat(search_string, folder);
         } else {
             u_strcpy(search_string, folder);
         }
    
         //    
         if ( folder[u_strlen(folder)-1] != '/' ) 
             u_strcat(search_string, L"/");
    
         u_strcat(search_string, L"\xFFFE");
         u_strcat(search_string, filtr);
     }

 /////  /////
 // 1)    `a`  hResult.name  !
 // 2)       .      .   "    "
 //////////////////////

    dbg("Find files...", NULL);


    if (!u_strcmp(search_string, L"/")) { // 

        DL_FsVolumeEnum(volumes);

        free(fname);
        fname = suAllocMem(sizeof(FILEINFO)*4, &err);
        if (err != RESULT_OK) return RESULT_FAIL;

        cur_folder[0] = '/';

        ENTRIES_NUM = 0;

        for (i=0; i < 4; i++) {
            fname[i].name[0] = volumes[i*3+1];//'a' + i;
            fname[i].name[1] = 0;
            fname[i].attrib = FS_ATTR_DIRECTORY;


            ENTRIES_NUM++;

            if (volumes[i*3+2] == NULL)  break;
        }

        return RESULT_OK;
    }

	
    sp.flags = 0x1C; 
	sp.attrib = FS_ATTR_DIRECTORY;
	sp.mask = FS_ATTR_DIRECTORY;
	
	status = DL_FsSSearch( sp, search_string, &hSearch, &count_files, 0 );
    dbg("Search status = %d", status);
	if ( status != RESULT_OK ) {
        DL_FsSearchClose( hSearch );
        return RESULT_FAIL;
    }

    dbg("count_files = %d", count_files);
	
	ENTRIES_NUM = count_files+1;

	dbg("Memory Fbrowser !", NULL);
	free(fname);
    dbg("Free file_list !", NULL);
    fname = suAllocMem(sizeof(FILEINFO)*(count_files+1), &err);
    dbg("Alloc error = %d", err);
    if (err != RESULT_OK) return RESULT_FAIL;
	

	u_strcpy(fname[0].name, L"..");
	fname[0].attrib = FS_ATTR_DIRECTORY;



    for ( i=0, j=1; j<=count_files; i++ ) {

		status = DL_FsSearchResults( hSearch, i, &count_res, &hResult );
		if ( status == RESULT_OK ) 
		{
            
           //     "    "
            if(!u_strcmp(hResult.name+u_strlen(hResult.name)-1, L"/")) continue;


			u_strcpy(fname[j].name, SplitPath(hResult.name, L"/"));
			fname[j].attrib = hResult.attrib;

		} 
        j++;
	}

	DL_FsSearchClose( hSearch ); 


    dbg("Find files end", NULL);

	
	return RESULT_OK;
}


WCHAR* SplitPath( WCHAR* path, WCHAR* spliter ) 
{
	int j = u_strlen(path)-2;
	while( j > 0 ) 
	{
		if ( !u_strncmp(path+j, spliter, 1) ) 
		{
			return path+j+1;
		}
		j--;
	}
	return path;
}


#define _BUF_SIZE                0x2000

UINT32 CopyFile( WCHAR *src, WCHAR *dst, UINT32 offset, UINT32 size)
{
     char                    	cbuf[_BUF_SIZE];     // Copy buffer
     FILE_HANDLE_T          	fSrc, fDst;
     UINT32                    	buf_size; 
	UINT32						total=0;


     if ( !DL_FsFFileExist(src) )
          return RESULT_FAIL;     

     fSrc = DL_FsOpenFile( src, FILE_READ_MODE, NULL );
	 if ( fSrc == FILE_HANDLE_INVALID ) {
		dbg("Src file no open", NULL);
		return RESULT_FAIL;
	 }
	 
     fDst = DL_FsOpenFile( dst, FILE_WRITE_MODE, NULL );
	 if ( fDst == FILE_HANDLE_INVALID ) {
		dbg("Dst file no open", NULL);
		return RESULT_FAIL;
	 }

     dbg("CopyFile. _BUF_SIZE = %d bytes", _BUF_SIZE);

     buf_size = _BUF_SIZE;
	 DL_FsFSeekFile( fSrc,  offset, SEEK_WHENCE_SET ); //   
     while(total < size) {
          DL_FsReadFile( cbuf, 1, buf_size, fSrc, &buf_size);
          dbg("CopyFile. Readed %d bytes", buf_size);
			  
          DL_FsWriteFile( cbuf, 1, buf_size, fDst, &buf_size );
          dbg("CopyFile. Writed %d bytes",buf_size);
		  total += buf_size;
     }
          
     DL_FsCloseFile(fSrc);
     DL_FsCloseFile(fDst);
	 
	 if (offset == 0) DL_FsDeleteFile(src, 0); //   ,  ,   MMS
     
     return RESULT_OK;
}
