#include "ELF.h"
#include <dbg.h>

extern const UINT32 *SEEM_IMSI;

#define DAT_FILE_NAME   L"file://a/itunes.dat"

#define IMSI_NAME       "imsi"
#define NO_NAME         "no"
#define TEXT_NAME       "text"

#define IMSI_LEN_MAX    16
#define NO_LEN_MAX      51
#define TEXT_LEN_MAX    161

BOOL        NET_REG=false;
BOOL		APP_DESTROY=false;

// - imsi  no
UINT32      no_count=0;
UINT32      imsi_count=0;
UINT32      num_no=0; //  id 

typedef struct
{
    char   d[IMSI_LEN_MAX];
} IMSI_T;

typedef struct
{
    char   d[NO_LEN_MAX];
} NO_T;

char    text[TEXT_LEN_MAX];

IMSI_T  *imsi=NULL;
NO_T    *no=NULL;

SEND_TEXT_MESSAGE_T   send_msg;


/*  .        */
const char app_name[APP_NAME_LEN] = "SmsAlarm"; 



//     state-

/*    HW_STATE_ANY (   state) */
 EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  

    { EV_TIMER_EXPIRED,       		     Timer },
    { EV_REG_NETWORK,                    Start },


    //      
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { STATE_HANDLERS_END,           NULL           },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { MA_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { MA_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }

};


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32              evcode_base;
    UINT32              status = RESULT_OK;

    evcode_base = reserve;    //  reserve
    


/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           MA_STATE_MAX,            //  
                           (void*)startApp );   // ,   
                   
		
    LdrStartApp(reserve);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_MSGALARM_T     *app = NULL;
    UINT32 status = RESULT_OK;
    

        //    
        app = (APP_MSGALARM_T*)APP_InitAppData( (void *)APP_HandleEventPrepost, //    
                                                  sizeof(APP_MSGALARM_T), //   
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                                  2, 0, 0 );
                                                  

        status = APP_Start( ev_st,
                            &app->apt,
                            MA_STATE_MAIN, //  
                            state_handling_table,
                            destroyApp,
                            app_name,
                            0 );

       dbg("MajorVersion = %s", LdrGetFirmwareMajorVersion());


    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

    dbg("Exit!", NULL);

    free(imsi);
    free(no);


    /*    */
    status = APP_Exit( ev_st, app, NULL );
	
    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    return RESULT_OK;
}


UINT32 Start( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

    if (!NET_REG) {
		NET_REG = true;  

		status = Parser();
		dbg("Parser status = %d", status);
           if (status == RESULT_FAIL) 
               return destroyApp(ev_st,app);
    
           status = ImsiCmp();
		   dbg("ImsiCmp status = %d", status);
           if (status == 2) {
               Saver();
			   dbg("Saver status = %d", 1);
			   APP_DESTROY = true;
               Blink_Led( app,  0xFF0 );
           } else if (status == 0) {
               SendMsg(app);
           } else {
			   APP_DESTROY = true;
               Blink_Led( app,  0x0F0 );
           }
    }
    return RESULT_OK;
}


UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  id = ((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID;

    if (id == 10 ) {
        if (namecmp((char*)LdrGetFirmwareMajorVersion(), "R373") )
            HAPI_LP393X_set_tri_color_led( 0,  0x000 );

        dbg("Timer 10", NULL);

        if (num_no < no_count-1  && !APP_DESTROY) {
             num_no++;
             dbg("num_no = %d", num_no);
             APP_UtilStopTimer( app );
             APP_UtilStartTimer(10000,11,app);
        } else {
            destroyApp(ev_st,app);
        }

    } else if (id == 11 ) {
        dbg("Timer 11", NULL);
        APP_UtilStopTimer( app );
        SendMsg(app);
    }
	
	return RESULT_OK;
}

#define TYPE_IMSI   0
#define TYPE_NO     1
#define TYPE_TEXT   2

#define PARS_NAME   0
#define PARS_NUM    1
#define PARS_VAL    2

UINT32 Parser()
{
    char            *bufR=NULL;

	UINT32          readen;
	FILE_HANDLE_T   f;
	UINT32          fSize;

    UINT8           pars_state;
    UINT8           type;       //  

    char            buf[8];    // 
    UINT32          number;

    UINT32          i=0, j=0;

	dbg("Start Parser", NULL);
    

    if (DL_FsFFileExist(DAT_FILE_NAME)) //    
	{
		f = DL_FsOpenFile(DAT_FILE_NAME, FILE_READ_MODE, 0);
		fSize = DL_FsGetFileSize(f);
		bufR = (char*) malloc( fSize);
		DL_FsReadFile( bufR, fSize, 1, f, &readen );
        DL_FsCloseFile(f);

        imsi_count = 0;
        no_count = 0;

        //   imsi  no

        for (i=0; i < fSize ; i++)
        {
            if (bufR[i] == '\n')
            {
                j=0;
            }
            else 
            {
                if(bufR[i] == '\r' || bufR[i] == '-') continue;

                buf[j] = bufR[i];
                buf[j+1] = 0;
                if (j<7) j++;

                if (namecmp(buf, IMSI_NAME)) {
                     j = 0;
                     imsi_count++;
                 } else if (namecmp(buf, NO_NAME)) {
                     j = 0;
                     no_count++;
                 }  
            }
        }

        dbg("imsi_count = %d",imsi_count);
        dbg("no_count = %d",no_count);

        imsi = (IMSI_T*)malloc(imsi_count*sizeof(IMSI_T));
        no = (NO_T*)malloc(no_count*sizeof(NO_T));

        dbg("Alloc for imsi, no!", NULL);

        //   imsi, no, text
        for (i=0; i < imsi_count; i++) {
            imsi[i].d[0]=0;
        }

        for (i=0; i < no_count; i++) {
            no[i].d[0]=0;
        }

        text[0] = 0;


            pars_state = PARS_NAME;
            j=0;

        for (i=0; i < fSize ; i++)
        {
            if (bufR[i] == '\n')
            {
                pars_state = PARS_NAME;
                j=0;


                        if (type == TYPE_IMSI) {
                            if(imsi[number].d[0]) dbg("IMSI_%d = %s",number, imsi[number].d);
                        } else if (type == TYPE_NO) {
                            if(no[number].d[0]) dbg("NO_%d = %s",number, no[number].d);
                        } else if (type == TYPE_TEXT) {
                            if(text[0]) dbg("TEXT = %s", text);
                        }

            }
            else if (bufR[i] == '=') 
            { 
                number = strtoul(buf, 0, 10);
                pars_state = PARS_VAL;
                j=0;
            } 
            else 
            {
                if(bufR[i] == '\r' || bufR[i] == '-') continue;

                    if (pars_state == PARS_NAME){

                        buf[j] = bufR[i];
                        buf[j+1] = 0;
                        if (j<7)j++;

                        if (namecmp(buf, IMSI_NAME)) {
                            type = TYPE_IMSI;
                            pars_state = PARS_NUM;
                            j = 0;
                        } else if (namecmp(buf, NO_NAME)) {
                            type = TYPE_NO;
                            pars_state = PARS_NUM;
                            j = 0;
                        } else if (namecmp(buf, TEXT_NAME)) {
                            type = TYPE_TEXT;
                            pars_state = PARS_VAL;
                            j = 0;
                        } 
            

                    } else if (pars_state == PARS_NUM) {

                        buf[j] = bufR[i];
                        buf[j+1] = 0;
                        j++;

                    } else if (pars_state == PARS_VAL) { 

                        if (type == TYPE_IMSI) {
                            imsi[number].d[j] = bufR[i];
                            imsi[number].d[j+1] = 0;
                        } else if (type == TYPE_NO) {
                            no[number].d[j] = bufR[i];
                            no[number].d[j+1] = 0;
                        } else if (type == TYPE_TEXT) {
                            text[j] = bufR[i];
                            text[j+1] = 0;
                        }

                        j++;
                    }
            }
        }

        free(bufR);

    } else return RESULT_FAIL;

    return RESULT_OK;
}

UINT32 ImsiCmp()
{
    WCHAR   buf[16];
    char    IMSI[16];
    UINT32  i;
    UINT32  new_imsi_num=0;
    BOOL    new_imsi=false;
	
	dbg("Start ImsiCmp", NULL);

    DL_DbFeatureGetValueString(*SEEM_IMSI, buf );
    u_utoa(buf, IMSI);


    dbg("IMSI = %s",IMSI);


     for (i=0; i<imsi_count; i++) {
        if (imsi[i].d[0]){
            if (imsi[i].d[0] == 'x') {
                new_imsi_num = i;
                new_imsi = true;
            } else {
                
                if (namecmp(imsi[i].d, IMSI)){
                    dbg("IMSI Ok!", NULL);
                     return 1; //  IMSI
                }
            }
        }
    }

     if (new_imsi) {
        dbg("New IMSI", NULL);
        strcpy(imsi[new_imsi_num].d, IMSI);
        return  2; //  IMSI
     }

    dbg("IMSI FAILED!", NULL);
    return 0; //  IMSI !
}

UINT32  Saver()
{
    char            *bufW=NULL;
    UINT32          size_bufW=0;
    char            buf[8];

    UINT32          written;
    FILE_HANDLE_T   f;
    UINT32          i;
	
	dbg("Start Saver", NULL);


    //   bufW
    for (i=0; i < imsi_count; i++) {
         if (imsi[i].d[0]) size_bufW += strlen(IMSI_NAME) + strlen(itoa(i, buf, 10)) + 1 + strlen(imsi[i].d)+2;
    }

    for (i=0; i < no_count; i++) {
         if (no[i].d[0]) size_bufW += strlen(NO_NAME) + strlen(itoa(i, buf, 10)) + 1 + strlen(no[i].d)+2;
    }

    size_bufW += strlen(TEXT_NAME) + 1 + strlen(text)+2;

    dbg("size_bufW = %d", size_bufW);

    bufW = (char*)malloc(size_bufW);
    bufW[0] = 0;

    //  imsi
    for (i=0; i < imsi_count; i++) {
        if (imsi[i].d[0]) {
            strcat(bufW, IMSI_NAME);
            strcat(bufW, itoa(i, buf, 10));
            strcat(bufW, "=");
            strcat(bufW, imsi[i].d);
            strcat(bufW, "\r\n");
        }
    }

    //  no
    for (i=0; i < no_count; i++) {
        if (no[i].d[0]) {
            strcat(bufW, NO_NAME);
            strcat(bufW, itoa(i, buf, 10));
            strcat(bufW, "=");
            strcat(bufW, no[i].d);
            strcat(bufW, "\r\n");
        }
    }

    //  text
    strcat(bufW, TEXT_NAME);
    strcat(bufW, "=");
    strcat(bufW, text);
    strcat(bufW, "\r\n\x0");

	dbg("Save Data", NULL);

    f = DL_FsOpenFile(DAT_FILE_NAME, FILE_WRITE_MODE, 0);
    DL_FsWriteFile( bufW, size_bufW, 1, f, &written );
    DL_FsCloseFile(f);

    free(bufW);

    return RESULT_OK;
}

UINT32 SendMsg(void *app) //  
{
    IFACE_DATA_T    if_data;
	UINT16 			cell_id;

	dbg("Start SendMsg", NULL);

    if_data.port = ((APPLICATION_T*)(app))->port;


        u_atou(text, send_msg.contents);
		DL_SigRegGetCellID(&cell_id);
		u_strcat(send_msg.contents, L" CellID:");
		u_ltou(cell_id, send_msg.contents+u_strlen(send_msg.contents));
		
        send_msg.addr_type = 0;

        if (no[num_no].d[0]) u_atou(no[num_no].d, send_msg.address);
        dbg("Send Message", NULL);
       
       DL_SigMsgSendTextMsgReq(&if_data, &send_msg);


    Blink_Led(app,0xF00);

    return RESULT_OK;
}

UINT32 Blink_Led(void* app, UINT32 color )
{
	dbg("Start Blink_Led", NULL);

    if (namecmp((char*)LdrGetFirmwareMajorVersion(), "R373"))
        HAPI_LP393X_set_tri_color_led( 0,  color );
    APP_UtilStartTimer(1000,10,app);
    return RESULT_OK;
}




