#include "MidTransfer.h"
#include "bluetooth.h"
#include "addon.h"
#include <dbg.h>

#define DRMRES_SELECTED		0x120000CC
#define DRMRES_APPJAVA		0x120000D0
#define DRMRES_PHONE		0x120000D9
#define DRMRES_TRANSFLASH   0x120000DA

extern const UINT32 *SEEM_IMEI; //  IMEI

UINT32 ENTRIES_NUM = 0;		// -   

UINT32 MAX_COUNT_MIDLETS = 71;


MIDLET *midlets = NULL;

BOOL TransFlash = FALSE; // TRUE =   - 
                         // FALSE =   -  
WCHAR IMEI[16];
WCHAR kJavaDir[] = L"mobile/kjava/installed/";

int step = 708; //  




/*  .        */
const char app_name[APP_NAME_LEN] = "MidTransfer"; 

/*     state- */

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    /* GUI-     */
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    /*   ,      UI */
    { EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};

EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{

    { EV_DIALOG_DONE,                   destroyApp },
    { EV_REQUEST_LIST_ITEMS,        HandleListReq  },
    /* STATE_HANDLERS_RESERVED ,   - ,  
          ,      
        . LdrInitEventHandlersTbl, LdrFindEventHandlerTbl */
    { EV_SELECT, 					    SelectItem },
    { STATE_HANDLERS_RESERVED, switchDevice_Action },
    { EV_DONE,                          destroyApp },
    { STATE_HANDLERS_END,                     NULL },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },
    
    { HW_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }
};

/*      elfpack- */
UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T *tbl,  UINT32 *base )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].code==STATE_HANDLERS_RESERVED)	
		{
			tbl[i].code = (*base)++;
		}
		i++;
	}
	return *base;
}

UINT32 LdrFindEventHandlerTbl( EVENT_HANDLER_ENTRY_T *tbl,  EVENT_HANDLER_T *hfn )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].hfunc==hfn)	
		{
			return tbl[i].code;
		}
		i++;
	}

	return 0;
}


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 				status = RESULT_OK;
	UINT32              evcode_base=reserve; //  reserve
	//UINT32              evcode_start = 0x3A6;
	//UINT32              evcode_start=0xABCD; //  
    //int i;
	//char buf[128];
    //WCHAR nameCfgFile[128]; //  
	
 
	//    ,   STATE_HANDLERS_RESERVED
	LdrInitEventHandlersTbl( main_state_handlers, &evcode_base );
    

    /*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)startApp );   // ,   

    	//   
		/*for (i=0; i < strlen(file_uri)-3; i++)
		{
			buf[i] = file_uri[i];
		}
        buf[i] = 0;
		
		strcat(buf, "cfg");

        u_atou(buf, nameCfgFile);

        ReadSetting(nameCfgFile); */
    
    LdrStartApp(evcode_base);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;
    

    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
        return RESULT_FAIL; //     

    /*     */
    app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_HELLOWORLD_T), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );

	/*   */
	status = InitResources();

    if (status == RESULT_FAIL) 
        return RESULT_FAIL;

    status = APP_Start( ev_st,
                        &app->apt,
                        HW_STATE_INIT, //  
                        state_handling_table,
                        destroyApp,
                        app_name,
                        0 );


    return status;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;
    APPLICATION_T           *papp = (APPLICATION_T*) app;

        if (midlets != NULL ) {
            suFreeMem(midlets);
			midlets = NULL;
		}

    APP_UtilUISDialogDelete(  &papp->dialog ); //   

	/*   */
	RemoveResources();

    /*    */
    status = APP_Exit( ev_st, app, 0 );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    main state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
 
    if(type!=ENTER_STATE_ENTER) return RESULT_OK;
   
    Update(ev_st, app);

    return RESULT_OK;
}

UINT32 Update( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    UIS_DIALOG_T            dialog = 0;
	UINT32					starting_num;
	ACTIONS_T				action_list; // 


    model();
    if (decodeJ2MEST() == RESULT_FAIL) return RESULT_FAIL;


    RemoveResources();
    InitResources();

	InitDlgActions( &action_list );

    if (papp->dialog != NULL) 
        APP_UtilUISDialogDelete( &papp->dialog );

	
	dialog = UIS_CreateList( &port,
							 0,
							 ENTRIES_NUM,
							 0,
							 &starting_num,
							 1,
							 2,
							 &action_list,
							 Resources[RES_LIST_CAPTION] );
    
  

    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;

	//   ,     starting_num 
	SendListItems(ev_st, app, 1, starting_num);


	return RESULT_OK;
}

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    //    
    status = APP_HandleUITokenGranted( ev_st, app );

    //   ,   state
    if( (status == RESULT_OK) && (papp->token_status == 2) )
    {
        status = APP_UtilChangeState( HW_STATE_MAIN, ev_st, app );
    }

    return status;
}


/* -  EV_REQUEST_LIST_ITEMS -   List    
          */
UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app )
{
	APPLICATION_T			*papp = (APPLICATION_T*) app;
	EVENT_T					*event;
	UINT32					start, num;

	//      "",      
	if( !papp->focused ) return RESULT_OK;

	//      
	event = AFW_GetEv( ev_st );

	start = event->data.list_items_req.begin_idx;
	num = event->data.list_items_req.count;



	//   ,     - ,      
	APP_ConsumeEv( ev_st, app );
	
	return SendListItems( ev_st, app, start, num );
}

UINT32 switchDevice_Action( EVENT_STACK_T *ev_st,  void *app )
{
	APP_ConsumeEv( ev_st, app );

	TransFlash = !TransFlash;

    Update(ev_st, app);
	
	return RESULT_OK;
}

UINT32 SelectItem (EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
    WCHAR       uri[265];
    WCHAR       buf_uri[256];
    WCHAR       num_buf[4];

    if (TransFlash)
    {
        u_strcpy(uri, L"/b/");
        u_strcat(uri, kJavaDir);
        u_strcat(uri, IMEI);
    }
    else
    {
        u_strcpy(uri, L"/c/");
        u_strcat(uri, kJavaDir);
    }

    u_strcat(uri, L"j2me");
    u_ltou( midlets[event->data.index - 1].num,  num_buf );
    u_strcat(uri, num_buf);
    u_strcat(uri, L".jar");

    u_strcpy(buf_uri, L"file:/");
    u_strcat(buf_uri, uri);

    if (DL_FsFFileExist( buf_uri ))
    {
        udbg("SendviaBT file=%s\n", uri);
        SendViaBT( uri, "application/jar" ); //   
    }

    return RESULT_OK;
}


/*            */
UINT32 SendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
	APPLICATION_T			*papp = (APPLICATION_T*) app;
	LIST_ENTRY_T			*plist; //    
	UINT32					i, index, status=RESULT_OK;
    WCHAR                   uri[265];
    WCHAR                   num_buf[4];
    DL_FS_MID_T             mid_id;
    LIST_IMAGE_ELEMENT_T    *img_element;

   if( num==0 ) return RESULT_FAIL; //  ,   
   if (midlets == NULL) return RESULT_FAIL;

	plist = (LIST_ENTRY_T*) suAllocMem( sizeof(LIST_ENTRY_T)*num, NULL ); // malloc
	if( plist==NULL ) return RESULT_FAIL;

    img_element = (LIST_IMAGE_ELEMENT_T*)suAllocMem( sizeof(LIST_IMAGE_ELEMENT_T)*num, NULL );
    if( img_element==NULL ) return RESULT_FAIL;


	//  
	for( index=0, i=start; (i<start+num) && (i<=ENTRIES_NUM); i++, index++)
	{
		plist[index].editable = FALSE;			//  
		plist[index].content.static_entry.unk6 = 1;

            if (TransFlash)
            {
                u_strcpy(uri, L"file://b/");
                u_strcat(uri, kJavaDir);
                u_strcat(uri, IMEI);
            }
            else
            {
                u_strcpy(uri, L"file://c/");
                u_strcat(uri, kJavaDir);
            }
        
            u_strcat(uri, L"j2me");
            u_ltou( midlets[i - 1].num,  num_buf );
            u_strcat(uri, num_buf);
            u_strcat(uri, L".png");


            DL_FsGetIDFromURI(uri,  &mid_id);


            img_element[index].image.file_id = mid_id;
            img_element[index].image_type = LIST_IMAGE_DL_FS_MID_T;
            img_element[index].image_index = i;


		//        
		UIS_MakeContentFromString( "j1q0", &(plist[index].content.static_entry.text), midlets[i-1].name, &img_element[index]);

    }

	//       ,    
	status = APP_UtilAddEvUISListData( ev_st, app, 0,
									   start, num,
									   FBF_LEAVE,
									   sizeof(LIST_ENTRY_T)*num,
									   plist );

    if( status!=RESULT_FAIL )
	{
		//        
		status = UIS_HandleEvent(papp->dialog, ev_st);
	} 

	suFreeMem(plist);
    suFreeMem(img_element);

    

	return status;

}

/*           */
UINT32 InitResources( )
{
    RES_ACTION_LIST_ITEM_T		action;
    UINT32						status;
    CONTENT_T dst;

    if (TransFlash)
    {
        UIS_MakeContentFromString( "Mp0Mq1",  &dst,  DRMRES_TRANSFLASH, L"MidTransfer");
    }
    else
    {
        UIS_MakeContentFromString( "Mp0Mq1",  &dst,  DRMRES_PHONE, L"MidTransfer");
    }

	/*     */
    status = DRM_CreateResource( &Resources[RES_LIST_CAPTION], RES_TYPE_CONTENT, (void*)&dst, sizeof(dst) );
	if( status!=RESULT_OK ) return status;

	/*    */
    action.softkey_label = 0;			//      
    action.list_label = 0x01001150;		//    
    action.softkey_priority = 0;
    action.list_priority = 1;			//     , ..        ,   0,     
    action.isExit = FALSE;
    action.sendDlgDone = FALSE;

    status = DRM_CreateResource( &Resources[RES_ACTION1], RES_TYPE_ACTION, (void*)&action, sizeof(RES_ACTION_LIST_ITEM_T));
	if( status!=RESULT_OK ) DRM_ClearResource( Resources[RES_LIST_CAPTION] );
    return status;
}

/*        */
UINT32 RemoveResources( )
{
	UINT32				status = RESULT_OK;
	UINT32				i;

	for(i=0;i<RES_MAX;i++)
	{
		status |= DRM_ClearResource( Resources[i] );
	}

	return status;

}

/*   */
UINT32 InitDlgActions( ACTIONS_T *action_list )
{
	/*  -           */
	
	/*    -    ,     
		      . */

	/*     (,   ) */
	/*   List       .  - ""  "",
		EV_DONE  EV_SELECT .        . */


	/*          */	
    action_list->action[0].operation = ACTION_OP_ADD; 
	/*         STATE_HANDLERS_RESERVED,        */
    action_list->action[0].event = LdrFindEventHandlerTbl( main_state_handlers, switchDevice_Action ); //       
    action_list->action[0].action_res = Resources[RES_ACTION1]; // ,  

	/*      */
    action_list->count = 1;

    return RESULT_OK;
}

/*
UINT32 ReadSetting(WCHAR *nameCfgFile) //    
{
	UINT32 bufR[1];
	UINT32 readen;
	FILE_HANDLE_T f;
	
	//    
	if (DL_FsFFileExist( nameCfgFile)) //    
	{
		f = DL_FsOpenFile(nameCfgFile, FILE_READ_MODE, 0);
		DL_FsReadFile( bufR, 4, 1, f, &readen );
			Setting.BT_ev = bufR[0];
		DL_FsCloseFile(f);

            PFprintf("*ELF MidTransfer* BT_ev = 0x%x\n", Setting.BT_ev);
	}
	
	return RESULT_OK;
} */


UINT32 decodeJ2MEST(void) //   J2MEST
{
    WCHAR path_J2MEST[128];

    int i1 = 0; // -  - 1 
    int j = 0;

	UINT8 *bufR=NULL;
	UINT8 bufUTF8[38];
	UINT32 readen;
	FILE_HANDLE_T f;
    UINT32 fSize; //  

    if (TransFlash)
    {
        u_strcpy(path_J2MEST, L"file://b/");
        u_strcat(path_J2MEST, kJavaDir);
        u_strcat(path_J2MEST, IMEI);
        u_strcat(path_J2MEST, L"J2MEST");
    }
    else
    {
        u_strcpy(path_J2MEST, L"file://a/");
        u_strcat(path_J2MEST, kJavaDir);
        u_strcat(path_J2MEST, L"J2MEST");
    }

    ENTRIES_NUM = 0;
	
	//  J2MEST
	if (DL_FsFFileExist( path_J2MEST )) //    
	{
		f = DL_FsOpenFile(path_J2MEST, FILE_READ_MODE, 0);
                
        fSize = DL_FsGetFileSize(f);
        dbg("fSize = %d\n", fSize);
		
        MAX_COUNT_MIDLETS = fSize/step;
        dbg("MAX_COUNT_MIDLETS = %d\n", MAX_COUNT_MIDLETS);

        if (midlets != NULL ) 
        {
            suFreeMem(midlets);
            midlets = NULL;
        }

        midlets = suAllocMem( MAX_COUNT_MIDLETS*sizeof(MIDLET), NULL );
        if (midlets == NULL) return RESULT_FAIL;


		for(i1 = 0; i1 < MAX_COUNT_MIDLETS & i1*step < fSize ; i1++)
		{
            bufR = (UINT8*) suAllocMem( 38, NULL );
            if (bufR == NULL) return RESULT_FAIL;

            DL_FsFSeekFile( f,  i1*step,  0 );
            DL_FsReadFile( bufR, 38, 1, f, &readen );


			if((bufR[1] & 0xF) != 0)
			{
                for(j=6; bufR[j] != 0; j++) 
                {
                    bufUTF8[j-6] = bufR[j];
                }
                bufUTF8[j-6] = 0; //    
				
				
				DL_Char_convUTF8toUCS2String(bufUTF8, sizeof(bufUTF8), 
                             midlets[ENTRIES_NUM].name, 
                             sizeof(bufUTF8));

                midlets[ENTRIES_NUM].num = i1;

                ENTRIES_NUM++;
                udbg("midName = %s\n", midlets[i1].name);
            }

            suFreeMem(bufR);
		}

        DL_FsCloseFile(f);
    }	
    else
    {
      udbg("not exist %s\n", path_J2MEST);
      return RESULT_FAIL;
    }
        

   return RESULT_OK;
}


UINT32 model(void) //   
{
    WCHAR path_J2MEST[128];

    dbg("IMEI offset = 0x%x\n", *SEEM_IMEI);
    DL_DbFeatureGetValueString(*SEEM_IMEI, IMEI );
    udbg("IMEI = %s\n", IMEI);
    u_strcat(IMEI, L"/");

    if (TransFlash)
	{
		u_strcpy(path_J2MEST, L"file://b/mobile/kjava/");
        u_strcat(path_J2MEST, IMEI);
        u_strcat(path_J2MEST, L"J2MEST");
    }
	else
	{
		u_strcpy(path_J2MEST, L"file://a/mobile/kjava/J2MEST");
	}		

    if (DL_FsFFileExist( path_J2MEST ))
	{
		u_strcpy(kJavaDir, L"mobile/kjava/");
		step = 708;
	}
	else
	{
		u_strcpy(kJavaDir, L"mobile/kjava/installed/");
		step = 1104;
	}	

    dbg("step = %d\n", step);

    return RESULT_OK;
}



