#ifndef Setting_H
#define Setting_H

#include <apps.h>
#include <uis.h>

/*    .      */
typedef struct
{ 
    APPLICATION_T           apt; /*   ,   */

    SU_PORT_T               port;

    WCHAR msg[7];
    /*      */
    /* ... */

} APP_HELLOWORLD_T;

/*   */
typedef enum
{
    HW_STATE_ANY, /* ANY-state   */
    HW_STATE_INIT,
    HW_STATE_MAIN,
    HW_STATE_EDIT,
    
    HW_STATE_MAX /*   */
} HW_STATES_T;

typedef enum
{
    RES_LIST_CAPTION=0,
    RES_EDIT_CAPTION1,
	RES_EDIT_CAPTION2,

    RES_MAX
} HW_RESOURCE;


/*     */
RESOURCE_ID Resources[RES_MAX];


UINT32 Register( char* file_uri,  char* param,  UINT32 reserve );

UINT32 HelloWorldStart( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 );
UINT32 HelloWorldExit( EVENT_STACK_T *ev_st,  void *app );

UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 EditStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type );
UINT32 EditOk( EVENT_STACK_T *ev_st,  void *app );
UINT32 EditExit( EVENT_STACK_T *ev_st,  void *app );
UINT32 EditData( EVENT_STACK_T *ev_st,  void *app );


UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app );
UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app );

UINT32 InitResources( void );
UINT32 RemoveResources( void );

UINT32 SelectItem( EVENT_STACK_T *ev_st,  void *app );


UINT32 SendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num);




#endif
