// PFprintf( "*ELF*SettingLight*  nameCfgFile = %s \n", nameCfgFile);
#include "Setting.h"

#define ENTRIES_NUM 4       //  - 

/*       ""  */


UINT32 siItem; //   
WCHAR nameCfgFile[256]; //  
UINT8 bufR[12]; //   




/*  .        */
const char app_name[APP_NAME_LEN] = "SettingLight";

/*     state- */

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{
    /* GUI-     */
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    /*   ,      UI */
    { EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};

EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{

    { EV_DIALOG_DONE,               HelloWorldExit },
    { EV_REQUEST_LIST_ITEMS,        HandleListReq  },
    /* STATE_HANDLERS_RESERVED ,   - ,  
          ,      
        . LdrInitEventHandlersTbl, LdrFindEventHandlerTbl */
	{ EV_DONE,                      HelloWorldExit },
    { EV_SELECT,                        SelectItem },

    { STATE_HANDLERS_END,           NULL           },
};

 EVENT_HANDLER_ENTRY_T edit_state_handlers[] =
{
    /*   ,      UI */
    { EV_GRANT_TOKEN,             	  HandleUITokenGranted },
    { EV_DATA,                               	 EditData  },
    { EV_DONE,                       		       EditOk  },
	{ EV_CANCEL,                 			 EditExit  },
    { STATE_HANDLERS_END,         			     	  NULL },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },

    { HW_STATE_MAIN,
      MainStateEnter,
      StateExit,
      main_state_handlers
    },

    { HW_STATE_EDIT,
      EditStateEnter,
      StateExit,
      edit_state_handlers
    }
};

/*      elfpack- */
UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T *tbl,  UINT32 *base )
{
    UINT32          i=0;
    while( tbl[i].code!=STATE_HANDLERS_END )
    {
        if(tbl[i].code==STATE_HANDLERS_RESERVED)
        {
            tbl[i].code = (*base)++;
        }
        i++;
    }
    return *base;
}

UINT32 LdrFindEventHandlerTbl( EVENT_HANDLER_ENTRY_T *tbl,  EVENT_HANDLER_T *hfn )
{
    UINT32          i=0;
    while( tbl[i].code!=STATE_HANDLERS_END )
    {
        if(tbl[i].hfunc==hfn)
        {
            return tbl[i].code;
        }
        i++;
    }

    return 0;
}


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
	UINT32              evcode_base;
    UINT32 status = RESULT_OK;
	int i, j;
	
	
	UINT32 readen;
	FILE_HANDLE_T f;
	char  buf[256];
	


    evcode_base = reserve;    //  reserve
    //    ,   STATE_HANDLERS_RESERVED
    LdrInitEventHandlersTbl( main_state_handlers, &evcode_base );


/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)HelloWorldStart );   // ,   

	//   
		for (i=strlen(file_uri)-1; i > 0 ; i--)
			if (file_uri[i] == 47) break;
			
	
		for (j=0; j <= i ; j++)
			buf[j] = file_uri[j];
		buf[j] = 0;
		

		strcat(buf, "Light.cfg");
		u_atou(buf, nameCfgFile);

		PFprintf( "*ELF SettingLight*  nameCfgFile = %s \n", buf);
		
		//  
		if (DL_FsFFileExist( nameCfgFile) ) //    
		{
			f = DL_FsOpenFile(nameCfgFile, FILE_READ_MODE, 0);
			DL_FsReadFile( bufR, 12, 1, f, &readen );
			DL_FsCloseFile(f);
		}	

    LdrStartApp(evcode_base);   //  

    return 1;   //    ,  
}


/*      */
UINT32 HelloWorldStart( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;


    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
        return RESULT_FAIL; //     

    /*     */
    app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_HELLOWORLD_T), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );
    /*   */
    status = InitResources();

    status = APP_Start( ev_st,
                        &app->apt,
                        HW_STATE_INIT, //  
                        state_handling_table,
                        HelloWorldExit,
                        app_name,
                        0 );

    return RESULT_OK;
}


/*     */
UINT32 HelloWorldExit( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;
	APPLICATION_T           *papp = (APPLICATION_T*) app;
	
	APP_UtilUISDialogDelete(  &papp->dialog ); //   
    /*   */
    RemoveResources();

    /*    */
    status = APP_Exit( ev_st, app, 0 );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    main state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    UIS_DIALOG_T            dialog = 0;
    UINT32                  starting_num;


    if(type!=ENTER_STATE_ENTER) return RESULT_OK;    

    dialog = UIS_CreateList( &port,
                             0,
                             ENTRIES_NUM,
                             0,
                             &starting_num,
                             0,
                             2,
                             NULL,   //      
                             Resources[RES_LIST_CAPTION] );

   

    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;


    //   ,     starting_num 
    SendListItems(ev_st, app, 1, starting_num);
	
	if (siItem != 0) //     
	{
		APP_UtilAddEvUISListChange( ev_st,
                                app,
                                0, // = 0
                                siItem,
                                4,
                                TRUE,
                                2, // = 2
                                FBF_FREE,
                                NULL,
                                NULL );	
								
		UIS_HandleEvent( dialog,  ev_st );		
	}	
    return RESULT_OK;
}

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    //    
    status = APP_HandleUITokenGranted( ev_st, app );

    //   ,   state
    if( (status == RESULT_OK) && (papp->token_status == 2) )
    {
        status = APP_UtilChangeState( HW_STATE_MAIN, ev_st, app );
    }
 
    return status;
}


/* -  EV_REQUEST_LIST_ITEMS -   List    
          */
UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    EVENT_T                 *event;
    UINT32                  start, num;

    //      "",      
    if( !papp->focused ) return RESULT_OK;

    //      
    event = AFW_GetEv( ev_st );

	start = event->data.list_items_req.begin_idx;
	num = event->data.list_items_req.count;

    //   ,     - ,      
    APP_ConsumeEv( ev_st, app );

    return SendListItems( ev_st, app, start, num );
}


/*            */
UINT32 SendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    LIST_ENTRY_T            *plist; //    
    UINT32                   i, index, status=RESULT_OK;


    if( num==0 ) return RESULT_FAIL; //  ,   

    plist = (LIST_ENTRY_T*) suAllocMem( sizeof(LIST_ENTRY_T)*num, NULL ); // malloc
    if( plist==NULL ) return RESULT_FAIL;

    //  

	for( index=0, i=start; (i<start+num) && (i<=ENTRIES_NUM); i++, index++)
	{
        plist[index].editable = FALSE;          //  
        plist[index].content.static_entry.unk6 = 1;
    }

	//  
        UIS_MakeContentFromString( "Ms0Si1", &(plist[0].content.static_entry.text),0x01001045, bufR[1]);
        UIS_MakeContentFromString( "Ms0q1s2Si3", &(plist[1].content.static_entry.text),0x010000CD, L". ", 0x01001045, bufR[3]);
        UIS_MakeContentFromString( "Ms0Si1", &(plist[2].content.static_entry.text),0x01000045, bufR[5]);
        UIS_MakeContentFromString( "Ms0Si1", &(plist[3].content.static_entry.text),0x01000A23, bufR[7]);


    //       ,    
    status = APP_UtilAddEvUISListData( ev_st, app, 0,
                                       start, num,
                                       FBF_LEAVE,
                                       sizeof(LIST_ENTRY_T)*num,
                                       plist );
									   

    if( status!=RESULT_FAIL )
    {
        //        
        status = UIS_HandleEvent(papp->dialog, ev_st);
    }

    suFreeMem(plist);

    return status;

}

/*           */
UINT32 InitResources( )
{

    UINT32  status;
    WCHAR   S1[] = L"Light Setting";
    WCHAR   S2[] = L"LTE: 0-100\nOther: 0-6";
    WCHAR   S3[] = L"0-255 sek";




    /*     */
		status = DRM_CreateResource( &Resources[RES_LIST_CAPTION], RES_TYPE_STRING, (void*)S1, (u_strlen(S1)+1)*sizeof(WCHAR) );
    if( status!=RESULT_OK ) return status;

	//  
		status = DRM_CreateResource( &Resources[RES_EDIT_CAPTION1], RES_TYPE_STRING, (void*)S2, (u_strlen(S2)+1)*sizeof(WCHAR) );
    if( status!=RESULT_OK ) return status;
	
	    status = DRM_CreateResource( &Resources[RES_EDIT_CAPTION2], RES_TYPE_STRING, (void*)S3, (u_strlen(S3)+1)*sizeof(WCHAR) );
    if( status!=RESULT_OK ) return status;
	

     return status;
}

/*        */
UINT32 RemoveResources( )
{
    UINT32              status = RESULT_OK;
    UINT32              i;

    for(i=0;i<RES_MAX;i++)
    {
        status |= DRM_ClearResource( Resources[i] );
    }

    return status;

}

UINT32 SelectItem (EVENT_STACK_T *ev_st,  void *app )
{
     UINT32                  status;
	 EVENT_T     *event = AFW_GetEv(ev_st);
	
	siItem = event->data.index;

    status = APP_UtilChangeState( HW_STATE_EDIT, ev_st, app ); //  

	APP_ConsumeEv( ev_st, app );
    return RESULT_OK;

}

/*    edit state */
UINT32 EditStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
        APP_HELLOWORLD_T           *papp = (APP_HELLOWORLD_T*) app;
		RESOURCE_ID             CaptionEditor;
		
		//        
		switch (siItem)
		{
			case 1: //  
				u_ltou( bufR[1],  papp->msg );
				CaptionEditor = Resources[RES_EDIT_CAPTION1];
			break;
			
			case 2: //  
				u_ltou( bufR[3],  papp->msg );
				CaptionEditor = Resources[RES_EDIT_CAPTION1];
			break;
			
			case 3: // 
				u_ltou( bufR[5],  papp->msg );
				CaptionEditor = Resources[RES_EDIT_CAPTION2];
			break;
			
			case 4: // . 
				u_ltou( bufR[7],  papp->msg );
				CaptionEditor = Resources[RES_EDIT_CAPTION2];
			break;
		}

        papp->apt.dialog = UIS_CreateCharacterEditor( &papp->port,
                                            papp->msg,
                                            32, //  
                                            3, // 3  
                                            FALSE,
                                            NULL,
                                            CaptionEditor
                                            );
        
		if(papp->apt.dialog == 0)
            return RESULT_FAIL;


        return RESULT_OK;
}


//      UIS_CreateCharacterEditor(
UINT32 EditData( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                  status = 0;
    EVENT_T      *event = AFW_GetEv(ev_st);
	

	UINT32 written;
	FILE_HANDLE_T f;

    if (event->attachment != 0)
    {

		PFprintf( "*ELF SettingLight*  DATA = %d \n", (UINT8)u_atol( event->attachment));
		
		switch (siItem)
		{
			case 1: // 
				bufR[1] = (UINT8)u_atol( event->attachment); //    long
			break;
			
			case 2: //  
				bufR[3] = (UINT8)u_atol( event->attachment); //    long
			break;
			
			case 3: // 
				bufR[5] = (UINT8)u_atol( event->attachment); //    long
			break;
			
			case 4: // . 
				bufR[7] = (UINT8)u_atol( event->attachment); //    long
			break;
        }
		
		
		//   
			f = DL_FsOpenFile(nameCfgFile, FILE_WRITE_MODE, 0);
			DL_FsWriteFile( bufR, 12, 1, f, &written );
			DL_FsCloseFile(f);
				
    }

	
    status = APP_UtilChangeState( HW_STATE_MAIN, ev_st, app );
	
    return status;

}

//   
UINT32 EditOk( EVENT_STACK_T *ev_st,  void *app )
{
     UINT32                  status = 0;
     ADD_EVENT_DATA_T *ev_data;

     APP_HELLOWORLD_T           *papp = (APP_HELLOWORLD_T*) app;
     AFW_AddEvEvD(ev_st, EV_REQUEST_DATA,ev_data);
	 UIS_HandleEvent( papp->apt.dialog,  ev_st );

     PFprintf("*ELF SettingLight* EditExit:%x\n",papp->apt.dialog);

    return status;
}

//   
UINT32 EditExit( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                  status = 0;
	//APP_HELLOWORLD_T           *papp = (APP_HELLOWORLD_T*) app;
	
	//APP_UtilUISDialogDelete( &papp->apt.dialog );
    status = APP_UtilChangeState( HW_STATE_MAIN, ev_st, app ); //   mait state
	
    return status;
}

//    state
UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APP_HELLOWORLD_T           *papp = (APP_HELLOWORLD_T*) app;
	APP_UtilUISDialogDelete( &papp->apt.dialog );
	return RESULT_OK;
}


