#include "ELF.h"

/*
// 79R
#define BLCHandleUserKeyPress               0x00000CED
#define BLCHandleUserKeyRelease             0x000001F5
#define BLCHandleBacklightContinueOn        0x00000E14
#define BLCHandleBacklightRestore           0x00000E15
#define BLCHandleUserActivity               0x000007F1
#define BLCHandleBacklightTimeout           0x000007F5
#define BLCHandleBacklightTimeout2          0x00000DF7
#define BLCHandleFeatureChangeInd           0x0008207E
#define BLCHandleExternalPowerInd           0x0008207B
#define BLCHandleSetColorAndTimeout         0x00000686
#define BLCHandleResetColorAndTimeout       0x00000685
#define BLCHandleScreensaverStart           0x00000E00
#define BLCHandleDisplayTimeout             0x000007F4
#define BLCHandleAlarmClockStart            0x00000E1C
#define BLCHandleEnableAndUpdateBacklight   0x00000E40
*/

extern const UINT32  *CALL_ALERT;
extern const UINT32 *KEYPAD_STATE;

UINT8 level=10; //  
UINT8 levelT = 10; //  
UINT8 levelMin = 1; //  

UINT8 timeWait; //  
UINT8 timeActivity; //   

UINT8 timeWaitT; //  


//   
BOOL exitN1;
BOOL exitN2;
BOOL exitN3;

UINT8 keyexitN1;
UINT8 keyexitN2;
UINT8 keyexitN3;
int Nul; //    0



/*  .        */
const char app_name[APP_NAME_LEN] = "Light"; 


//     state-

/*    HW_STATE_ANY (   state) */
 EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    { NULL,								  Call },
    { EV_KEY_PRESS,             HandleKeypress },
	{ EV_KEY_RELEASE,         HandleKeyrelease },
	{ EV_TIMER_EXPIRED,       		     Timer },
	

    /*
       !!!
    { BLCHandleUserKeyPress,                OnControl },
    { BLCHandleUserKeyRelease,              OnControl },
    { BLCHandleBacklightContinueOn,         OnControl },
    { BLCHandleBacklightRestore,            OnControl },
    { BLCHandleUserActivity,                OnControl },
    { BLCHandleBacklightTimeout,            APP_ConsumeEv },  
    { BLCHandleBacklightTimeout2,           APP_ConsumeEv }, 
    { BLCHandleFeatureChangeInd,            OnControl },
    { BLCHandleExternalPowerInd,            OnControl },
   { BLCHandleSetColorAndTimeout,          OnControl },
   { BLCHandleResetColorAndTimeout,        OnControl },
    { BLCHandleScreensaverStart,            OnControl },
   { BLCHandleDisplayTimeout,              OnControl },   
    { BLCHandleAlarmClockStart,             OnControl },
   { BLCHandleEnableAndUpdateBacklight,    OnControl },
    */

    //      
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { STATE_HANDLERS_END,           NULL           },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }

};


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32          status = RESULT_OK;
    UINT32          evcode_base;
	UINT32          i;
    char            buf[256];
    WCHAR           nameCfgFile[256];
	UINT8           bufR[12];
	UINT32          readen;
	FILE_HANDLE_T   f;

	any_state_handlers[0].code = *CALL_ALERT;
	
    evcode_base = reserve;    //  reserve
   
	

    /*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)startApp );   // ,   
                   
	
		//   
		for (i=0; i < strlen(file_uri)-3; i++)
			buf[i] = file_uri[i];
        buf[i] = 0;

        strcat(buf, "cfg");
        u_atou(buf, nameCfgFile);

        //    		
		if (DL_FsFFileExist( nameCfgFile ) ) //    
		{
			f = DL_FsOpenFile(nameCfgFile, FILE_READ_MODE, 0);
			DL_FsReadFile( bufR, 12, 1, f, &readen );
			DL_FsCloseFile(f);
			
				level = bufR[1];
				levelMin = bufR[3];
				timeWait = bufR[5];
				timeActivity = bufR[7];
				
				keyexitN1 = bufR[9];
				keyexitN2 = bufR[10];
				keyexitN3 = bufR[11];
		}	
	
    LdrStartApp(reserve);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;
	


    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
    {
        return RESULT_FAIL; //     
    }
    else
    {
        //    
        app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEventPrepost, //    
                                                  sizeof(APP_HELLOWORLD_T), //   
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                                  2, 0, 0 );
                                                  

        status = APP_Start( ev_st,
                            &app->apt,
                            HW_STATE_MAIN, //  
                            state_handling_table,
                            destroyApp,
                            app_name,
                            0 );
		
      OnControl(ev_st, app);

    }

    return RESULT_OK;
}




/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

	APP_UtilStopTimer( app );
    /*    */
    status = APP_Exit( ev_st, app, NULL );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    return RESULT_OK;
}


/*  , EV_KEY_PRESS    */
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
	UINT8       keypress;
	
	
	keypress = event->data.key_pressed;
	
	//     
	if (keyexitN1 != 0 && keyexitN2 != 0 && keyexitN3 != 0)
	{
		if (exitN1)
		{
			if (exitN2)
			{
				if (!exitN3) if (keypress == keyexitN3) exitN3 = TRUE;
			}
			else
			{
				if (keypress == keyexitN2) exitN2 = TRUE;
			}
		}
		else
		{
			if (keypress == keyexitN1) exitN1 = TRUE;
		}

		if (keypress != keyexitN1 && keypress != keyexitN2 && keypress != keyexitN3 )
		{
			exitN1 = FALSE;
			exitN2 = FALSE;
			exitN3 = FALSE;
		}
	}	
	
	switch (keypress)
	{
		case KEY_VOLDOWN: //  
		
		if (Nul == 1)
		{
			if (level > 0)
			{
			 
				if (level <=10) 
				{
					level -= 1;
				}
				else
				{
					level -= 5;
				}
				//levelT = level;
			}
			return APP_ConsumeEv(ev_st,  app);
		}	
		break;
		
		case KEY_VOLUP: //  
		
		if (Nul == 1)
		{
            if (namecmp((char*)LdrGetPlatformName(), "LTE"))
            {
    			if (level < 100 ) 
    			{
    				
    				if (level < 10) 
    				{
    					level += 1;
    				}
    				else
    				{
    					level += 5;
    				}
    				//levelT = level;
    			}
            }
            else
            {
                if (level < 6 ) 
  					level ++;

            }
			return APP_ConsumeEv(ev_st,  app);
		}	
		break;
		
		
		case KEY_0:
			Nul = 1;
		break;
		
		default:
			Nul = 0;
		break;
	}

    if(exitN1 & exitN2 & exitN3 ) return destroyApp(ev_st, app);

    OnControl(ev_st,app);
    
 
    return RESULT_OK;
}

UINT32 HandleKeyrelease( EVENT_STACK_T *ev_st,  void *app )
{
	if (!KeypadLock()) 
	{
		timeWaitT=0;
		DAL_EnableDisplay( 0 ); //  
		if (namecmp((char*)LdrGetPlatformName(), "LTE")){
            HAPI_LP393X_disp_backlight_intensity(level); //  LTE
        } else {
            UIS_SetBacklightWithIntensity(255, level); //   
        }
	}

	return RESULT_OK;
}

UINT32 OnControl(EVENT_STACK_T *ev_st,  void *app)
{
    //APP_ConsumeEv(ev_st, app);
    DAL_EnableDisplay( 0 ); //  
    DL_KeyUpdateKeypadBacklight(1); //   

    if (namecmp((char*)LdrGetPlatformName(), "LTE")){
        HAPI_LP393X_disp_backlight_intensity(level); //  LTE
    } else {
        UIS_SetBacklightWithIntensity(255, level); //   
    }


	levelT = level;
	timeWaitT=0;

    if (timeWait != 0)	
	{
		APP_UtilStopTimer( app );
		APP_UtilStartCyclicalTimer( 1000,  1,  app );
	}
	else
	{
		if (timeActivity != 0) 
		{
			APP_UtilStopTimer( app );
			APP_UtilStartCyclicalTimer(1000,  1,  app);
				
		}	
	}

    return RESULT_OK;
}


UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
	if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 1) //    
	{
		timeWaitT ++;
	
		
		if (KeypadLock() && timeWaitT == 3) 
		{   
			    if (namecmp((char*)LdrGetPlatformName(), "LTE")){
                    HAPI_LP393X_disp_backlight_intensity(level); //  LTE
                } else {
                    UIS_SetBacklightWithIntensity(255, level); //   
                }
            DL_KeyUpdateKeypadBacklight(0); //  
			APP_UtilStopTimer( app );
			timeWaitT = timeWait;

		}
		else
		{
			if (timeWait != 0 && timeWaitT == timeWait )
			{
				//PFprintf("*ELF Light*  ligth < \n");
				APP_UtilStopTimer( app );
				DL_KeyUpdateKeypadBacklight(0); //  
				APP_UtilStartCyclicalTimer( 100,  2,  app );
				
			}

			if (timeActivity != 0 && timeWaitT == timeActivity)
			{
				//PFprintf("*ELF Light*  display off\n");
                APP_UtilStopTimer( app );
				levelT=0;
                    DL_KeyUpdateKeypadBacklight(0); //  
                        if (namecmp((char*)LdrGetPlatformName(), "LTE")){
                            HAPI_LP393X_disp_backlight_intensity(0); //  LTE
                        } else {
                            UIS_SetBacklightWithIntensity(255, 0); //   
                        }
                    DAL_DisableDisplay( 0 );
			}
		}
	}
	
	if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 2) //     
	{
		if (levelT > levelMin)
		{
			levelT --;
            if (namecmp((char*)LdrGetPlatformName(), "LTE")){
                HAPI_LP393X_disp_backlight_intensity(levelT); //  LTE
            } else {
                UIS_SetBacklightWithIntensity(255, levelT); //   
            }
		}
		else
		{
			//PFprintf("*ELF Light*  display < \n");
			APP_UtilStopTimer( app );
			if (timeActivity != 0 && timeActivity > timeWait) 
			APP_UtilStartCyclicalTimer(1000,  1,  app);
		}
	}
	
	
	return RESULT_OK;
}


UINT32 Call( EVENT_STACK_T *ev_st,  void *app )
{
	DAL_EnableDisplay( 0 ); //    
	return RESULT_OK;
}


BOOL KeypadLock(void)
{
   UINT8 keypad_statate;
   DL_DbFeatureGetCurrentState( *KEYPAD_STATE, &keypad_statate );
   PFprintf(" KEYPAD_STATE = %d\n", keypad_statate);
   return keypad_statate;
}	

