#include "addCell.h"

UINT16  cell_id;
WCHAR   ELF_folder[256]; //  
		
	
/*  .        */
const char app_name[APP_NAME_LEN] = "SeemEditor";

/*     state- */

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{
    /* GUI-     */
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    /*   ,      UI */
    { EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};


 EVENT_HANDLER_ENTRY_T edit_state_handlers[] =
{
    /*   ,      UI */
    { EV_DATA,                               	 EditData  },
    { EV_DONE,                       		       EditOk  },
	{ EV_CANCEL,                 				 EditExit  },
    { STATE_HANDLERS_RESERVED,                       Mask  },
    { STATE_HANDLERS_END,         			     	  NULL },
};

 EVENT_HANDLER_ENTRY_T notice_state_handlers[] =
{

    { EV_DIALOG_DONE,                           NoticeExit },
    { STATE_HANDLERS_END,         			     	  NULL },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },

    { HW_STATE_EDIT,
      EditStateEnter,
      StateExit,
      edit_state_handlers
    },
	
	{ HW_STATE_NOTICE,
      NoticeStateEnter,
      StateExit,
      notice_state_handlers
    }
};



UINT32 LdrFindEventHandlerTbl( EVENT_HANDLER_ENTRY_T *tbl,  EVENT_HANDLER_T *hfn )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].hfunc==hfn)	
			return tbl[i].code;

		i++;
	}

	return 0;
}

/*      elfpack- */
UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T *tbl,  UINT32 *base )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].code==STATE_HANDLERS_RESERVED)	
			tbl[i].code = (*base)++;

		i++;
	}
	return *base;
}


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 		status = RESULT_OK;
	UINT32      evcode_base=reserve;
    UINT16 i;

    LdrInitEventHandlersTbl( edit_state_handlers, &evcode_base );

/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)HelloWorldStart );   // ,   


        u_atou(file_uri, ELF_folder);

        for (i=u_strlen(ELF_folder)-1; i > 0 ; i--){
            if (ELF_folder[i] == '/') break;
            ELF_folder[i] = 0;
        }

    LdrStartApp(evcode_base);   //  

    return 1;   //    ,  
}


/*      */
UINT32 HelloWorldStart( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;


    /*     */
    app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_HELLOWORLD_T), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );

    DL_SigRegGetCellID(&cell_id);
    /*   */
    status = InitResources();
    

    status |= APP_Start( ev_st,
                        &app->apt,
                        HW_STATE_INIT, //  
                        state_handling_table,
                        HelloWorldExit,
                        app_name,
                        0 );
						
			
						

    return RESULT_OK;
}


/*     */
UINT32 HelloWorldExit( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;
	APPLICATION_T           *papp = (APPLICATION_T*) app;
	
	 APP_UtilUISDialogDelete(  &papp->dialog );
     /*   */
     RemoveResources();

    /*    */
    status = APP_Exit( ev_st, app, 0 );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}


UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    //    
    status = APP_HandleUITokenGranted( ev_st, app );

    //   ,   state
    if( (status == RESULT_OK) && (papp->token_status == 2) )
    {
        status = APP_UtilChangeState( HW_STATE_EDIT, ev_st, app );
    }
 
    return status;
}


/*           */
UINT32 InitResources( )
{
    UINT32                      status;
    RES_ACTION_LIST_ITEM_T		action;
    WCHAR mask[] = L"Mask";
    WCHAR buf[16] = L"Cellid ";
    
    u_ltou(cell_id, buf+u_strlen(buf));
 

    status = DRM_CreateResource( &Resources[RES_EDIT_CAPTION], RES_TYPE_STRING, (void*)(buf), (u_strlen((WCHAR*)(buf))+1)*sizeof(WCHAR) );
    if( status!=RESULT_OK ) return status;

     status |= DRM_CreateResource( &Resources[RES_MASK], RES_TYPE_STRING, (void*)(mask), (u_strlen((WCHAR*)(mask))+1)*sizeof(WCHAR) );
    if( status!=RESULT_OK ) return status;

    	/*    */
    action.softkey_label = 0;			//    -
    action.list_label =  RES_MASK;		// 
    action.softkey_priority = 0; 
    action.list_priority = 3;			//   
    action.isExit = FALSE;
    action.sendDlgDone = FALSE;

    status |= DRM_CreateResource( &Resources[RES_ACTION_MASK], RES_TYPE_ACTION, (void*)&action, sizeof(RES_ACTION_LIST_ITEM_T));
    if( status!=RESULT_OK ) return status;
	
    return status;
}

UINT32 Mask( EVENT_STACK_T *ev_st,  void *app)
{
    

    return RESULT_OK;
}

/*        */
UINT32 RemoveResources( )
{
    UINT32              status = RESULT_OK;
    UINT32              i;

    for(i=0;i<RES_MAX;i++)
    {
        status |= DRM_ClearResource( Resources[i] );
    }

    return status;

}


UINT32 EditStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
        APP_HELLOWORLD_T           *papp = (APP_HELLOWORLD_T*) app;
        ACTIONS_T				action_list; // 



        papp->apt.dialog = UIS_CreateCharacterEditor( &papp->port,
                                            NULL,
                                            1,
                                            32,
                                            FALSE,
                                            NULL,
                                            Resources[RES_EDIT_CAPTION] );


        if(papp->apt.dialog == 0)
            return RESULT_FAIL;

        action_list.action[0].operation = ACTION_OP_ADD; 
        action_list.action[0].event = LdrFindEventHandlerTbl( edit_state_handlers, Mask ); //       
        action_list.action[0].action_res = Resources[RES_ACTION_MASK]; // ,  

        action_list.count = 1;

        UIS_SetActionList(papp->apt.dialog, &action_list);


        return RESULT_OK;
}



UINT32 EditData( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                  status = 0;
    EVENT_T      *event = AFW_GetEv(ev_st);
	char buf[64];
    WCHAR name[256];

    UINT32 w;
    FILE_HANDLE_T f;


    if (event->attachment != NULL)  {
        itoa(cell_id, buf, 10);
        strcat(buf, ";");
		UCS2toCP1251( event->attachment, buf+strlen(buf));
        strcat(buf, "\r\n");

        u_strcpy(name, ELF_folder);
        u_strcat(name, L"cells.txt");

        //   
        f = DL_FsOpenFile(name, FILE_APPEND_PLUS_MODE, 0);
        if (f != FILE_HANDLE_INVALID ) {

            DL_FsWriteFile( buf, strlen(buf), 1, f, &w );
            DL_FsCloseFile(f);
    
            status = APP_UtilChangeState( HW_STATE_NOTICE, ev_st, app );
        }
    }

    return status;

}

UINT32 EditOk( EVENT_STACK_T *ev_st,  void *app )
{
     UINT32                  status = 0;
     ADD_EVENT_DATA_T *ev_data;

     APP_HELLOWORLD_T           *papp = (APP_HELLOWORLD_T*) app;
     AFW_AddEvEvD(ev_st, EV_REQUEST_DATA,ev_data);
	 UIS_HandleEvent( papp->apt.dialog,  ev_st );

    return status;
}

UINT32 EditExit( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                		 status = 0;
	
	HelloWorldExit( ev_st, app );

    return status;
}

UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APP_HELLOWORLD_T           *papp = (APP_HELLOWORLD_T*) app;
	APP_UtilUISDialogDelete( &papp->apt.dialog );
	return RESULT_OK;
}

UINT32 NoticeStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    CONTENT_T               content;
    UIS_DIALOG_T            dialog = 0;
	

	if(type!=ENTER_STATE_ENTER) return RESULT_OK;
    
    UIS_MakeContentFromString("s0", &content, LANG_STORED); //   
    
    dialog = UIS_CreateTransientNotice( &port, &content, NOTICE_TYPE_OK );
      
    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;

    return RESULT_OK;
}

UINT32 NoticeExit( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                		 status = 0;

    HelloWorldExit( ev_st, app );

    return status;
}

UINT32 UCS2toCP1251(WCHAR *src, char *trg)
{
    UINT16  i;

    for(i=0; i <= u_strlen(src); i++) {
        if (src[i] < 0xA0) { //  128
            trg[i] = src[i];
        } else if (src[i] == 0x451){ // 
            trg[i] = 0xB8;
        } else if (src[i] == 0x401){ // 
            trg[i] = 0xA8;
        } else if (src[i] > 0x40F) { // 
            trg[i] = src[i] - 0x350;
        } else {
            trg[i] = 0x3F; // ? -  
        }
    }

    return RESULT_OK;
}

