#ifndef Informer_h
#define Informer_h


#include <apps.h>
#include <weather_api.h>

#define TIME_UPDATE_DATE        30000 //   
#define TIME_REFRESH            60    //    
#define INFO_STRING_SIZE        80    //  . 


typedef struct {
    UINT16 cell_id;
    char  name[32+1];
    BOOL  mask;
} CELLS_T;


typedef enum {
    INFO_DATE,
    INFO_BATTERY,
    INFO_SIGNAL,
    INFO_CELLS,
    INFO_DISKS,
    INFO_WEATHER,
    INFO_MAX
} INFO_STRING_ID_T;

typedef struct {
    BOOL        enabled_1;
    BOOL        enabled_2;
    UINT8       x, y;

    UINT8       anchor;
    UINT8       between; //   
    UINT8       font;
    UINT8       font_style;
    
    COLOR_T     fcolor;
    COLOR_T     bcolor;
    
} INFO_STYLE_T; // size = 16

typedef struct {
    INFO_STYLE_T    style;
    WCHAR           str[INFO_STRING_SIZE];
    
} INFO_STRING_T;



/*    .      */
typedef struct
{ 
    APPLICATION_T           apt; /*   ,   */
	
    /*      */
    /* ... */

} APP_INFORMER_T;

/*   */
typedef enum
{
    IF_STATE_ANY, /* ANY-state   */

    IF_STATE_MAIN,

    IF_STATE_MAX /*   */
} IF_STATES_T;


UINT32 Register( char* file_uri,  char* param,  UINT32 reserve );

UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 );
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app );

UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 HandleWeatherAPI( EVENT_STACK_T * ev_st, void * app );

UINT32 ReadSetting(WCHAR *nameCfgFile);

UINT32 USSD( EVENT_STACK_T * ev_st, void * app );
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app );

UINT32 HandleKeyrelease( EVENT_STACK_T *ev_st,  void *app );
UINT32 IdleStart( EVENT_STACK_T *ev_st,  void *app );
UINT32 Timer( EVENT_STACK_T *ev_st,  void *app );


UINT32  ReadCells(void);
char* FindCell(UINT16 cellid);
CLK_DATE_T Date(WCHAR *buf_date);
UINT8 Battery(WCHAR *buf_con);
SIGNAL_STRENGTH_T Signal(WCHAR *buf_con );
UINT16 Cells(WCHAR *buf_con);
UINT32 Disks(WCHAR *buf_con);
UINT32 Weather(WCHAR *buf_con);

UINT32 UpdateData(void);
UINT32 DrawInfo(void);
UINT32 DrawString(WCHAR *ustr, INFO_STYLE_T   xstyle );

UINT32 degree(UINT32 x, UINT32 y);
BOOL WorkingTable(void);

#endif