#include "Informer.h"
#include "LNGparser.h"
#include <dbg.h>

WCHAR   ELF_folder[256]; //  

CELLS_T         *cells=NULL;
UINT16          count_cells=0;

UIS_DIALOG_T        dialog;

INFO_STRING_T   info[INFO_MAX];

BOOL exitN1;
BOOL exitN2;
BOOL exitN3;

UINT8 keyexitN1;
UINT8 keyexitN2;
UINT8 keyexitN3;

DRAWING_BUFFER_T		bufd;

//  
char LngRes[LNG_MAX][32];

/*  .        */
const char app_name[APP_NAME_LEN] = "Informer"; 


//    
Weather_getForecast_f *      Weather_getForecast = NULL;
Weather_getTemperature_f *   Weather_getTemperature = NULL;
Weather_getPhenomena_f *     Weather_getPhenomena = NULL;
Weather_getWind_f *          Weather_getWind = NULL;

//     state-

/*    IF_STATE_ANY (   state) */
static EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    { 0x76A,                         IdleStart },
    { EV_USER_ACTIVITY,              IdleStart },
    { EV_USSD_COMPLETE,             USSD },
    //{ EV_USSD_COMPLETE-1,             USSD },
    //{ EV_USSD_COMPLETE-2,             USSD },
    
    { EV_KEY_PRESS,             HandleKeypress },

	{ EV_TIMER_EXPIRED,       		     Timer },
    
    

    //      
    { STATE_HANDLERS_END,           NULL           },
};

static EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { STATE_HANDLERS_RESERVED,	    HandleWeatherAPI },	//      api.
    { STATE_HANDLERS_END,           NULL             },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { IF_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { IF_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }

};


UINT32 LdrFindEventHandlerTbl( EVENT_HANDLER_ENTRY_T *tbl,  EVENT_HANDLER_T *hfn )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].hfunc==hfn)	
			return tbl[i].code;

		i++;
	}

	return 0;
}

UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T *tbl,  UINT32 *base )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].code==STATE_HANDLERS_RESERVED)	
			tbl[i].code = (*base)++;

		i++;
	}
	return *base;
}


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32              status = RESULT_OK;
	UINT32              evcode_base=reserve;
    UINT32              i;
    WCHAR				nameCfgFile[256];

    if (EV_IDLE_FOCUS != 0){
        any_state_handlers[0].code = EV_IDLE_FOCUS;
    }
    if (EV_DISPLAY_ACTIVE != 0) {
        any_state_handlers[1].code = EV_DISPLAY_ACTIVE;
    }
    LdrInitEventHandlersTbl((EVENT_HANDLER_ENTRY_T *)main_state_handlers, &evcode_base);

    /*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           IF_STATE_MAX,            //  
                           (void*)startApp );   // ,   

        u_atou(file_uri, ELF_folder);

        for (i=u_strlen(ELF_folder)-1; i > 0 ; i--){
            if (ELF_folder[i] == '/') break;
            ELF_folder[i] = 0;
        }

        udbg("ELF_folder = %s\n", ELF_folder); 

        u_atou(file_uri, nameCfgFile);
		nameCfgFile[u_strlen(nameCfgFile)-3] = 0;
		u_strcat(nameCfgFile, L"cfg");	
        ReadSetting(nameCfgFile);

        nameCfgFile[u_strlen(nameCfgFile)-3] = 0;
		u_strcat(nameCfgFile, L"lng");	
        ReadLang(nameCfgFile);

		
    LdrStartApp(evcode_base);   //  
    
    return 1;   //    ,  
}




/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_INFORMER_T     *app = NULL;
    UINT32 status = RESULT_OK;
   


        //    
        app = (APP_INFORMER_T*)APP_InitAppData( (void *)APP_HandleEventPrepost, //    
                                                  sizeof(APP_INFORMER_T), //   
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                                  2, 0, 0 );
            
                         

        status = APP_Start( ev_st,
                            &app->apt,
                            IF_STATE_MAIN, //  
                            state_handling_table,
                            destroyApp,
                            app_name,
                            0 );
        ReadCells();

        UpdateData();
        APP_UtilStartCyclicalTimer( TIME_UPDATE_DATE,  1,  app );
		
    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;
    APP_INFORMER_T          *papp = (APP_INFORMER_T*) app;

    dbg("EXIT ELF", NULL);

    CloseLang();

	APP_UtilStopTimer( app );
    APP_UtilUISDialogDelete(  &papp->apt.dialog ); 

    /*    */
    status = APP_Exit( ev_st, app, NULL );
    	
    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
     APP_INFORMER_T          *papp = (APP_INFORMER_T*) app;
     GRAPHIC_POINT_T         display_size;
     ADD_EVENT_DATA_T	     add_data;
    
    
	if(type!=ENTER_STATE_ENTER) return RESULT_OK;


    display_size = UIS_CanvasGetDisplaySize();

      bufd.w = display_size.x+1;
      bufd.h = display_size.y+1;
      bufd.buf = NULL;
	
    dialog = UIS_CreateColorCanvasWithWallpaper(&papp->apt.port, &bufd, 0, 0);// create canvas 

    if(dialog == 0) return RESULT_FAIL;
    papp->apt.dialog = dialog;

    //  API  Weather
	add_data.data_tag = 0;
	add_data.data.params[0] = LdrFindEventHandlerTbl( main_state_handlers, HandleWeatherAPI );		//      
	WeatherReqAPI(add_data);

       
    return RESULT_OK;
}

UINT32 HandleWeatherAPI( EVENT_STACK_T * ev_st, void * app )
{
	EVENT_T *	event = AFW_GetEv(ev_st);
	
	dbg("APIAnsw: Enter", NULL);
	
	APP_ConsumeEv( ev_st, app );
	
	Weather_getForecast = (Weather_getForecast_f *)(event->data.params[0]);
	Weather_getTemperature = (Weather_getTemperature_f *)(event->data.params[1]);
    Weather_getPhenomena = (Weather_getPhenomena_f *)(event->data.params[2]);
    Weather_getWind = (Weather_getWind_f *)(event->data.params[3]);

    UpdateData(); 
         APP_UtilStopTimer(app);
         APP_UtilStartCyclicalTimer( TIME_REFRESH,  2,  app );
	
	return RESULT_OK;
}

UINT32 IdleStart( EVENT_STACK_T *ev_st,  void *app )
{
    DrawInfo();
    return RESULT_OK;
}


UINT32 ReadSetting(WCHAR *nameCfgFile) 
{

	UINT8 bufR[3];
	UINT32 readen;
	FILE_HANDLE_T f;
    UINT16  i;

    dbg("ReadSetting", NULL);
		

			f = DL_FsOpenFile(nameCfgFile, FILE_READ_MODE, 0);
            if (f == FILE_HANDLE_INVALID ) return RESULT_FAIL;

            dbg("CFG file open!", NULL);


            for (i=0; i < INFO_MAX; i++ ) {
                DL_FsReadFile( &(info[i].style),sizeof(INFO_STYLE_T), 1, f, &readen );
            }

            DL_FsReadFile( bufR, 3, 1, f, &readen );

				keyexitN1 = bufR[0];
				keyexitN2 = bufR[1];
				keyexitN3 = bufR[2];

            DL_FsCloseFile(f);


        return RESULT_OK;
}

UINT32  ReadCells()
{
    INT32           status=0;
    WCHAR           cells_name[256];
    UINT32          readen;
	FILE_HANDLE_T   fh;
	UINT32          fSize;
    char            *bufR;

    int i = 0, j = 0, n = 0;
	char bufVal[16];
	BOOL bValue = true;

    dbg("ReadCells", NULL);

    u_strcpy(cells_name, ELF_folder);
    u_strcat(cells_name, L"cells.txt");


	fh = DL_FsOpenFile(cells_name, FILE_READ_MODE, 0);
    if (fh == FILE_HANDLE_INVALID) return RESULT_FAIL;

    dbg("ReadLngRes", NULL);

	fSize = DL_FsGetFileSize(fh);
	bufR = (char*)suAllocMem( fSize, &status );
    if (status) return RESULT_FAIL;

    dbg("Alloc for cells.txt!", NULL);


    DL_FsReadFile( bufR, fSize, 1, fh, &readen );
    DL_FsCloseFile(fh);
    

    //  - 
    for (i=0; i < fSize; i++)
		if (bufR[i] == 0x0A) count_cells++;

    cells = (CELLS_T*)suAllocMem(sizeof(CELLS_T)*count_cells, &status);
    if (status) return RESULT_FAIL;
    dbg("Alloc for cells", NULL);
    memset(cells, 0, sizeof(CELLS_T)*count_cells);

    //  
    for (i=0; i < fSize; i++) {
        if (bufR[i] == '\n') { //  
           cells[n].cell_id = strtoul( bufVal,  0,  10 );
           j=0;
           bValue = true;
           n++; 
        } else if (bufR[i] == ';') { // 
              bValue = false;
              j=0;
        } else {
            if(bufR[i] == '\r') continue; // 
            if (j+1 > 32) continue;


               if (bValue) {
                   if (bufR[i] == 'x' || bufR[i] == 'X') {
                       bufVal[j] = '0';
                       cells[n].mask ++;
                   } else {
                       bufVal[j] = bufR[i];
                   }
                   bufVal[j+1] = 0;
               } else {
                   cells[n].name[j] = bufR[i];
                   cells[n].name[j+1]= 0;
               }

            j++;

        }
    }

    free(bufR);
 
    return status;
}

#define USSD_ID  0

UINT32 USSD( EVENT_STACK_T * ev_st, void * app ) {
    USSD_COMPLETE_T  *att = (AFW_GetEv(ev_st)->attachment);
    char    buf[200];

   // APP_ConsumeEv(ev_st, app);

    //if (att->result == 0) {
    //    DL_AudPlayTone( 0,  7 );
    //}

    //if (att->ussd_id == 0xF) {
        //dbg("USSD id = %d", att->ussd_id);
        //dbg("USSD res = %d", att->result);
        u_utoa((att->ussd_string.string), buf);
        dbg("USSD Complete! = %s", buf);

        DL_SigCallSSAbortUSSDReq(USSD_ID);
    //}
    return RESULT_OK;
}

/*  , EV_KEY_PRESS    */
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    UINT8       keypress = (AFW_GetEv(ev_st))->data.key_pressed;
    IFACE_DATA_T 	if_data;
    USSD_STRING_T 	str_req;
    //struct {UINT16 ussd_id; USSD_STRING_T str;}att_data;

    //att_data.ussd_id=0;
     //u_strcpy(att_data.ussd_string.string, L"*555#");


    if_data.port=((APPLICATION_T*)app)->port;
    u_strcpy(str_req.string, L"*101#");


    if (keyexitN1 != 0 && keyexitN2 != 0 && keyexitN3 != 0)
    {
        if (exitN1)
        {
            if (exitN2)
            {
                if (!exitN3) if (keypress == keyexitN3) exitN3 = TRUE;
            }
            else
            {
                if (keypress == keyexitN2) exitN2 = TRUE;
            }
        }
        else
        {
            if (keypress == keyexitN1) exitN1 = TRUE;
        }

        if (keypress != keyexitN1 && keypress != keyexitN2 && keypress != keyexitN3 )
        {
            exitN1 = FALSE;
            exitN2 = FALSE;
            exitN3 = FALSE;
        }
    }		

    if(exitN1 & exitN2 & exitN3 ) return destroyApp(ev_st, app);

    if (keypress == KEY_RED && WorkingTable()) {
         UpdateData(); 
         APP_UtilStopTimer(app);
         APP_UtilStartCyclicalTimer( TIME_REFRESH,  2,  app );
    } else if (keypress == KEY_1) {
        //APP_ConsumeEv(ev_st,app);

        DL_SigCallSSSendUSSDResponseReq(&if_data,
                                        USSD_ID, //  . : 0x0000 - 0xFFFE
									    &str_req //  
                                        );

 
    } 
	
    return RESULT_OK;
}

UINT32 HandleKeyrelease( EVENT_STACK_T *ev_st,  void *app )
{
    //if (WorkingTable()) UIS_ForceRefresh();
    

	return RESULT_OK;
}

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{

	if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 1)
	{
            if (WorkingTable()) {
                UpdateData();
                if (WorkingTable()) DrawInfo();
                APP_UtilStopTimer(app);
                APP_UtilStartCyclicalTimer( TIME_REFRESH,  2,  app );
            }
	} else if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 2) {
        if (WorkingTable()) DrawInfo();
        APP_UtilStopTimer(app);
        APP_UtilStartCyclicalTimer( TIME_UPDATE_DATE,  1,  app );
    }
	
	return RESULT_OK;
}

CLK_DATE_T Date(WCHAR *buf_date)
{
    CLK_DATE_T date;
    UINT32 a, y, m;
    UINT8  res;

    if (!(info[INFO_DATE].style.enabled_1 | info[INFO_DATE].style.enabled_2)) return date;

    dbg("update Date", NULL);

    buf_date[0] = 0;


    DL_ClkGetDate( &date);

    a=(14-date.month)/12; 
    y=date.year-a; 
    m=date.month+12*a-2; 

    if (info[INFO_DATE].style.enabled_1) {

        u_ltou(date.day, buf_date);
        u_strcat(buf_date, L"/");
    
        u_ltou(date.month, buf_date+u_strlen(buf_date));
        u_strcat(buf_date, L"/");
    
        u_ltou(date.year, buf_date+u_strlen(buf_date));
        u_strcat(buf_date, L"\n");
    }

    if (info[INFO_DATE].style.enabled_2) {
    
        switch((date.day+y+y/4-y/100+y/400+(31*m)/12)%7) {
    
        case 0: // 
            res = LNG_SUNDAY;
            break;
        case 1: // 
            res = LNG_MONDAY;
            break;
        case 2: // 
            res = LNG_TUESDAY;
            break;
        case 3: // 
            res = LNG_WEDNESDAY;
            break;
        case 4: // 
            res = LNG_THURSDAY;
            break;
        case 5: // 
            res = LNG_FRIDAY;
            break;
        case 6: // 
            res = LNG_SATURDAY;
            break;
        }
    
        u_strcat(buf_date, Lang.str[res]);
    }

    return date;
}


extern const UINT32 *SBCM_ATOD_vltg;
#define BAT_MAX		402
#define BAT_MIN		335

UINT8 Battery(WCHAR *buf_con )
{
    UINT16  dy,dya,dyb,dyc,bf;
    UINT8   Bat;

    if (!(info[INFO_BATTERY].style.enabled_1 | info[INFO_BATTERY].style.enabled_2)) return RESULT_FAIL;

    dbg("update Battery", NULL);

    buf_con[0] = 0;

	Bat = *((char*)(*SBCM_ATOD_vltg));

    dy=(Bat) + 231;
	
    dya=dy/100;             // 
    dyb=(dy-dya*100)/10;    // 
    dyc=dy-100*dya-10*dyb;  // 

    if(dy >= BAT_MAX){
        bf=100;
    } else if(dy <= BAT_MIN) {
        bf=1;
	} else {
		bf=((dy-BAT_MIN)*100)/(BAT_MAX-BAT_MIN);
	}
    
    u_strcpy(buf_con, Lang.str[LNG_BATTERY]);

    if (info[INFO_BATTERY].style.enabled_1) {
        // 
        u_ltou(bf, buf_con+u_strlen(buf_con));
        u_strcat(buf_con, L"% ");
    }
    if (info[INFO_BATTERY].style.enabled_2) {
        // 
        u_ltou(dya, buf_con+u_strlen(buf_con));
        u_strcat(buf_con, L".");
        u_ltou(dyb,buf_con+u_strlen(buf_con));
        u_ltou(dyc, buf_con+u_strlen(buf_con));
        u_strcat(buf_con, L"V");
    }

    return Bat;

}


SIGNAL_STRENGTH_T Signal(WCHAR *buf_con )
{
    SIGNAL_STRENGTH_T   sig;

    if (!(info[INFO_SIGNAL].style.enabled_1 | info[INFO_SIGNAL].style.enabled_2)) return sig;

    dbg("update Signal", NULL);

    buf_con[0] = 0;

    DL_SigRegQuerySignalStrength(&sig);

    
    u_strcpy(buf_con, Lang.str[LNG_SIGNAL]);

    if (info[INFO_SIGNAL].style.enabled_1) {
        u_ltou(sig.percent, buf_con+u_strlen(buf_con));
        u_strcat(buf_con, L"% ");
    }
    if (info[INFO_SIGNAL].style.enabled_2) {
        u_ltou(sig.dbm, buf_con+u_strlen(buf_con));
        u_strcat(buf_con, L"dbm");
    }

    return sig;
}

UINT16 Cells(WCHAR *buf_con)
{
    UINT16 i;

    UINT16              cell_id;

    dbg("update Cells", NULL);

    buf_con[0] = 0;

    DL_SigRegGetCellID(&cell_id);
   

    if (info[INFO_CELLS].style.enabled_1) {
        u_strcpy(buf_con, Lang.str[LNG_CELLID]);
        u_ltou(cell_id, buf_con+u_strlen(buf_con));
        u_strcat(buf_con, L"\n");
    }

    if (info[INFO_CELLS].style.enabled_2) {
    
        for (i=0; i < count_cells; i++) {
            if (cells[i].cell_id == cell_id){
                 u_atou(cells[i].name, buf_con+u_strlen(buf_con) );
                 break;
            }
        }
    
        if (i == count_cells) {
            for (i=0; i < count_cells; i++) {
                if (cells[i].mask && cells[i].cell_id == (cell_id/degree(10,cells[i].mask))*degree(10,cells[i].mask)){
                     u_atou(cells[i].name, buf_con+u_strlen(buf_con) );
                     break;
                }
            }
        }
    }
        
    return cell_id;
}


UINT32 Disks(WCHAR *buf_con)
{
    UINT8       i;
    WCHAR       volumes[12];
    WCHAR       volume[3];
    VOLUME_DESCR_T descr;

    dbg("update Disks", NULL);

    buf_con[0] = 0;

    if (!(info[INFO_DISKS].style.enabled_1 | info[INFO_DISKS].style.enabled_1)) return RESULT_FAIL;

    //   
    DL_FsVolumeEnum( volumes ); // result = {0,'/',0,'a',0xff,0xfe,0,'/', ...}


    for (i=0; i < 4; i++) {
       volume[0] = volumes[i*3];
       volume[1] = volumes[i*3+1];
       volume[2] = 0;
       
       u_strcat(buf_con, volume);
       u_strcat(buf_con, L"/  ");

       DL_FsGetVolumeDescr( volume, &descr );

       if (info[INFO_DISKS].style.enabled_1) {
           if (descr.free_size > (1024*1024)) {
               u_ltou(descr.free_size/(1024*1024), buf_con+u_strlen(buf_con));
               if((descr.free_size%(1024*1024))/102400 > 0){
                   u_strcat(buf_con, L",");
                   u_ltou((descr.free_size%(1024*1024))/102400, buf_con+u_strlen(buf_con));
                   u_strcat(buf_con, L" Mb");
               } else {
                   u_strcat(buf_con, L" Mb");
               }
           } else {
               u_ltou(descr.free_size/1024, buf_con+u_strlen(buf_con));
               u_strcat(buf_con, L" Kb");
           }
           
       }

       if (info[INFO_DISKS].style.enabled_2) {
           u_strcat(buf_con, L" | ");
           if (descr.vol_size > (1024*1024)) {
               u_ltou(descr.vol_size/(1024*1024), buf_con+u_strlen(buf_con));
               if(descr.vol_size%(1024*1024) > 0){
                   u_strcat(buf_con, L",");
                   u_ltou((descr.vol_size%(1024*1024))/102400, buf_con+u_strlen(buf_con));
                   u_strcat(buf_con, L" Mb\n");
               } else {
                   u_strcat(buf_con, L" Mb\n");
               }
           } else {
               u_ltou(descr.vol_size/1024, buf_con+u_strlen(buf_con));
               u_strcat(buf_con, L" Kb\n");
           }
       } else {
           u_strcat(buf_con, L"\n");
       }


       if (volumes[i*3+2] == NULL)  break;
    }

    return RESULT_OK;
}


UINT32 Weather(WCHAR *buf_con)
{
    UINT32 status;
    if (!(info[INFO_WEATHER].style.enabled_1 | info[INFO_WEATHER].style.enabled_2)) return RESULT_FAIL;

    dbg("update Weather", NULL);

    buf_con[0] = 0;
    dbg("buf_con = 0", NULL);


    if (Weather_getTemperature != NULL || Weather_getForecast != NULL || Weather_getPhenomena != NULL || Weather_getWind != NULL) {
        dbg("API Weather find!", NULL);

        if (info[INFO_WEATHER].style.enabled_1) {
            dbg("Draw Date", NULL);
            status=Weather_getForecast(buf_con, 1);
            dbg("status getForecast = %d", status);
            if (status == RESULT_OK) u_strcat(buf_con, L"\n");
        }

        if (info[INFO_WEATHER].style.enabled_2) {
            dbg("Draw DATA", NULL);
            status=Weather_getTemperature(buf_con+u_strlen(buf_con), 1);
            if (status == RESULT_OK) u_strcat(buf_con, L",");
            status=Weather_getWind(buf_con+u_strlen(buf_con), 1);
            if (status == RESULT_OK) u_strcat(buf_con, L"\n");
            status=Weather_getPhenomena(buf_con+u_strlen(buf_con), 1);
        }
    } else {
        dbg("API Weather not find", NULL);
    }

    return status;
}


UINT32 UpdateData(void)
{
    UIS_ForceRefresh();

    Date(info[INFO_DATE].str);
    Battery(info[INFO_BATTERY].str);
    Signal(info[INFO_SIGNAL].str);
    Cells(info[INFO_CELLS].str);
    Disks(info[INFO_DISKS].str);
    Weather(info[INFO_WEATHER].str);

    dbg("Update Date!", NULL);
         
    return RESULT_OK;
}


UINT32 DrawInfo(void)
{
    UINT16 i;

    if (!WorkingTable()) return RESULT_FAIL;

    for (i=0; i < INFO_MAX; i++ ) {
           DrawString(info[i].str, info[i].style);
    }
    return RESULT_OK;
}


UINT32 DrawString(WCHAR *ustr, INFO_STYLE_T   xstyle )
{
    GRAPHIC_POINT_T         anchor_point;
    COLOR_T                 color;
    UINT16                  i, offset=0;
   
    color.red = 0;
    color.green = 0;
    color.blue = 255;
    color.transparent = 128;// 128;

    anchor_point.x = xstyle.x;
    anchor_point.y = xstyle.y;

    UIS_CanvasSetFont(xstyle.font, dialog);
    UIS_CanvasSetFontStyle(xstyle.font_style, dialog);
    UIS_CanvasSetBackgroundColor(xstyle.bcolor);
    UIS_CanvasSetForegroundColor(xstyle.fcolor);



    for (i=0; i < u_strlen(ustr); i++) {
        if (ustr[i] == '\n') {
            UIS_CanvasDrawColorText (ustr, offset, i - offset,
							 anchor_point,
							 xstyle.anchor,
							 dialog	);
            offset = i+1;
            anchor_point.y += xstyle.between; 
        }
    }

    UIS_CanvasDrawColorText (ustr, offset, i - offset,
							 anchor_point,             
							 xstyle.anchor,
							 dialog
							);

    UIS_CanvasSetFontStyle(FONT_STYLE_PLAIN, dialog);
    
    return RESULT_OK;
}

//   
UINT32 degree(UINT32 x, UINT32 y)
{  
 UINT32 result=x;
    if (y == 0) {  
         return 1;  
    } else {  
        while (y > 1) {  
            result *= x; 
            y--;  
        }  
    }  
    return result;
}

 // : TRUE -   , FALSE  -   
BOOL WorkingTable(void)
{
	UINT8 res;
	
	UIS_GetActiveDialogType(&res);
	
	if (res == 0xE) {
		return TRUE;
	} else {
		return FALSE;
	}	
}






