#include "ELF.h"

extern const UINT32 *KEYPAD_STATE;

BOOL exitN1=FALSE;
BOOL exitN2=FALSE;
BOOL exitN3=FALSE;

UINT8 keyexitN1;
UINT8 keyexitN2;
UINT8 keyexitN3;

struct 
{
	UINT8 keycode;
	UINT32 color;
} keyled[40];



/*  .        */
const char app_name[APP_NAME_LEN] = "Illumination"; 


//     state-

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    { EV_KEY_PRESS,             HandleKeypress },
	{ EV_KEY_RELEASE,         HandleKeyrelease },

    //      
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { STATE_HANDLERS_END,           NULL           },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }

};


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
	UINT32              evcode_base;
    UINT32 				status = RESULT_OK;
	
	WCHAR 				nameCfgFile[256];
	UINT32 				i;
	FILE_HANDLE_T 		f;
	UINT32 				readen;
	UINT8 				bufR[324];
	
    evcode_base = reserve;    //  reserve

	/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)startApp );   // ,   
	
        u_atou(file_uri, nameCfgFile);
        nameCfgFile[u_strlen(nameCfgFile)-3] = 0;
		u_strcat(nameCfgFile, L"cfg");
						   
		if (DL_FsFFileExist(nameCfgFile)) //    
		{
			f = DL_FsOpenFile(nameCfgFile, FILE_READ_MODE, 0);
			DL_FsReadFile( bufR, 324, 1, f, &readen );
			DL_FsCloseFile(f);
		
			for (i=0; i < 40; i++)
			{
				keyled[i].keycode = bufR[i*8];
				if (bufR[i*8+2] <= 0x0F && bufR[i*8+3] <= 0x0F && bufR[i*8+4] <= 0x0F)
				keyled[i].color = (UINT32)((bufR[i*8+2]*0x100) + (bufR[i*8+3]*0x10) + (bufR[i*8+4]));
				PFprintf( "key = %d ",	bufR[i*8] );
				PFprintf( "color = %x \n", 	(UINT32)((bufR[i*8+2]*0x100) + (bufR[i*8+3]*0x10) + (bufR[i*8+4]))  );
			}	
			
			
				keyexitN1 = bufR[321];
				keyexitN2 = bufR[322];
				keyexitN3 = bufR[323];		
		
		}					   
             
		
    LdrStartApp(reserve);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;

	
    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
    {
        return RESULT_FAIL; //     
    }
    else
    {
        //    
        app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEventPrepost, //    
                                                  sizeof(APP_HELLOWORLD_T), //   
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                                  2, 0, 0 );
                                                  

        status = APP_Start( ev_st,
                            &app->apt,
                            HW_STATE_MAIN, //  
                            state_handling_table,
                            destroyApp,
                            app_name,
                            0 );
    
	}

    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;
	
	HAPI_LP393X_set_tri_color_led( 0,  0x000 );

	APP_UtilStopTimer( app );
    /*    */
    status = APP_Exit( ev_st, app, NULL );
	
	
	
    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    return RESULT_OK;
}


	
/*  , EV_KEY_PRESS    */
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
	UINT8 		keypress;
	UINT32		i;
	
	keypress = event->data.key_pressed;
	
	if (keyexitN1 != 0 && keyexitN2 != 0 && keyexitN3 != 0)
	{
		if (exitN1)
		{
			if (exitN2)
			{
				if (!exitN3) if (keypress == keyexitN3) exitN3 = TRUE;
			}
			else
			{
				if (keypress == keyexitN2) exitN2 = TRUE;
			}
		}
		else
		{
			if (keypress == keyexitN1) exitN1 = TRUE;
		}

		if (keypress != keyexitN1 && keypress != keyexitN2 && keypress != keyexitN3 )
		{
			exitN1 = FALSE;
			exitN2 = FALSE;
			exitN3 = FALSE;
		}
	}	
	
	if(exitN1 & exitN2 & exitN3 ) return destroyApp(ev_st, app);
	
	if (!KeypadLock())
	{
		for (i=0; i < 40; i++)
		{
			if (keypress == keyled[i].keycode)
			{
				if (keyled[i].color != 0) HAPI_LP393X_set_tri_color_led( 0,  keyled[i].color );
				break;
			}
		}
	}	
	
	
	
    return RESULT_OK;
}

UINT32 HandleKeyrelease( EVENT_STACK_T *ev_st,  void *app )
{
	HAPI_LP393X_set_tri_color_led( 0,  0x000 );
	return RESULT_OK;
}

BOOL KeypadLock(void)
{
   UINT8 keypad_statate;
   DL_DbFeatureGetCurrentState( *KEYPAD_STATE, &keypad_statate );
   return keypad_statate;
}	



