#ifndef HexEditor_H
#define HexEditor_H


#include <apps.h>

//    
#define GRID_X              76
#define GRID_Y              40

// -   
#define LINES_COUNT         8
#define COLUMNS_COUNT       4
#define CELLS_COUNT         32 //   = COLUMNS_COUNT*LINES_COUNT

//  
#define LINE_H              20
//  
#define COLUMN_W            25


#define DRMRES_FOLDER		0x120000CE

extern UIS_DIALOG_T         dialog=0;


/*    .      */
typedef struct
{ 
    APPLICATION_T           apt; /*   ,   */

} APP_HEXEDITOR_T;

/*   */
typedef enum
{
    HE_STATE_ANY, /* ANY-state   */

    HE_STATE_INIT,
    HE_STATE_MAIN,
    HE_STATE_EDIT,
    HE_STATE_MENU,
    HE_STATE_FBROWSER,
    HE_STATE_RAM,
    HE_STATE_SEEM,
    HE_STATE_FIND,
    HE_STATE_GOTO,
    

    HE_STATE_MAX /*   */
} HE_STATES_T;

typedef enum 
{
    MENU_FILE_OPEN=1,
    MENU_RAM_OPEN,
    MENU_SEEM_OPEN,
    MENU_FIND,
    MENU_GOTO,
    MENU_MAX=MENU_GOTO
} MENU_ITEMS_T;

typedef enum
{
	RES_LIST_CAPTION=0,
	RES_EDIT_CAPTION,
	RES_MAX
} HE_RESOURCE;


/*     */
RESOURCE_ID Resources[RES_MAX];


typedef enum 
{
    HEX_MODE,
    DEC_MODE,
    TEXT_MODE,
    MAX_MODE=TEXT_MODE
} VIEW_MODES_T;


typedef struct
{ 
	WCHAR		name[FILENAME_MAX_LEN+1]; //  
	UINT16		attrib;   // 
} FILEINFO;	

typedef enum {
    OPEN_FILE,
    OPEN_RAM,
    OPEN_SEEM
}OPEN_MODE_T;


UINT32 Register( char* file_uri,  char* param,  UINT32 reserve );
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 );
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app );

UINT32 ReadSetting(WCHAR *cfg_file);
UINT32 SaveSetting(WCHAR *cfg_file);
UINT32 InitResources(void);
UINT32 RemoveResources(void);

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app );

UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app );
UINT32 EditStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 EditData( EVENT_STACK_T *ev_st,  void *app );
UINT32 EditOk( EVENT_STACK_T *ev_st,  void *app );

UINT32 MenuStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 mSelectItem( EVENT_STACK_T *ev_st,  void *app ) ;
UINT32 mSendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num);

UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type );
UINT32 Back( EVENT_STACK_T *ev_st,  void *app );

UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app );
UINT32 FbrowserStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type );
UINT32 FbrowserStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 fbSendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num);
UINT32 fbSelectItem( EVENT_STACK_T *ev_st,  void *app ) ;
UINT32 UpdateList( EVENT_STACK_T *ev_st,  void *app, UINT32 sItem );

UINT32 RAMStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 RAMData( EVENT_STACK_T *ev_st,  void *app );

UINT32 SEEMStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 SEEMData( EVENT_STACK_T *ev_st,  void *app );

UINT32 FindStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 FindData( EVENT_STACK_T *ev_st,  void *app );

UINT32 GoToStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 GoToData( EVENT_STACK_T *ev_st,  void *app );

UINT32 FindFile( WCHAR *folder, WCHAR *filtr ); //  
UINT32 OpenFile(WCHAR *uri);
UINT32 OpenRAM(UINT32  address);
UINT32 OpenSeem(UINT16 seem, UINT32 rec);
UINT32 LoadBuffer(INT32 off_set);
UINT32 SaveOffset(INT32 off_set, UINT8 value);
UINT32 GoTo(INT32 off_set);
INT32 FindPattern(char *pattern, INT32 off_set);
UINT32 Data2Pattern(WCHAR *data, char *pattern);
INT32 RelativeOffset(INT32 off_set);

UINT32 paint(void); //  

GRAPHIC_POINT_T  XY(UINT32 sItem);
WCHAR* dec2hex( UINT32 dec, WCHAR *hex, UINT16 size );
UINT32 UCS2toCP1251(WCHAR *src, char *trg);

WCHAR* SplitPath( WCHAR* path, WCHAR* spliter ) ;

#endif
