#include "GUI.h"
#include "fpaParser.h"
#include "iniParser.h"
#include <dbg.h>


UINT32                  CG1_begin = 0x80000;

FPA_FILE_T              fpa_file;
WCHAR                   file_open[256];
RESULT_PATCH_T          res_patch;

/*     */
RESOURCE_ID Resources[RES_MAX];

/*  .        */
const char app_name[APP_NAME_LEN] = "FlashPatcher"; 

//     state-

/*    FP_STATE_ANY (   state) */
static EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    // GUI     
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    { STATE_HANDLERS_END,           NULL           },
};

static EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    //   ,      UI
    { EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};

static EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { STATE_HANDLERS_RESERVED,      useUndo        },
    { EV_SELECT,                    usePatch       },
    { EV_DIALOG_DONE,               destroyApp     },
    { EV_DONE,                      destroyApp     },
    
    { STATE_HANDLERS_END,           NULL           },
};

static EVENT_HANDLER_ENTRY_T msg_state_handlers[] =
{
    { EV_DIALOG_DONE,               destroyApp     },
    { EV_DONE,                      destroyApp     },
    { STATE_HANDLERS_END,           NULL           },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { FP_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { FP_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },
    
    { FP_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    },

    { FP_STATE_MSG,
      MsgStateEnter,
      NULL,
      msg_state_handlers
    }
};

UINT32 LdrFindEventHandlerTbl( EVENT_HANDLER_ENTRY_T *tbl,  EVENT_HANDLER_T *hfn )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].hfunc==hfn)	
			return tbl[i].code;
		i++;
	}

	return 0;
}

/*      elfpack- */
UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T *tbl,  UINT32 *base )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].code==STATE_HANDLERS_RESERVED)	
			tbl[i].code = (*base)++;
		i++;
	}
	return *base;
}

/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 status = RESULT_OK;
    UINT32 evcode_base = reserve;    //  reserve

    WCHAR		c_ini_uri[256];
    char        temp_str[32];

    if (strlen(param)) {
        param2uri(param, file_open);
    }  else {
        file_open[0] = 0;
        return LdrUnloadELF(&Lib); //  
    }

    memset(temp_str, 0, 32);
    //   
    u_atou(file_uri, c_ini_uri);
	c_ini_uri[u_strlen(c_ini_uri)-3] = 0;
	u_strcat(c_ini_uri, L"ini");

    if (OpenINI(c_ini_uri) == RESULT_OK){
        setSeparator('=');

        ReadParamINI("CG1", temp_str, 32, "0x10080000");
        CG1_begin = strtoul(temp_str, NULL, 16);
        dbg("CG1_begin = 0x%x", CG1_begin);
        if (CG1_begin >= 0x10000000) CG1_begin -=  0x10000000;

        ReadParamINI("Undo", temp_str, 32, "yes");
        if (!strcmp(temp_str, "yes") || !strcmp(temp_str, "true")) Use_Undo = true;
        else Use_Undo = false;
        dbg("Undo = %s",temp_str);

        
    }
    CloseINI();

    LdrInitEventHandlersTbl( main_state_handlers, &evcode_base );
    

    /*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           FP_STATE_MAX,            //  
                           (void*)startApp );   // ,   

                  
    
    LdrStartApp(evcode_base);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_FLASHPATCHER_T     *app = NULL;
    UINT32 					status = RESULT_OK;
    

    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
        return RESULT_FAIL; //     

    //    
    app = (APP_FLASHPATCHER_T*)APP_InitAppData( (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_FLASHPATCHER_T), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );

    InitResources();

    status = APP_Start( ev_st,
                        &app->apt,
                        FP_STATE_INIT, //  
                        state_handling_table,
                        destroyApp,
                        app_name,
                        0 );




    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                  status;
    APP_FLASHPATCHER_T     *papp=(APP_FLASHPATCHER_T*)app;

    APP_ConsumeEv(ev_st, app);

    FreeFpaFile(&fpa_file);
    RemoveResources();
    APP_UtilUISDialogDelete(  &papp->apt.dialog ); //   

    /*    */
    status = APP_Exit( ev_st, app, 0 );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    main state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    CONTENT_T               content;
    UIS_DIALOG_T            dialog = 0;

    UINT32                  i;
    UINT32                  status;
    UINT32                  size_info=0;
    WCHAR                   *info;

    ACTIONS_T				action_list; // 
   

    if(type!=ENTER_STATE_ENTER) return RESULT_OK;

       
    //  
    status = ParseFpaFile(file_open, &fpa_file);
    dbg("status ParseFpaFile = %d", status);


    if (status == PARSE_OK) {
        action_list.count = 0;
        ActionAdd(&action_list, EV_SELECT, Resources[RES_ACTION0]); //   
        if (fpa_file.undo && Use_Undo) { //  
            ActionAdd(&action_list, LdrFindEventHandlerTbl( main_state_handlers, useUndo ), Resources[RES_ACTION1]);
        }

        //   
        for (i=0; i < fpa_file.count_info; i++) {
            size_info += strlen(fpa_file.info[i].name) + 8;
            size_info += strlen(fpa_file.info[i].value) + 8;
        }
        info = alloc(size_info*sizeof(WCHAR));
        info[0]=0;
        for (i=0; i < fpa_file.count_info; i++) {
            u_atou(fpa_file.info[i].name, info+u_strlen(info));
            u_strcat(info, L": \n");
            u_atou(fpa_file.info[i].value, info+u_strlen(info));
            u_strcat(info, L"\n\n");
        }
    } else {
        //    
        info = alloc(32*sizeof(WCHAR));
        if (status == PARSE_FILE_FAIL) {
            u_strcpy(info, L"File invalid");
        } else if (status == PARSE_MEM_FAIL) {
            u_strcpy(info, L"Memory fail");
        } else {
            u_strcpy(info, L"Error");
        }
    }

    UIS_MakeContentFromString("q0Nq1", &content, L"FlashPatcher by om2804", info); //   
    dialog = UIS_CreateViewer(&port, &content, &action_list);
    //dialog = UIS_CreateTransientNotice( &port, &content, NOTICE_TYPE_OK );

    free(info);
    if(dialog == 0) return RESULT_FAIL;
    papp->dialog = dialog;
   

    return RESULT_OK;
}

/*    main state */
UINT32 MsgStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    CONTENT_T               content;
    UIS_DIALOG_T            dialog = 0;



    if(type!=ENTER_STATE_ENTER) return RESULT_OK;

    if (res_patch == PATCH_OK) {
        UIS_MakeContentFromString("Cq0", &content, L"Ok"); //   
        dialog = UIS_CreateTransientNotice( &port, &content, NOTICE_TYPE_OK );
    } else if (res_patch == PATCH_MEM_FAIL) {
        UIS_MakeContentFromString("Cq0", &content, L"Memory fail"); //   
        dialog = UIS_CreateTransientNotice( &port, &content, NOTICE_TYPE_FAIL );
    } else {
        UIS_MakeContentFromString("Cq0", &content, L"fail"); //   
        dialog = UIS_CreateTransientNotice( &port, &content, NOTICE_TYPE_FAIL );
    }

    if(dialog == 0) return RESULT_FAIL;
    papp->dialog = dialog;
   

    return RESULT_OK;
}

UINT32 usePatch( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                  i, j, k, l;
    UINT32                  badr = 0;
    UINT32                  mask;
    BLOCK_T                 block;
    UINT32                  status;

    INT32                  *nums; //     
    UINT32                  n=0;

    BOOL                    undo=false; //   


    APP_ConsumeEv(ev_st, app);

    if (!fpa_file.undo && Use_Undo) { //     ,  
        undo = true; //     
        //    
        fpa_file.count_undo =  fpa_file.count_code;
        fpa_file.undo = alloc(fpa_file.count_undo*sizeof( PARAM_UNDO_T ));
        if (fpa_file.undo == NULL) {
            res_patch = PATCH_MEM_FAIL; 
            return APP_UtilChangeState( FP_STATE_MSG,  ev_st,  app ); //    
        }

        for (i=0; i < fpa_file.count_undo; i++) {
            fpa_file.undo[i].adress = fpa_file.code[i].adress;
            fpa_file.undo[i].count_bytes = fpa_file.code[i].count_bytes;
            fpa_file.undo[i].bytes = alloc(fpa_file.undo[i].count_bytes);
            if (fpa_file.undo[i].bytes == NULL) {
                res_patch = PATCH_MEM_FAIL; 
                return APP_UtilChangeState( FP_STATE_MSG,  ev_st,  app ); //    
            }
        }

    }

    nums = alloc(fpa_file.count_code*sizeof(INT32));
    if (nums == NULL) { 
        res_patch = PATCH_MEM_FAIL; 
        return APP_UtilChangeState( FP_STATE_MSG,  ev_st,  app ); //    
    }
    memset(nums, -1, fpa_file.count_code*sizeof(INT32));

    for (i=0; i < fpa_file.count_code; i++) {
        //   
        for (j=0; j < fpa_file.count_code; j++) if (i == nums[j]) break;
        if (j < fpa_file.count_code) continue; //  

        badr = getBlockAdr(fpa_file.code[i].adress+CG1_begin);
        dbg("badr = 0x%x", badr);

        status = CopyBlock(badr, &block);
        dbg("status CopyBlock = %d", status);


        if(status == RESULT_OK) {

            //    
            for (k=i; k < fpa_file.count_code; k++) {
                if (badr == getBlockAdr(fpa_file.code[k].adress+CG1_begin)) {
                    nums[n] = k; n++;
                    dbg("num = %d",k);
                    dbg("count_bytes = %d", fpa_file.code[k].count_bytes);
                    for (l=0; l  < fpa_file.code[k].count_bytes; l++) {
                        if (Use_Undo) {
                            fpa_file.undo[k].bytes[l] = SetValue(&block, fpa_file.code[k].adress+CG1_begin+l, fpa_file.code[k].bytes[l]);
                        } else {
                            SetValue(&block, fpa_file.code[k].adress+CG1_begin+l, fpa_file.code[k].bytes[l]);
                        }
                    }
                }
            }
    
            mask = suDisableAllInt(); //  
    
            FlashDevEraseBlock(badr); //   

            WriteBlock(badr, block); //  
   
            suSetInt(mask); //  

            FreeBlock(&block); //  
            
            res_patch = PATCH_OK;

        } else {
            res_patch = PATCH_MEM_FAIL;
            break;
        }

    }
    
    free(nums);

    if (undo) makeUndo(); //   

    APP_UtilChangeState( FP_STATE_MSG,  ev_st,  app ); //    

    return RESULT_OK;
}

UINT32 useUndo( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                  i, j, k, l;
    UINT32                  badr = 0;
    UINT32                  mask;
    BLOCK_T                 block;
    UINT32                  status;

    INT32                  *nums; //     
    UINT32                  n=0;


    APP_ConsumeEv(ev_st, app);

       

    nums = alloc(fpa_file.count_code*sizeof(INT32));
    if (nums == NULL) { 
        res_patch = PATCH_MEM_FAIL; 
        return APP_UtilChangeState( FP_STATE_MSG,  ev_st,  app ); //    
    }
    memset(nums, -1, fpa_file.count_undo*sizeof(INT32));

    for (i=0; i < fpa_file.count_undo; i++) {
        //   
        for (j=0; j < fpa_file.count_undo; j++) if (i == nums[j]) break;
        if (j < fpa_file.count_undo) continue; //  

        badr = getBlockAdr(fpa_file.undo[i].adress+CG1_begin);
        dbg("badr = 0x%x", badr);

        status = CopyBlock(badr, &block);
        dbg("status CopyBlock = %d", status);


        if(status == RESULT_OK) {

            //    
            for (k=i; k < fpa_file.count_undo; k++) {
                if (badr == getBlockAdr(fpa_file.undo[k].adress+CG1_begin)){
                    nums[n] = k; n++;
                    dbg("num = %d",k);
                    dbg("count_bytes = %d", fpa_file.undo[k].count_bytes);
                    for (l=0; l  < fpa_file.undo[k].count_bytes; l++) {
                        SetValue(&block, fpa_file.undo[k].adress+CG1_begin+l, fpa_file.undo[k].bytes[l]);
                    }
                }
            }
    
            mask = suDisableAllInt(); //  
    
            FlashDevEraseBlock(badr); //   

            WriteBlock(badr, block); //  
   
            suSetInt(mask); //  

            FreeBlock(&block); //  
            
            res_patch = PATCH_OK;

        } else {
            res_patch = PATCH_MEM_FAIL;
            break;
        }

    }

    
    free(nums);

    APP_UtilChangeState( FP_STATE_MSG,  ev_st,  app ); //    

    return RESULT_OK;
}

void makeUndo(void) 
{
    UINT32  i,j;
    WCHAR   undo_file[256];
    FILE    f;
    UINT32  w;
    char    val[16];

    //    
    u_strcpy(undo_file, file_open);
    undo_file[u_strlen(undo_file)-4] = 0;
    u_strcat(undo_file, L"_UNDO.fpa");

    udbg("undo_file = %s", undo_file);
    

    f = DL_FsOpenFile(undo_file, FILE_WRITE_MODE, 0);
    if (f  == FILE_INVALID) return;

    //  Info
    DL_FsWriteFile("[Patch_Info]\r\n", 14, 1, f, &w);
    for (i=0; i < fpa_file.count_info; i++) {
        DL_FsWriteFile(fpa_file.info[i].name, strlen(fpa_file.info[i].name), 1, f, &w);
        DL_FsWriteFile("=", 1, 1, f, &w);
        DL_FsWriteFile(fpa_file.info[i].value, strlen(fpa_file.info[i].value), 1, f, &w);
        DL_FsWriteFile("\r\n", 2, 1, f, &w);
    }

    DL_FsWriteFile("\r\n", 2, 1, f, &w);

    //  Code
    DL_FsWriteFile("[Patch_Code]\r\n", 14, 1, f, &w);
    for (i=0; i < fpa_file.count_undo; i++) {
        dec2hex(fpa_file.undo[i].adress, val, 8);
        DL_FsWriteFile(val, 8, 1, f, &w);
        DL_FsWriteFile(":", 1, 1, f, &w);
        for (j=0; j < fpa_file.undo[i].count_bytes; j++) {
             dec2hex(fpa_file.undo[i].bytes[j], val, 2);
              DL_FsWriteFile(val, 2, 1, f, &w);
        }
        DL_FsWriteFile("\r\n", 2, 1, f, &w);
    }
    DL_FsCloseFile(f);
}

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    //    
    status = APP_HandleUITokenGranted( ev_st, app );

    //   ,   state
    if( (status == RESULT_OK) && (papp->token_status == 2) )
    {
        status = APP_UtilChangeState( FP_STATE_MAIN, ev_st, app );
    }

    return status;
}

/*           */
UINT32 InitResources( )
{
    RES_ACTION_LIST_ITEM_T		action;

    DRM_CreateResource( &Resources[RES_ACTION1_CAPTION], RES_TYPE_STRING, (void*)L"Undo", (u_strlen(L"Undo")+1)*sizeof(WCHAR) );


    memclr(&action, sizeof(RES_ACTION_LIST_ITEM_T));

    #if (defined(L7e) || defined(L9))
    action.list_label = LANG_USE;			//   
    action.list_priority = 1;
    #else
    action.softkey_label = LANG_USE;			//   -
    action.softkey_priority = 1;
    #endif

    DRM_CreateResource( &Resources[RES_ACTION0], RES_TYPE_ACTION, (void*)&action, sizeof(RES_ACTION_LIST_ITEM_T));

    
    memclr(&action, sizeof(RES_ACTION_LIST_ITEM_T));

    action.list_label = Resources[RES_ACTION1_CAPTION];			//   
    action.list_priority = 0;

    DRM_CreateResource( &Resources[RES_ACTION1], RES_TYPE_ACTION, (void*)&action, sizeof(RES_ACTION_LIST_ITEM_T));


    return RESULT_OK;
}

/*        */
UINT32 RemoveResources( )
{
	UINT32				status = RESULT_OK;
	UINT32				i;

	for(i=0;i<RES_MAX;i++)
		status |= DRM_ClearResource( Resources[i] );

	return status;
}
//      
UINT32 OneAction( ACTIONS_T * list, EVENT_CODE_T event, RESOURCE_ID res, UINT8 op )
{
	if ( list == NULL || list->count >= 16 )
		return RESULT_FAIL;
	list->action[list->count].operation = op;
	list->action[list->count].event = event;
	list->action[list->count].action_res = res;
	list->count++;
	return RESULT_OK;
}

UINT32 ActionAdd( ACTIONS_T * list, EVENT_CODE_T event, RESOURCE_ID res )
{
	return OneAction(list, event, res, ACTION_OP_ADD);
}

UINT32 ActionUpd( ACTIONS_T * list, EVENT_CODE_T event, RESOURCE_ID res )
{
	return OneAction(list, event, res, ACTION_OP_UPDATE);
}

//    128 
UINT32 CopyBlock(UINT32 adr, BLOCK_T *block)
{
    int i, j;
    memset(block, 0, sizeof(BLOCK_T)); //  
    for (i=0; i < COUNT_SEGMENT; i++) {
        block->segment[i] = alloc(SEGMENT_SIZE);
        if (block->segment[i] == NULL) {
            dbg("malloc fail on %d segment", i);
            for (j=i-1; j > 0; j--) {
                free(block->segment[j]);
            }
            return RESULT_FAIL;
        }
    }

    //  
    for (i=0; i < COUNT_SEGMENT; i++) {
        dbg("copy adr 0x%x", adr+0x10000000+SEGMENT_SIZE*i);
        memcpy(block->segment[i], (UINT8*)(adr+0x10000000+SEGMENT_SIZE*i), SEGMENT_SIZE);
    }

    return RESULT_OK;
}

//  
void FreeBlock(BLOCK_T *block)
{
    int i;
    for (i=0; i < COUNT_SEGMENT; i++)      
        free(block->segment[i]);
}

//  
UINT32 WriteBlock(UINT32 adr, BLOCK_T block)
{
    int i;
    for (i=0; i < COUNT_SEGMENT; i++) {
        FlashDevWrite(block.segment[i], adr+SEGMENT_SIZE*i, SEGMENT_SIZE);
    }
    return RESULT_OK;
}

//   
BYTE SetValue(BLOCK_T *block, UINT32 adr, BYTE value)
{
    UINT32 badr;
    UINT32 n;
    UINT32 oadr;
    UINT32 adr_badr;

    BYTE    res;


    badr = getBlockAdr(adr);
    adr_badr = adr - badr;
    n = adr_badr/SEGMENT_SIZE; //  
    oadr = adr_badr - n*SEGMENT_SIZE;
    

    dbg("\n adr = 0x%x", adr);
    dbg("badr = 0x%x", badr);
    dbg("adr_badr = 0x%x", adr_badr);
    dbg("n =%d", n);
    dbg("oadr=0x%x", oadr);
    dbg("value = 0x%x\n", value);

    res = block->segment[n][oadr]; //  
    block->segment[n][oadr] = value; 

    return res;
}


//   
UINT32 getBlockAdr(UINT32 adr)
{
    return (adr/BLOCK_SIZE)*BLOCK_SIZE;
}

//    16-  
char* dec2hex( UINT32 dec, char *hex, UINT16 size )
{
    UINT32 d=dec;
    UINT32 len=0; // -  hex_buf
	UINT16 hex_buf[32]; // 
	INT16 i, j; //  


	if(d==0) {
        for (j=0; j < size; j++ ) {
            hex[j] = '0';
        }
		hex[j]= 0;

	} else {

        while (d != 0) {
            hex_buf[len] = d%16;
            d = d/16;
            len ++;
        }

        for (j=0; j < size - len; j++ ) {
            hex[j] = '0';
        }

        len--;
        for (i=len; i >= 0; i--) {
            if(hex_buf[i]<10) hex[j] = '0'+hex_buf[i];
            else hex[j] = 'A'+hex_buf[i]-10;
            j++;
        }   
        hex[j] = 0;
    }

	return hex;
}


UINT32 util_asc2ul( const char * s, UINT32 count )
{
    char    b;
    UINT32    res = 0;
    
    while ( count > 0 ) {
        b = *s++;
        if ( b >= '0' && b <= '9' ) {
            b -= '0';
        } else if ( b >= 'A' && b <= 'F' ) {
            b = b - 'A' + 10;
        } else if ( b >= 'a' && b <= 'f' ) {
            b = b - 'a' + 10;
        } else
            b = 0;
        res = res << 4;
        res |= b;
        count--;
    }
    
    return res;
}

UINT32 param2uri(char *param, WCHAR *uri)
{
    _u64                    tmp;
    DL_FS_MID_T             fid;

    if (strlen(param) > 16) { //  
        u_atou(param, uri);
    } else { // id
        tmp.R0 = util_asc2ul(param+0, 8);
        tmp.R1 = util_asc2ul(param+8, 8);
    
        if (tmp.R0==0 && tmp.R1==0) {
            u_atou(param, uri);
        } else {
            memcpy(&fid, &tmp, sizeof(UINT64));
            DL_FsGetURIFromID( &fid, uri );
        }
    }
    return RESULT_OK;
}
