#include "event.h"
#include <dbg.h>



/*  .        */
const char app_name[APP_NAME_LEN] = "EventsLog"; 

UINT32 	F1=0; //  
UINT32 	F2=0;

FILE LogFile=NULL;

BOOL	destroy=false;

//     state-

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    { EV_KEY_PRESS,             HandleKeypress },


    //      
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { STATE_HANDLERS_END,           NULL           },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }

};


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 status = RESULT_OK;
	UINT32 evcode_base= reserve;    //  reserve
	
	WCHAR nameCfgFile[64];
	
	UINT32 bufR[2];
	UINT32 readen;
	FILE_HANDLE_T f;
    
	

/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)startApp );   // ,   
                   
	//   
	
		u_atou(file_uri, nameCfgFile);
		nameCfgFile[u_strlen(nameCfgFile)-3] = 0;
		u_strcat(nameCfgFile, L"cfg");			

		udbg("nameCfgFile = %s\n", nameCfgFile);		
		
		//    		
		if (DL_FsFFileExist( nameCfgFile)) //    
		{
			f = DL_FsOpenFile(nameCfgFile, FILE_READ_MODE, 0);
			DL_FsReadFile( bufR, sizeof(UINT32)*2, 1, f, &readen );
			DL_FsCloseFile(f);
			
				F1 = bufR[0];
				F2 = bufR[1];
				dbg("Filtr1 = 0x%x\n", F1);
				dbg("Filtr2 = 0x%x\n", F2);
		}	
		
		//   
		nameCfgFile[u_strlen(nameCfgFile)-3] = 0;
		u_strcat(nameCfgFile, L"log");
		OpenLog(nameCfgFile);
		
    LdrStartApp(reserve);   //  
    
    return 1;   //    ,  
}

void My_APP_HandleEvent( EVENT_STACK_T *ev_st, void *app, APP_ID_T appid, REG_ID_T regid )
{
	char event_str[32];
	EVENT_T  *event = AFW_GetEv(ev_st);
	

	if (event->code >= F1 && event->code <= F2) {
		if(event->att_size > 0) dbg("EVENT = 0x%x   att_size=%d b\n", event->code, event->att_size);
		else dbg("EVENT = 0x%x\n", event->code);
		strcpy(event_str, "0x"); itoa(event->code, event_str+strlen(event_str), 16); 
		if (event->att_size > 0) { //   ?
			strcat(event_str, "   att_size="); itoa(event->att_size, event_str+strlen(event_str), 10); strcat(event_str, " b");
		}
		strcat(event_str, "\r\n");
		SendLog(event_str);
	}

    APP_HandleEventPrepost( ev_st,  app,  appid,  regid );
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;
    


    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
    {
        return RESULT_FAIL; //     
    }
    else
    {
        //    
        app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)My_APP_HandleEvent, //    
                                                  sizeof(APP_HELLOWORLD_T), //   
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                                  2, 0, 0 );
                                                  

        status = APP_Start( ev_st,
                            &app->apt,
                            HW_STATE_MAIN, //  
                            state_handling_table,
                            destroyApp,
                            app_name,
                            0 );

    }

    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

	if (destroy) {
		CloseLog();
		
		/*    */
	    status = APP_Exit( ev_st, app, NULL );
			
	    /*   */
	    LdrUnloadELF(&Lib); // &Lib    
	}

    return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    return RESULT_OK;
}


	
/*  , EV_KEY_PRESS    */
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
	EVENT_T     *event = AFW_GetEv(ev_st);
	char		key_str[8];

	dbg("KeyPress = %d\n", event->data.key_pressed);
	strcpy(key_str, "Code keyPress=");
	itoa(event->data.key_pressed, key_str+strlen(key_str), 10);
	strcat(key_str, "\r\n");
	SendLog(key_str);
	
	switch (event->data.key_pressed)
	{
		case KEY_STAR:
			destroy = true;
			return destroyApp(ev_st, app);
		break;
	}
	
    return RESULT_OK;
}


UINT32 OpenLog(WCHAR *uri)
{
	DL_FsDeleteFile( uri,  0 );
	LogFile = DL_FsOpenFile( uri,  FILE_WRITE_MODE,  0 );
	return RESULT_OK;
}

UINT32 CloseLog()
{
	return DL_FsCloseFile(LogFile);
}

UINT32 SendLog(char *str)
{
  UINT32 written;
  
	DL_FsWriteFile( (void*) str,
                    strlen(str),
                    1, 
                    LogFile,
                    &written);
					
	return RESULT_OK;
}






