#ifndef UNZIP_H
#define UNZIP_H

#include <zlib.h>
#include <apps.h>



#define ZIP_HEADER_SIZE					30

#define ZIP_HEADER_OFF_PACK_SIZE		0x0012
#define ZIP_HEADER_OFF_UNPACK_SIZE		0x0016
#define ZIP_HEADER_OFF_FILENAME_LEN		0x001A

#define ZIP_HEADER_OFF_MAGIC			0x0000
#define ZIP_HEADER_MAGIC_DATA			0x04034b50		// 'P','K',0x03,0x04 in LittleEndian

#define ZLIB_IN_BUF_SIZE				4*1024					//     
#define ZLIB_OUT_BUF_SIZE				ZLIB_IN_BUF_SIZE*2		// .............   


UINT32 getint( const char * ptr );
void * zcalloc( void * opaque, UINT32 items, UINT32 size );
void zcfree( void * opaque, void * ptr );

UINT32  UnpackFile(WCHAR *uri_zip, WCHAR *src_file, WCHAR *dst_file, BOOL RAM);

BOOL RAM_AddBlock(char *buf, UINT32 size);
BOOL RAM_Create(UINT32 size);
void RAM_Delete(void);

#endif