#include "unzip.h"
#include <dbg.h>

char    *src=NULL; //= "\r\nname=\r\n:english\r\nunpack lng/eng/Tunes.lng Test/Tunes.lng\r\n:\r\nunpack lng/rus/Tunes.lng Test/Tunes.lng\r\n\r\nname=\r\n:normal\r\nunpack cfg/normal/Tunes.cfg Test/Tunes.cfg\r\n:asCorelet\r\nunpack cfg/Corelet/Tunes.cfg Test/Tunes.cfg\r\nautorun Tunes/Tunes.elf";
UINT32  size_buf=0; //  

//    ARM BigEndian
// * UINT32     4 ,  x86   
UINT32 getint( const char * ptr )
{	//    4 
	return (UINT32)( (ptr[0] <<  0) |
					(ptr[1] <<  8) |
					(ptr[2] << 16) |
					(ptr[3] << 24) );
}



/*   zcalloc & zcfree  ,
 *     (  44R),    
 */
void * zcalloc( void * opaque, UINT32 items, UINT32 size )
{
	INT32	err;
	void *	ptr;
	size_t	sz = items * size;
	ptr = suAllocMem(sz, &err);
	if ( err == 0 )	// OK
		return ptr;
	// ERR
	err("zcalloc: can't allocate %d bytes", sz);
	return NULL;
}
void zcfree( void * opaque, void * ptr )
{
	suFreeMem(ptr);
}

// uri_zip -  
// src_file -  
// dst_file -  
// RAM - true -  , false -   
UINT32  UnpackFile(WCHAR *uri_zip, WCHAR *src_file, WCHAR *dst_file, BOOL RAM) 
{
    FILE				zip_file, out_file;
    UINT32				read, wr;
    char *				rbuf;							//   
    char *				wbuf;							//   
    char				header[ZIP_HEADER_SIZE];
    UINT32				pack_sz=0,
						unpack_sz=0,
						file_name_len=0;
    WCHAR               *file_name=NULL;

    udbg ("uri_zip %s", uri_zip);
    udbg ("src_file %s", src_file);
    udbg ("dst_file %s", dst_file);

    zip_file = DL_FsOpenFile(uri_zip, FILE_READ_MODE, 0);
    if ( zip_file == FILE_INVALID ) {
        err("zip not open", NULL);
        return RESULT_FAIL;
    }

    while (1) {
            //  
            DL_FsReadFile(header, 1, ZIP_HEADER_SIZE, zip_file, &read);
            dbg("Read header DONE, read = %d", read);
            if ( read != ZIP_HEADER_SIZE ) {
                pack_sz=0;
				unpack_sz=0;
                break; //    :(
            }
            dbg("Magic = 0x%x", getint(header + ZIP_HEADER_OFF_MAGIC));
            if ( getint(header + ZIP_HEADER_OFF_MAGIC) != ZIP_HEADER_MAGIC_DATA ) return RESULT_FAIL; //    zip
    
            pack_sz = getint(header + ZIP_HEADER_OFF_PACK_SIZE);
            unpack_sz = getint(header + ZIP_HEADER_OFF_UNPACK_SIZE);
            file_name_len = getint(header + ZIP_HEADER_OFF_FILENAME_LEN);
            dbg("pack_sz = %d", pack_sz);
            dbg("unpack_sz = %d", unpack_sz);
            dbg("file_name_len = %d", file_name_len);
    
            //   
            rbuf = (char *) malloc(file_name_len+1);
            DL_FsReadFile(rbuf, 1, file_name_len, zip_file, &read);
            rbuf[file_name_len] = 0;
    
            file_name = (WCHAR *) malloc((file_name_len+1)*sizeof(WCHAR));
            u_atou(rbuf, file_name);
            free(rbuf);

            udbg("file_name = %s", file_name);
            udbg("src_file = %s", src_file);
            if (u_strcmp(file_name, src_file) == 0) {
                // !  !
                dbg("Yes!", NULL);
                free(file_name);
                break;
            } else {
                DL_FsFSeekFile( zip_file,  pack_sz, SEEK_WHENCE_CUR ); //    
            }
    
            free(file_name);
    }

    if (pack_sz == 0 || unpack_sz == 0) return RESULT_FAIL;

    if (!RAM) {
        //  ,   
        out_file = DL_FsOpenFile(dst_file, FILE_WRITE_MODE, 0);
    
        if ( out_file == FILE_INVALID ) {
                        err("out file handle is invalid", NULL);
                        /* TODO:
                                 
                               (DL_FsSeekFile)
                                ("continue")
                        */
        }
    } else {
        RAM_Create(unpack_sz);
    }
				
	if ( pack_sz == unpack_sz ) {	// no compression
						/*   ,
							    rbuf
							     4*1024 (4 )  
						*/
    	size_t		total_read = 0;
	    rbuf = (char *) malloc(ZLIB_IN_BUF_SIZE);
	    while ( total_read < pack_sz ) {		//     
			read = ZLIB_IN_BUF_SIZE;			//   
            if ( total_read + read > pack_sz )	//     , 
				read = pack_sz - total_read;	// 
			DL_FsReadFile(rbuf, 1, read, zip_file, &read);
			if (!RAM) {
                DL_FsWriteFile(rbuf, 1, read, out_file, &wr);
            } else {
                RAM_AddBlock(rbuf, read);
            }
			// TODO:     wr == read,   !
			total_read += read;
	    }
		free(rbuf);
	} else {
						/*   ,
							 2  - rbuf  wbuf
							   4*1024 (4 )  
							 wbuf   2     rbuf,    
							         rbuf  wbuf,
							   
							...
						*/
        int			err = 0;
        size_t		total_write = 0;
		z_stream	d_stream;
		rbuf = (char *) malloc(ZLIB_IN_BUF_SIZE);			// 4  8
		wbuf = (char *) malloc(ZLIB_OUT_BUF_SIZE);		//    ,   ...
															//   ,  
					
		//   ( )  zlib
		d_stream.zalloc_func	= (void *)zcalloc;
		d_stream.zfree_func		= (void *)zcfree;
		d_stream.opaque_func	= NULL;
					
		//  z_stream
		read = ZLIB_IN_BUF_SIZE;
		DL_FsReadFile(rbuf, 1, read, zip_file, &read);
		d_stream.next_in	= (BYTE *) rbuf;
		d_stream.avail_in	= read;
		err = inflateInit2(&d_stream,-MAX_WBITS);
		dbg("inflateInit2 DONE, err = %d", err);
					
		goto UnPackZIP_entry;
						
		while ( err != Z_STREAM_END && err >= 0 ) {		//  err  " "   
						//    read   
						//  ,    , inflate   
						//     ,      
            read = ZLIB_IN_BUF_SIZE;
            DL_FsReadFile(rbuf, 1, read, zip_file, &read);
						
			// using zlib's z_stream
			d_stream.next_in	= (BYTE *) rbuf;	//   
			d_stream.avail_in	= read;

	//     
	//  , ,    z_stream    
UnPackZIP_entry:
			d_stream.next_out	= (BYTE *) wbuf;
			d_stream.avail_out	= ZLIB_OUT_BUF_SIZE;
			if ( ZLIB_OUT_BUF_SIZE > unpack_sz ) {
				d_stream.avail_out	= unpack_sz;
			}
						
						//   =)
						dbg("call inflate ------------------------", NULL);
						dbg("avail_in = %d, next_in = 0x%p", d_stream.avail_in, d_stream.next_in);
						dbg("avail_out = %d, next_out = 0x%p", d_stream.avail_out, d_stream.next_out);
						err = inflate(&d_stream, Z_SYNC_FLUSH);
						dbg("inflate DONE, err = %d", err);
						dbg("avail_in = %d, total_in = %d", d_stream.avail_in, d_stream.total_in);
						dbg("avail_out = %d, total_out = %d", d_stream.avail_out, d_stream.total_out);
						
			//  DONE
			if ( err >= 0 ) {
                if (!RAM) {
                    DL_FsWriteFile(wbuf, 1, d_stream.total_out-total_write, out_file, &wr);
                } else {
                    RAM_AddBlock(wbuf, d_stream.total_out-total_write);
                }
				total_write = d_stream.total_out;
			}
						
						//      
						//      
			if ( d_stream.avail_in > 0 )		//   
			DL_FsFSeekFile(zip_file, -d_stream.avail_in, SEEK_WHENCE_CUR );
		}

        dbg("call inflateEnd", NULL);
		inflateEnd(&d_stream);		// zlib       ,
												//        d_stream
					
		free(rbuf);
		free(wbuf);
	}

    DL_FsCloseFile(out_file);
    DL_FsCloseFile(zip_file);

    return RESULT_OK;
}


BOOL RAM_AddBlock(char *buf, UINT32 size) {
    dbg("RAM_AddBlock %d b", size);
    memcpy((char*)(src+size_buf),buf,size);
    dbg("cur_pos = 0x%p", src+size_buf);
    src[size_buf+size]=0;
    size_buf += size;
    return RESULT_OK;
}

BOOL RAM_Create(UINT32 size) {
    dbg("RAM_Create %d b", size);
    src = malloc(size+1);
    return RESULT_OK;
}

void RAM_Delete() 
{
     dbg("RAM_Delete", NULL);
    free(src);
}


