#ifndef PARSER_H
#define PARSER_H


#include <apps.h>
#include "unzip.h"

extern char    *src;
extern UINT32  size_buf;

typedef enum {
    cmd_null,
    autorun,
    extreg,
    unpack,
    mkdir,
    exit
} COMMAND_ID_T;

typedef struct {
    COMMAND_ID_T   id;
    UINT8          pad[3];
    WCHAR          param1[256];
    WCHAR          param2[256];
} COMMAND_T;

typedef struct {
    WCHAR   str[64];
} STR_T;

typedef struct {
    UINT32      num; // - 
    WCHAR       dialog_name[64]; //  
    WCHAR       pad;
    STR_T       *data; //  
} DATA_LIST_T;

typedef enum {
    PARSE_CMD_NAME,
    PARSE_PARAM1,
    PARSE_PARAM2

} PARSE_MODE_T;

BOOL NextBlock(void);
BOOL ParseBlock(DATA_LIST_T *data);
COMMAND_T* ParseCommands(int number, int *num,  COMMAND_T *commands);
COMMAND_ID_T name2id(char *cmd_name);
WCHAR a2u(char c);

#endif