#include "parser.h"
#include <dbg.h>

char    *end=NULL, *begin=NULL;


BOOL NextBlock() {

    if (end == src + size_buf) return RESULT_FAIL; //  

    begin = end;
    return RESULT_OK;
}

BOOL ParseBlock(DATA_LIST_T *data) 
{
    char    *i, *j;
    int     n=0, k=0;
    char    *position;


    data->num = 0;

    if (begin == NULL) {
        //   
        begin = strstr(src, "name=");
        if (begin == NULL) return RESULT_FAIL;
    }
    
    position = begin;
    position += strlen("name=");

    end = strstr(position, "name=");
    if (end == position || end == NULL) end = src + size_buf;

    dbg("begin = 0x%p", begin);
    dbg("end = 0x%p", end);

    for (i=position; i < end; i++) {
        if (*i == ':') data->num++; //  -   
    }
    dbg("num items = %d", data->num);

    free(data->data);
    data->data = malloc(data->num*sizeof(STR_T));

    for (i=position; i < end; i++) {
        data->dialog_name[n] = a2u(*i);
        n++;
        if (*i == 0x0D) {
            data->dialog_name[n]=0; //    
            udbg("name_dialog = %s",data->dialog_name); 
            position=i;
            break;
        }
    }

    n=0;

    //   
    for (i=position; i < end; i++) {
        
        if (*i == ':') {
            dbg("item %d", n+1);
            for (j=i+1; j < end; j++) {
                if (*j == 0x0D) {
                    
                    data->data[n].str[k] = 0;
                    udbg("item_name = %s",data->data[n].str);
                    n++;
                    k=0;
                    
                    break;
                }
                data->data[n].str[k] = a2u(*j);
                k++;
            }

        }
    }
    

    return RESULT_OK;
}

//    
COMMAND_T* ParseCommands(int number, int *num, COMMAND_T *commands) {
    char *i, *j;
    int n=0, k=0, c=0;
    PARSE_MODE_T   parse_mode = PARSE_CMD_NAME; 
    char    cmd_name[32];
    


    for (i=begin; i < end; i++) { //    
        if (*i == ':') {
            n++;
            if (n == number) {
               
                while (*i != 0x0A) i++; //   

                for (j=i+1; j < end; j++) { //  - 
                    if (*j == 0x0A) c++;
                    if (*j == ':') break;
                }
                dbg("num commands = %d", c);
                *num = c;

                commands = malloc(c*sizeof(COMMAND_T)); //  
                n=0;

                for (i=i+1; i < end; i++) {

                    if (*i == ':') break; //  

                    if (*i == 0x0A) { //  
                        parse_mode = PARSE_CMD_NAME;
                        n++;
                        k = 0;
                        continue;
                    }

                    switch (parse_mode) 
                    {
                    case PARSE_CMD_NAME:
                        if (*i == ' ') {
                            cmd_name[k] = 0; //    
                            commands[n].id = name2id(cmd_name);
                            
                            dbg("command id = %d", commands[n].id);
                            parse_mode = PARSE_PARAM1;
                            k=0;
                            continue;
                        }
                        cmd_name[k] = *i;
                        k++;
                        break;

                    case PARSE_PARAM1:
                         if (commands[n].id != cmd_null && commands[n].id != exit) {
                            
                            if (*i == ' ') {
                                commands[n].param1[k] = 0;
                                udbg("param1 = %s", commands[n].param1);
                                parse_mode = PARSE_PARAM2;
                                k=0;
                                continue;
                            }
                            commands[n].param1[k] = a2u(*i);
                            commands[n].param1[k+1] = 0;
                            k++;
                         }
                        
                        break;

                    case PARSE_PARAM2:
                        if (commands[n].id != autorun && commands[n].id != mkdir && commands[n].id != exit) { //     
                            
                            if (*i == 0x0D) {
                                commands[n].param2[k] = 0;
                                udbg("param2 = %s", commands[n].param2);
                                continue;
                            }
                            commands[n].param2[k] = a2u(*i);
                            commands[n].param2[k+1] = 0;
                            k++;
                        }
                        
                        break;
                    }
                }
                break;
            }
        }
    }

 return commands;
}

COMMAND_ID_T name2id(char *cmd_name) {

    dbg("\n", NULL);
    dbg("cmd_name = %s", cmd_name);

    if (strcmp(cmd_name, "unpack") == 0) return unpack;
    if (strcmp(cmd_name, "mkdir") == 0) return mkdir;
    if (strcmp(cmd_name, "autorun") == 0) return autorun;
    if (strcmp(cmd_name, "extreg") == 0) return extreg;
    
    if (strcmp(cmd_name, "exit") == 0) return exit;

    return cmd_null;
}

WCHAR a2u(char c) {
    char str[2];
    WCHAR str2[2];

    str[0]=c;
    str[1]=0;

    u_atou(str, str2);

    return str2[0];
}
