#ifndef GUI_H
#define GUI_H

#include <apps.h>
#include <uis.h>
#include "parser.h"


/*    .      */
typedef struct
{ 
    APPLICATION_T           apt; /*   ,   */

    /*      */
    /* ... */

} APP_ELFINSTALLER_T;

/*   */
typedef enum
{
    EI_STATE_ANY, /* ANY-state   */

    EI_STATE_INIT,
    EI_STATE_MAIN,

    EI_STATE_MAX /*   */
} EI_STATES_T;

typedef enum
{
	RES_LIST_CAPTION=0,
	RES_ACTION1,
	RES_MAX
} EI_RESOURCE;



/*     */
RESOURCE_ID Resources[RES_MAX];


UINT32 Register( char* file_uri,  char* param,  UINT32 reserve );

UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 );
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app );

UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 MainStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type );

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app );
UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app );
UINT32 HandleAction( EVENT_STACK_T *ev_st,  void *app );

UINT32 InitResources( void );
UINT32 RemoveResources( void );

UINT32 SendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num);

UINT32 RunCommands(UINT32 num, COMMAND_T *commands);



#endif
