#include "GUI.h"
#include "INIparser.h"
#include <dbg.h>


DATA_LIST_T                 data;

WCHAR   uri_zip[256]; // zip 
WCHAR   ElfFolder[256]=L"/b/Elf/";

/*  .        */
const char app_name[APP_NAME_LEN] = "ElfInstaller"; 

/*     state- */

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    /* GUI-     */
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    /*   ,      UI */
    { EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};

EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { EV_DIALOG_DONE,                   destroyApp },
    { EV_REQUEST_LIST_ITEMS,        HandleListReq  },
    /* STATE_HANDLERS_RESERVED ,   - ,  
          ,      
        . LdrInitEventHandlersTbl, LdrFindEventHandlerTbl */
    { EV_SELECT,                        HandleAction },
    { EV_DONE,                          destroyApp },
    { STATE_HANDLERS_END,                     NULL },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { EI_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { EI_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },
    
    { EI_STATE_MAIN,
      MainStateEnter,
      MainStateExit,
      main_state_handlers
    }
};

/*      elfpack- */
UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T *tbl,  UINT32 *base )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].code==STATE_HANDLERS_RESERVED)	
		{
			tbl[i].code = (*base)++;
		}
		i++;
	}
	return *base;
}

UINT32 LdrFindEventHandlerTbl( EVENT_HANDLER_ENTRY_T *tbl,  EVENT_HANDLER_T *hfn )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].hfunc==hfn)	
		{
			return tbl[i].code;
		}
		i++;
	}

	return 0;
}



UINT32 util_asc2ul( const char * s, UINT32 count )
{
	char    b;
	UINT32    res = 0;
	
	while ( count > 0 ) {
		b = *s++;
		if ( b >= '0' && b <= '9' ) {
			b -= '0';
		} else if ( b >= 'A' && b <= 'F' ) {
			b = b - 'A' + 10;
		} else if ( b >= 'a' && b <= 'f' ) {
			b = b - 'a' + 10;
		} else
		b = 0;
		res = res << 4;
		res |= b;
		count--;
	}
	
	return res;
}

UINT32 param2uri(char *param, WCHAR *uri)
{
	_u64                    tmp;
	DL_FS_MID_T             fid;

	tmp.R0 = util_asc2ul(param+0, 8);
	tmp.R1 = util_asc2ul(param+8, 8);

	if (tmp.R0==0 && tmp.R1==0) {
		u_atou(param, uri);
	} else {
		memcpy(&fid, &tmp, sizeof(UINT64));
		DL_FsGetURIFromID( &fid, uri );
	}
	return RESULT_OK;
}

/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 status = RESULT_OK;
    UINT32 evcode_base=reserve;    //  reserve;
    WCHAR		    c_ini_uri[256];
    char            cElfFolder[256];
	
	//    ,   STATE_HANDLERS_RESERVED
	//LdrInitEventHandlersTbl( main_state_handlers, &evcode_base );
    

/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           EI_STATE_MAX,            //  
                           (void*)startApp );   // ,   

    if (strlen(param)) {
        
        //   
        u_atou(file_uri, c_ini_uri);
    	c_ini_uri[u_strlen(c_ini_uri)-3] = 0;
    	u_strcat(c_ini_uri, L"ini");	

        if (OpenINI(c_ini_uri) == RESULT_OK) {
    	    setSeparator('=');
    	    ReadParamINI("ElfFolder", cElfFolder, 256, "/b/Elf/");
            dbg("ElfFolder = %s", cElfFolder);
            u_atou(cElfFolder, ElfFolder);
            CloseINI();
    	}

		param2uri(param, uri_zip);
        LdrStartApp(evcode_base);   //  
	} else {
        LdrUnloadELF(&Lib);
    }
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_ELFINSTALLER_T      *app = NULL;
    UINT32                  status = RESULT_OK;
    

    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
        return RESULT_FAIL; //     

    /*     */
    app = (APP_ELFINSTALLER_T*)APP_InitAppData( (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_ELFINSTALLER_T), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );

	/*   */
	status = InitResources();
    // 
    memclr(&data, sizeof(DATA_LIST_T));

    UnpackFile(uri_zip, L"install.bat", NULL, true);
  
    status = APP_Start( ev_st,
                        &app->apt,
                        EI_STATE_INIT, //  
                        state_handling_table,
                        destroyApp,
                        app_name,
                        0 );


    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

	/*   */
	RemoveResources();
    free(data.data);
    RAM_Delete();

    /*    */
    status = APP_Exit( ev_st, app, 0 );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    main state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    UIS_DIALOG_T            dialog = 0;
	UINT32					starting_num;
    
	//ACTIONS_T				action_list; // 

	if(type!=ENTER_STATE_ENTER) return RESULT_OK;

	/*          */	
    //action_list.action[0].operation = ACTION_OP_ADD; 
	/*         STATE_HANDLERS_RESERVED,        */
    //action_list.action[0].event = LdrFindEventHandlerTbl( main_state_handlers, HandleAction ); //       
    //action_list.action[0].action_res = Resources[RES_ACTION1]; // ,  

	/*      */
    //action_list->count = 1;

    
    ParseBlock(&data); 

    //   
    DRM_SetResource( Resources[RES_LIST_CAPTION],  data.dialog_name , (u_strlen(data.dialog_name)+1)*sizeof(WCHAR) );
	dialog = UIS_CreateList( &port,
							 0,
							 data.num,
							 0,
							 &starting_num,
							 0,
							 2,
							 NULL, //action_list,
							 Resources[RES_LIST_CAPTION] );
  
   
    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;

	//   ,     starting_num 
	SendListItems(ev_st, app, 1, starting_num);

    return RESULT_OK;
}

UINT32 MainStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APP_ELFINSTALLER_T           *papp = (APP_ELFINSTALLER_T*)app;

    if ( type == EXIT_STATE_SUSPEND ) return RESULT_OK;

	APP_UtilUISDialogDelete( &papp->apt.dialog );

	return RESULT_OK;
}


UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    //    
    status = APP_HandleUITokenGranted( ev_st, app );

    //   ,   state
    if( (status == RESULT_OK) && (papp->token_status == 2) )
    {
        status = APP_UtilChangeState( EI_STATE_MAIN, ev_st, app );
    }

    return status;
}


/* -  EV_REQUEST_LIST_ITEMS -   List    
          */
UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app )
{
	APPLICATION_T			*papp = (APPLICATION_T*) app;
	EVENT_T					*event;
	UINT32					start, num;

	//      "",      
	if( !papp->focused ) return RESULT_OK;

	//      
	event = AFW_GetEv( ev_st );

	start = event->data.list_items_req.begin_idx;
	num = event->data.list_items_req.count;

	//   ,     - ,      
	APP_ConsumeEv( ev_st, app );
	
	return SendListItems( ev_st, app, start, num );
}

UINT32 HandleAction( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32 index = (AFW_GetEv(ev_st))->data.index;
    int num;
    UINT32  status;
    COMMAND_T                   *commands=NULL;

	//APP_ConsumeEv( ev_st, app );

    dbg("index = %d", index);
    commands = ParseCommands(index, &num, commands);
 
    status = RunCommands(num, commands);
    free(commands);

    if (status == RESULT_FAIL) return destroyApp(ev_st,app);

    if (NextBlock() == RESULT_OK)  { 
        APP_UtilChangeState( EI_STATE_MAIN, ev_st, app );
    } else {
        return destroyApp(ev_st,app);
    }

	return RESULT_OK;
}


/*            */
UINT32 SendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
	APPLICATION_T			*papp = (APPLICATION_T*) app;
	LIST_ENTRY_T			*plist; //    
	UINT32					i, index, status=RESULT_OK;
    
    if( num==0 ) return RESULT_FAIL; //  ,   

	plist = (LIST_ENTRY_T*) suAllocMem( sizeof(LIST_ENTRY_T)*num, NULL ); // malloc
	if( plist==NULL ) return RESULT_FAIL;

	//  
	for( index=0, i=start; (i<start+num) && (i<=data.num); i++, index++)
	{
		plist[index].editable = FALSE;			//  
		plist[index].content.static_entry.unk6 = 1;

		//        
		UIS_MakeContentFromString( "q0", &(plist[index].content.static_entry.text), data.data[i-1].str );
	}

	//       ,    
	status = APP_UtilAddEvUISListData( ev_st, app, 0,
									   start, num,
									   FBF_LEAVE,
									   sizeof(LIST_ENTRY_T)*num,
									   plist );
	if( status!=RESULT_FAIL )
	{
		//        
		status = UIS_HandleEvent(papp->dialog, ev_st);
	}

	suFreeMem(plist);

	return status;

}

/*           */
UINT32 InitResources( )
{
    RES_ACTION_LIST_ITEM_T		action;
    UINT32						status;

	const WCHAR list_caption[] = L"Welcome";

	/*     */
    status = DRM_CreateResource( &Resources[RES_LIST_CAPTION], RES_TYPE_STRING, (void*)list_caption, (u_strlen((WCHAR*)list_caption)+1)*sizeof(WCHAR) );
	if( status!=RESULT_OK ) return status;

	/*    */
    action.softkey_label = 0;			//      
    action.list_label = 0x01001B77;		//     
    action.softkey_priority = 0;
    action.list_priority = 1;			//     , ..        ,   0,     
    action.isExit = FALSE;
    action.sendDlgDone = FALSE;

    status = DRM_CreateResource( &Resources[RES_ACTION1], RES_TYPE_ACTION, (void*)&action, sizeof(RES_ACTION_LIST_ITEM_T));
	if( status!=RESULT_OK ) DRM_ClearResource( Resources[RES_LIST_CAPTION] );
    return status;
}

/*        */
UINT32 RemoveResources( )
{
	UINT32				status = RESULT_OK;
	UINT32				i;

	for(i=0;i<RES_MAX;i++)
	{
		status |= DRM_ClearResource( Resources[i] );
	}

	return status;

}


UINT32 RunCommands(UINT32 num, COMMAND_T *commands)
{
    int     i;
    UINT32  status;
    WCHAR   dst_file[256];

    dbg("\n", NULL);
    dbg("Run %d commands", num);

    for (i=0; i<num; i++) {
        dbg("commands id = %d", commands[i].id);
        switch (commands[i].id) {
        case unpack:
            u_strcpy(dst_file, ElfFolder);
            u_strcat(dst_file, commands[i].param2);
            status = UnpackFile(uri_zip, commands[i].param1, dst_file, false);
            break;

        case mkdir:
            u_strcpy(dst_file, ElfFolder);
            u_strcat(dst_file, commands[i].param1);
            DL_FsMkDir( dst_file,  0 );
            break;

        case exit:
            return RESULT_FAIL;
            break;
        }
    }

    return RESULT_OK;
}
  
