#ifndef GRAPHICS_H
#define GRAPHICS_H

#include <apps.h>


extern UIS_DIALOG_T     dialog;
extern UINT16           ENTRIES_NUM;
extern WCHAR            FolderELF[128];

typedef struct
{
	WCHAR		name[32]; //  
    WCHAR       fullname[128]; //    
} ELFINFO;

extern ELFINFO *ename;

typedef struct 
{
    UINT8   *buf;
    UINT32  size;
} PIC_T;

typedef enum
{
    PIC_SOFT_LINE=0,
    PIC_TITLE_LINE,
    PIC_PREV,
    PIC_PLAY,
    PIC_PAUSE,
    PIC_STOP,
    PIC_NEXT,
    PIC_PREV_USE,
    PIC_PLAY_USE,
    PIC_PAUSE_USE,
    PIC_STOP_USE,
    PIC_NEXT_USE,
    PIC_RND,
    PIC_REP_ONE,
    PIC_REP_ALL
} PICTURES;

#define SetFont(x) UIS_CanvasSetFont( x, dialog)
#define SetFontStyle(x) UIS_CanvasSetFontStyle( x, dialog)

UINT32 DrawLine(INT16 x1, INT16 y1, INT16 x2, INT16 y2);
UINT32 DrawRect(INT32 x, INT32 y, UINT32 w, UINT32 h);
UINT32 FillRect(INT32 x, INT32 y, UINT32 w, UINT32 h);
UINT32 SetFillColor(UINT32 color);
UINT32 SetForegroundColor(UINT32);
UINT32 SetBackgroundColor(UINT32 color);
UINT32 DrawText(WCHAR *str, INT32 x, INT32 y, UINT16 anchor);
UINT32 DrawImageId( UINT32 n, INT16 x, INT16 y, UINT16 anchor);
UINT32 StartAnimationId( UINT32 n, INT16 x, INT16 y, UINT16 anchor);
UINT32 StopAnimationId( void );
GRAPHIC_POINT_T GetImageIdSize( UINT32 n);

UINT32 DrawSoftKey(WCHAR *str, UINT8 type, BOOL pressed);
UINT32 DrawTitleBar(WCHAR *title);
UINT32 DrawScrollBar(UINT32 num, INT32 cur);

UINT32 LoadPic(void);
UINT32 FreeMemPic(void);

void uPFprintf(char* format, WCHAR* s1);

#endif
