#include "Graphics.h"

PIC_T   *pictures=NULL;
PIC_T   DEF_PIC; 

CANVAS_IMAGE_HANDLE_T ani_image_handle;


UINT32 DrawLine(INT16 x1, INT16 y1, INT16 x2, INT16 y2)
{
    GRAPHIC_POINT_T begin;
    GRAPHIC_POINT_T end;

    begin.x = x1;
    begin.y = y1;
    end.x = x2;
    end.y = y2;

    UIS_CanvasDrawLine(begin, end, dialog);

    return RESULT_OK;
}

UINT32 DrawRect(INT32 x, INT32 y, UINT32 w, UINT32 h) // 
{
    GRAPHIC_REGION_T        region;

    region.ulc.x = x;
    region.ulc.y = y;
    region.lrc.x = x+w;
    region.lrc.y = y+h;

    UIS_CanvasDrawRect(region, 0, dialog);

    return RESULT_OK;
}


UINT32 FillRect(INT32 x, INT32 y, UINT32 w, UINT32 h) //   
{
    GRAPHIC_REGION_T        region;

    region.ulc.x = x;
    region.ulc.y = y;
    region.lrc.x = x+w;
    region.lrc.y = y+h;

    UIS_CanvasFillRect(region, dialog);

    return RESULT_OK;
}


UINT32 SetFillColor(UINT32 color) //   	
{
    COLOR_T                 colorx;

    colorx.red = (color & 0xFF000000) >> 24;
    colorx.green = (color & 0x00FF0000) >> 16;
    colorx.blue = (color & 0x0000FF00) >> 8;
    colorx.transparent = color & 0x000000FF;

    UIS_CanvasSetFillColor(colorx);

    return RESULT_OK;
}

UINT32 SetForegroundColor(UINT32 color) //    , ...
{
    COLOR_T                 colorx;

    colorx.red = (color & 0xFF000000) >> 24;
    colorx.green = (color & 0x00FF0000) >> 16;
    colorx.blue = (color & 0x0000FF00) >> 8;
    colorx.transparent = color & 0xFF;

    UIS_CanvasSetForegroundColor(colorx);

    return RESULT_OK;
}

UINT32 SetBackgroundColor(UINT32 color) //    
{
    COLOR_T                 colorx;

    colorx.red = (color & 0xFF000000) >> 24;
    colorx.green = (color & 0x00FF0000) >> 16;
    colorx.blue = (color & 0x0000FF00) >> 8;
    colorx.transparent = color & 0xFF;

    UIS_CanvasSetBackgroundColor(colorx);

    return RESULT_OK;
}


UINT32 DrawText(WCHAR *str, INT32 x, INT32 y, UINT16 anchor)
{
    GRAPHIC_POINT_T anchor_point;


    anchor_point.x = x;
    anchor_point.y = y;


    UIS_CanvasDrawColorText (str,
							 0,
							 (UINT16)u_strlen(str),  	//  
							 anchor_point,              //   
							 anchor,	    //   . : ANCHOR_LEFT | ANCHOR_TOP
							 dialog);
    return RESULT_OK;
}



UINT32 DrawImageId( UINT32 n, INT16 x, INT16 y, UINT16 anchor)
{
    PICTURE_TYPE_UNION_T picture_data;
    GRAPHIC_POINT_T anchor_point;

    CANVAS_IMAGE_HANDLE_T image_handle;
    GRAPHIC_POINT_T image_size;
    GRAPHIC_REGION_T image_region;



    picture_data.PointerValue.resourcePicturePointerValue = pictures[n].buf;
    picture_data.PointerValue.imageSize = pictures[n].size;

    anchor_point.x = x;
    anchor_point.y = y;

    image_handle = UIS_CanvasOpenImageAndGetSize(STORED_IN_MEMORY_TYPE,
								  picture_data,
								  &image_size);	



    UIS_CanvasSetImageAttribute(image_handle,
                                IA_OBEY_TRANSPARENCY,
							    NULL);



    UIS_CanvasRenderImageToBuffer(image_handle,
                                  image_size,
                                  anchor_point,
                                  anchor,
                                  &image_region,
                                  Copy,
                                  dialog);


    UIS_CanvasCloseImage(image_handle);


    return RESULT_OK;
}


UINT32 StartAnimationId( UINT32 n, INT16 x, INT16 y, UINT16 anchor)
{
     PICTURE_TYPE_UNION_T picture_data;
    GRAPHIC_POINT_T anchor_point;

    
    GRAPHIC_POINT_T image_size;
    GRAPHIC_REGION_T image_region;

    if (pictures[n].buf == NULL) return RESULT_FAIL;

    picture_data.PointerValue.resourcePicturePointerValue = pictures[n].buf;
    picture_data.PointerValue.imageSize = pictures[n].size;

    anchor_point.x = x;
    anchor_point.y = y;

    ani_image_handle = UIS_CanvasOpenImageAndGetSize(STORED_IN_MEMORY_TYPE,
								  picture_data,
								  &image_size);	

    UIS_CanvasSetImageAttribute(ani_image_handle,
                                IA_OBEY_TRANSPARENCY,
							    NULL);

    UIS_CanvasRenderImageToBuffer(ani_image_handle,
                                  image_size,
                                  anchor_point,
                                  anchor,
                                  &image_region,
                                  Copy,
                                  dialog);


    UIS_CanvasIsImageAnimated(ani_image_handle);		

    return RESULT_OK;
}

UINT32 StopAnimationId(void ) 
{
    //if (pictures[n].buf == NULL) return RESULT_FAIL;

    UIS_CanvasPauseAnimation(ani_image_handle);
    UIS_CanvasCloseImage(ani_image_handle);
    return RESULT_OK;
}


GRAPHIC_POINT_T GetImageIdSize( UINT32 n)
{
    PICTURE_TYPE_UNION_T picture_data;
    GRAPHIC_POINT_T img_size;


    picture_data.PointerValue.resourcePicturePointerValue = pictures[n].buf;
    picture_data.PointerValue.imageSize = pictures[n].size;


    img_size = UIS_CanvasGetImageSize(STORED_IN_MEMORY_TYPE, picture_data);

    return img_size;
}

UINT32 DrawSoftKey(WCHAR *str, UINT8 type, BOOL pressed)
{
     UIS_CanvasDrawColorSoftkey(str, type, // 0 - menu, 1 - left, 2 - right
                                pressed,       
                                false, 
								dialog);

     return RESULT_OK;
}

UINT32 DrawTitleBar(WCHAR *title)
{
           UIS_CanvasDrawTitleBar(title, 
                            false,  
                            1, 
                            false, 
                            true,  
                            dialog);

     return RESULT_OK;
}

UINT32 DrawScrollBar(UINT32 num, INT32 cur)
{
    UIS_CanvasDrawColorScrollBar(num, 
                                  (num < 9) ? num : 9,
                                  cur-1, 
                                  false, // = false
                                 dialog);
    return RESULT_OK;
}


UINT32 LoadPic()
{
    UINT32          n=0; // - 
	UINT32          readen;
	FILE_HANDLE_T   f;

    WCHAR pic_name[256];

    u_strcpy(pic_name, FolderELF);
    u_strcat(pic_name, L"ElfRunner.gif");

    if (DL_FsFFileExist(pic_name)) {
       f = DL_FsOpenFile(pic_name, FILE_READ_MODE, 0);
       DEF_PIC.size = DL_FsGetFileSize(f);
       DEF_PIC.buf = malloc(DEF_PIC.size);
       DL_FsReadFile( DEF_PIC.buf, DEF_PIC.size, 1, f, &readen );
       DL_FsCloseFile(f);
    } else {
        DEF_PIC.buf = NULL;
        DEF_PIC.size = 0;
    }


    pictures = malloc(ENTRIES_NUM*sizeof(PIC_T));

    for (n=0; n < ENTRIES_NUM; n++)
    {
        u_strcpy(pic_name, L"file:/");
        u_strcat(pic_name, ename[n].fullname);
        pic_name[u_strlen(pic_name)-3] = 0;
        u_strcat(pic_name, L"gif");


        
        //    
        if (DL_FsFFileExist(pic_name)) //    
        {
            f = DL_FsOpenFile(pic_name, FILE_READ_MODE, 0);
            pictures[n].size = DL_FsGetFileSize(f);
            pictures[n].buf = malloc(pictures[n].size);
            DL_FsReadFile( pictures[n].buf, pictures[n].size, 1, f, &readen );
            DL_FsCloseFile(f);
        } 
        else 
        {
            pictures[n].size = DEF_PIC.size;
            pictures[n].buf = DEF_PIC.buf;
        }
    }
   

    return RESULT_OK;
}

UINT32 FreeMemPic()
{
    int n;


    for (n=0; n < ENTRIES_NUM; n++)
    {
       if (pictures[n].buf != DEF_PIC.buf) free(pictures[n].buf);
    }

    free(DEF_PIC.buf);
    free(pictures);

    return RESULT_OK;
}

void uPFprintf(char* format, WCHAR* s1) 
{
	char* t = suAllocMem(u_strlen(s1)+1, NULL);
	u_utoa(s1, t);
	PFprintf(format, t);
	suFreeMem(t);
}
