#ifndef ELFRUNNER_H
#define ELFRUNNER_H


#include <apps.h>
#include "Graphics.h"


//#define AUTORUN L"file://c/auto.run"
//#define FOLDER_ELFS L"file://c/mobile/mixedmedia/"

#define AUTORUN L"file://b/Elf/Auto.run"


#define DRMRES_FOLDER		0x120000CE
#define DRMRES_SELECTED		0x120000CC

/* MENU ICONS */

#define ICON_SIZE           48
#define BETWEEN_ICONS       3

#define COLUMN1         10
#define COLUMN2         COLUMN1+ICON_SIZE+BETWEEN_ICONS 
#define COLUMN3         COLUMN2+ICON_SIZE+BETWEEN_ICONS 

#define LINE1           42
#define LINE2           LINE1+ICON_SIZE+BETWEEN_ICONS 
#define LINE3           LINE2+ICON_SIZE+BETWEEN_ICONS 

/**************/

#define MENU_NUM        2
#define ITEMS_NUM       4
#define LISTS_NUM       5

typedef struct
{
    UINT32 color_background;
    UINT32 color_select;
    UINT32 color_mark;
    UINT32 evcode_start;
} SETTING_T;

typedef struct
{ 
	WCHAR		name[64]; //  
    UINT16      attrib;
    BOOL        selected; 
} FILEINFO;

typedef struct
{ 
	WCHAR		name[32]; //  
} RUNLISTINFO;


typedef struct
{ 
    APPLICATION_T           apt; /*   ,   */
  
    /*      */
    /* ... */

} APP_ELFRUNNER_T;

/*   */
typedef enum
{
    ER_STATE_ANY, /* ANY-state   */

    ER_STATE_INIT,
    ER_STATE_INSTALLED,
    ER_STATE_MENU,
    ER_STATE_ITEMS,
    ER_STATE_LISTS,
    ER_STATE_ALL,
    ER_STATE_AUTORUN,
    ER_STATE_EDIT,  // new runlist
    ER_STATE_EDIT2, // rename elf
    ER_STATE_EDIT3, // rename runlist

    ER_STATE_MAX /*   */
} ER_STATES_T;


typedef enum  // 
{
	RES_LIST_CAPTION=0,
    RES_EDIT_CAPTION,
    RES_EDIT_CAPTION2,
    RES_EDIT_CAPTION3,
    RES_ACTION4_CAPTION,
    RES_ACTION5_CAPTION,
    RES_ELFICON,
    RES_ACTION0, // 
    RES_ACTION1, //  
    RES_ACTION2, // 
    RES_ACTION3, // 
    RES_ACTION4, //   Auto.run
    RES_ACTION5, //  Auto.run
	RES_MAX
} ER_RESOURCE; 

typedef enum
{
    LNG_AUTORUN = 0,
    LNG_ADD_AUTORUN,
    LNG_CAPTION_EDITOR,
    LNG_CAPTION_EDITOR2,
    LNG_MENU,
    LNG_ITEMS,
    LNG_LISTS,
    LNG_SELECT,
    LNG_PASTE,
    LNG_NEXT,
    LNG_PREV,

    LNG_MAX

} LNG_RESOOURCE;



/*     */
RESOURCE_ID Resources[RES_MAX];

UINT32 Register( char* file_uri,  char* param,  UINT32 reserve );

UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 );
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app );

UINT32 InstalledStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 InstalledStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type );

WCHAR* GetNameRunlist(WCHAR *InstallFile);
UINT32 NewRunlist(WCHAR *name);
UINT32 DeleteRunlist(void);
UINT32 RenameRunlist(WCHAR *name);

UINT32 Installed_Delete(UINT32 item);
UINT32 Installed_Install(WCHAR *name, WCHAR *fullname);
UINT32 Installed_Copy(UINT32 item);
UINT32 Installed_Paste(UINT32 item);

UINT32 MenuStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 ItemsStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 ListsStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 MenuStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type );

UINT32 AllStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 AllStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type );
UINT32 AutorunStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 AutorunStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type );

UINT32 EditStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 Edit2StateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 Edit3StateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 EditStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type );
UINT32 EditOk( EVENT_STACK_T *ev_st,  void *app );
UINT32 EditExit( EVENT_STACK_T *ev_st,  void *app );
UINT32 EditData( EVENT_STACK_T *ev_st,  void *app );
UINT32 Edit2Data( EVENT_STACK_T *ev_st,  void *app );
UINT32 Edit3Data( EVENT_STACK_T *ev_st,  void *app );

UINT32 SendListItems_Installed( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num);
UINT32 SendListItems_Menu( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num);
UINT32 SendListItems_Items( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num);
UINT32 SendListItems_Lists( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num);
UINT32 SendListItems_All( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num);
UINT32 SendListItems_Autorun( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num);


UINT32 Update( EVENT_STACK_T *ev_st,  void *app, UINT32 sItem );

UINT32 Navigate (EVENT_STACK_T *ev_st,  void *app );

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app );
UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app );

UINT32 InitResources( void );
UINT32 RemoveResources( void );

UINT32 SelectItem( EVENT_STACK_T *ev_st,  void *app);

UINT32 Action( EVENT_STACK_T *ev_st,  void *app );
UINT32 Del_Action( EVENT_STACK_T *ev_st,  void *app );
UINT32 Run_Action( EVENT_STACK_T *ev_st,  void *app );
UINT32 Back( EVENT_STACK_T *ev_st,  void *app );
UINT32 AddAutorun_Action( EVENT_STACK_T *ev_st,  void *app );
UINT32 Autorun_Action( EVENT_STACK_T *ev_st,  void *app );

UINT32 FindRunLists(void);
UINT32 FindELFs(void);
UINT32 ReadELFs(void); //    
UINT32 ReadAutorun(void); //   Auto.run
UINT32 Fullname2Name(void);
UINT32 ReadLngRes(WCHAR *LngResFile); //    

UINT32 AddAutorun(WCHAR *name); //    Auto.run
UINT32 Install(WCHAR *name); //     

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app );

UINT32 Keypress( EVENT_STACK_T *ev_st,  void *app );
UINT32 Keyrelease( EVENT_STACK_T *ev_st,  void *app );

UINT32 paint_select(void);
UINT32 paint_clear(UINT32 index);
UINT32 paint(void);
GRAPHIC_POINT_T  XY(UINT32 sItem);
UINT8 getColumn(UINT16 sItem);
UINT32 getNumFrame(UINT32 index);

UINT32 SaveSetting(void);
UINT32 ReadSetting(void);

UINT32 FindFile( WCHAR *folder, WCHAR *filtr ); //  

UINT32 AddShortcut( EVENT_STACK_T *ev_st,  void *app );

WCHAR* SplitPath( WCHAR* path, WCHAR* spliter );
UINT32 GetResourceString(WCHAR *str, RESOURCE_ID resID);
UINT32 ClearBuf(WCHAR *buf, UINT32 size);

#endif
