#include "ELFrunner.h"
#include <dbg.h>


//  
const UINT32 ELFICON[] = { 0x47494638, 0x39610F00, 0x0F00F7E0, 0x00FFFFFF, 0xFFFFCCFF, 0xFF99FFFF, 0x66FFFF33, 0xFFFF00FF, 0xCCFFFFCC, 0xCCFFCC99, 0xFFCC66FF, 0xCC33FFCC, 0x00FF99FF, 0xFF99CCFF,
                           0x9999FF99, 0x66FF9933, 0xFF9900FF, 0x66FFFF66, 0xCCFF6699, 0xFF6666FF, 0x6633FF66, 0x00FF33FF, 0xFF33CCFF, 0x3399FF33, 0x66FF3333, 0xFF3300FF, 0x00FFFF00, 0xCCFF0099,
                           0xFF0066FF, 0x0033FF00, 0x00CCFFFF, 0xCCFFCCCC, 0xFF99CCFF, 0x66CCFF33, 0xCCFF00CC, 0xCCFFCCCC, 0xCCCCCC99, 0xCCCC66CC, 0xCC33CCCC, 0x00CC99FF, 0xCC99CCCC, 0x9999CC99, 
                           0x66CC9933, 0xCC9900CC, 0x66FFCC66, 0xCCCC6699, 0xCC6666CC, 0x6633CC66, 0x00CC33FF, 0xCC33CCCC, 0x3399CC33, 0x66CC3333, 0xCC3300CC, 0x00FFCC00, 0xCCCC0099, 0xCC0066CC,
                           0x0033CC00, 0x0099FFFF, 0x99FFCC99, 0xFF9999FF, 0x6699FF33, 0x99FF0099, 0xCCFF99CC, 0xCC99CC99, 0x99CC6699, 0xCC3399CC, 0x009999FF, 0x9999CC99, 0x99999999, 0x66999933,
                           0x99990099, 0x66FF9966, 0xCC996699, 0x99666699, 0x66339966, 0x009933FF, 0x9933CC99, 0x33999933, 0x66993333, 0x99330099, 0x00FF9900, 0xCC990099, 0x99006699, 0x00339900,
                           0x0066FFFF, 0x66FFCC66, 0xFF9966FF, 0x6666FF33, 0x66FF0066, 0xCCFF66CC, 0xCC66CC99, 0x66CC6666, 0xCC3366CC, 0x006699FF, 0x6699CC66, 0x99996699, 0x66669933, 0x66990066,
                           0x66FF6666, 0xCC666699, 0x66666666, 0x66336666, 0x006633FF, 0x6633CC66, 0x33996633, 0x66663333, 0x66330066, 0x00FF6600, 0xCC660099, 0x66006666, 0x00336600, 0x0033FFFF,
                           0x33FFCC33, 0xFF9933FF, 0x6633FF33, 0x33FF0033, 0xCCFF33CC, 0xCC33CC99, 0x33CC6633, 0xCC3333CC, 0x003399FF, 0x3399CC33, 0x99993399, 0x66339933, 0x33990033, 0x66FF3366,
                           0xCC336699, 0x33666633, 0x66333366, 0x003333FF, 0x3333CC33, 0x33993333, 0x66333333, 0x33330033, 0x00FF3300, 0xCC330099, 0x33006633, 0x00333300, 0x0000FFFF, 0x00FFCC00,
                           0xFF9900FF, 0x6600FF33, 0x00FF0000, 0xCCFF00CC, 0xCC00CC99, 0x00CC6600, 0xCC3300CC, 0x000099FF, 0x0099CC00, 0x99990099, 0x66009933, 0x00990000, 0x66FF0066, 0xCC006699,
                           0x00666600, 0x66330066, 0x000033FF, 0x0033CC00, 0x33990033, 0x66003333, 0x00330000, 0x00FF0000, 0xCC000099, 0x00006600, 0x00330000, 0x0064D7F4, 0x7ADDF68B, 0xE6FDA9EC, 
                           0xFDBAF1FF, 0xC9F3FDDA, 0xF5FCEAF9, 0xFDFFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
                           0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0021F904,
                           0x010000E0, 0x002C0000, 0x00000F00, 0x0F000008, 0x7200B361, 0x1B38309B, 0xB66DDC12, 0x76F3F64D, 0xA0B487D8, 0x0C6E9BC8, 0x6D61436C, 0xD2081AD4, 0x76B0A237, 0x6F0E2166, 
                           0x1BD9B19B, 0x4987040B, 0x764CC82D, 0x64C68C12, 0x274E1498, 0x1226C79B, 0xDA46EAC4, 0x1851A74E, 0x9C285316, 0x94991323, 0xC4873013, 0x6E2B5A53, 0x63376E4B, 0x7DBA8CF8,
                           0x7429509E, 0x05ABCA8C, 0xCA53E753, 0x96509946, 0xE4181000, 0x3B000000 
                          };

//  
WCHAR LngRes[LNG_MAX][32];

SETTING_T Setting;

UIS_DIALOG_T            dialog;
DRAWING_BUFFER_T		bufd; //   

FILEINFO                *fname=NULL;
ELFINFO                 *ename=NULL;
RUNLISTINFO             *run_list=NULL;

UINT16 id_run_list=0;
UINT16 count_run_list=0;


WCHAR  FolderELF[128]; //  
WCHAR  cur_folder[256]; //  

UINT32                  buf_item=0; 
INT32                   sel_item=1; //   
UINT16                  ENTRIES_NUM = 0;	// - 


/*  .        */
const char app_name[APP_NAME_LEN] = "ElfRunner"; 

/*     state- */

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    /* GUI-     */
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    /*   ,      UI */
    { EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};

 EVENT_HANDLER_ENTRY_T installed_state_handlers[] =
{
    { EV_DIALOG_DONE,                      destroyApp },
    { EV_LOSE_FOCUS,                       destroyApp },

    { EV_SELECT, 					       SelectItem },
    { EV_INK_KEY_PRESS,                      Keypress },
    { EV_INK_KEY_RELEASE,                  Keyrelease },
    { EV_TIMER_EXPIRED,       	                Timer },
    

    { STATE_HANDLERS_END,                        NULL },
};

 EVENT_HANDLER_ENTRY_T menu_state_handlers[] =
{
    { EV_DIALOG_DONE,                   destroyApp },
    { EV_REQUEST_LIST_ITEMS,         HandleListReq },
    //{ EV_LIST_NAVIGATE,					  Navigate },

    { EV_SELECT, 					    SelectItem },
    { EV_DONE,                          Back },
    
    { STATE_HANDLERS_END,                     NULL },
};


 EVENT_HANDLER_ENTRY_T all_state_handlers[] =
{
    { EV_DIALOG_DONE,                   destroyApp },
    { EV_REQUEST_LIST_ITEMS,         HandleListReq },
    { EV_LIST_NAVIGATE,					  Navigate },
    /* STATE_HANDLERS_RESERVED ,   - ,  
          ,      
        . LdrInitEventHandlersTbl, LdrFindEventHandlerTbl */

    //{ STATE_HANDLERS_RESERVED,          Del_Action }, // 
    { STATE_HANDLERS_RESERVED,          Run_Action },
    { STATE_HANDLERS_RESERVED,   AddAutorun_Action },
    { EV_SELECT, 					    SelectItem },
    { EV_DONE,                                Back },
    { EV_CREATE_SHORTCUT,              AddShortcut },

    { STATE_HANDLERS_END,                     NULL },
};

 EVENT_HANDLER_ENTRY_T autorun_state_handlers[] =
{
    { EV_DIALOG_DONE,                   destroyApp },
    { EV_REQUEST_LIST_ITEMS,         HandleListReq },
    { EV_LIST_NAVIGATE,					  Navigate },
    /* STATE_HANDLERS_RESERVED ,   - ,  
          ,      
        . LdrInitEventHandlersTbl, LdrFindEventHandlerTbl */

    { STATE_HANDLERS_RESERVED,          Del_Action }, // 

    { EV_SELECT, 					    SelectItem },
    { EV_DONE,                                Back },

    { STATE_HANDLERS_END,                     NULL },
};

const EVENT_HANDLER_ENTRY_T edit_state_handlers[] =
{
    { EV_DATA,                               	 EditData  },
    { EV_DONE,                       		       EditOk  },
	{ EV_CANCEL,                 				 EditExit  },
    { STATE_HANDLERS_END,                             NULL },
};

const EVENT_HANDLER_ENTRY_T edit2_state_handlers[] =
{
    { EV_DATA,                                  Edit2Data  },
    { EV_DONE,                       		       EditOk  },
	{ EV_CANCEL,                 				 EditExit  },
    { STATE_HANDLERS_END,                             NULL },
};

const EVENT_HANDLER_ENTRY_T edit3_state_handlers[] =
{
    { EV_DATA,                                  Edit3Data  },
    { EV_DONE,                       		       EditOk  },
	{ EV_CANCEL,                 				 EditExit  },
    { STATE_HANDLERS_END,                             NULL },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { ER_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { ER_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },
    
    { ER_STATE_INSTALLED,
      InstalledStateEnter,
      InstalledStateExit,
      installed_state_handlers
    },


    { ER_STATE_MENU,
      MenuStateEnter,
      MenuStateExit,
      menu_state_handlers
    },

    { ER_STATE_ITEMS,
      ItemsStateEnter,
      MenuStateExit,
      menu_state_handlers
    },

    { ER_STATE_LISTS,
      ListsStateEnter,
      MenuStateExit,
      menu_state_handlers
    },

    { ER_STATE_ALL,
      AllStateEnter,
      AllStateExit,
      all_state_handlers
    },

    { ER_STATE_AUTORUN,
      AutorunStateEnter,
      AutorunStateExit,
      autorun_state_handlers
    },

    { ER_STATE_EDIT,
      EditStateEnter,
      EditStateExit,
      edit_state_handlers
    },

    { ER_STATE_EDIT2,
      Edit2StateEnter,
      EditStateExit,
      edit2_state_handlers
    },

    { ER_STATE_EDIT3,
      Edit3StateEnter,
      EditStateExit,
      edit3_state_handlers
    }
};

/*      elfpack- */
UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T *tbl,  UINT32 *base )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].code==STATE_HANDLERS_RESERVED)	
		{
			tbl[i].code = (*base)++;
		}
		i++;
	}
	return *base;
}

UINT32 LdrFindEventHandlerTbl( EVENT_HANDLER_ENTRY_T *tbl,  EVENT_HANDLER_T *hfn )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].hfunc==hfn)	
		{
			return tbl[i].code;
		}
		i++;
	}

	return 0;
}


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    /*       ""  */
    UINT32              evcode_base=reserve;

    UINT32 status = RESULT_OK;
    char buf[128];
    WCHAR LngResFile[128]; //   
    UINT16 i, j;
	
    //evcode_base = reserve;    //  reserve
	//    ,   STATE_HANDLERS_RESERVED
	LdrInitEventHandlersTbl( installed_state_handlers, &evcode_base );
    LdrInitEventHandlersTbl( all_state_handlers, &evcode_base );
    LdrInitEventHandlersTbl( autorun_state_handlers, &evcode_base );

       //   
        for (i=strlen(file_uri)-1; i > 0 ; i--)
			if (file_uri[i] == '/') break;
		
		for (j=0; j <= i ; j++)
			buf[j] = file_uri[j];
		buf[j] = 0;
		u_atou(buf, FolderELF); 

    ReadSetting();

   /*   */
    status = APP_Register( &Setting.evcode_start,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           ER_STATE_MAX,            //  
                           (void*)startApp );       // ,   



        


        //   
		for (i=0; i < strlen(file_uri)-3; i++)
			buf[i] = file_uri[i];
        buf[i] = 0;
        u_atou(buf, LngResFile);
        u_strcat(LngResFile, L"lng"); 

        ReadLngRes(LngResFile);
        
        

    //LdrStartApp(evcode_base);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_ELFRUNNER_T     *app = NULL;
    UINT32 status = RESULT_OK;
    


    /*     */
    app = (APP_ELFRUNNER_T*)APP_InitAppData( (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_ELFRUNNER_T), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );

    FindRunLists();
	/*   */
	status = InitResources();


    status = APP_Start( ev_st,
                        &app->apt,
                        ER_STATE_INIT, //  
                        state_handling_table,
                        destroyApp,
                        app_name,
                        0 );

    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;
    APPLICATION_T           *papp = (APPLICATION_T*) app;

    StopAnimationId();

    SaveSetting(); //  
    buf_item = 0;

	/*   */
	RemoveResources();

    free(ename);
    free(fname);
    free(run_list);

    APP_UtilUISDialogDelete(  &papp->dialog ); //   

    /*    */
    status = APP_Exit( ev_st, app, 0 );

    /*   */
    //LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    main state */
UINT32 InstalledStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;

    GRAPHIC_POINT_T         display_size;   
    

    if(type!=ENTER_STATE_ENTER) return RESULT_OK;

    udbg("ELF folder = %s\n", FolderELF);

    
    FindRunLists();
    ReadELFs();
    LoadPic();
	
      display_size = UIS_CanvasGetDisplaySize();

      bufd.w = display_size.x+1;
      bufd.h = display_size.y+1;
      bufd.buf = NULL;// malloc(176*220*2);
		
	dialog = UIS_CreateColorCanvas ( &port, &bufd, false ); //  

    if(dialog == 0) return RESULT_FAIL;
    papp->dialog = dialog;

    paint();
    paint_select();

    DrawTitleBar(run_list[id_run_list].name);
    APP_UtilStartTimer( 2000,  1,  app );


    return RESULT_OK;
}

UINT32 InstalledStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

    if ( type == EXIT_STATE_SUSPEND )
      return RESULT_OK;

    dbg("Exit installed state!", NULL);
    StopAnimationId();
    FreeMemPic();
    //free(ename);
	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}

//    
WCHAR* GetNameRunlist(WCHAR *InstallFile)
{
    u_strcpy(InstallFile, FolderELF);
    u_strcat(InstallFile, run_list[id_run_list].name);
    u_strcat(InstallFile, L".rlt");

    udbg("InstallFile = %s\n", InstallFile);

    return InstallFile;
}

UINT32 NewRunlist(WCHAR *name)
{
    WCHAR           newRunList[128];
    FILE_HANDLE_T   f;
    //UINT8           buffer=0;
    //UINT32          written;

    dbg("New Runlist", NULL);

    u_strcpy(newRunList, FolderELF);
    u_strcat(newRunList, name);
    u_strcat(newRunList, L".rlt");

    udbg("newRunList = %s\n", newRunList);

    f = DL_FsOpenFile(newRunList, FILE_WRITE_EXIST_MODE, 0);
    //DL_FsWriteFile( &buffer, 1, 1, f, &written);
    DL_FsCloseFile(f);   

    dbg("Runlist create!", NULL);
        
    FindRunLists();

        
    
        for (id_run_list=0; id_run_list < count_run_list; id_run_list++) {
            if (!u_strcmp(run_list[id_run_list].name, name))  break;
        }

        if (id_run_list == count_run_list) id_run_list=0;

        dbg("id_run_list = %d", id_run_list);

    return RESULT_OK;
}

UINT32 RenameRunlist(WCHAR *name)
{
    WCHAR           newRunList[128];
    WCHAR           InstallFile[128];

    GetNameRunlist(InstallFile);

    u_strcpy(newRunList, FolderELF);
    u_strcat(newRunList, name);
    u_strcat(newRunList, L".rlt");

    DL_FsSRenameFile( InstallFile,  newRunList,  0 );
  
    FindRunLists();

        id_run_list=0;
    
        for (id_run_list=0; id_run_list < count_run_list; id_run_list++) {
            if (!u_strcmp(run_list[id_run_list].name, name))  break;
        }

    return RESULT_OK;
}

UINT32 DeleteRunlist()
{
    WCHAR           InstallFile[128];

    GetNameRunlist(InstallFile);
    DL_FsDeleteFile( InstallFile,  0 );
    id_run_list = 0;

    return RESULT_OK;
}

//     
UINT32 Installed_Install(WCHAR *name, WCHAR *fullname)
{
	UINT32	        written;
	FILE_HANDLE_T	f;
    WCHAR           InstallFile[128];
    UINT16          j,k;
    WCHAR           elfname[32];


    GetNameRunlist(InstallFile);

    f = DL_FsOpenFile(InstallFile, FILE_APPEND_PLUS_MODE, 0);

    if (name == NULL) {
         for (j=u_strlen(fullname)-1; fullname[j] != '/' && j > 0; j--);
         j++;
         for (k=j; k < u_strlen(fullname)-4 && k-j < 32; k++)
             elfname[k-j] = fullname[k];
         elfname[k-j] = 0;

         ClearBuf(elfname, 32);
         DL_FsWriteFile(elfname, 64, 1, f, &written );
    } else {
        ClearBuf(name, 32);
        DL_FsWriteFile(name, 64, 1, f, &written );
    }
    ClearBuf(fullname, 128);
	DL_FsWriteFile(fullname, 256, 1, f, &written );
	DL_FsCloseFile(f);
	
	return RESULT_OK;
} 

//     
UINT32 Installed_Delete(UINT32 item)
{
    UINT32          i, index=item;
    WCHAR           InstallFile[128];

    GetNameRunlist(InstallFile);
    DL_FsDeleteFile( InstallFile,  0 );
        
        if (ENTRIES_NUM > 1)
        {
            for (i=0; i < ENTRIES_NUM; i++)
                if (i != item-1) Installed_Install(ename[i].name, ename[i].fullname);
            //ReadELFs();
        }
        else
        {
           ENTRIES_NUM=0;
        }


    if (index > 1) {
        index--;
    } else {
        index=1;
    }

    return index;
}

//     
UINT32 Installed_Rename(UINT32 item, WCHAR *new_name)
{
    UINT32          i;
    WCHAR           InstallFile[128];

    GetNameRunlist(InstallFile);
    DL_FsDeleteFile( InstallFile,  0 );

    u_strcpy(ename[item-1].name, new_name);
        
            for (i=0; i < ENTRIES_NUM; i++)
                 Installed_Install(ename[i].name, ename[i].fullname);

            //ReadELFs();

   return RESULT_OK;
}

UINT32 Installed_Copy(UINT32 item)
{
    if (item <= ENTRIES_NUM && item != 0) {
        buf_item = item;
    } else {
        buf_item = 0;
        return RESULT_FAIL;
    }
    
    return RESULT_OK;
}

UINT32 Installed_Paste(UINT32 item)
{
    UINT32          i, index;
    WCHAR           InstallFile[128];

    GetNameRunlist(InstallFile);
    DL_FsDeleteFile( InstallFile,  0 );

    if (buf_item > ENTRIES_NUM && buf_item != 0) return RESULT_FAIL;

    if (buf_item < item) {
        index = item;
     } else {
        index = item-1;
    }

    for (i=0; i < index; i++)
            if (i != buf_item-1) Installed_Install(ename[i].name, ename[i].fullname);

    Installed_Install(ename[buf_item-1].name, ename[buf_item-1].fullname);
        
    for (i=index; i < ENTRIES_NUM; i++)
        if (i != buf_item-1) Installed_Install(ename[i].name, ename[i].fullname);


    buf_item = 0;

    return RESULT_OK;
}

UINT32 MenuStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    UIS_DIALOG_T            dialog = 0;
	UINT32					starting_num;


    if(type!=ENTER_STATE_ENTER) return RESULT_OK;
  

    DRM_SetResource( Resources[RES_LIST_CAPTION], (void*)LngRes[LNG_MENU], (u_strlen(LngRes[LNG_MENU])+1)*sizeof(WCHAR) );


	dialog = UIS_CreateList( &port,
							 0,
							 MENU_NUM,
							 0,
							 &starting_num,
							 0,
							 2,
							 NULL,
							 Resources[RES_LIST_CAPTION] ); 

 
    
    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;

    SendListItems_Menu( ev_st, app, 1, starting_num );

    return RESULT_OK;
}

UINT32 ItemsStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    UIS_DIALOG_T            dialog = 0;
	UINT32					starting_num;


    if(type!=ENTER_STATE_ENTER) return RESULT_OK;
   

    DRM_SetResource( Resources[RES_LIST_CAPTION],  (void*)LngRes[LNG_ITEMS], (u_strlen(LngRes[LNG_ITEMS])+1)*sizeof(WCHAR) );


	dialog = UIS_CreateList( &port,
							 0,
							 ITEMS_NUM,
							 0,
							 &starting_num,
							 0,
							 2,
							 NULL,
							 Resources[RES_LIST_CAPTION] ); 

 
    
    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;

    SendListItems_Items( ev_st, app, 1, starting_num );

    return RESULT_OK;
}

UINT32 ListsStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    UIS_DIALOG_T            dialog = 0;
	UINT32					starting_num;


    if(type!=ENTER_STATE_ENTER) return RESULT_OK;
   

    DRM_SetResource( Resources[RES_LIST_CAPTION],  (void*)LngRes[LNG_LISTS], (u_strlen(LngRes[LNG_LISTS])+1)*sizeof(WCHAR) );


	dialog = UIS_CreateList( &port,
							 0,
							 LISTS_NUM,
							 0,
							 &starting_num,
							 0,
							 2,
							 NULL,
							 Resources[RES_LIST_CAPTION] ); 

 
    
    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;

    SendListItems_Lists( ev_st, app, 1, starting_num );

    return RESULT_OK;
}

UINT32 MenuStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

    if ( type == EXIT_STATE_SUSPEND )
      return RESULT_OK;

	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}


UINT32 AllStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APP_ELFRUNNER_T         *papp = (APP_ELFRUNNER_T*) app;
    SU_PORT_T               port = papp->apt.port;
    UIS_DIALOG_T            dialog = 0;
	UINT32					starting_num;
	ACTIONS_T				action_list; // 

    if(type!=ENTER_STATE_ENTER) return RESULT_OK;
   

            action_list.action[0].operation = ACTION_OP_ADD; 
            /*         STATE_HANDLERS_RESERVED,        */
            action_list.action[0].event = LdrFindEventHandlerTbl( all_state_handlers, AddAutorun_Action ); //       
            action_list.action[0].action_res = Resources[RES_ACTION4]; // ,  

            action_list.action[1].operation = ACTION_OP_UPDATE; 
            /*         STATE_HANDLERS_RESERVED,        */
            action_list.action[1].event = EV_SELECT; //       
            action_list.action[1].action_res = Resources[RES_ACTION3]; // ,  

            action_list.count = 2;

            buf_item = 1;

    
    free(ename);
    if (DL_FsDirExist(L"file://b/Elf/")) {
        u_strcpy(cur_folder, L"/b/Elf/");
    } else if (DL_FsDirExist(L"file://a/Elf/")) {
        u_strcpy(cur_folder, L"/a/Elf/");
    } else if (DL_FsDirExist(L"file://c/Elf/")) {
        u_strcpy(cur_folder, L"/c/Elf/");
    } else {
        u_strcpy(cur_folder, L"/");
    }

    FindELFs();
    
    DRM_SetResource( Resources[RES_LIST_CAPTION], (void*)cur_folder, (u_strlen((WCHAR*)(cur_folder))+1)*sizeof(WCHAR) );

	dialog = UIS_CreateList( &port,
							 0,
							 ENTRIES_NUM,
							 0,
							 &starting_num,
							 0,
							 2,
							 &action_list,
							 Resources[RES_LIST_CAPTION] ); 

 
    
    if(dialog == 0) return RESULT_FAIL;

    papp->apt.dialog = dialog;

    UIS_SetCenterSelectAction (papp->apt.dialog, LdrFindEventHandlerTbl( all_state_handlers, Run_Action ) );

    SendListItems_All( ev_st, app, 1, starting_num );

    return RESULT_OK;
}

UINT32 AllStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

    if ( type == EXIT_STATE_SUSPEND )
      return RESULT_OK;

    sel_item = 1;
    buf_item = 0;

    free(fname);
	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}

UINT32 AutorunStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    UIS_DIALOG_T            dialog = 0;
	UINT32					starting_num;
	ACTIONS_T				action_list; // 

    if(type!=ENTER_STATE_ENTER) return RESULT_OK;
   

	        action_list.action[0].operation = ACTION_OP_ADD; 
            /*         STATE_HANDLERS_RESERVED,        */
            action_list.action[0].event = LdrFindEventHandlerTbl( autorun_state_handlers, Del_Action ); //       
            action_list.action[0].action_res = Resources[RES_ACTION2]; // ,  

            action_list.count = 1;


    DRM_ClearResource( Resources[RES_LIST_CAPTION] );
    DRM_CreateResource( &Resources[RES_LIST_CAPTION], RES_TYPE_STRING, (void*)L"Auto.run", (u_strlen((WCHAR*)(L"Auto.run"))+1)*sizeof(WCHAR) );


    ReadAutorun();
	
	dialog = UIS_CreateList( &port,
							 0,
							 ENTRIES_NUM,
							 0,
							 &starting_num,
							 0,
							 2,
							 &action_list,
							 Resources[RES_LIST_CAPTION] ); 

 
    
    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;

    SendListItems_Autorun( ev_st, app, 1, starting_num );

    return RESULT_OK;
}

UINT32 AutorunStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

    if ( type == EXIT_STATE_SUSPEND )
      return RESULT_OK;

    sel_item = 1;

    free(ename);
	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}

UINT32 Update( EVENT_STACK_T *ev_st,  void *app, UINT32 sItem )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
   
	if (sItem != 0)
	{
		APP_UtilAddEvUISListChange( ev_st,
                                app,
                                0, // = 0
                                sItem,
                                ENTRIES_NUM,
                                TRUE,
                                2,          // = 2
                                FBF_LEAVE,
                                NULL,
                                NULL );	
								
		UIS_HandleEvent( papp->dialog,  ev_st );		
	}


	return RESULT_OK;
}

UINT32 EditStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UIS_DIALOG_T            dialog = NULL;


    if(type!=ENTER_STATE_ENTER) 
		return RESULT_OK;


        dialog = UIS_CreateCharacterEditor( &papp->port,
                                            L"",
                                            1,
                                            96,
                                            FALSE,
                                            NULL,            
                                            Resources[RES_EDIT_CAPTION]
                                            );

        if(dialog == NULL) return RESULT_FAIL;

        papp->dialog = dialog;

        return RESULT_OK;
}

UINT32 Edit2StateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UIS_DIALOG_T            dialog = NULL;


    if(type!=ENTER_STATE_ENTER) 
		return RESULT_OK;


        dialog = UIS_CreateCharacterEditor( &papp->port,
                                            ename[sel_item-1].name,
                                            1,
                                            31,
                                            FALSE,
                                            NULL,            
                                            Resources[RES_EDIT_CAPTION2]
                                            );

        if(dialog == NULL) return RESULT_FAIL;

        papp->dialog = dialog;

        return RESULT_OK;
}

UINT32 Edit3StateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UIS_DIALOG_T            dialog = NULL;


    if(type!=ENTER_STATE_ENTER) 
		return RESULT_OK;


        dialog = UIS_CreateCharacterEditor( &papp->port,
                                            run_list[id_run_list].name,
                                            1,
                                            96,
                                            FALSE,
                                            NULL,            
                                            Resources[RES_EDIT_CAPTION]
                                            );

        if(dialog == NULL) return RESULT_FAIL;

        papp->dialog = dialog;

        return RESULT_OK;
}

UINT32 EditStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

    if ( type == EXIT_STATE_SUSPEND )
      return RESULT_OK;

	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}


UINT32 EditData( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32       status = 0;
    EVENT_T      *event = AFW_GetEv(ev_st);

    NewRunlist(event->attachment);
    sel_item=1;
   
    status = APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
    
    return status;
}


UINT32 Edit2Data( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32       status = 0;
    EVENT_T      *event = AFW_GetEv(ev_st);


    Installed_Rename(sel_item, (WCHAR*)(event->attachment));
    status = APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
    
    return status;
}

UINT32 Edit3Data( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32       status = 0;
    EVENT_T      *event = AFW_GetEv(ev_st);


    RenameRunlist((WCHAR*)(event->attachment));
    status = APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
    
    return status;
}

UINT32 EditOk( EVENT_STACK_T *ev_st,  void *app )
{
     UINT32                  status = 0;
     ADD_EVENT_DATA_T        *ev_data;
     APPLICATION_T           *papp = (APPLICATION_T*) app;

     AFW_AddEvEvD(ev_st, EV_REQUEST_DATA,ev_data);
	 UIS_HandleEvent( papp->dialog,  ev_st );

    return status;
}

UINT32 EditExit( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                	    status = 0;

    status = APP_UtilChangeState(ER_STATE_INSTALLED, ev_st, app );
    
    return status;
}



//    
UINT32 ReadLngRes(WCHAR *LngResFile)
{
	WCHAR *bufR=NULL;
	UINT32 readen;
	FILE_HANDLE_T f;
	UINT32 fSize; //  

	int i = 0, j = 0, numStr = 0;


	if (DL_FsFFileExist(LngResFile)) //    
		{
			f = DL_FsOpenFile(LngResFile, FILE_READ_MODE, 0);
			fSize = DL_FsGetFileSize(f);
			bufR = malloc( fSize );
			DL_FsReadFile( bufR, fSize, 1, f, &readen );
			
			for (i=0; i < fSize && j+1 < 32 && numStr < LNG_MAX; i++)
			{
				if (bufR[i] == 0x000A) //  
				{
                     j=0;
					 numStr++; // 
				}
				else
				{
                    if(bufR[i] != 0xFEFF && bufR[i] != 0x000D) // 
					{
						 LngRes[numStr][j] = bufR[i];
                         LngRes[numStr][j+1] = 0;
						 j++;
					}
                    
				}
			}
			
            
			DL_FsCloseFile(f);
			free(bufR);
		}
	return RESULT_OK;
}

UINT32 Navigate (EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T                 *event = AFW_GetEv(ev_st);


	sel_item = event->data.index;
	return RESULT_OK;
}


UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    //    
    status = APP_HandleUITokenGranted( ev_st, app );

    //   ,   state
    if( (status == RESULT_OK) && (papp->token_status == 2) )
    {
        status = APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
    }

    return status;
}


/* -  EV_REQUEST_LIST_ITEMS -   List    
          */
UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app )
{
	APPLICATION_T			*papp = (APPLICATION_T*) app;
	EVENT_T					*event;
	UINT32					start, num;
    

	//      "",      
	if( !papp->focused ) return RESULT_OK;

	//      
	event = AFW_GetEv( ev_st );

	start = event->data.list_items_req.begin_idx;
	num = event->data.list_items_req.count;

	//   ,     - ,      
	APP_ConsumeEv( ev_st, app );

    switch (papp->state) {
        case ER_STATE_INSTALLED:
            return SendListItems_Installed( ev_st, app, start, num );
        break;

        case ER_STATE_MENU:
            return SendListItems_Menu( ev_st, app, start, num );
        break;

        case ER_STATE_ITEMS:
            return SendListItems_Items( ev_st, app, start, num );
        break;

        case ER_STATE_LISTS:
            return SendListItems_Lists( ev_st, app, start, num );
        break;

        case ER_STATE_ALL:
            return SendListItems_All( ev_st, app, start, num );
        break;

        case ER_STATE_AUTORUN:
            return SendListItems_Autorun( ev_st, app, start, num );
        break;
    }

    return RESULT_OK;
}

/*            */
UINT32 SendListItems_Installed( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
    APPLICATION_T			*papp = (APPLICATION_T*) app;
	LIST_ENTRY_T			*plist=NULL; //    
	UINT32					i, index, j, status=RESULT_OK;
    DL_FS_MID_T             f;
    LIST_IMAGE_ELEMENT_T    *img_element;
    WCHAR                   pic[128];


    if( num==0 ) return RESULT_FAIL; //  ,   

	plist = (LIST_ENTRY_T*) malloc( sizeof(LIST_ENTRY_T)*num ); // malloc
	if( plist==NULL ) return RESULT_FAIL;

    img_element = (LIST_IMAGE_ELEMENT_T*)suAllocMem( sizeof(LIST_IMAGE_ELEMENT_T)*num, NULL );
    if( img_element==NULL ) return RESULT_FAIL;

    //  
            for( index=0, i=start; (i<start+num) && (i<=ENTRIES_NUM); i++, index++)
            {
                plist[index].editable = FALSE;			//  
                plist[index].content.static_entry.unk6 = 1;

                for (j=0; j < u_strlen(ename[i-1].fullname)-3; j++)
        			pic[j] = ename[i-1].fullname[j];
                pic[j] = 0;
                u_strcat(pic, L"gif"); 

           		
                if (DL_FsFFileExist( pic ))
                {
                    DL_FsGetIDFromURI(pic,  &f);
                    img_element[index].image.file_id = f;
                    img_element[index].image_type = LIST_IMAGE_DL_FS_MID_T;
                    img_element[index].image_index = i;

                    UIS_MakeContentFromString( "j1q0", &(plist[index].content.static_entry.text), ename[i-1].name, &img_element[index] );
                }
                else
                {
                    UIS_MakeContentFromString( "p1q0", &(plist[index].content.static_entry.text), ename[i-1].name,  Resources[RES_ELFICON] );
                }
            }

    //       ,    
	status = APP_UtilAddEvUISListData( ev_st, app, 0,
									   start, num,
									   FBF_LEAVE,
									   sizeof(LIST_ENTRY_T)*num,
									   plist );
	if( status!=RESULT_FAIL )
	{
		//        
		status = UIS_HandleEvent(papp->dialog, ev_st);
	}

	free(plist);

    return status;
}

UINT32 SendListItems_Menu( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
    APPLICATION_T			*papp = (APPLICATION_T*) app;
	LIST_ENTRY_T			*plist=NULL; //    
	UINT32					i, index, status=RESULT_OK;


    if( num==0 ) return RESULT_FAIL; //  ,   

	plist = (LIST_ENTRY_T*) malloc( sizeof(LIST_ENTRY_T)*num ); // malloc
	if( plist==NULL ) return RESULT_FAIL;

    //  
    
    for( index=0, i=start; (i<start+num) && (i<=MENU_NUM); i++, index++)
    {
                plist[index].editable = FALSE;			//  
                plist[index].content.static_entry.unk6 = 1;

                
    }

    UIS_MakeContentFromString( "s0", &(plist[0].content.static_entry.text), 0x01001818 );
    UIS_MakeContentFromString( "q0", &(plist[1].content.static_entry.text), LngRes[LNG_AUTORUN] );
   
    


    //       ,    
	status = APP_UtilAddEvUISListData( ev_st, app, 0,
									   start, num,
									   FBF_LEAVE,
									   sizeof(LIST_ENTRY_T)*num,
									   plist );
	if( status!=RESULT_FAIL )
	{
		//        
		status = UIS_HandleEvent(papp->dialog, ev_st);
	}

	free(plist);

    return status;
}

UINT32 SendListItems_Items( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
    APPLICATION_T			*papp = (APPLICATION_T*) app;
	LIST_ENTRY_T			*plist=NULL; //    
	UINT32					i, index, status=RESULT_OK;


    if( num==0 ) return RESULT_FAIL; //  ,   

	plist = (LIST_ENTRY_T*) malloc( sizeof(LIST_ENTRY_T)*num ); // malloc
	if( plist==NULL ) return RESULT_FAIL;

    //  
    for( index=0, i=start; (i<start+num) && (i<=ITEMS_NUM); i++, index++)
    {
                plist[index].editable = FALSE;			//  
                plist[index].content.static_entry.unk6 = 1;
    }

    UIS_MakeContentFromString( "s0", &(plist[0].content.static_entry.text), LANG_DELETE );
    UIS_MakeContentFromString( "s0", &(plist[1].content.static_entry.text), LANG_RENAME );
    UIS_MakeContentFromString( "q0", &(plist[2].content.static_entry.text), LngRes[LNG_SELECT] );
    UIS_MakeContentFromString( "q0", &(plist[3].content.static_entry.text), LngRes[LNG_PASTE] );
    

    //       ,    
	status = APP_UtilAddEvUISListData( ev_st, app, 0,
									   start, num,
									   FBF_LEAVE,
									   sizeof(LIST_ENTRY_T)*num,
									   plist );
	if( status!=RESULT_FAIL )
	{
		//        
		status = UIS_HandleEvent(papp->dialog, ev_st);
	}

	free(plist);

    return status;
}

UINT32 SendListItems_Lists( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
    APPLICATION_T			*papp = (APPLICATION_T*) app;
	LIST_ENTRY_T			*plist=NULL; //    
	UINT32					i, index, status=RESULT_OK;


    if( num==0 ) return RESULT_FAIL; //  ,   

	plist = (LIST_ENTRY_T*) malloc( sizeof(LIST_ENTRY_T)*num ); // malloc
	if( plist==NULL ) return RESULT_FAIL;

    //  
    for( index=0, i=start; (i<start+num) && (i<=ITEMS_NUM); i++, index++)
    {
                plist[index].editable = FALSE;			//  
                plist[index].content.static_entry.unk6 = 1;
    }

    UIS_MakeContentFromString( "s0", &(plist[0].content.static_entry.text), LANG_DELETE );
    UIS_MakeContentFromString( "s0", &(plist[1].content.static_entry.text), LANG_RENAME );
    UIS_MakeContentFromString( "s0", &(plist[2].content.static_entry.text), LANG_CREATE );
    UIS_MakeContentFromString( "q0", &(plist[3].content.static_entry.text), LngRes[LNG_NEXT] );
    UIS_MakeContentFromString( "q0", &(plist[4].content.static_entry.text), LngRes[LNG_PREV] );


    //       ,    
	status = APP_UtilAddEvUISListData( ev_st, app, 0,
									   start, num,
									   FBF_LEAVE,
									   sizeof(LIST_ENTRY_T)*num,
									   plist );
	if( status!=RESULT_FAIL )
	{
		//        
		status = UIS_HandleEvent(papp->dialog, ev_st);
	}

	free(plist);

    return status;
}


UINT32 SendListItems_All( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
    APPLICATION_T			*papp = (APPLICATION_T*) app;
	LIST_ENTRY_T			*plist=NULL; //    
	UINT32					i, index, status=RESULT_OK;
    UINT32					img_res=NULL, img_select=NULL;


    if( num==0 ) return RESULT_FAIL; //  ,   

	plist = (LIST_ENTRY_T*) malloc( sizeof(LIST_ENTRY_T)*num ); // malloc
	if( plist==NULL ) return RESULT_FAIL;

    //  
    
    for( index=0, i=start; (i<start+num) && (i<=ENTRIES_NUM); i++, index++)
    {
                plist[index].editable = FALSE;			//  
                plist[index].content.static_entry.unk6 = 1;


    img_select=NULL;
    img_res=NULL;



        if (fname[i-1].attrib & FS_ATTR_DIRECTORY) 
        {
            img_res = DRMRES_FOLDER;
        }
        else if ( !u_strcmp(u_strmakelower(SplitPath( fname[i-1].name, L".")), L"elf")  )
        {
            img_res = Resources[RES_ELFICON];
        }	

        if (fname[i-1].selected)
            img_select = DRMRES_SELECTED;


        UIS_MakeContentFromString( "p1q0Sp2", &(plist[index].content.static_entry.text), fname[i-1].name, img_res, img_select);

    }

    //       ,    
	status = APP_UtilAddEvUISListData( ev_st, app, 0,
									   start, num,
									   FBF_LEAVE,
									   sizeof(LIST_ENTRY_T)*num,
									   plist );
	if( status!=RESULT_FAIL )
	{
		//        
		status = UIS_HandleEvent(papp->dialog, ev_st);
	}

	free(plist);

    return status;
}

UINT32 SendListItems_Autorun( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
    APPLICATION_T			*papp = (APPLICATION_T*) app;
	LIST_ENTRY_T			*plist=NULL; //    
	UINT32					i, index, status=RESULT_OK;


    if( num==0 ) return RESULT_FAIL; //  ,   

	plist = (LIST_ENTRY_T*) malloc( sizeof(LIST_ENTRY_T)*num ); // malloc
	if( plist==NULL ) return RESULT_FAIL;

    //  
            for( index=0, i=start; (i<start+num) && (i<=ENTRIES_NUM); i++, index++)
            {
                plist[index].editable = FALSE;			//  
                plist[index].content.static_entry.unk6 = 1;

                UIS_MakeContentFromString( "q0", &(plist[index].content.static_entry.text), ename[i-1].name );
            }    
   
    //       ,    
	status = APP_UtilAddEvUISListData( ev_st, app, 0,
									   start, num,
									   FBF_LEAVE,
									   sizeof(LIST_ENTRY_T)*num,
									   plist );
	if( status!=RESULT_FAIL )
	{
		//        
		status = UIS_HandleEvent(papp->dialog, ev_st);
	}

	free(plist);

    return status;
}



/*           */
UINT32 InitResources( )
{
    UINT32						status;
    RES_ACTION_LIST_ITEM_T		action[6];

    
	/*     */
    status = DRM_CreateResource( &Resources[RES_LIST_CAPTION], RES_TYPE_STRING, (void*)run_list[id_run_list].name, (u_strlen((WCHAR*)run_list[id_run_list].name)+1)*sizeof(WCHAR) );

    /*     */
    status = DRM_CreateResource( &Resources[RES_EDIT_CAPTION], RES_TYPE_STRING, (void*)LngRes[LNG_CAPTION_EDITOR], (u_strlen(LngRes[LNG_CAPTION_EDITOR])+1)*sizeof(WCHAR) );

    /*    2 */
    status = DRM_CreateResource( &Resources[RES_EDIT_CAPTION2], RES_TYPE_STRING, (void*)LngRes[LNG_CAPTION_EDITOR2], (u_strlen(LngRes[LNG_CAPTION_EDITOR])+1)*sizeof(WCHAR) );

    /*     4 */
    status = DRM_CreateResource( &Resources[RES_ACTION4_CAPTION], RES_TYPE_STRING, (void*)LngRes[LNG_ADD_AUTORUN], (u_strlen((WCHAR*)LngRes[LNG_ADD_AUTORUN])+1)*sizeof(WCHAR) );

    /*     5 */
    status = DRM_CreateResource( &Resources[RES_ACTION5_CAPTION], RES_TYPE_STRING, (void*)LngRes[LNG_AUTORUN], (u_strlen((WCHAR*)LngRes[LNG_AUTORUN])+1)*sizeof(WCHAR) );

    /*     */
    status = DRM_CreateResource( &Resources[RES_ELFICON], RES_TYPE_GRAPHICS, (void*)ELFICON, sizeof(ELFICON) );
    if( status!=RESULT_OK ) return status;


     /*    */
    action[0].softkey_label = 0x01000A64;			//      
    action[0].list_label = 0;		        // ""
    action[0].softkey_priority = -1;
    action[0].list_priority = 0;		
    action[0].isExit = FALSE;
    action[0].sendDlgDone = FALSE;

    status = DRM_CreateResource( &Resources[RES_ACTION0], RES_TYPE_ACTION, (void*)&action[0], sizeof(RES_ACTION_LIST_ITEM_T));


    /*    */
    action[1].softkey_label = 0;			//      
    action[1].list_label = 0x01001818;		// " "
    action[1].softkey_priority = 0;
    action[1].list_priority = 3;		
    action[1].isExit = FALSE;
    action[1].sendDlgDone = FALSE;

    status = DRM_CreateResource( &Resources[RES_ACTION1], RES_TYPE_ACTION, (void*)&action[1], sizeof(RES_ACTION_LIST_ITEM_T));

    /*    */
    action[2].softkey_label = 0;			//    -
    action[2].list_label = 0x01000078;		// ""
    action[2].softkey_priority = 0;
    action[2].list_priority = 1;
    action[2].isExit = FALSE;
    action[2].sendDlgDone = FALSE;

    status = DRM_CreateResource( &Resources[RES_ACTION2], RES_TYPE_ACTION, (void*)&action[2], sizeof(RES_ACTION_LIST_ITEM_T));

    /*    */
    action[3].softkey_label = 0x01001B7C;			//   -
    action[3].list_label = 0;		// ""
    action[3].softkey_priority = 1;
    action[3].list_priority = 0;
    action[3].isExit = FALSE;
    action[3].sendDlgDone = FALSE;

    status = DRM_CreateResource( &Resources[RES_ACTION3], RES_TYPE_ACTION, (void*)&action[3], sizeof(RES_ACTION_LIST_ITEM_T));

    /*    */
    action[4].softkey_label = 0;			//    -
    action[4].list_label = Resources[RES_ACTION4_CAPTION];		// ""
    action[4].softkey_priority = 0;
    action[4].list_priority = 1;
    action[4].isExit = FALSE;
    action[4].sendDlgDone = FALSE;

    status = DRM_CreateResource( &Resources[RES_ACTION4], RES_TYPE_ACTION, (void*)&action[4], sizeof(RES_ACTION_LIST_ITEM_T));

     /*    */
    action[5].softkey_label = 0;			//    -
    action[5].list_label = Resources[RES_ACTION5_CAPTION];		// ""
    action[5].softkey_priority = 0;
    action[5].list_priority = 2;
    action[5].isExit = FALSE;
    action[5].sendDlgDone = FALSE;

    status = DRM_CreateResource( &Resources[RES_ACTION5], RES_TYPE_ACTION, (void*)&action[5], sizeof(RES_ACTION_LIST_ITEM_T));


    return status;
}

/*        */
UINT32 RemoveResources( )
{
	UINT32				status = RESULT_OK;
	UINT32				i;

	for(i=0;i<RES_MAX;i++)
	{
		status |= DRM_ClearResource( Resources[i] );
	}

	return status;
}

UINT32 Action( EVENT_STACK_T *ev_st,  void *app )
{
	APP_ConsumeEv( ev_st, app );

    APP_UtilChangeState(ER_STATE_ALL, ev_st, app);

	return RESULT_OK;
}

UINT32 Del_Action( EVENT_STACK_T *ev_st,  void *app )
{
    //APPLICATION_T   *papp=(APPLICATION_T*)app;
    int i;


	APP_ConsumeEv( ev_st, app );


            DL_FsDeleteFile( AUTORUN,  0 );

            if (ENTRIES_NUM > 1)
            {
                for (i=0; i < ENTRIES_NUM; i++)
                    if (i != sel_item-1) AddAutorun(ename[i].fullname);
        
                ReadAutorun();
            }
            else
            {
                ENTRIES_NUM=0;
            }


    if (sel_item > 1) {
        sel_item--;
    } else {
        sel_item=1;
    }
    Update(ev_st,app,sel_item);

	return RESULT_OK;
}

UINT32 Run_Action( EVENT_STACK_T *ev_st,  void *app )
{
    //APP_ELFRUNNER_T   *papp=(APP_ELFRUNNER_T*)app;
    UINT32          i;
    WCHAR u_buf_fullname[256];


	APP_ConsumeEv( ev_st, app );

     if (sel_item == 1 && u_strcmp(cur_folder, L"/"))
                {
                    // 
                    if (cur_folder[u_strlen(cur_folder)-1] == '/') cur_folder[u_strlen(cur_folder)-1] = 0;
                        for (i=u_strlen(cur_folder)-1; i > 0 ; i--)
                        {
                            if (cur_folder[i] == '/')
                            {
                                break;
                            }
                            else
                            {
                                cur_folder[i] = 0;
                            }
                        }


                        FindELFs();
                        sel_item = buf_item;
                        buf_item = 1;
                        DRM_SetResource( Resources[RES_LIST_CAPTION], (void*)cur_folder, (u_strlen(cur_folder)+1)*sizeof(WCHAR) );
                        Update(ev_st, app, sel_item);
                        UIS_Refresh();
                        
                }
                else
                    {
                        if (fname[sel_item-1].attrib & FS_ATTR_DIRECTORY)
                        {
                        //   
                            buf_item = sel_item; 


                            u_strcat(cur_folder, fname[sel_item-1].name);
                            u_strcat(cur_folder, L"/");

                            FindELFs();
                            DRM_SetResource( Resources[RES_LIST_CAPTION], (void*)cur_folder, (u_strlen(cur_folder)+1)*sizeof(WCHAR) );
                            Update(ev_st, app, 1);
                            UIS_Refresh();
                        }
                        else
                        {
                                u_strcpy(u_buf_fullname,  L"file:/");
                                u_strcat(u_buf_fullname, cur_folder);
                                u_strcat(u_buf_fullname, fname[sel_item-1].name);
                                    
                            
                                LdrLoadELF( u_buf_fullname,  NULL );
                                APP_ConsumeEv( ev_st, app );
                                destroyApp(ev_st, app);
                        }
                    }




	return RESULT_OK;
}

UINT32 AddAutorun_Action( EVENT_STACK_T *ev_st,  void *app )
{
    WCHAR uri[256];
    APP_ConsumeEv( ev_st, app );

    u_strcpy(uri, L"file:/");
    u_strcat(uri, cur_folder);
    u_strcat(uri, fname[sel_item-1].name);

    AddAutorun(uri);
    return RESULT_OK;
}

UINT32 Autorun_Action( EVENT_STACK_T *ev_st,  void *app )
{
    APP_ConsumeEv( ev_st, app );

    APP_UtilChangeState(ER_STATE_AUTORUN, ev_st, app );
    return RESULT_OK;
}

UINT32 Back( EVENT_STACK_T *ev_st,  void *app ) //    
{
    APP_ELFRUNNER_T   *papp = ( APP_ELFRUNNER_T* ) app;

	APP_ConsumeEv( ev_st, app );

    if (papp->apt.state == ER_STATE_MENU || papp->apt.state == ER_STATE_ITEMS || papp->apt.state == ER_STATE_LISTS) {
        APP_UtilChangeState(ER_STATE_INSTALLED, ev_st, app );
    } else {
        APP_UtilChangeState(ER_STATE_MENU, ev_st, app );
    }
    
    return RESULT_OK;
}

UINT32 SelectItem( EVENT_STACK_T *ev_st,  void *app)
{
    APP_ELFRUNNER_T   *papp = ( APP_ELFRUNNER_T* ) app;
    EVENT_T         *event = AFW_GetEv(ev_st);

    WCHAR                    uri[128];

    switch (papp->apt.state)
    {
        case ER_STATE_INSTALLED:

            if (DL_FsFFileExist(ename[sel_item-1].fullname))
            {
                u_strcpy(uri, L"file:/");
                u_strcat(uri, ename[sel_item-1].fullname);

                LdrLoadELF( uri,  NULL );
                APP_ConsumeEv( ev_st, app );
                destroyApp(ev_st, app);
            }
        break;

        case ER_STATE_MENU:
            if (event->data.index == 1) {
                Action(ev_st,app);
            } else if (event->data.index == 2) {
                Autorun_Action(ev_st,app);
            } 
            break;

        case ER_STATE_ITEMS:
            if (event->data.index == 1) { // delete
                sel_item = Installed_Delete(sel_item) ;
                APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
            } else if (event->data.index == 2) { // rename
                APP_UtilChangeState( ER_STATE_EDIT2, ev_st, app );
            } else if (event->data.index == 3) { // select
                if(getNumFrame(sel_item) == getNumFrame(buf_item) ) paint_clear(buf_item);
                Installed_Copy(sel_item);
                APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
            } else if (event->data.index == 4) { // paste
                Installed_Paste(sel_item);
                APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
            }
            break;

         case ER_STATE_LISTS:
            if (event->data.index == 1) { // delete
                DeleteRunlist();
                APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
            } else if (event->data.index == 2) { // rename 
                APP_UtilChangeState( ER_STATE_EDIT3, ev_st, app );
            } else if (event->data.index == 3) { // new
                APP_UtilChangeState( ER_STATE_EDIT, ev_st, app );
            } else if (event->data.index == 4) { // next
                sel_item=1;
                        if (id_run_list < count_run_list-1){
                             id_run_list++;
                        } else {
                            id_run_list=0;
                        }

                        APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
            } else if (event->data.index == 5) { // prev
                sel_item=1;
                        if (id_run_list > 0) {
                             id_run_list--;
                        } else {
                            id_run_list=count_run_list-1;
                        }
                        
                        
                        APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
            }
            break;

       

        case ER_STATE_ALL:

                if (!(fname[event->data.index-1].attrib & FS_ATTR_DIRECTORY))
                {
                            fname[event->data.index-1].selected = TRUE;

                            u_strcpy(uri, cur_folder);
                            u_strcat(uri, fname[event->data.index-1].name);

                            Installed_Install(NULL, uri);
                            Update(ev_st,app,event->data.index);
                }
        break;
    }


    return RESULT_OK;
}


UINT32 FindRunLists(void)
{
    UINT32                  i;
	FS_SEARCH_PARAMS_T      fs_param;
    FS_SEARCH_HANDLE_T      fs_handle;
    FS_SEARCH_RESULT_T      fs_result; 
    WCHAR                   search_str[128];

	UINT16 res_count, count = 1; 
    fs_param.flags = 0x1C;
	    //0xD -       
        //0x29 -  
	fs_param.attrib = 0x0000;
	fs_param.mask = 0x0000; 

    u_strcpy(search_str, FolderELF);
    u_strcat(search_str, L"\xFFFE*.rlt\xFFFE*.RLT");

	DL_FsSSearch( fs_param, search_str, &fs_handle, &res_count, 0); 

    
    free(run_list);
    run_list = malloc(res_count*sizeof(RUNLISTINFO));

    count_run_list = res_count;

    for (i=0; i < res_count; i++)
    {
        DL_FsSearchResults(fs_handle, i, &count, &fs_result);
        fs_result.name[u_strlen(fs_result.name)-4] = 0;
        u_strcpy(run_list[i].name, SplitPath(fs_result.name, L"/"));
        
        udbg("run_list.name = %s\n", run_list[i].name);
    }

    DL_FsSearchClose(fs_handle);

	return RESULT_OK;
}

UINT32 FindELFs(void)
{
	FindFile(  cur_folder, L"*" );

	return RESULT_OK;
}

UINT32 ReadELFs(void) //    
{
	UINT32          readen;
	FILE_HANDLE_T   f;
	UINT32          fSize;
    UINT16          i = 0;
    WCHAR           InstallFile[128];

    if (id_run_list >= count_run_list) return RESULT_FAIL;
    
    GetNameRunlist(InstallFile);
        

	//     
	if (DL_FsFFileExist( InstallFile )) //    
	{
        udbg("Read %s", InstallFile);

		f = DL_FsOpenFile(InstallFile, FILE_READ_MODE, 0);
		fSize = DL_FsGetFileSize(f);

        ENTRIES_NUM = fSize/(64+256);

        free(ename);
        ename = (ELFINFO*) malloc(ENTRIES_NUM*sizeof(ELFINFO));

        dbg("Count Elfs = %d", ENTRIES_NUM);

        for (i=0; i < ENTRIES_NUM; i++)
        {
            DL_FsFSeekFile(f,  i*(256+64), 0); //    
            DL_FsReadFile( ename[i].name, 64, 1, f, &readen ); //   
            udbg("name = %s\n", ename[i].name);
            DL_FsReadFile( ename[i].fullname, 256, 1, f, &readen ); //      256 
            udbg("fullname = %s\n", ename[i].fullname);
        }

		DL_FsCloseFile(f);

        //Fullname2Name();
       
	}
    else
    {
        ENTRIES_NUM=0;
    }
    return RESULT_OK;
}



//    Auto.run
UINT32 AddAutorun(WCHAR *name)
{
	UINT32	        written, r;
	FILE_HANDLE_T	f;
    char  enter[] = {0x0D, 0x0A};
    char  buf[2];
    char  buf_fullname[256];
    WCHAR           uri[64];


    u_strcpy(uri, AUTORUN);
    

    u_utoa(name, buf_fullname);

        f = DL_FsOpenFile(uri, FILE_APPEND_PLUS_MODE, 0);
        
        DL_FsFSeekFile( f,  -2, SEEK_WHENCE_END );
        DL_FsReadFile( buf, 2, 1, f,  &r );
        DL_FsFSeekFile( f,  0, SEEK_WHENCE_END );

        if (DL_FsGetFileSize(f) != 0 && buf[0] != enter[0] && buf[1] != enter[1]) {
            DL_FsWriteFile( enter, 2, 1, f, &written );
            dbg("Add enter", NULL);
        }
        DL_FsWriteFile(buf_fullname, strlen(buf_fullname), 1, f, &written );
        DL_FsWriteFile( enter, 2, 1, f, &written );
        

        DL_FsCloseFile(f);
	
	return RESULT_OK;
} 

UINT32 ReadAutorun(void) //   Auto.run
{
	UINT32          readen;
	FILE_HANDLE_T   f;
	UINT32          fSize;
    char           *bufR;
    WCHAR           uri[64];

    int i = 0, j = 0, numStr=0;

    u_strcpy(uri, AUTORUN);

    
	//     
	if (!DL_FsFFileExist(uri)) { //    
        uri[7] = 'a';
        if (!DL_FsFFileExist(uri)) {
            uri[7] = 'c';
        }
    }

		f = DL_FsOpenFile(uri, FILE_READ_MODE, 0);
        if (f == FILE_HANDLE_INVALID ) {
            dbg("Autorun no open", NULL);
            ENTRIES_NUM=0;
            return RESULT_FAIL;
        }
        

		fSize = DL_FsGetFileSize(f);
        dbg("fSize = %d b",fSize);
        bufR = malloc(fSize);

        DL_FsReadFile( bufR, fSize, 1, f, &readen );
        DL_FsCloseFile(f);

        ENTRIES_NUM = 0;
        for (i=0; i < fSize; i++)
           if (bufR[i] == 0x0A) ENTRIES_NUM++; //  - 
        if (bufR[fSize-1] != 0x0A) ENTRIES_NUM++;
        dbg("count lines = %d",ENTRIES_NUM);
        

       free(ename);
       ename = (ELFINFO*) malloc(ENTRIES_NUM*sizeof(ELFINFO));

        //  

        ename[numStr].fullname[0]= 0;
      		for (i=0; i < fSize && j+1 < 256 && numStr <= ENTRIES_NUM; i++)
			{
				if (bufR[i] == 0x0A) //  
				{
                     j=0;
					 numStr++; // 

                     ename[numStr].fullname[0]= 0;
				}
				else
				{
                    if( bufR[i] != 0x0D) // 
					{
						 ename[numStr].fullname[j] = bufR[i];
						 ename[numStr].fullname[j+1] = 0;
						 j++;
					}
				}
			}

         free(bufR);

         Fullname2Name();


    return RESULT_OK;
}

UINT32 Fullname2Name(void)
{
    int i=0, j=0, k=0;

        //   
        for (i=0; i < ENTRIES_NUM; i++)
        {
            if (ename[i].fullname[0] == ';' || ename[i].fullname[0] == 0)
            {
               for (j=0; j < 31; j++)
                   ename[i].name[j] = ename[i].fullname[j];
               ename[i].name[j] = 0;
            }
            else
            {
                  for (j=u_strlen(ename[i].fullname)-1; ename[i].fullname[j] != '/' && j >= 0; j--);
                  j++;
            
                  for (k=j; k < u_strlen(ename[i].fullname)-4; k++)
                      ename[i].name[k-j] = ename[i].fullname[k];
                  ename[i].name[k-j] = 0;
            }

               udbg("NAME = %s\n", ename[i].name);
        }

    return RESULT_OK;
}



UINT32 FindFile( WCHAR *folder, WCHAR *filtr ) //  
{
    INT32                   err=RESULT_OK;
	FS_SEARCH_PARAMS_T		sp;
	FS_SEARCH_RESULT_T		hResult;
	FS_SEARCH_HANDLE_T		hSearch;


	UINT16		count_files=0, count_res=1;
	UINT32		status = RESULT_OK;
	INT32		i=0, j=0;
    UINT8       mode=0;
    WCHAR       volumes[12];

    WCHAR       search_string[256];

    	
	if ( folder==NULL || !u_strcmp(folder, L"/")) {
            u_strcpy(search_string, L"/");
    } else {
        //    file://
        if(u_strncmp(folder, L"file:/", 6))
        {
            u_strcpy(search_string, L"file:/");
            u_strcat(search_string, folder);
        } else {
            u_strcpy(search_string, folder);
        }
            
        //    
        if ( folder[u_strlen(folder)-1] != '/' ) 
            u_strcat(search_string, L"/");
    
        u_strcat(search_string, L"\xFFFE");
        u_strcat(search_string, filtr);
    }

    /////  /////
    // 1)    `a`  hResult.name  !
    // 2)       .      .   "    "
    //////////////////////

    if (!u_strcmp(search_string, L"/")) { // 

        DL_FsVolumeEnum(volumes);

        free(fname);
        fname = suAllocMem(sizeof(FILEINFO)*4, &err);
        if (err != RESULT_OK) return RESULT_FAIL;

        cur_folder[0] = '/';

        ENTRIES_NUM = 0;

        for (i=0; i < 4; i++) {
            fname[i].name[0] = volumes[i*3+1];//'a' + i;
            fname[i].name[1] = 0;
            fname[i].attrib = FS_ATTR_DIRECTORY;
            fname[i].selected = false;

            ENTRIES_NUM++;

            if (volumes[i*3+2] == NULL)  break;
        }

        return RESULT_OK;
    }
	
	sp.flags = 0x1C; 
	sp.attrib = 0;
	sp.mask = 0;
	
	status = DL_FsSSearch( sp, search_string, &hSearch, &count_files, 0 );

	if ( status != RESULT_OK ) {
        DL_FsSearchClose( hSearch );
        return RESULT_FAIL;
    }

    dbg("FB: count_files = %d", count_files);
	
	ENTRIES_NUM = count_files+1;

	free(fname);
    fname = suAllocMem(sizeof(FILEINFO)*(count_files+1), &err);
    if (err != RESULT_OK) return RESULT_FAIL;
	
	u_strcpy(fname[0].name, L"..");
	fname[0].attrib = FS_ATTR_DIRECTORY;
    fname[0].selected = false;


	for ( i=0, j=1; j<=count_files; i++ ) {

            if (i >= count_files){
                if (mode > 0) {
                    break;
                } else {
                    i=-1;
                    mode=1;
                    continue;
                }
            }

		status = DL_FsSearchResults( hSearch, i, &count_res, &hResult );
		if ( status == RESULT_OK ) 
		{
            if ((mode==0) && !(hResult.attrib&FS_ATTR_DIRECTORY)) continue;
            if ((mode==1) && (hResult.attrib&FS_ATTR_DIRECTORY)) continue;

            //     "    "
            if(!u_strcmp(hResult.name+u_strlen(hResult.name)-1, L"/")) continue;

            if ( (hResult.attrib & FS_ATTR_DIRECTORY) || !u_strcmp( u_strmakelower(SplitPath(hResult.name, L".")), L"elf" ))
            {
                u_strcpy( fname[j].name, SplitPath(hResult.name, L"/"));
                //u_PFprintf("*ELF ElfRunner* fname.name = %s\n", fname[ENTRIES_NUM].name);
                fname[j].attrib = hResult.attrib;
                fname[j].selected = false;
                j++;
            }
		} 
        
	}

    ENTRIES_NUM = j;
   

	DL_FsSearchClose( hSearch ); 
	
	return RESULT_OK;
}


UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
	UINT32 tid = ((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID;

	switch (tid ) {
    case 1:
        paint_select();
        break;

    }
    return RESULT_OK;
}


UINT32 Keypress( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T			*papp = (APPLICATION_T*) app;
    UINT8                   key_code = (AFW_GetEv(ev_st))->data.key_pressed;

    UINT8                   n_column=0;
    UINT16                  i;


    APP_ConsumeEv(ev_st,app);

     switch (key_code)
     {
         case KEY_2:
                          sel_item = Installed_Delete(sel_item) ;
                          APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
                          break;

         case KEY_5:
                        APP_UtilChangeState( ER_STATE_EDIT2, ev_st, app );
                        break;

         case KEY_1:
             if(getNumFrame(sel_item) == getNumFrame(buf_item) ) paint_clear(buf_item);
             Installed_Copy(sel_item);
             break;

         case KEY_3:
             Installed_Paste(sel_item);
             APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
             break;
            
         case KEY_POUND:
             sel_item=1;
                        if (id_run_list < count_run_list-1){
                             id_run_list++;
                        } else {
                            id_run_list=0;
                        }
                        
                       
                        APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
                    break;
            
         case KEY_STAR:
             sel_item=1;
                        if (id_run_list > 0) {
                             id_run_list--;
                        } else {
                            id_run_list=count_run_list-1;
                        }
                        
                        
                        APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
                        break;
            
         case KEY_8:  // new runlist
             APP_UtilChangeState( ER_STATE_EDIT, ev_st, app );
             break;

         case KEY_7: // rename runlist
             APP_UtilChangeState( ER_STATE_EDIT3, ev_st, app );
             break;
            
                  case KEY_0: // del runlist
                      DeleteRunlist();
                      APP_UtilChangeState( ER_STATE_INSTALLED, ev_st, app );
                      break;
            
            

         
         case KEY_RED:
                      FreeMemPic();
                      destroyApp(ev_st,app);
                      break;
            
         case KEY_RIGHT:
             paint_clear(sel_item);
                      if (sel_item < ENTRIES_NUM) {
                           sel_item += 1;
                      } else {
                          sel_item = 1;
                      }
                      paint_select();
                      break;
            
         case KEY_LEFT:
             paint_clear(sel_item);
                      if (sel_item > 1) {
                           sel_item -= 1;
                      } else {
                          sel_item = ENTRIES_NUM;
                      }
                      paint_select();
                      break;
            
         case KEY_DOWN:
             paint_clear(sel_item);
             
                      if (sel_item+3 <= ENTRIES_NUM) {
                           sel_item += 3;
                      } else {
                          n_column = getColumn(sel_item);
                          if (n_column == 1) {
                              sel_item = 2;
                          } else if (n_column == 2) {
                              sel_item = 3;
                          } else if (n_column == 3 || n_column == 0) {
                              sel_item = 1;
                          }
                          
                      }
                      paint_select();
                      break;
            
         case KEY_UP:
             paint_clear(sel_item);
                      if (sel_item-2 > 1) {
                           sel_item -= 3;
                      } else {
                          n_column = getColumn(sel_item);

                          if (n_column == 1) {
                              for (i=ENTRIES_NUM; i > 1; i--) {
                                  if (getColumn(i) == 3) {
                                      sel_item=i;
                                      break;
                                  }
                              }
                          } else if (n_column == 2) {
                               for (i=ENTRIES_NUM; i > 1; i--) {
                                  if (getColumn(i) == 1) {
                                      sel_item=i;
                                      break;
                                  }
                              }
                          } else if (n_column == 3 || n_column == 0) {
                              for (i=ENTRIES_NUM; i > 1; i--) {
                                  if (getColumn(i) == 2) {
                                      sel_item=i;
                                      break;
                                  }
                              }
                          }
                      }
                      paint_select();
                      break;
            
         
                  case KEY_CENTER:
                      FreeMemPic();
                      AFW_AddEvNoD(ev_st, EV_SELECT );
                      UIS_HandleEvent(papp->dialog, ev_st);
                      break;
            
                  //case KEY_MENU:
                      //APP_UtilChangeState(ER_STATE_MENU, ev_st, app);
                     // break;

         case KEY_LSOFT:
             APP_UtilChangeState(ER_STATE_ITEMS, ev_st, app);
             break;

         case KEY_RSOFT:
             APP_UtilChangeState(ER_STATE_LISTS, ev_st, app);
             break;
    
            }

    return RESULT_OK;
}

UINT32 Keyrelease( EVENT_STACK_T *ev_st,  void *app )
{
    //APPLICATION_T			*papp = (APPLICATION_T*) app;
    UINT8                   key_code = (AFW_GetEv(ev_st))->data.key_pressed;


    APP_ConsumeEv(ev_st,app);

     switch (key_code) {
     case KEY_MENU:
         APP_UtilChangeState(ER_STATE_MENU, ev_st, app);
         break;
     }
    return RESULT_OK;
}


UINT32 paint(void)
{
    GRAPHIC_POINT_T  item;
    UINT32           i, n;

            // 
            SetBackgroundColor(Setting.color_background );
            SetFillColor(Setting.color_background);
            FillRect(0, 16, bufd.w, bufd.h);
        
            // 
            if (sel_item > 9) {
                i = getNumFrame(sel_item);
                i = (i*9) - 8;
            } else {
                i = 1;
            }
        
            for (n=i; n < i+9 && n <= ENTRIES_NUM; n++) {
                item = XY(n);
                if (n == sel_item) {
                    StopAnimationId();
                    StartAnimationId( n-1, item.x+1, item.y+1, ANCHOR_LEFT | ANCHOR_TOP);
                } else {
                    DrawImageId( n-1, item.x+1, item.y+1, ANCHOR_LEFT | ANCHOR_TOP);
                }
            }
            
            // GUI

            DrawSoftKey(LngRes[LNG_ITEMS], 1, false);
            DrawSoftKey(LngRes[LNG_LISTS], 2, false);
            DrawSoftKey(NULL, 0, false);
    
    return RESULT_OK;
}

UINT32 paint_clear(UINT32 index)
{
    GRAPHIC_POINT_T  item;

    //  
    item = XY(index);
    SetForegroundColor(Setting.color_background);
    DrawRect(item.x, item.y, ICON_SIZE+1, ICON_SIZE+1);

    return RESULT_OK;
}

UINT32 paint_select()
{
    GRAPHIC_POINT_T  item;
    UINT16  i;
    static  prev_item;

    i = getNumFrame(sel_item);
    if (getNumFrame(prev_item) != i) { 
        paint();
    } else {
        //  
        item = XY(sel_item);
        StopAnimationId();
        StartAnimationId( sel_item-1, item.x+1, item.y+1, ANCHOR_LEFT | ANCHOR_TOP);
        item = XY(prev_item);
        DrawImageId( prev_item-1, item.x+1, item.y+1, ANCHOR_LEFT | ANCHOR_TOP);
    }
    prev_item = sel_item;
    //  
    DrawTitleBar(ename[sel_item-1].name);

    // 
    DrawScrollBar(ENTRIES_NUM, sel_item+1);

    //  
    if (buf_item <= ENTRIES_NUM && buf_item != 0 && getNumFrame(buf_item) == i) {
        item = XY(buf_item);
        SetForegroundColor(Setting.color_mark);
        DrawRect(item.x, item.y, ICON_SIZE+1, ICON_SIZE+1);
    }

    //  
    item = XY(sel_item);
    SetForegroundColor(Setting.color_select);
    DrawRect(item.x, item.y, ICON_SIZE+1, ICON_SIZE+1);


    return RESULT_OK;
}

GRAPHIC_POINT_T  XY(UINT32 sItem)
{
    GRAPHIC_POINT_T  item;
    UINT32 I=0;

    if (sItem > 9) {
        I = (sItem % 9);
        if (I == 0)  I = 9;
    } else {
        I = sItem;
    }

    

    if (I <= 3) {
        item.y = LINE1;
    } else  if (I > 3 && I < 7) {
        item.y = LINE2;
    } else  if (I > 6 && I < 10) {
        item.y = LINE3;
    } else {
        item.y = 0;
    }

    if (I == 1 || I == 4 || I == 7) {
        item.x = COLUMN1;
    } else if (I == 2 || I == 5 || I == 8) {
        item.x = COLUMN2;
    } else if (I == 3 || I == 6 || I == 9) {
        item.x = COLUMN3;
    } else {
        item.x = 0;
    }

    return item;
}

UINT8 getColumn(UINT16 sItem)
{
    UINT32 I=0;

    if (sItem > 9) {
        I = (sItem % 9);
        if (I == 0)  I = 9;
    } else {
        I = sItem;
    }

    if (I == 1 || I == 4 || I == 7) {
        return 1;
    } else if (I == 2 || I == 5 || I == 8) {
        return 2;
    } else if (I == 3 || I == 6 || I == 9) {
        return 3;
    } else {
        return 0;
    }
}

//    (9 )
UINT32 getNumFrame(UINT32 index)
{
    UINT32 i;

    i = index / 9;
    if ((index % 9) != 0) i++;

    return i;
}

//    
UINT32 ReadSetting(void) 
{
	UINT32 readen;
	FILE_HANDLE_T f;
    WCHAR nameCfgFileU[256];

    u_strcpy(nameCfgFileU, FolderELF);
    u_strcat(nameCfgFileU, L"ElfRunner.cfg");
	
	//    
	if (DL_FsFFileExist(nameCfgFileU)) //    
	{
		f = DL_FsOpenFile(nameCfgFileU, FILE_READ_MODE, 0);
        DL_FsReadFile( &id_run_list, sizeof(UINT16), 1, f, &readen );
        DL_FsReadFile( &Setting, sizeof(SETTING_T), 1, f, &readen );

        DL_FsCloseFile(f);
    }
	
	return RESULT_OK;
}

//   
UINT32 SaveSetting(void)
{
	UINT32 written;
	FILE_HANDLE_T f;
    WCHAR nameCfgFileU[256];

    u_strcpy(nameCfgFileU, FolderELF);
    u_strcat(nameCfgFileU, L"ElfRunner.cfg");
	
	//   
	f = DL_FsOpenFile(nameCfgFileU, FILE_WRITE_MODE, 0);

    DL_FsWriteFile( &id_run_list, sizeof(UINT16), 1, f, &written );
    DL_FsWriteFile( &Setting, sizeof(SETTING_T), 1, f, &written );

	DL_FsCloseFile(f);

	return RESULT_OK;
}

UINT32 AddShortcut( EVENT_STACK_T *ev_st,  void *app )
{
    WCHAR               uri[256];
    SHORTCUT_CREATE_T   *sc = (SHORTCUT_CREATE_T*)(AFW_GetEv(ev_st)->attachment);
    DL_FS_MID_T         fid;
    _u64                tmp;

    dbg("Create shortcut", NULL);


    u_strcpy(uri, cur_folder);
    u_strcat(uri, fname[sel_item-1].name);

    if (u_strcmp(SplitPath( fname[sel_item-1].name, L"."), L"elf")) {
        APP_ConsumeEv(ev_st, app);
    } else {
        
        DL_FsGetIDFromURI(uri, &fid);
        dbg("fid = 0x%x%x", fid);
        sc->type = SC_TYPE_APP;
    
        memcpy( &tmp, &fid, sizeof(UINT64) );
        sc->list1_index = tmp.R0;
        sc->param1 = tmp.R1;   
                
        u_strncpy( sc->text, fname[sel_item-1].name, SC_TEXT_LEN );
        sc->param2 = NULL;
        sc->list2_index = NULL;
        sc->lang_text = NULL;
    
        APP_UtilShortcutCreateAppShortcut( ev_st, app, 0xFF10 );
    }

    return RESULT_OK;
}



WCHAR* SplitPath( WCHAR* path, WCHAR* spliter ) 
{
	int j = u_strlen(path)-2;
	while( j > 0 ) 
	{
		if ( !u_strncmp(path+j, spliter, 1) ) 
		{
			return path+j+1;
		}
		j--;
	}
	return path;
}

UINT32 GetResourceString(WCHAR *str, RESOURCE_ID resID)
{
	UINT32 resource_size;
	DRM_GetResourceLength(resID, &resource_size);
	if(resource_size > 0) DRM_GetResource(resID, str, resource_size);
	return RESULT_OK;
}

UINT32 ClearBuf(WCHAR *buf, UINT32 size)
{
   UINT32 i;
   for (i=u_strlen(buf); i < size; i++) {
       buf[i] = 0;
   }
   return RESULT_OK;
}
