#include "ELF.h"

 UINT8 Percent1 = 15;
 UINT8 Percent2 = 50;
 UINT8 Percent3 = 75;
 UINT8 Percent4 = 90;
 UINT8 Percent5 = 100;

 UINT32 time1; // 
 UINT32 time2; // 

 
BOOL exitN1;
BOOL exitN2;
BOOL exitN3;

UINT8 keyexitN1;
UINT8 keyexitN2;
UINT8 keyexitN3;



/*  .        */
const char app_name[APP_NAME_LEN] = "Battery"; 


//     state-

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    { EV_KEY_PRESS,             HandleKeypress },

	{ EV_TIMER_EXPIRED,       		     Timer },

    //      
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { STATE_HANDLERS_END,           NULL           },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }

};


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 				status = RESULT_OK;
	UINT32              evcode_base;
	WCHAR				nameCfgFile[256];
	
	UINT8 bufR[10];
	UINT32 readen;
	FILE_HANDLE_T f;
    

    evcode_base = reserve;    //  reserve
	 
	

/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)startApp );   // ,   
                   
		
		u_atou(file_uri, nameCfgFile);
		nameCfgFile[u_strlen(nameCfgFile)-3] = 0;
		u_strcat(nameCfgFile, L"cfg");	
		
		if (DL_FsFFileExist( nameCfgFile)) //    
		{
			f = DL_FsOpenFile(nameCfgFile, FILE_READ_MODE, 0);
			DL_FsReadFile( bufR, 5, 2, f, &readen );
			DL_FsCloseFile(f);
			
			
			Percent1 = bufR[0];
			Percent2 = bufR[1];
			Percent3 = bufR[2];
			Percent4 = bufR[3];
			Percent5 = bufR[4];

            time1 = bufR[5]*1000;
            time2 = bufR[6]*1000;
				
				keyexitN1 = bufR[7];
				keyexitN2 = bufR[8];
				keyexitN3 = bufR[9];
		}	
		
		
		
    LdrStartApp(reserve);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;
	


    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
    {
        return RESULT_FAIL; //     
    }
    else
    {
        //    
        app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEventPrepost, //    
                                                  sizeof(APP_HELLOWORLD_T), //   
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                                  2, 0, 0 );
                                                  

        status = APP_Start( ev_st,
                            &app->apt,
                            HW_STATE_MAIN, //  
                            state_handling_table,
                            destroyApp,
                            app_name,
                            0 );
		
		
		
		APP_UtilStartCyclicalTimer( time1,  1,  app );
    }

    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

	APP_UtilStopTimer( app );
	HAPI_LP393X_set_tri_color_led( 0,  0x000 );
    /*    */
    status = APP_Exit( ev_st, app, NULL );
	
	
	
    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    return RESULT_OK;
}



	
/*  , EV_KEY_PRESS    */
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
	UINT8       keypress;
	
	
	keypress = event->data.key_pressed;
	
	if (keyexitN1 != 0 && keyexitN2 != 0 && keyexitN3 != 0)
	{
		if (exitN1)
		{
			if (exitN2)
			{
				if (!exitN3) if (keypress == keyexitN3) exitN3 = TRUE;
			}
			else
			{
				if (keypress == keyexitN2) exitN2 = TRUE;
			}
		}
		else
		{
			if (keypress == keyexitN1) exitN1 = TRUE;
		}

		if (keypress != keyexitN1 && keypress != keyexitN2 && keypress != keyexitN3 )
		{
			exitN1 = FALSE;
			exitN2 = FALSE;
			exitN3 = FALSE;
		}
	}		

	if(exitN1 & exitN2 & exitN3 ) return destroyApp(ev_st, app);
	
    return RESULT_OK;
}



UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
	UINT32	id = ((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID;
	
	char *offset = (char*)0x127d0f41;
	UINT8 BatLev;
	
	if (id == 1)
	{
	
		if (*offset < MIN_BAT) 
		{
			BatLev = 0;
		}
		else
		{
			if (*offset > MAX_BAT) 
			{
				BatLev = 100;
			}
			else
			{
				BatLev = (UINT16)(((*offset - MIN_BAT) * 100))/(MAX_BAT - MIN_BAT);
			}
		}
		

		PFprintf ("Battery = %d\n", BatLev);

        if (!APP_MMC_Util_IsVoiceCall())
        {
             if (BatLev <= Percent5) HAPI_LP393X_set_tri_color_led( 0,  0x0F0 ); //  
             if (BatLev <= Percent4) HAPI_LP393X_set_tri_color_led( 0,  0x7F0 ); //  
             if (BatLev <= Percent3) HAPI_LP393X_set_tri_color_led( 0,  0xFF0 ); // 
             if (BatLev <= Percent2) HAPI_LP393X_set_tri_color_led( 0,  0xF70 ); // 		
             if (BatLev <= Percent1) HAPI_LP393X_set_tri_color_led( 0,  0xF00 ); // 
        }

            APP_UtilStopTimer( app );
            APP_UtilStartCyclicalTimer( time2,  2,  app );
	} 
	else if (id == 2)
    {
        HAPI_LP393X_set_tri_color_led( 0,  0x000 ); //  
        APP_UtilStopTimer( app );
        APP_UtilStartCyclicalTimer( time1,  1,  app );
    }
	return RESULT_OK;
}



