#ifndef MidTransfer_H
#define MidTransfer_H

#include <apps.h>


/*    .      */
typedef struct
{ 
    APPLICATION_T           apt; /*   ,   */
    UINT8                   state;
    UINT32                  item;
    

    /*      */
    /* ... */

} APP_BACKUPER_T;

/*   */
typedef enum
{
    BP_STATE_ANY, /* ANY-state   */

    BP_STATE_INIT,
    BP_STATE_MAIN,
    BP_STATE_BACKUP,
    BP_STATE_RESTORE,

    BP_STATE_CONF,
    BP_STATE_MSG,

    BP_STATE_MAX /*   */
} BP_STATES_T;

typedef enum
{
	RES_LIST_CAPTION=0,
	RES_ACTION1,
	RES_MAX
} BP_RESOURCE;

// 
typedef enum
{
    MAIN_BACKUP = 1,
    MAIN_RESTORE,
    MAIN_MAX=MAIN_RESTORE
} MAIN_ITEMS_T;

typedef enum
{
    BACKUP_SMS=1,
    BACKUP_PHONEBOOK,
    BACKUP_SHORTCUT,
    BACKUP_PDS,
    BACKUP_MAX = BACKUP_PDS
} BACKUP_ITEMS_T;

typedef enum
{
    RESTORE_SMS = 1,
    RESTORE_PHONEBOOK,
    RESTORE_SHORTCUT,
    RESTORE_MAX = RESTORE_SHORTCUT
} RESTORE_ITEMS_T;

/*     */
RESOURCE_ID Resources[RES_MAX];


UINT32 Register( char* file_uri,  char* param,  UINT32 reserve );

UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 );
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app );

UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 BackupStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 RestoreStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 ConfStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 MsgStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type );

UINT32 No( EVENT_STACK_T *ev_st,  void *app );
UINT32 Yes( EVENT_STACK_T *ev_st,  void *app );

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app );
UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app );
UINT32 HandleAction( EVENT_STACK_T *ev_st,  void *app );
UINT32 HandleAction( EVENT_STACK_T *ev_st,  void *app );
UINT32 Back( EVENT_STACK_T *ev_st,  void *app );
UINT32 SelectItem( EVENT_STACK_T *ev_st,  void *app );
UINT32 SelectItem_Backup( EVENT_STACK_T *ev_st,  void *app );
UINT32 SelectItem_Restore( EVENT_STACK_T *ev_st,  void *app );

UINT32 InitDlgActions( ACTIONS_T *action_list );
UINT32 InitResources( void );
UINT32 RemoveResources( void );


UINT32 SendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num);

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app );
UINT32 MessageOpen( EVENT_STACK_T *ev_st,  void *app );
UINT32 MessageClose( EVENT_STACK_T *ev_st,  void *app, UINT32 status );

//  PDS
UINT32 Backup_PDS(WCHAR *folder);
//  
UINT32 Backup_Shortcut(WCHAR *folder);
//  
UINT32 Backup_Phonebook(void *app, WCHAR *folder);
UINT32 Read_PbRecord( EVENT_STACK_T *ev_st,  void *app );
//  
UINT32 Backup_Sms(WCHAR *folder);
//    
UINT32 Backup_Seem_AllRecords(UINT16 seem, WCHAR *folder);
//    
UINT32 Backup_Seem_Record(UINT16 seem, UINT16 record, WCHAR *folder);
//  
UINT32 Backup_File(WCHAR *src, WCHAR *folder);

//  
UINT32 Restore_Shortcut(WCHAR *folder);
//  
UINT32 Restore_Phonebook(void *app, WCHAR *folder);
//  
UINT32 Restore_Sms(WCHAR *folder);
//    
UINT32 Restore_Seem_AllRecords(UINT16 seem, WCHAR *folder);
//    
UINT32 Restore_Seem_Record(UINT16 seem, UINT16 record, WCHAR *folder);
//  
UINT32 Restore_File(WCHAR *dst, WCHAR *folder);

//  
UINT32 CopyFile(WCHAR * src, WCHAR * dst );


WCHAR* SplitPath( WCHAR* path, WCHAR* spliter ); 
WCHAR* dec2hex( UINT16 dec, WCHAR *hex );
void u_PFprintf(char* format, WCHAR* s1) ;

#endif
