#include "Backuper.h"
#include <dbg.h>

UINT32  ENTRIES_NUM = 2;		

WCHAR   FolderElf[256];

UINT16  num_rec=0; //   
UINT16  count_rec=0; // -  
UINT16  count_total_rec=0; // -   


UINT8                   flag; // 0 - , 1 - 

/*  .        */
const char app_name[APP_NAME_LEN] = "Backuper"; 

/*     state- */

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    /* GUI-     */
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    { EV_TIMER_EXPIRED,       		         Timer },
    { EV_PHONEBOOK_READ_RECORD,      Read_PbRecord },
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    /*   ,      UI */
    { EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};

EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { EV_DIALOG_DONE,                   destroyApp },
    { EV_REQUEST_LIST_ITEMS,        HandleListReq  },
    /* STATE_HANDLERS_RESERVED ,   - ,  
          ,      
        . LdrInitEventHandlersTbl, LdrFindEventHandlerTbl */
    { STATE_HANDLERS_RESERVED,        HandleAction },
    { EV_DONE,                          destroyApp },
    { EV_SELECT,                        SelectItem },
    { STATE_HANDLERS_END,                     NULL },
};

EVENT_HANDLER_ENTRY_T backup_state_handlers[] =
{
    { EV_DIALOG_DONE,                   destroyApp },
    { EV_REQUEST_LIST_ITEMS,        HandleListReq  },

    { EV_DONE,                          Back },
    { EV_SELECT,                        SelectItem_Backup },
    { STATE_HANDLERS_END,                     NULL },
};

EVENT_HANDLER_ENTRY_T restore_state_handlers[] =
{
    { EV_DIALOG_DONE,                   destroyApp },
    { EV_REQUEST_LIST_ITEMS,        HandleListReq  },

    { EV_DONE,                          Back },
    { EV_SELECT,                        SelectItem_Restore },
    { STATE_HANDLERS_END,                     NULL },
};

EVENT_HANDLER_ENTRY_T conf_state_handlers[] =
{
    { EV_NO,            					    No },
	{ EV_YES,            					   Yes },
    { STATE_HANDLERS_END,                     NULL },
};

EVENT_HANDLER_ENTRY_T msg_state_handlers[] =
{

    { STATE_HANDLERS_END,                     NULL },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { BP_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { BP_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },
    
    { BP_STATE_MAIN,
      MainStateEnter,
      StateExit,
      main_state_handlers
    },

    { BP_STATE_BACKUP,
      BackupStateEnter,
      StateExit,
      backup_state_handlers
    },

    { BP_STATE_RESTORE,
      RestoreStateEnter,
      StateExit,
      restore_state_handlers
    },

    { BP_STATE_CONF,
      ConfStateEnter,
      StateExit,
      conf_state_handlers
    },

    { BP_STATE_MSG,
      MsgStateEnter,
      StateExit,
      msg_state_handlers
    }
};

/*      elfpack- */
UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T *tbl,  UINT32 *base )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].code==STATE_HANDLERS_RESERVED)	
		{
			tbl[i].code = (*base)++;
		}
		i++;
	}
	return *base;
}

UINT32 LdrFindEventHandlerTbl( EVENT_HANDLER_ENTRY_T *tbl,  EVENT_HANDLER_T *hfn )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].hfunc==hfn)	
		{
			return tbl[i].code;
		}
		i++;
	}

	return 0;
}


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    /*       ""  */
    UINT32              evcode_base;
    UINT32              status = RESULT_OK;
    UINT32              i;
	
    evcode_base = reserve;    //  reserve
	//    ,   STATE_HANDLERS_RESERVED
	LdrInitEventHandlersTbl( main_state_handlers, &evcode_base );
    

    /*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           BP_STATE_MAX,            //  
                           (void*)startApp );   // ,   

    //   
    u_atou(file_uri, FolderElf);
    for (i=u_strlen(FolderElf)-1; i > 0; i--)
        if (FolderElf[i] == '/') break;
    FolderElf[i+1] = 0;

                 
    LdrStartApp(evcode_base);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_BACKUPER_T     *app = NULL;
    UINT32 status = RESULT_OK;


    /*     */
    app = (APP_BACKUPER_T*)APP_InitAppData( (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_BACKUPER_T), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );

	/*   */
	status = InitResources();

    status = APP_Start( ev_st,
                        &app->apt,
                        BP_STATE_INIT, //  
                        state_handling_table,
                        destroyApp,
                        app_name,
                        0 );


    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

	/*   */
	RemoveResources();

    /*    */
    status = APP_Exit( ev_st, app, 0 );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    main state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    UIS_DIALOG_T            dialog = 0;
	UINT32					starting_num;
	//ACTIONS_T				action_list; // 

	if(type!=ENTER_STATE_ENTER) return RESULT_OK;

	//InitDlgActions( &action_list );

    ENTRIES_NUM = MAIN_MAX;
	
	dialog = UIS_CreateList( &port,
							 0,
							 ENTRIES_NUM,
							 0,
							 &starting_num,
							 0,
							 2,
							 NULL,
							 Resources[RES_LIST_CAPTION] );
  
   
    if(dialog == 0) return RESULT_FAIL;
    papp->dialog = dialog;

	//   ,     starting_num 
	SendListItems(ev_st, app, 1, starting_num);

    return RESULT_OK;
}

/*    backup state */
UINT32 BackupStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    UIS_DIALOG_T            dialog = 0;
	UINT32					starting_num;
	//ACTIONS_T				action_list; // 

	if(type!=ENTER_STATE_ENTER) return RESULT_OK;

	//InitDlgActions( &action_list );

    ENTRIES_NUM=BACKUP_MAX;
	
	dialog = UIS_CreateList( &port,
							 0,
							 ENTRIES_NUM,
							 0,
							 &starting_num,
							 0,
							 2,
							 NULL,
							 Resources[RES_LIST_CAPTION] );
  
   
    if(dialog == 0) return RESULT_FAIL;
    papp->dialog = dialog;

	//   ,     starting_num 
	SendListItems(ev_st, app, 1, starting_num);

    return RESULT_OK;
}

/*    restore state */
UINT32 RestoreStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    UIS_DIALOG_T            dialog = 0;
	UINT32					starting_num;
	//ACTIONS_T				action_list; // 

	if(type!=ENTER_STATE_ENTER) return RESULT_OK;

    ENTRIES_NUM=RESTORE_MAX;
	//InitDlgActions( &action_list );
	
	dialog = UIS_CreateList( &port,
							 0,
							 ENTRIES_NUM,
							 0,
							 &starting_num,
							 0,
							 2,
							 NULL,
							 Resources[RES_LIST_CAPTION] );
  
   
    if(dialog == 0) return RESULT_FAIL;
    papp->dialog = dialog;

	//   ,     starting_num 
	SendListItems(ev_st, app, 1, starting_num);

    return RESULT_OK;
}

UINT32 ConfStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    CONTENT_T               content;
    UIS_DIALOG_T            dialog = 0;


	if(type!=ENTER_STATE_ENTER) return RESULT_OK;
    
    UIS_MakeContentFromString("MCq0", &content, L"Reboot ?");
    
    dialog = UIS_CreateConfirmation( &port, &content);

    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;

    return RESULT_OK;
}

UINT32 MsgStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    UIS_DIALOG_T            dialog = 0;
    CONTENT_T               content;

    if(type!=ENTER_STATE_ENTER) return RESULT_OK;

    UIS_MakeContentFromString("MCs0", &content, LANG_WAIT); 
    
    dialog = UIS_CreateTransientNotice( &port, &content,  NOTICE_TYPE_WAIT );

    if(dialog == 0) return RESULT_FAIL;
    papp->dialog = dialog;

   
    return RESULT_OK;
}

UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}


UINT32 Yes( EVENT_STACK_T *ev_st,  void *app )
{
    // 
    HAPI_WATCHDOG_soft_reset();
    return RESULT_OK;
}


UINT32 No( EVENT_STACK_T *ev_st,  void *app )
{
	APP_BACKUPER_T  *papp = (APP_BACKUPER_T*)app;

    APP_UtilChangeState( papp->state, ev_st, app );

    return RESULT_OK;
}

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    //    
    status = APP_HandleUITokenGranted( ev_st, app );

    //   ,   state
    if( (status == RESULT_OK) && (papp->token_status == 2) )
    {
        status = APP_UtilChangeState( BP_STATE_MAIN, ev_st, app );
    }

    return status;
}


/* -  EV_REQUEST_LIST_ITEMS -   List    
          */
UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app )
{
	APPLICATION_T			*papp = (APPLICATION_T*) app;
	EVENT_T					*event;
	UINT32					start, num;

	//      "",      
	if( !papp->focused ) return RESULT_OK;

	//      
	event = AFW_GetEv( ev_st );

	start = event->data.list_items_req.begin_idx;
	num = event->data.list_items_req.count;

	//   ,     - ,      
	APP_ConsumeEv( ev_st, app );
	
	return SendListItems( ev_st, app, start, num );
}

UINT32 HandleAction( EVENT_STACK_T *ev_st,  void *app )
{
	APP_ConsumeEv( ev_st, app );
	
	/*     -  */
	return APP_Exit( ev_st, app, 0);
	
}


UINT32 Back( EVENT_STACK_T *ev_st,  void *app )
{
    APP_UtilChangeState( BP_STATE_MAIN, ev_st, app );
 
    return RESULT_OK;
}

UINT32 SelectItem( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32 index = (AFW_GetEv(ev_st))->data.index;
    APP_BACKUPER_T  *papp = (APP_BACKUPER_T*)app;


    switch(index)
    {
        case MAIN_BACKUP:  // Backup
           papp->state = papp->apt.state;
           APP_UtilChangeState( BP_STATE_BACKUP, ev_st, app );
        break;

        case MAIN_RESTORE:  // Restore
           papp->state = papp->apt.state;
           APP_UtilChangeState( BP_STATE_RESTORE, ev_st, app );
        break;
    }

    return RESULT_OK;
}

UINT32 SelectItem_Backup( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32 index = (AFW_GetEv(ev_st))->data.index;
    APP_BACKUPER_T  *papp = (APP_BACKUPER_T*)app;

    papp->item = index;

    MessageOpen(ev_st,app);

    return RESULT_OK;
}

UINT32 SelectItem_Restore( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32 index = (AFW_GetEv(ev_st))->data.index;
    APP_BACKUPER_T  *papp = (APP_BACKUPER_T*)app;

    papp->item = index;

    MessageOpen(ev_st,app);

    return RESULT_OK;
}


/*            */
UINT32 SendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
	APPLICATION_T			*papp = (APPLICATION_T*) app;
	LIST_ENTRY_T			*plist=NULL; //    
	UINT32					i, index, status=RESULT_OK;
    
    if( num==0 ) return RESULT_FAIL; //  ,   

	plist = (LIST_ENTRY_T*) malloc( sizeof(LIST_ENTRY_T)*num ); // malloc
	if( plist==NULL ) return RESULT_FAIL;

	//  
	for( index=0, i=start; (i<start+num) && (i<=ENTRIES_NUM); i++, index++)
	{
		plist[index].editable = FALSE;			//  
		plist[index].content.static_entry.unk6 = 1;
	}

    switch (papp->state)
    {
        case BP_STATE_MAIN:
            UIS_MakeContentFromString( "Mq0", &(plist[0].content.static_entry.text), L"Backup" );
            UIS_MakeContentFromString( "Mq0", &(plist[1].content.static_entry.text), L"Restore" );
            break;

        case BP_STATE_BACKUP:
            UIS_MakeContentFromString( "Mq0", &(plist[0].content.static_entry.text), L"SMS" );
            UIS_MakeContentFromString( "Ms0", &(plist[1].content.static_entry.text), LANG_PHONEBOOK );
            UIS_MakeContentFromString( "Ms0", &(plist[2].content.static_entry.text), LANG_SHORTCUTS );
            UIS_MakeContentFromString( "Mq0", &(plist[3].content.static_entry.text), L"PDS" );
            break;

        case BP_STATE_RESTORE:
            UIS_MakeContentFromString( "Mq0", &(plist[0].content.static_entry.text), L"SMS" );
            UIS_MakeContentFromString( "Ms0", &(plist[1].content.static_entry.text), LANG_PHONEBOOK );
            UIS_MakeContentFromString( "Ms0", &(plist[2].content.static_entry.text), LANG_SHORTCUTS );
            break;
    }

    

	//       ,    
	status = APP_UtilAddEvUISListData( ev_st, app, 0,
									   start, num,
									   FBF_LEAVE,
									   sizeof(LIST_ENTRY_T)*num,
									   plist );
	if( status!=RESULT_FAIL )
	{
		//        
		status = UIS_HandleEvent(papp->dialog, ev_st);
	}

	free(plist);

	return status;

}

/*           */
UINT32 InitResources( )
{
    RES_ACTION_LIST_ITEM_T		action;
    UINT32						status;

	const WCHAR list_caption[] = L"Backuper";

	/*     */
    status = DRM_CreateResource( &Resources[RES_LIST_CAPTION], RES_TYPE_STRING, (void*)list_caption, (u_strlen((WCHAR*)list_caption)+1)*sizeof(WCHAR) );
	if( status!=RESULT_OK ) return status;

	/*    */
    action.softkey_label = 0;			//      
    action.list_label = 0x01001B77;		//     
    action.softkey_priority = 0;
    action.list_priority = 1;			//     , ..        ,   0,     
    action.isExit = FALSE;
    action.sendDlgDone = FALSE;

    status = DRM_CreateResource( &Resources[RES_ACTION1], RES_TYPE_ACTION, (void*)&action, sizeof(RES_ACTION_LIST_ITEM_T));
	if( status!=RESULT_OK ) DRM_ClearResource( Resources[RES_LIST_CAPTION] );
    return status;
}

/*        */
UINT32 RemoveResources( )
{
	UINT32				status = RESULT_OK;
	UINT32				i;

	for(i=0;i<RES_MAX;i++)
	{
		status |= DRM_ClearResource( Resources[i] );
	}

	return status;

}

/*   */
UINT32 InitDlgActions( ACTIONS_T *action_list )
{
	/*  -           */
	
	/*    -    ,     
		      . */

	/*     (,   ) */
	/*   List       .  - ""  "",
		EV_DONE  EV_SELECT .        . */


	/*          */	
    action_list->action[0].operation = ACTION_OP_ADD; 
	/*         STATE_HANDLERS_RESERVED,        */
    action_list->action[0].event = LdrFindEventHandlerTbl( main_state_handlers, HandleAction ); //       
    action_list->action[0].action_res = Resources[RES_ACTION1]; // ,  

	/*      */
    action_list->count = 1;

    return RESULT_OK;
}

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
    APP_BACKUPER_T  *papp = (APP_BACKUPER_T*)app;
    UINT32  status=0;

	if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 1)
	{
        if (papp->state == BP_STATE_RESTORE) {
            switch (papp->item) {
                case RESTORE_SMS:  // Restore Sms
                   status=Restore_Sms(L"SMS/");
                   MessageClose(ev_st,app,status);
                break;

                 case RESTORE_PHONEBOOK:  //  
                   status=Restore_Phonebook(app, L"Phonebook/");
                   MessageClose(ev_st,app,RESULT_FAIL);
                break;
        
                case RESTORE_SHORTCUT:  //  
                   status=Restore_Shortcut(L"Shortcut/");
                   MessageClose(ev_st,app,status);
                break;
            }

        } else if (papp->state == BP_STATE_BACKUP) {
            switch(papp->item)
            {
                case BACKUP_SMS:  // Backup Sms
                    Backup_Sms(L"SMS/");
                    MessageClose(ev_st,app,status);
                break;
        
                case BACKUP_PHONEBOOK:  // Backup  
                   Backup_Phonebook(app, L"Phonebook/");
                break;
        
                case BACKUP_SHORTCUT:  // Backup 
                   Backup_Shortcut(L"Shortcut/");
                   MessageClose(ev_st,app,status);
                break;
        
                case BACKUP_PDS: 
                    Backup_PDS(L"PDS/");
                    MessageClose(ev_st,app,status);
                break;
            }
        }


        
	}
	
	return RESULT_OK;
}


UINT32 MessageOpen( EVENT_STACK_T *ev_st,  void *app )
{
    APP_BACKUPER_T  *papp = (APP_BACKUPER_T*)app;

    APP_UtilStartTimer( 1000,  1,  app );
    papp->state=papp->apt.state;
    APP_UtilChangeState( BP_STATE_MSG, ev_st, app );
    return RESULT_OK;
}

UINT32 MessageClose( EVENT_STACK_T *ev_st,  void *app, UINT32 status )
{
    APP_BACKUPER_T  *papp = (APP_BACKUPER_T*)app;

    dbg("status = %d", status);

    if ( status == RESULT_OK && papp->state == BP_STATE_RESTORE) {
        APP_UtilChangeState( BP_STATE_CONF, ev_st, app );
    } else {
        APP_UtilChangeState( papp->state, ev_st, app );
    }


    return RESULT_OK;
}

//  PDS
UINT32 Backup_PDS(WCHAR *folder)
{
    void*           adr_PDS = (void*)0x10010000;
    UINT32          wr = 0;
    FILE_HANDLE_T   f;
    WCHAR           uri[256];

    u_strcpy(uri, FolderElf);
    u_strcat(uri, folder);
    DL_FsMkDir(uri,  0); //  
    u_strcat(uri, L"PDS.smg");


    f = DL_FsOpenFile( uri,  FILE_WRITE_MODE,  NULL );
    DL_FsWriteFile( adr_PDS, 1,  65536, f, &wr);
    DL_FsCloseFile(f);

    return RESULT_OK;
}

//  
UINT32 Backup_Shortcut(WCHAR *folder)
{
    UINT32  status=0;

    status=Backup_Seem_AllRecords(0x0002, folder);
    status=Backup_Seem_Record(0x0157, 1, folder);

    return status;
}

//  
UINT32 Restore_Shortcut(WCHAR *folder)
{
    UINT32  status=0;

    status=Restore_Seem_AllRecords(0x0002, folder);
    status=Restore_Seem_Record(0x0157, 1, folder);

    return status;
}

//  
UINT32 Backup_Phonebook(void *app, WCHAR *folder)
{
    UINT32  status=0;
    WCHAR                           uri[256];
    IFACE_DATA_T if_data;
    if_data.port = ((APPLICATION_T*)app)->port;
/*
    status=Backup_Seem_AllRecords(0x003D, folder);
    status=Backup_Seem_AllRecords(0x003E, folder);
    status=Backup_Seem_AllRecords(0x003F, folder);
    status=Backup_Seem_AllRecords(0x0040, folder);
    status=Backup_Seem_AllRecords(0x0041, folder);
    status=Backup_Seem_AllRecords(0x0042, folder);
    status=Backup_Seem_AllRecords(0x0043, folder);
    status=Backup_Seem_AllRecords(0x0044, folder);
    status=Backup_Seem_AllRecords(0x0045, folder);
    status=Backup_Seem_AllRecords(0x01A9, folder);
    status=Backup_Seem_AllRecords(0x0183, folder);
    status=Backup_Seem_AllRecords(0x0232, folder);
    status=Backup_Seem_AllRecords(0x0233, folder);
    status=Backup_Seem_AllRecords(0x0234, folder);
    status=Backup_Seem_AllRecords(0x0235, folder);
    status=Backup_Seem_AllRecords(0x0236, folder);
    status=Backup_Seem_AllRecords(0x0259, folder);
    status=Backup_Seem_AllRecords(0x0080, folder);
    status=Backup_Seem_AllRecords(0x007F, folder);
    status=Backup_Seem_AllRecords(0x022A, folder);

    status=Backup_File(L"file://a/DL_DMH_File", folder);
*/	
    num_rec = 1;
    count_rec = 0;
    flag = 0;

            //   
        u_strcpy(uri, FolderElf);
        u_strcat(uri, folder);
        DL_FsMkDir(uri,  0); //  
        u_strcat(uri, L"records.pb");
        if (DL_FsFFileExist(uri)) DL_FsDeleteFile(uri, 0);

         u_strcpy(uri, FolderElf);
        u_strcat(uri, folder);
        u_strcat(uri, L"categoryes.pb");
        if (DL_FsFFileExist(uri)) DL_FsDeleteFile(uri, 0);

    DL_DbPhoneBookGetUsedRecords ( 0,
                                   PHONEBOOK_DEVICE_PHONE, 
								   &count_total_rec,
                                   0 );

    dbg("count_total_rec = %d", count_total_rec);

      status =  DL_DbPhoneBookGetRecordByIndex ( &if_data,
									 0, 
									 num_rec, //  
									 1,
									 0 ); 

    return status;
}

UINT32 Read_PbRecord( EVENT_STACK_T *ev_st,  void *app )
{
    UINT8 *attach = AFW_GetEv(ev_st)->attachment;
    UINT16 attach_size = AFW_GetEv(ev_st)->att_size;


        FILE_HANDLE_T                   f;
        UINT32                          w;
        WCHAR                           uri[256];
        WCHAR                           folder[] = L"Phonebook/";

   IFACE_DATA_T if_data;
   if_data.port = ((APPLICATION_T*)app)->port;

   dbg("pb_rec result = %d", attach[0]);

    if (attach[0] == 0)
    {
        //   
        u_strcpy(uri, FolderElf);
        u_strcat(uri, folder);
        
        if (flag == 1) {
            u_strcat(uri, L"categoryes.pb");
        } else {
            u_strcat(uri, L"records.pb");
        }
        

        attach_size -= 4;

        //   
        f = DL_FsOpenFile(uri,  FILE_APPEND_PLUS_MODE, 0);
        DL_FsWriteFile(&attach_size, sizeof(UINT16), 1, f, &w);
        DL_FsWriteFile(attach+4, attach_size, 1, f, &w);
        DL_FsCloseFile(f);

        count_rec ++;
    }

    if (count_rec >= count_total_rec) {
        if (flag == 0) {
                flag = 1;
                count_rec = 0; 
                num_rec = 0;
                    DL_DbPhoneBookGetNumberofCategories( 0,
                                                    PHONEBOOK_DEVICE_PHONE,
                                                    &count_total_rec );

        
        } else {
            return MessageClose(ev_st,app,RESULT_FAIL);
        }
    }

    num_rec++;

    if (flag == 1) {

        DL_DbPhoneBookGetCategoryRecordByIndex( &if_data, 
											   0,
											   PHONEBOOK_DEVICE_PHONE,
											   num_rec );

    } else {
    
        DL_DbPhoneBookGetRecordByIndex ( &if_data,
                                         0, 
                                         num_rec, //  
                                         1,
                                         0 ); 
    }

    return RESULT_OK;
}

//  
UINT32 Restore_Phonebook(void *app, WCHAR *folder)
{
        FILE_HANDLE_T                   f;
        UINT32                          r;
        WCHAR                           uri[256];


        UINT16  size_rec;
        UINT8   *record=NULL;

        UINT16  all_size=0, file_size=1;

   IFACE_DATA_T if_data;
   if_data.port = ((APPLICATION_T*)app)->port;
    /*
    //    :(
    Restore_Seem_AllRecords(0x003D, folder);
    Restore_Seem_AllRecords(0x003E, folder);
    Restore_Seem_AllRecords(0x003F, folder);
    Restore_Seem_AllRecords(0x0040, folder);
    Restore_Seem_AllRecords(0x0041, folder);
    Restore_Seem_AllRecords(0x0042, folder);
    Restore_Seem_AllRecords(0x0043, folder);
    Restore_Seem_AllRecords(0x0044, folder);
    Restore_Seem_AllRecords(0x0045, folder);
    Restore_Seem_AllRecords(0x01A9, folder);
    Restore_Seem_AllRecords(0x0183, folder);
    Restore_Seem_AllRecords(0x0232, folder);
    Restore_Seem_AllRecords(0x0233, folder);
    Restore_Seem_AllRecords(0x0234, folder);
    Restore_Seem_AllRecords(0x0235, folder);
    Restore_Seem_AllRecords(0x0236, folder);
    Restore_Seem_AllRecords(0x0259, folder);
    Restore_Seem_AllRecords(0x0080, folder);
    Restore_Seem_AllRecords(0x007F, folder);
    Restore_Seem_AllRecords(0x022A, folder);

    Restore_File(L"file://a/DL_DMH_File", folder);
*/
   
            //   
            u_strcpy(uri, FolderElf);
            u_strcat(uri, folder);
            u_strcat(uri, L"records.pb");


            f = DL_FsOpenFile(uri,  FILE_READ_MODE, 0);
            if (f ==  FILE_HANDLE_INVALID ) return RESULT_FAIL;

            file_size = DL_FsGetFileSize(f);

            while (all_size != file_size) {
                DL_FsReadFile(&size_rec, sizeof(UINT16), 1, f, &r);
                record = malloc(size_rec);
                DL_FsReadFile(record, size_rec, 1, f, &r);
                

                all_size = all_size + 2 + size_rec;
    
                DL_DbPhoneBookStoreRecord ( &if_data, 
                                            0,
                                            record, 
                                            0 );

                free(record);
            }

            DL_FsCloseFile(f);

            u_strcpy(uri, FolderElf);
            u_strcat(uri, folder);
            u_strcat(uri, L"categoryes.pb");
           
                
             f = DL_FsOpenFile(uri,  FILE_READ_MODE, 0);
            if (f ==  FILE_HANDLE_INVALID ) return RESULT_FAIL;

            all_size = 0;
            file_size = DL_FsGetFileSize(f);

            while (all_size != file_size) {
                DL_FsReadFile(&size_rec, sizeof(UINT16), 1, f, &r);
                record = malloc(size_rec);
                DL_FsReadFile(record, size_rec, 1, f, &r);
                

                all_size = all_size + 2 + size_rec;

                DL_DbPhoneBookStoreCategoryRecord (  &if_data,
											0,
											PHONEBOOK_DEVICE_PHONE,
											record,
											NULL );


                free(record);
            }    
            
        DL_FsCloseFile(f);



    return RESULT_OK;
}

//  
UINT32 Backup_Sms(WCHAR *folder)
{
    UINT32  status=0;

    status=Backup_Seem_AllRecords(0x007D, folder);
    status=Backup_Seem_AllRecords(0x0144, folder);

    return status;
}

//  
UINT32 Restore_Sms(WCHAR *folder)
{
    UINT32  status=0;

    status=Restore_Seem_AllRecords(0x007D, folder);
    status=Restore_Seem_AllRecords(0x0144, folder);

    return status;
}

//    
UINT32 Backup_Seem_AllRecords(UINT16 seem, WCHAR *folder)
{
    UINT32      i;
    UINT32  status=0;

    for (i=1; i <= SEEM_MAX_RECORD_get_max_record(seem); i++) {
        status=Backup_Seem_Record(seem, i, folder);
    }
    
    return status;
}

//    
UINT32 Restore_Seem_AllRecords(UINT16 seem, WCHAR *folder)
{
    UINT32      i;
    UINT32  status=0;

    for (i=1; i <= SEEM_MAX_RECORD_get_max_record(seem); i++) {
        status=Restore_Seem_Record(seem, i, folder);
    }
    
    return status;
}

//    
UINT32 Backup_Seem_Record(UINT16 seem, UINT16 record, WCHAR *folder)
{
    SEEM_ELEMENT_DATA_CONTROL_T     seem_data;
	UINT8                           *data_buf=NULL;

    FILE_HANDLE_T                   f;
    UINT32                          written;
    WCHAR                           uri[256];
    WCHAR                           val_buf[16];

    dbg("backup %x_ %d seem", seem, record);

    seem_data.seem_element_id = seem;
	seem_data.seem_record_number = record;
	seem_data.seem_offset = 0;

    //   
	seem_data.seem_size = SEEM_GET_ADDRESS_LENGTH_element_length(seem);
    dbg("seem_size = %d", seem_data.seem_size);
		
	data_buf = (UINT8*) malloc(seem_data.seem_size);

    //  
	SEEM_ELEMENT_DATA_read (&seem_data, data_buf, true);

    //   
    u_strcpy(uri, FolderElf);
    u_strcat(uri, folder);
    DL_FsMkDir(uri,  0); //  
    dec2hex(seem,  val_buf);
    u_strcat(uri, val_buf);
    u_strcat(uri, L"_");
    dec2hex(record,  val_buf);
    u_strcat(uri, val_buf);
    u_strcat(uri, L".seem");

    //   
    f = DL_FsOpenFile(uri,  FILE_WRITE_EXIST_MODE, 0);
    DL_FsWriteFile(data_buf, seem_data.seem_size, 1, f, &written);
    DL_FsCloseFile(f);


    free(data_buf);

    return RESULT_OK;
}



//    
UINT32 Restore_Seem_Record(UINT16 seem, UINT16 record, WCHAR *folder)
{
    SEEM_ELEMENT_DATA_CONTROL_T     seem_data;
	UINT8                           *data_buf=NULL;

    FILE_HANDLE_T                   f;
    UINT32                          read;
    UINT32                          fSize;
    WCHAR                           uri[256];
    WCHAR                           val_buf[16];

    dbg("restore %x_%x seem", seem, record);

    //   
    u_strcpy(uri, FolderElf);
    u_strcat(uri, folder);
    
    dec2hex(seem,  val_buf);
    u_strcat(uri, val_buf);
    u_strcat(uri, L"_");
    dec2hex(record,  val_buf);
    u_strcat(uri, val_buf);
    u_strcat(uri, L".seem");

    if (!DL_FsFFileExist(uri)) return RESULT_FAIL;

    //   
    f = DL_FsOpenFile(uri, FILE_READ_MODE, 0);
    fSize = DL_FsGetFileSize(f);

    seem_data.seem_element_id = seem;
	seem_data.seem_record_number = record;
	seem_data.seem_offset = 0;
    seem_data.seem_size = fSize;
    
    data_buf = (UINT8*) malloc(fSize);
    DL_FsReadFile(data_buf, fSize, 1, f, &read);
    DL_FsCloseFile(f);

    //  
	SEEM_ELEMENT_DATA_write (&seem_data, data_buf);

    free(data_buf);

    return RESULT_OK;
}

//  
UINT32 Backup_File(WCHAR *src, WCHAR *folder)
{
    WCHAR                           uri[256];
    UINT32  status=0;

    dbg("backup file", NULL);

    u_strcpy(uri, FolderElf);
    u_strcat(uri, folder);
    DL_FsMkDir(uri,  0); //  
    u_strcat(uri, SplitPath(src, L"/"));

    status=CopyFile( src, uri );

    return status;
}

//  
UINT32 Restore_File(WCHAR *dst, WCHAR *folder)
{
    WCHAR                           uri[256];
    UINT32  status=0;

    dbg("restore file", NULL);

    u_strcpy(uri, FolderElf);
    u_strcat(uri, folder);
    u_strcat(uri, SplitPath(dst, L"/"));


    status=CopyFile( uri, dst );

    return status;
}

#define _BUF_SIZE               2<<12     // 0x2000 

UINT32 CopyFile( WCHAR *src, WCHAR *dst )
{
     char                    cbuf[_BUF_SIZE];     // Copy buffer
     FILE_HANDLE_T          fSrc, fDst;
     UINT32                    size;    

     //if ( DL_FsFFileExist(dst) )
     //     return RESULT_FAIL; 
     // 

     if ( !DL_FsFFileExist(src) )
          return RESULT_FAIL;     


     fSrc = DL_FsOpenFile( src, FILE_READ_MODE, NULL );
     fDst = DL_FsOpenFile( dst, FILE_WRITE_MODE, NULL );

     if ( fSrc == FILE_HANDLE_INVALID || fDst == FILE_HANDLE_INVALID ) {
          dbg("file no open", NULL);
          DL_FsCloseFile(fSrc);
          DL_FsCloseFile(fDst);
          return RESULT_FAIL;
     }

     dbg("CopyFile. _BUF_SIZE = %d bytes", _BUF_SIZE);

     size = _BUF_SIZE;
     while(size == _BUF_SIZE) {
          DL_FsReadFile( cbuf, 1, size, fSrc, &size );
          dbg("CopyFile. Readed %d bytes", size);
          DL_FsWriteFile( cbuf, 1, size, fDst, &size );
          dbg("CopyFile. Writed %d bytes", size);
     }
     
     
     DL_FsCloseFile(fSrc);
     DL_FsCloseFile(fDst);
     
     return RESULT_OK;
}



WCHAR* dec2hex( UINT16 dec, WCHAR *hex )
{

	UINT16 hex_buf[8];
	UINT16 len=0; 
	INT16 i; 

	if(dec==0)
	{	
		hex[0]='0';
		hex[1]= 0;

		return hex;
	}	

	while (dec != 0)
	{
		hex_buf[len] = dec%16;
		dec = dec/16;
		len ++;
	}
	
	len--;
	
	for (i=len; i >= 0; i--)
	{
	    if(hex_buf[i]<10) hex[len-i] = '0'+hex_buf[i];
	    else hex[len-i] = 'A'+hex_buf[i]-10;
	}   
	
	
	hex[len+1] = 0;

	
	return hex;
}

WCHAR* SplitPath( WCHAR* path, WCHAR* spliter ) 
{
	int j = u_strlen(path)-2;
	while( j > 0 ) 
	{
		if ( !u_strncmp(path+j, spliter, 1) ) 
		{
			return path+j+1;
		}
		j--;
	}
	return NULL;
}

void u_PFprintf(char* format, WCHAR* s1) 
{
	char* t = suAllocMem(u_strlen(s1)+1, NULL);
	u_utoa(s1, t);
	PFprintf(format, t);
	suFreeMem(t);
}
