#include "ELF.h"


UINT16 timeWait; //   
UINT16 timeWaitT; //    

//     
BOOL exitN1;
BOOL exitN2;
BOOL exitN3;

UINT8 keyexitN1;
UINT8 keyexitN2;
UINT8 keyexitN3;


/*  .        */
const char app_name[APP_NAME_LEN] = "AutoLock"; 


//     state-

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    

    //      
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
	{ EV_KEY_PRESS,             HandleKeypress },
	{ EV_KEY_RELEASE,         HandleKeyrelease },
	{ EV_TIMER_EXPIRED,       		     Timer },
    { STATE_HANDLERS_END,           NULL           },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }

};


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32              evcode_base;
    UINT32 				status = RESULT_OK;
	UINT32 				i;

    WCHAR nameCfgFile[256]; //   
    char buf[256];
    UINT8 bufR[5];
    UINT32 readen;
    FILE_HANDLE_T f;
	
    evcode_base = reserve;    //  reserve
    

/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)startApp );   // ,   
                   
	
		
		for (i=0; i < strlen(file_uri)-3; i++)
			buf[i] = file_uri[i];
		buf[i] = 0;

		
		strcat(buf, "cfg"); //   

        u_atou(buf, nameCfgFile);
  

                //    		
            if (DL_FsFFileExist(nameCfgFile)) //    
            {
                f = DL_FsOpenFile(nameCfgFile, FILE_READ_MODE, 0);
                DL_FsReadFile( bufR, 5, 1, f, &readen );
                DL_FsCloseFile(f);

                    timeWait = bufR[0]*0x100 + bufR[1];

                    keyexitN1 = bufR[2];
                    keyexitN2 = bufR[3];
                    keyexitN3 = bufR[4];
            }
			
			PFprintf("*ELF AutoLock*  timeWait = %d\n", timeWait);

    LdrStartApp(reserve);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;


    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
    {
        return RESULT_FAIL; //     
    }
    else
    {
        //    
        app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEventPrepost, //    
                                                  sizeof(APP_HELLOWORLD_T), //   
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                                  2, 0, 0 );
                                                  

        status = APP_Start( ev_st,
                            &app->apt,
                            HW_STATE_MAIN, //  
                            state_handling_table,
                            destroyApp,
                            app_name,
                            0 );

					
		if (timeWait != 0 ) 
			APP_UtilStartCyclicalTimer( 1000,  1,  app ); //  

    }

    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

	APP_UtilStopTimer( app );
    /*    */
    status = APP_Exit( ev_st, app, NULL );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    return RESULT_OK;
}

	
/*  , EV_KEY_PRESS    */
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
	UINT8       keypress;
	
	
	keypress = event->data.key_pressed;
	
	//     
	if (keyexitN1 != 0 && keyexitN2 != 0 && keyexitN3 != 0)
	{
		if (exitN1)
		{
			if (exitN2)
			{
				if (!exitN3) if (keypress == keyexitN3) exitN3 = TRUE;
			}
			else
			{
				if (keypress == keyexitN2) exitN2 = TRUE;
			}
		}
		else
		{
			if (keypress == keyexitN1) exitN1 = TRUE;
		}

		if (keypress != keyexitN1 && keypress != keyexitN2 && keypress != keyexitN3 )
		{
			exitN1 = FALSE;
			exitN2 = FALSE;
			exitN3 = FALSE;
		}
	}	
	
	timeWaitT=0;
	
	
		if (timeWait != 0 && !KeypadLock() )
		{
			APP_UtilStopTimer( app );
			APP_UtilStartCyclicalTimer( 1000,  1,  app );
		}

    if(exitN1 & exitN2 & exitN3) return destroyApp(ev_st, app);
    
    
    return RESULT_OK;
}

UINT32 HandleKeyrelease( EVENT_STACK_T *ev_st,  void *app )
{

	timeWaitT=0; //   
	
	return RESULT_OK;
}

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
    if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 1)
	{
		timeWaitT ++;

		if (timeWaitT >= timeWait && WorkingTable()) 
		{
			PFprintf("*ELF AutoLock*  Keypad Lock!\n");
			APP_UtilStopTimer( app );
			AFW_CreateInternalQueuedEvAux( EV_KEYPAD_LOCK, 0x64, 0, 0 ); //  
		}	
	}
	
	return RESULT_OK;
}

BOOL WorkingTable(void)
{
	UINT8 res;
	
	UIS_GetActiveDialogType(&res);
	
	if (res == 0xE) {
		return TRUE;
	} else {
		return FALSE;
	}	
}

BOOL KeypadLock(void)
{
	UINT8 keypad_statate;
	DL_DbFeatureGetCurrentState( DB_FEATURE_KEYPAD_STATE, &keypad_statate );
	return keypad_statate;
}	

