#ifndef FPAPARSER_H
#define FPAPARSER_H

#include <apps.h>



typedef struct {
	char 		*name;
	char		*value;
} PARAM_INFO_T;

typedef struct {
	UINT32 		adress;
	BYTE		*bytes;
	UINT32		count_bytes;
} PARAM_CODE_T;

typedef struct {
	PARAM_INFO_T	*info;
    UINT32          count_info;
	PARAM_CODE_T	*code;
    UINT32          count_code;
} FPA_FILE_T;

typedef enum {
    PARSE_OK,
    PARSE_FAIL,
    PARSE_UNK_SECTION,
    PARSE_FORMAT_FAIL,
    PARSE_MEM_FAIL,
    PARSE_FILE_FAIL

} RESULT_PARSE_T;

UINT32 ParseFpaFile(WCHAR *name, FPA_FILE_T *fpa_file);
UINT32 ParseBytes(BYTE *buf, UINT32 size, UINT32 cur_pos, PARAM_CODE_T *code);
void FreeFpaFile(FPA_FILE_T *fpa_file);
UINT32 GetSymbolPosition(BYTE *buf, UINT32 size, UINT32 cur_pos, char c);
void * alloc(UINT32 size);
void CopyStr(char *dst, char *src, UINT32 num);

#endif
