#include "fpaParser.h"
#include <dbg.h>


UINT32 ParseFpaFile(WCHAR *name, FPA_FILE_T *fpa_file) 
{
    FILE  	 		f;
    UINT32          r;
	BYTE 			*buf;
	UINT32			size;
	UINT32			i, j, k;
    UINT8			section=0;

    UINT32          n=0; //    
    char            temp_str[32];


	//   
	f = DL_FsOpenFile(name, FILE_READ_MODE, 0);
    if (f == FILE_INVALID) return PARSE_FILE_FAIL;
	size = DL_FsGetFileSize(f);
	buf = alloc(size);
	DL_FsReadFile(buf, 1, size, f, &r); 
	DL_FsCloseFile(f);
	
	i=0;
    j=0;
	section=0;
    memset(fpa_file,0,sizeof(FPA_FILE_T));

	while (i<size) {

        //    '['
        if (buf[i] == '[') {
                //   
				if (strncmp((char*)buf+i+1, "Patch_Info", 10) == 0) {
                    dbg("Patch_Info", NULL);
                    section=1;
                } else if (strncmp((char*)buf+i+1, "Patch_Code", 10) == 0) {
                    dbg("Patch_Code", NULL);
                    section=2;
                } else {
                    dbg("Unk", NULL);
                    return PARSE_UNK_SECTION;
                }
                i = GetSymbolPosition(buf, size, i, 0x0A);
                if (!i) return PARSE_FORMAT_FAIL;
                i++;
		}

		if (section == 1) { // Patch_Info

            //  -   
            if (fpa_file->count_info == 0) {
                n=0;
                k=i;
                while(true) {
                    j = GetSymbolPosition(buf,size,k,0x0A);
                    if (j-k > 4) fpa_file->count_info++;
                    if (j == 0 || buf[j+1] == '[') break;
                    k=j+1;
                }
                dbg("count_info = %d", fpa_file->count_info);
                fpa_file->info = alloc(fpa_file->count_info*sizeof(PARAM_INFO_T)); //     
                if (fpa_file->info == NULL){
                    return PARSE_MEM_FAIL;
                }
            }
            
            j = GetSymbolPosition(buf,size,i,'='); //   
            if (j != 0) {
            //   
               fpa_file->info[n].name = alloc(j-i+1);
               CopyStr((char*)(buf+i), fpa_file->info[n].name, j-i);
               dbg("name = %s", fpa_file->info[n].name);
               i = j+1;
               //   
               j = GetSymbolPosition(buf,size,i,0x0D);
               if (j == 0) j = size;
                   //   
                   fpa_file->info[n].value = alloc(j-i+1);
                   CopyStr((char*)(buf+i), fpa_file->info[n].value, j-i);
                   dbg("value = %s", fpa_file->info[n].value);
                   i = j+1;
                   n++;
               
            }
             

		} else if (section == 2) { // Patch_Code

            //  -   
            if (fpa_file->count_code == 0) {
                n=0;
                k=i;
                while(true) {
                    j = GetSymbolPosition(buf,size,k,0x0A);
                    if (j == 0) j = size;
                    if (j-k > 4) fpa_file->count_code++;
                    if (j == size || buf[j+1] == '[') break;
                    k=j+1;
                }
                dbg("count_code = %d", fpa_file->count_code);
                fpa_file->code = alloc(fpa_file->count_code*sizeof(PARAM_CODE_T)); //     
                if (fpa_file->code == NULL){
                    return PARSE_MEM_FAIL;
                }
            }

            j = GetSymbolPosition(buf,size,i,':'); //   
            if (j != 0){
               //  
               CopyStr((char*)(buf+i), temp_str, j-i);
               fpa_file->code[n].adress =  strtoul(temp_str, NULL, 16);
               dbg("num code = %d",n);
               dbg("adress = 0x%x", fpa_file->code[n].adress);
               i = j+1;
               //  
               j = ParseBytes(buf, size, i, fpa_file->code+n);
               
               if (j == 0) j = size;
               i = j;
               n++;
            }
		}

		i++;
	}
    
	free(buf);
    return PARSE_OK;
}



//   
UINT32 ParseBytes(BYTE *buf, UINT32 size, UINT32 cur_pos, PARAM_CODE_T *code)
{
    UINT32 j=cur_pos;
    UINT32 n=0;
    UINT32 i=0;
    char   str_byte[4];

    
    while (true) {
        if (buf[j] == ';' || j >= size || buf[j] == 0x0D) break;
        if (buf[j] == ' ') { j++; continue; } //  
        n++;
        j++;
    }
    code->count_bytes = n/2; //   -  
    dbg("count_bytes = %d",code->count_bytes);
    code->bytes = alloc(code->count_bytes);

    n=0;
    j=cur_pos;
    while (true) {
        if (buf[j] == ' ') { j++; continue; }; //  
        if (buf[j] == ';' || j >= size || buf[j] == 0x0D) return GetSymbolPosition(buf, size, j, 0x0A);

            str_byte[n]=buf[j];
            if (n+1 > 1) {
                n=0;
                str_byte[2] = 0;
                code->bytes[i] = strtoul(str_byte,NULL,16);
                dbg("byte = 0x%x", code->bytes[i]);
                i++;
            } else { n++; }

        j++;
    }
}

//  
void FreeFpaFile(FPA_FILE_T *fpa_file)
{
    UINT32 i;

    for (i=0; i < fpa_file->count_info; i++) {
        free(fpa_file->info[i].name);
        free(fpa_file->info[i].value);
    }
    free(fpa_file->info);
    for (i=0; i < fpa_file->count_code; i++) {
        free(fpa_file->code[i].bytes);
    }
    free(fpa_file->code);
}


//    c
UINT32 GetSymbolPosition(BYTE *buf, UINT32 size, UINT32 cur_pos, char c)
{
    int j=cur_pos;
    while(true) {
        if (j >= size) return 0; 
        if (buf[j] == c) return j; //  
        j++;
    }
}

void CopyStr(char *dst, char *src, UINT32 num)
{
    UINT32 i;
    for (i=0; i < num; i++) src[i]=dst[i];
    src[i]=0;
}

void * alloc(UINT32 size)
{
    INT32 er; 
    void *ptr; 
    ptr = suAllocMem( size, &er ); 
    if (er==0) return ptr; 
    else  return NULL;  
}
