#include "GUI.h"
#include "fpaParser.h"
#include "iniParser.h"
#include <dbg.h>

UINT32                  CG1_begin = 0x80000;
FPA_FILE_T              fpa_file;
WCHAR                   file_open[256];
RESULT_PATCH_T          res_patch;

/*     */
RESOURCE_ID Resources[RES_MAX];

/*  .        */
const char app_name[APP_NAME_LEN] = "FlashPatcher"; 

//     state-

/*    FP_STATE_ANY (   state) */
static EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    // GUI     
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    { STATE_HANDLERS_END,           NULL           },
};

static EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    //   ,      UI
    { EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};

static EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { EV_DIALOG_DONE,               destroyApp     },
    { EV_DONE,                      destroyApp     },
    { EV_SELECT,                    usePatch       },
    { STATE_HANDLERS_END,           NULL           },
};

static EVENT_HANDLER_ENTRY_T msg_state_handlers[] =
{
    { EV_DIALOG_DONE,               destroyApp     },
    { EV_DONE,                      destroyApp     },
    { STATE_HANDLERS_END,           NULL           },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { FP_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { FP_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },
    
    { FP_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    },

    { FP_STATE_MSG,
      MsgStateEnter,
      NULL,
      msg_state_handlers
    }
};

/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 status = RESULT_OK;
    UINT32 evcode_base = reserve;    //  reserve

    WCHAR		c_ini_uri[256];
    char        temp_str[32];

    if (strlen(param)) {
        param2uri(param, file_open);
    }  else {
        file_open[0] = 0;
        return LdrUnloadELF(&Lib); //  
    }

    memset(temp_str, 0, 32);
    //   
    u_atou(file_uri, c_ini_uri);
	c_ini_uri[u_strlen(c_ini_uri)-3] = 0;
	u_strcat(c_ini_uri, L"ini");

    if (OpenINI(c_ini_uri) == RESULT_OK){
        setSeparator('=');
        ReadParamINI("CG1", temp_str, 32, "0x10080000");
        CG1_begin = strtoul(temp_str, NULL, 16);
        if (CG1_begin >= 0x10000000) CG1_begin -=  0x10000000;
        dbg("CG1_begin = 0x%x", CG1_begin);
    }
    CloseINI();
    

/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           FP_STATE_MAX,            //  
                           (void*)startApp );   // ,   

                  
    
    LdrStartApp(reserve);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_FLASHPATCHER_T     *app = NULL;
    UINT32 					status = RESULT_OK;
    

    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
        return RESULT_FAIL; //     

    //    
    app = (APP_FLASHPATCHER_T*)APP_InitAppData( (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_FLASHPATCHER_T), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );

    InitResources();

    status = APP_Start( ev_st,
                        &app->apt,
                        FP_STATE_INIT, //  
                        state_handling_table,
                        destroyApp,
                        app_name,
                        0 );




    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

    FreeFpaFile(&fpa_file);

    RemoveResources();
    /*    */
    status = APP_Exit( ev_st, app, 0 );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    main state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    CONTENT_T               content;
    UIS_DIALOG_T            dialog = 0;

    UINT32                  i;
    UINT32                  status;
    UINT32                  size_info=0;
    WCHAR                   *info;

    ACTIONS_T				action_list; // 
   

    if(type!=ENTER_STATE_ENTER) return RESULT_OK;

       
    //  
    status = ParseFpaFile(file_open, &fpa_file);
    dbg("status ParseFpaFile = %d", status);


    if (status == PARSE_OK) {
        ActionAdd(&action_list, EV_SELECT, Resources[RES_ACTION0]); //   

        //   
        for (i=0; i < fpa_file.count_info; i++) {
            size_info += strlen(fpa_file.info[i].name) + 8;
            size_info += strlen(fpa_file.info[i].value) + 8;
        }
        info = alloc(size_info*sizeof(WCHAR));
        info[0]=0;
        for (i=0; i < fpa_file.count_info; i++) {
            u_atou(fpa_file.info[i].name, info+u_strlen(info));
            u_strcat(info, L": \n");
            u_atou(fpa_file.info[i].value, info+u_strlen(info));
            u_strcat(info, L"\n\n");
        }
    } else {
        //    
        info = alloc(32*sizeof(WCHAR));
        if (status == PARSE_FILE_FAIL) {
            u_strcpy(info, L"File invalid");
        } else if (status == PARSE_MEM_FAIL) {
            u_strcpy(info, L"Memory fail");
        } else {
            u_strcpy(info, L"Error");
        }
    }

    UIS_MakeContentFromString("q0Nq1", &content, L"FlashPatcher by om2804", info); //   
    dialog = UIS_CreateViewer(&port, &content, &action_list);
    //dialog = UIS_CreateTransientNotice( &port, &content, NOTICE_TYPE_OK );

    free(info);
    if(dialog == 0) return RESULT_FAIL;
    papp->dialog = dialog;
   

    return RESULT_OK;
}

/*    main state */
UINT32 MsgStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    CONTENT_T               content;
    UIS_DIALOG_T            dialog = 0;



    if(type!=ENTER_STATE_ENTER) return RESULT_OK;

    if (res_patch == PATCH_OK) {
        UIS_MakeContentFromString("Cq0", &content, L"Ok"); //   
        dialog = UIS_CreateTransientNotice( &port, &content, NOTICE_TYPE_OK );
    } else if (res_patch == PATCH_MEM_FAIL) {
        UIS_MakeContentFromString("Cq0", &content, L"Memory fail"); //   
        dialog = UIS_CreateTransientNotice( &port, &content, NOTICE_TYPE_FAIL );
    } else {
        UIS_MakeContentFromString("Cq0", &content, L"fail"); //   
        dialog = UIS_CreateTransientNotice( &port, &content, NOTICE_TYPE_FAIL );
    }

    if(dialog == 0) return RESULT_FAIL;
    papp->dialog = dialog;
   

    return RESULT_OK;
}

UINT32 usePatch( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32                  i, j, k, l;
    UINT32                  badr = 0;
    UINT32                  mask;
    BLOCK_T                 block;
    UINT32                  status;

    INT32                  *nums; //     
    UINT32                  n=0;


    APP_ConsumeEv(ev_st, app);

       

    nums = alloc(fpa_file.count_code*sizeof(INT32));
    memset(nums, -1, fpa_file.count_code*sizeof(INT32));

    for (i=0; i < fpa_file.count_code; i++) {
        //   
        for (j=0; j < fpa_file.count_code; j++) if (i == nums[j]) break;
        if (j < fpa_file.count_code) continue; //  

        badr = getBlockAdr(fpa_file.code[i].adress+CG1_begin);
        dbg("badr = 0x%x", badr);

        status = CopyBlock(badr, &block);
        dbg("status CopyBlock = %d", status);


        if(status == RESULT_OK) {

            //    
            for (k=i; k < fpa_file.count_code; k++) {
                if (badr == getBlockAdr(fpa_file.code[k].adress+CG1_begin)){
                    nums[n] = k; n++;
                    dbg("num = %d",k);
                    dbg("count_bytes = %d", fpa_file.code[k].count_bytes);
                    for (l=0; l  < fpa_file.code[k].count_bytes; l++) {
                        SetValue(&block, fpa_file.code[k].adress+CG1_begin+l, fpa_file.code[k].bytes[l]);
                    }
                }
            }
    
            mask = suDisableAllInt(); //  
    
            FlashDevEraseBlock(badr); //   

            WriteBlock(badr, block); //  
   
            suSetInt(mask); //  

            FreeBlock(&block); //  
            
            res_patch = PATCH_OK;

        } else {
            res_patch = PATCH_MEM_FAIL;
            break;
        }

    }

    
    free(nums);

    APP_UtilChangeState( FP_STATE_MSG,  ev_st,  app ); //    

    return RESULT_OK;
}

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    //    
    status = APP_HandleUITokenGranted( ev_st, app );

    //   ,   state
    if( (status == RESULT_OK) && (papp->token_status == 2) )
    {
        status = APP_UtilChangeState( FP_STATE_MAIN, ev_st, app );
    }

    return status;
}

/*           */
UINT32 InitResources( )
{
    RES_ACTION_LIST_ITEM_T		action;

    memclr(&action, sizeof(RES_ACTION_LIST_ITEM_T));

    #if (defined(L7e) || defined(L9))
    action.list_label = LANG_USE;			//   
    action.list_priority = 2;
    #else 
    action.softkey_label = LANG_USE;			//   -
    action.softkey_priority = 1;
    #endif

    return DRM_CreateResource( &Resources[RES_ACTION0], RES_TYPE_ACTION, (void*)&action, sizeof(RES_ACTION_LIST_ITEM_T));
}

/*        */
UINT32 RemoveResources( )
{
	UINT32				status = RESULT_OK;
	UINT32				i;

	for(i=0;i<RES_MAX;i++)
		status |= DRM_ClearResource( Resources[i] );

	return status;
}
//      
UINT32 OneAction( ACTIONS_T * list, EVENT_CODE_T event, RESOURCE_ID res, UINT8 op )
{
	if ( list == NULL || list->count >= 16 )
		return RESULT_FAIL;
	list->action[list->count].operation = op;
	list->action[list->count].event = event;
	list->action[list->count].action_res = res;
	list->count++;
	return RESULT_OK;
}

UINT32 ActionAdd( ACTIONS_T * list, EVENT_CODE_T event, RESOURCE_ID res )
{
	return OneAction(list, event, res, ACTION_OP_ADD);
}

UINT32 ActionUpd( ACTIONS_T * list, EVENT_CODE_T event, RESOURCE_ID res )
{
	return OneAction(list, event, res, ACTION_OP_UPDATE);
}

//    128 
UINT32 CopyBlock(UINT32 adr, BLOCK_T *block)
{
    int i, j;
    memset(block, 0, sizeof(BLOCK_T)); //  
    for (i=0; i < COUNT_SEGMENT; i++) {
        block->segment[i] = alloc(SEGMENT_SIZE);
        if (block->segment[i] == NULL) {
            dbg("malloc fail on %d segment", i);
            for (j=i-1; j > 0; j--) {
                free(block->segment[j]);
            }
            return RESULT_FAIL;
        }
    }

    //  
    for (i=0; i < COUNT_SEGMENT; i++) {
        dbg("copy segment %d", i);
        memcpy(block->segment[i], (UINT8*)(adr+0x10000000+SEGMENT_SIZE*i), SEGMENT_SIZE);
    }

    return RESULT_OK;
}

//  
void FreeBlock(BLOCK_T *block)
{
    int i;
    for (i=0; i < COUNT_SEGMENT; i++)      
        free(block->segment[i]);
}

UINT32 WriteBlock(UINT32 adr, BLOCK_T block)
{
    int i;
    for (i=0; i < COUNT_SEGMENT; i++) {
        FlashDevWrite(block.segment[i], adr+SEGMENT_SIZE*i, SEGMENT_SIZE);
    }
    return RESULT_OK;
}

void SetValue(BLOCK_T *block, UINT32 adr, BYTE value)
{
    UINT32 badr;
    UINT32 n;
    UINT32 oadr;
    UINT32 adr_badr;


    badr = getBlockAdr(adr);
    adr_badr = adr - badr;
    n = adr_badr/SEGMENT_SIZE; //  
    oadr = adr_badr - n*SEGMENT_SIZE;
    
/*
    dbg("\n adr = 0x%x", adr);
    dbg("badr = 0x%x", badr);
    dbg("adr_badr = 0x%x", adr_badr);
    dbg("n =%d", n);
    dbg("oadr=0x%x", oadr);
    dbg("value = 0x%x\n", value);
*/
    block->segment[n][oadr] = value; 
}


//   
UINT32 getBlockAdr(UINT32 adr)
{
    return (adr/BLOCK_SIZE)*BLOCK_SIZE;
}


UINT32 util_asc2ul( const char * s, UINT32 count )
{
    char    b;
    UINT32    res = 0;
    
    while ( count > 0 ) {
        b = *s++;
        if ( b >= '0' && b <= '9' ) {
            b -= '0';
        } else if ( b >= 'A' && b <= 'F' ) {
            b = b - 'A' + 10;
        } else if ( b >= 'a' && b <= 'f' ) {
            b = b - 'a' + 10;
        } else
            b = 0;
        res = res << 4;
        res |= b;
        count--;
    }
    
    return res;
}

UINT32 param2uri(char *param, WCHAR *uri)
{
    _u64                    tmp;
    DL_FS_MID_T             fid;

    if (strlen(param) > 16) { //  
        u_atou(param, uri);
    } else { // id
        tmp.R0 = util_asc2ul(param+0, 8);
        tmp.R1 = util_asc2ul(param+8, 8);
    
        if (tmp.R0==0 && tmp.R1==0) {
            u_atou(param, uri);
        } else {
            memcpy(&fid, &tmp, sizeof(UINT64));
            DL_FsGetURIFromID( &fid, uri );
        }
    }
    return RESULT_OK;
}
