#include "GUI.h"
#include "INIparser.h"
#include <dbg.h>

UIS_DIALOG_T            dialog;
DRAWING_BUFFER_T		bufd; //   
WCHAR					rec_folder[256]; //  

/*  .        */
const char app_name[APP_NAME_LEN] = "Dictaphone"; 


static EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    /* GUI-     */
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    { STATE_HANDLERS_END,           NULL           },
};

static EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    /*   ,      UI */
    { EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};

static EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
   
    { EV_INK_KEY_PRESS,             HandleKeypress },
    { EV_TIMER_EXPIRED,       	             Timer },
    { EV_MME_OPEN_SUCCESS,             StartRecord },
    { EV_MME_PLAY_COMPLETE,         RecordComplete },

    { STATE_HANDLERS_END,                     NULL },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { DP_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { DP_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },
    
    { DP_STATE_MAIN,
      MainStateEnter,
      StateExit,
      main_state_handlers
    }
};




/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32      status = RESULT_OK;
    /*       ""  */
    UINT32      evcode_base= reserve; //  reserve
    UINT16      i;
    WCHAR		c_ini_uri[256];
    char        temp_folder[256];

    memset(temp_folder, 0, 256);

     //   
    u_atou(file_uri, c_ini_uri);
	c_ini_uri[u_strlen(c_ini_uri)-3] = 0;
	u_strcat(c_ini_uri, L"ini");

    if (OpenINI(c_ini_uri) == RESULT_OK){
        setSeparator('=');
        ReadParamINI("Path", temp_folder, 256, "/");
        dbg("Path = %s", temp_folder);
        if (temp_folder[0] == '/' && temp_folder[1] == 0 ) {
            //   
            u_atou(file_uri, rec_folder);
            for (i=u_strlen(rec_folder)-1; i > 0 ; i--){
                if (rec_folder[i] == '/') break;
                rec_folder[i] = 0;
            }
        } else if (temp_folder[0] == '/' && temp_folder[2] != '/' && temp_folder[4] != ':') {
            //    
            //   
            u_atou(file_uri, rec_folder);
            for (i=u_strlen(rec_folder)-1; i > 0 ; i--){
                if (rec_folder[i] == '/') {rec_folder[i] = 0; break; }
                rec_folder[i] = 0;
            }
            u_atou(temp_folder, rec_folder+i);
        } else {
            //  
            u_atou(temp_folder, rec_folder);
        }
        CloseINI();
    } else {
        //   
            u_atou(file_uri, rec_folder);
            for (i=u_strlen(rec_folder)-1; i > 0 ; i--){
                if (rec_folder[i] == '/') break;
                rec_folder[i] = 0;
            }
    }
    udbg("rec_folder = %s", rec_folder);

    /*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           DP_STATE_MAX,            //  
                           (void*)startApp );   // ,   
    
	
	LdrStartApp(evcode_base);   //  

    	
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_DICTAPHONE_T    *app = NULL;
    UINT32          	status = RESULT_OK;

    /*   GUI  */
    app = (APP_DICTAPHONE_T*)APP_InitAppData( (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_DICTAPHONE_T), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );
   
	//  
    status = APP_Start( ev_st,
                        &app->apt,
                        DP_STATE_INIT, //  
                        state_handling_table,
                        destroyApp,
                        app_name,
                        0 );
						
	// init app
	app->mhandle = NULL;
	app->time = 0;
    app->state = STOP;


    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32              status;
    APPLICATION_T       *papp = (APPLICATION_T*) app;

    StopRecord(ev_st, app);
    APP_UtilUISDialogDelete(  &papp->dialog ); //  

    /*    */
    status = APP_Exit( ev_st, app, 0 );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}



UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    //    
    status = APP_HandleUITokenGranted( ev_st, app );

    //   ,   state
    if( (status == RESULT_OK) && (papp->token_status == 2) )
        status = APP_UtilChangeState( DP_STATE_MAIN, ev_st, app );


    return status;
}

/*    main state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;
    
	if(type!=ENTER_STATE_ENTER) return RESULT_OK;

    bufd.w = 176;
    bufd.h = 220;
    bufd.buf = NULL;

	dialog = UIS_CreateColorCanvas ( &port, &bufd, TRUE ); //  

    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;

	paint(ev_st, app);

    return RESULT_OK;
}

UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}

UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T             *event = AFW_GetEv(ev_st);
	APP_DICTAPHONE_T 	*papp = (APP_DICTAPHONE_T*)app;

    APP_ConsumeEv( ev_st, app );

    switch (event->data.key_pressed)
	{
    case KEY_LSOFT:
    case KEY_RED:
        return destroyApp(ev_st,app);
        break;

    case KEY_RSOFT:
        if (papp->state == STOP) {
            CaptureCreate(ev_st,app);
        } else {
            StopRecord(ev_st,app);
        }
        
        break;

    }

    paint(ev_st,app);

    return RESULT_OK;
}

void paint(EVENT_STACK_T *ev_st,  void *app)
{
	APP_DICTAPHONE_T 	*papp = (APP_DICTAPHONE_T*)app;
    WCHAR   			str[64];

    // 
	SetFillColor(0xFFFFFF00);
    FillRect(0, 0, bufd.w, bufd.h);

    SetForegroundColor(0x00000000);
    switch (papp->state) {
    case STOP:
        SetForegroundColor(0x0000FF00);
        DrawRect(3, 3, 16, 16); // 
        GetResourceString(str, LANG_RECORD);
        DrawText(str, bufd.w-3, bufd.h-20, ANCHOR_RIGHT | ANCHOR_TOP); // 
        break;

    case RECORD:
        SetForegroundColor(0xFF000000);
        DrawArc(3, 3, 16, 16); // 
        //  
        DL_FsSGetFileNameWithExt(papp->uri, str);
        DrawText(str, 3, 3+20, ANCHOR_LEFT | ANCHOR_TOP);
        GetResourceString(str, LANG_STOP); // 
        DrawText(str, bufd.w-3, bufd.h-20, ANCHOR_RIGHT | ANCHOR_TOP);
        break;
    }

    // 
    sec2hms(papp->time,str);
    SetForegroundColor(0x00000000);
    DrawText(str, 3+16+5, 3, ANCHOR_LEFT | ANCHOR_TOP);

    // - 
    GetResourceString(str, LANG_EXIT);
    DrawText(str, 3, bufd.h-20, ANCHOR_LEFT | ANCHOR_TOP);
}

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
	APP_DICTAPHONE_T 	*papp = (APP_DICTAPHONE_T*)app;
    UINT32         		t_id = ((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID;


	if (t_id == 1)
	{
		papp->time++;
		paint(ev_st, app); // 
	}

    return RESULT_OK;
}

 
UINT32 CaptureCreate(EVENT_STACK_T *ev_st,  void *app)
{
    APP_DICTAPHONE_T 	        *papp = (APP_DICTAPHONE_T*)app;
    IFACE_DATA_T                iface;
    MMSS_FILE_FORMAT_T          file_format; //  
    MMSS_MEDIA_FORMAT_T     	media_format;


    iface.port = papp->apt.port;

    file_format = MMSS_AMR;

    memset(&media_format, 0, sizeof(MMSS_MEDIA_FORMAT_T));
    media_format.media_type = MMSS_AUDIO;
    media_format.audio_format.bit_rate = 0; // default
    media_format.audio_format.audio_codec = AMR_CODEC;
    media_format.audio_format.sampling_freq = 0; // default
    media_format.audio_format.audio_mode = 0; // Mono
    
    papp->mhandle = MME_GC_capture_create(&iface, NULL, file_format, &media_format);

    dbg("mhandle = 0x%p", papp->mhandle);

    if (papp->mhandle) return RESULT_OK;
    else return RESULT_FAIL;
}

//  
UINT32 StartRecord(EVENT_STACK_T *ev_st,  void *app)
{
    APP_DICTAPHONE_T 	        *papp = (APP_DICTAPHONE_T*)app;
    UINT32                      status;

    // MME_GC_capture_set_attribute( papp->mhandle,
	//								  ATTRIBUTE_NAME_T   	attribute_name,
	//								  void  				*attribute_value );
     

    GetFileName(papp->uri);
    udbg("uri = %s", papp->uri);
    status = MME_GC_capture_start(papp->mhandle, papp->uri);
    dbg("StartRecord status = %d", status);
    if (status == RESULT_OK) {
        papp->state = RECORD;
        APP_UtilStartCyclicalTimer( 1000,  1, app ); //   
    }

    return status;
}

//  
UINT32 StopRecord(EVENT_STACK_T *ev_st,  void *app)
{
    APP_DICTAPHONE_T 	        *papp = (APP_DICTAPHONE_T*)app;
    UINT32                      status;

    status = MME_GC_capture_stop(papp->mhandle);
    status |= MME_GC_capture_delete(papp->mhandle);
    
    dbg("StopRecord status = %d", status);

    if (status == RESULT_OK) {
        papp->state = STOP;
    }

    APP_UtilStopTimer(app);
    papp->mhandle=NULL;
    papp->time=0;

    return status;
}

UINT32 RecordComplete(EVENT_STACK_T *ev_st,  void *app)
{
    MME_PLAY_COMPLETE_T         *attach = AFW_GetEv(ev_st )->attachment;
    APP_DICTAPHONE_T 	        *papp = (APP_DICTAPHONE_T*)app;

    if (papp->mhandle == attach->media_handle && papp->mhandle != NULL) {
        dbg("RecordComlete status = %d", attach->status);
        StopRecord(ev_st,app);
    }

    return RESULT_OK;
}

/// Util ///

//    
void GetFileName(WCHAR *uri)
{
    CLK_DATE_T      date;
    CLK_TIME_T      time;


	u_strcpy(uri, rec_folder);
    DL_FsMkDir( uri,  0 ); //  
    if (rec_folder[u_strlen(rec_folder)-1] != '/') u_strcat(uri, L"/"); //  ,  
	//    
    DL_ClkGetDate( &date);
    DL_ClkGetTime( &time);
	u_ltou(date.day, uri+u_strlen(uri));
    u_strcat(uri, L".");
    u_ltou(date.month, uri+u_strlen(uri));
    u_strcat(uri, L".");
    u_ltou(date.year, uri+u_strlen(uri));
    u_strcat(uri, L"_");
    u_ltou(time.hour, uri+u_strlen(uri));
    u_strcat(uri, L":");
    u_ltou(time.minute, uri+u_strlen(uri));
    u_strcat(uri, L":");
    u_ltou(time.second, uri+u_strlen(uri));
    // 
	u_strcat(uri, L".amr"); 
}


//   ::
void sec2hms(UINT32 seconds, WCHAR *str)
{
    UINT32        t, r;

    // 
    for( r='0',t=seconds; t>35999; t-=36000,r++ ); //  
    str[0] = r;
    for( r='0'; t>35999; t-=3600,r++ ); //  
    str[1] = r; //  ,     
    str[2] = ':';

    // 
    for( r='0',t=seconds; t>599; t-=600,r++ ); //  
    str[3] = r;
    for( r='0'; t>59; t-=60,r++ ); //  
    str[4] = r; //  ,     
    str[5] = ':';

    // 
    for( r='0'; t>9; t-=10,r++ ); //     
    str[6] = r;
    str[7] = '0'+t; //  ,     
    str[8] = 0;
}

//    
UINT32 GetResourceString(WCHAR *str, RESOURCE_ID resID)
{
	UINT32 resource_size;
	DRM_GetResourceLength(resID, &resource_size);
	if(resource_size > 0) DRM_GetResource(resID, str, resource_size);
	return RESULT_OK;
}
