#include "bluetooth.h"

extern  const UINT32 *EVENT_BT;


typedef struct {
    UINT32        unk1;            	// 0x05000000
    WCHAR         uri[265];
    char          content_type[50]; // size=??
    UINT32        unk2;            	// 0x00010000 if move / NULL if copy
    UINT32        unk3;            	// 0x00010000
    UINT32        unk4;            	// NULL
} send_via_bt_attach_LTE;  

typedef struct
{
     UINT8       	folder; //  5
     UINT8        	unk0[0x24C-sizeof(UINT8)-4];
     UINT16        	type; //0-copy,1-move
     UINT16       	unk4;
     DL_FS_MID_T 	*p_ids;
     UINT32        	num_files;
     UINT8        	unk1[2452-8-sizeof(UINT8)-(0x24C-sizeof(UINT8))-sizeof(DL_FS_MID_T)+1];
     UINT8        	unk2; // 1
     UINT8        	unk3[6];
} send_via_bt_attach_LTE2;

typedef struct
{
	UINT16			unk1; // = 1
	UINT8   		unk2[6];
	UINT8			unk3; // = 6
	UINT8			unk4[0x24B];
	DL_FS_MID_T 	*p_ids;
    UINT32        	num_files;
	UINT8			unk5[0x738];
} send_via_bt_attach_NEW;

UINT32 SendViaBT( WCHAR* uri, char* content_type)
{


    #if (defined(L7e) || defined(L9))
        send_via_bt_attach_NEW*        att_data_NEW;
    
        att_data_NEW = suAllocMem(sizeof(send_via_bt_attach_NEW), NULL);
    	memset (att_data_NEW, 0, sizeof(send_via_bt_attach_NEW));
    	att_data_NEW->p_ids = suAllocMem(sizeof(DL_FS_MID_T), NULL);
    	DL_FsGetIDFromURI(uri, att_data_NEW->p_ids);
    	att_data_NEW->unk1 = 1;
    	att_data_NEW->unk3 = 6;
    	att_data_NEW->num_files = 1;
        AFW_CreateInternalQueuedEvAux( *EVENT_BT, FBF_FREE, sizeof(send_via_bt_attach_NEW), att_data_NEW );

    #else 
            send_via_bt_attach_LTE*        att_data_LTE;
            send_via_bt_attach_LTE2*       att_data_LTE2;
    
        	if (namecmp((char*)LdrGetPlatformName(), "LTE"))
        	{
        		att_data_LTE = suAllocMem(sizeof(send_via_bt_attach_LTE), NULL);
        		memset (att_data_LTE, 0, sizeof(send_via_bt_attach_LTE));
        		u_strcpy(att_data_LTE->uri, uri);
                strcpy(att_data_LTE->content_type, content_type);
                att_data_LTE->unk1 = 0x05000000;    
        		att_data_LTE->unk2 = 0;				// copy
                att_data_LTE->unk3 = 0x00010000;   
        		
        		AFW_CreateInternalQueuedEvAux( *EVENT_BT, FBF_FREE, sizeof(send_via_bt_attach_LTE), att_data_LTE );
        	}
        	else
        	{
                att_data_LTE2 = suAllocMem(sizeof(send_via_bt_attach_LTE2), NULL);
        			memset (att_data_LTE2, 0, sizeof(send_via_bt_attach_LTE2));
        			att_data_LTE2->p_ids = suAllocMem(sizeof(DL_FS_MID_T), NULL);
        			DL_FsGetIDFromURI(uri, att_data_LTE2->p_ids);
        			att_data_LTE2->folder = 5;
        			att_data_LTE2->type = 0;
        			att_data_LTE2->unk2 = 1;
        			att_data_LTE2->num_files = 1;
        			
        			AFW_CreateInternalQueuedEvAux( *EVENT_BT, FBF_FREE, sizeof(send_via_bt_attach_LTE2), att_data_LTE2 );
            }
    #endif

   
   return RESULT_OK;
}

