#ifndef GUI_H
#define GUI_H

#include "Graphics.h"


typedef enum {
    RECORD,
    STOP,
    PAUSE

} DIC_STATES_T;

/*    .      */
typedef struct
{ 
    APPLICATION_T           apt; /*   ,   */
	
	MME_GC_MEDIA_FILE		mhandle;
	WCHAR					uri[272]; //   
	UINT16					time; //  
	DIC_STATES_T            state; // 

} APP_DICTAPHONE_T;

/*   */
typedef enum
{
    DP_STATE_ANY, /* ANY-state   */

    DP_STATE_INIT,
    DP_STATE_MAIN,

    DP_STATE_MAX /*   */
} DP_STATES_T;

UINT32 Register( char* file_uri,  char* param,  UINT32 reserve );
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 );
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app );

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app );
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type );
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app );

void paint(EVENT_STACK_T *ev_st,  void *app);

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app );

UINT32 CaptureCreate(EVENT_STACK_T *ev_st,  void *app);
UINT32 StartRecord(EVENT_STACK_T *ev_st,  void *app);
UINT32 StopRecord(EVENT_STACK_T *ev_st,  void *app);
UINT32 RecordComplete(EVENT_STACK_T *ev_st,  void *app);

// Util
void GetFileName(WCHAR *uri); 
void sec2hms(UINT32 seconds, WCHAR *str);

#endif
