#include "utils.h"
#include <dbg.h>

//  
void *talloc(UINT32 size) { 
    INT32 er; 
    void *ptr; 
    ptr = suAllocMem( size, &er ); 
    if (er==0) return ptr; 
    else  return NULL;  
}

//      
UINT32 file_write(WCHAR* uri, UINT8 mode, void* buffer, UINT32 size)
{
    UINT32  w, r=0, fsize;
    BYTE    *buf;
    FILE    f;

    

    if ((uri[1] == 'c' || uri[7] == 'c') && (mode == FILE_APPEND_MODE || mode == FILE_APPEND_PLUS_MODE) /*&& (DL_FsGetFileSize(f) > 0 )*/) {
        //   /c/     

        f = DL_FsOpenFile( uri,  FILE_READ_MODE,  0 );
       
        fsize = DL_FsGetFileSize(f);

        buf = talloc(fsize);
        if (buf == NULL) return 0;

        DL_FsReadFile( buf, fsize, 1, f, &r );
        DL_FsCloseFile(f);

        f = DL_FsOpenFile( uri,  FILE_WRITE_PLUS_MODE,  0 );
        DL_FsWriteFile( buf, fsize, 1, f, &w);
        DL_FsWriteFile( buffer, size, 1, f, &w);
        DL_FsCloseFile(f);

        free(buf);
        
    } else {
        dbg("standart copy",NULL);
        f = DL_FsOpenFile( uri,  mode,  0 );
        DL_FsWriteFile( buffer, size, 1, f, &w);
        DL_FsCloseFile(f); 
    }
    return w;
}


                     


//    
UINT32 GetResourceString(WCHAR *str, RESOURCE_ID resID)
{
	UINT32 resource_size;
	DRM_GetResourceLength(resID, &resource_size);
	if(resource_size > 0) DRM_GetResource(resID, str, resource_size);
	return RESULT_OK;
}



//     spliter  
WCHAR* SplitPath( WCHAR* path, WCHAR* spliter ) 
{
	int j = u_strlen(path)-2;
	while( j > 0 ) 
	{
		if ( !u_strncmp(path+j, spliter, 1) ) 
		{
			return path+j+1;
		}
		j--;
	}
	return path;
}

 // : TRUE -   , FALSE  -   
BOOL WorkingTable(void)
{
	UINT8 res;
	
	UIS_GetActiveDialogType(&res);
	
	if (res == 0xE)	{
		return TRUE;
	} else {
		return FALSE;
	}
}

 // : TRUE -  , FALSE  -   
BOOL JavaApp(void)
{
	UINT8 res;
	
	UIS_GetActiveDialogType(&res);
	
	if (res == DialogType_GameAni)
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}	
}

// : TRUE -  ., FALSE  - .
BOOL KeypadLock(void)
{
	UINT8 keypad_statate;
	DL_DbFeatureGetCurrentState( *KEYPAD_STATE, &keypad_statate );
	return keypad_statate;
}	

UINT32 util_asc2ul( const char * s, UINT32 count )
{
    char    b;
    UINT32    res = 0;
    
    while ( count > 0 ) {
        b = *s++;
        if ( b >= '0' && b <= '9' ) {
            b -= '0';
        } else if ( b >= 'A' && b <= 'F' ) {
            b = b - 'A' + 10;
        } else if ( b >= 'a' && b <= 'f' ) {
            b = b - 'a' + 10;
        } else
            b = 0;
        res = res << 4;
        res |= b;
        count--;
    }
    
    return res;
}

UINT32 param2uri(char *param, WCHAR *uri)
{
    _u64                    tmp;
    DL_FS_MID_T             fid;

    if (strlen(param) > 16) { //  
        u_atou(param, uri);
    } else { // id
        tmp.R0 = util_asc2ul(param+0, 8);
        tmp.R1 = util_asc2ul(param+8, 8);
    
        if (tmp.R0==0 && tmp.R1==0) {
            u_atou(param, uri);
        } else {
            memcpy(&fid, &tmp, sizeof(UINT64));
            DL_FsGetURIFromID( &fid, uri );
        }
    }
    return RESULT_OK;
}

//      
UINT32 OneAction( ACTIONS_T * list, EVENT_CODE_T event, RESOURCE_ID res, UINT8 op )
{
	if ( list == NULL || list->count >= 16 )
		return RESULT_FAIL;
	list->action[list->count].operation = op;
	list->action[list->count].event = event;
	list->action[list->count].action_res = res;
	list->count++;
	return RESULT_OK;
}

UINT32 ActionAdd( ACTIONS_T * list, EVENT_CODE_T event, RESOURCE_ID res )
{
	return OneAction(list, event, res, ACTION_OP_ADD);
}

UINT32 ActionDel( ACTIONS_T * list, EVENT_CODE_T event, RESOURCE_ID res )
{
	return OneAction(list, event, res, ACTION_OP_DELETE);
}

UINT32 ActionUpd( ACTIONS_T * list, EVENT_CODE_T event, RESOURCE_ID res )
{
	return OneAction(list, event, res, ACTION_OP_UPDATE);
}



