#include "ELF.h"
UINT32              evcode_base;

extern const UINT32  *CALL_ALERT;

int level=10; //  
int levelT = 10; //  
int levelMin = 1; //  

int timeWait; //  
int timeWaitT; //  
int timeActivity; //   

char nameCfgFile[64];

INT8 T; //   


//   
BOOL exitN1;
BOOL exitN2;
BOOL exitN3;

UINT8 keyexitN1;
UINT8 keyexitN2;
UINT8 keyexitN3;
int Nul; //    0

UINT32 offsetLock=0; //    
UINT8 bLock=0; // 1- ., 0-. 


/*  .        */
const char app_name[APP_NAME_LEN] = "Light"; 


//     state-

/*    HW_STATE_ANY (   state) */
 EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    { EV_KEY_PRESS,             HandleKeypress },
	{ EV_KEY_RELEASE,         HandleKeyrelease },
	{ EV_TIMER_EXPIRED,       		     Timer },
	{ NULL,								  Call },

    //      
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { STATE_HANDLERS_END,           NULL           },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }

};


/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 status = RESULT_OK;
	int i;

	any_state_handlers[3].code = *CALL_ALERT;
	
    evcode_base = reserve;    //  reserve
	
    
	

/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)startApp );   // ,   
                   
	
		//   
		for (i=0; i < strlen(file_uri)-3; i++)
		{
			nameCfgFile[i] = file_uri[i];
		}
		
		strcat(nameCfgFile, "cfg");
	
    LdrStartApp(reserve);   //  
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;
	
	WCHAR buf[64];
	UINT8 bufR[12];
	UINT32 readen;
	FILE_HANDLE_T f;
    


    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
    {
        return RESULT_FAIL; //     
    }
    else
    {
        //    
        app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEventPrepost, //    
                                                  sizeof(APP_HELLOWORLD_T), //   
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                                  2, 0, 0 );
                                                  

        status = APP_Start( ev_st,
                            &app->apt,
                            HW_STATE_MAIN, //  
                            state_handling_table,
                            destroyApp,
                            app_name,
                            0 );
		

		//    		
		if (DL_FsFFileExist( u_atou(nameCfgFile, buf)) == TRUE ) //    
		{
			f = DL_FsOpenFile(u_atou(nameCfgFile, buf), FILE_READ_MODE, 0);
			DL_FsReadFile( bufR, 4, 3, f, &readen );
			DL_FsCloseFile(f);
			
				level = bufR[1];
				levelMin = bufR[3];
				timeWait = bufR[5];
				timeActivity = bufR[7];
				
				keyexitN1 = bufR[9];
				keyexitN2 = bufR[10];
				keyexitN3 = bufR[11];
		}	
		
		//    phone.db
		offsetLock =  fReadDB(KEYPAD_LOCK);
		PFprintf("*AutoLock* offsetWorkingTable = %x\n", offsetLock ); 
				
		if (timeWait != 0) 
		{
			APP_UtilStartCyclicalTimer( 1000,  1,  app ); //  
			T = 1;
		}	
		else
		{
			APP_UtilStartCyclicalTimer(timeActivity*1000,  3,  app); //    
			T = 3;
		}
		levelT = level;
		HAPI_LP393X_disp_backlight_intensity(level); 

    }

    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

	APP_UtilStopTimer( app );
    /*    */
    status = APP_Exit( ev_st, app, NULL );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    return RESULT_OK;
}


#define create_mask(mask, sbit, len)\
    (mask = 0xFFFFFFFFL,\
     mask >>= sbit,\
     mask <<= (sizeof(mask) * 8) - len,\
     mask >>= (sizeof(mask) * 8) - (sbit + len))

#define set_data(dest, sbit, data) (dest = ((unsigned int)data) << sbit)
#define get_data(data, sbit) (data >>= sbit)

void hPCAPwrite(UINT8  port, UINT8 pin, UINT8 len, UINT8 write_data)
{
    HAPI_CAP_ACCESS hapi_cap_params;
    UINT8 num_bits = len;
    UINT8 bit_specifier = pin;

    create_mask(hapi_cap_params.mask, bit_specifier, num_bits);
    set_data(hapi_cap_params.data, bit_specifier, write_data);
    hapi_cap_params.rw = 1;
    hapi_cap_params.reg = port;
    hapi_cap_params.addr = 0;
    HAPI_PCAP_transceive(&hapi_cap_params);
}

unsigned int hPCAPread(UINT8  port, UINT8 pin, UINT8 len)
{
    unsigned int data_buffer;
    HAPI_CAP_ACCESS hapi_cap_params;
    UINT8 num_bits = len;
    UINT8 bit_specifier = pin;

    create_mask(hapi_cap_params.mask, bit_specifier, num_bits);
    set_data(hapi_cap_params.data, bit_specifier, 0);
    hapi_cap_params.rw = 0;
    hapi_cap_params.reg = port;
    hapi_cap_params.addr = &hapi_cap_params.data;
    HAPI_PCAP_transceive(&hapi_cap_params);
    data_buffer = get_data(hapi_cap_params.data, bit_specifier);
    return(data_buffer);
}

	
/*  , EV_KEY_PRESS    */
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
	UINT8       keypress;
	
	
	keypress = event->data.key_pressed;
	
	DAL_EnableDisplay( 0 ); //  
	HAPI_LP393X_disp_backlight_intensity(level); //   
	
	//     
	if (keyexitN1 != 0 && keyexitN2 != 0 && keyexitN3 != 0)
	{
		if (exitN1)
		{
			if (exitN2)
			{
				if (!exitN3) if (keypress == keyexitN3) exitN3 = TRUE;
			}
			else
			{
				if (keypress == keyexitN2) exitN2 = TRUE;
			}
		}
		else
		{
			if (keypress == keyexitN1) exitN1 = TRUE;
		}

		if (keypress != keyexitN1 && keypress != keyexitN2 && keypress != keyexitN3 )
		{
			exitN1 = FALSE;
			exitN2 = FALSE;
			exitN3 = FALSE;
		}
	}	
	
	switch (keypress)
	{
		case KEY_VOLDOWN: //  
		
		if (Nul == 1)
		{
			if (level > 0)
			{
			 
				if (level <=10) 
				{
					level -= 1;
				}
				else
				{
					level -= 5;
				}
				levelT = level;
			}
			return APP_ConsumeEv(ev_st,  app);
		}	
		break;
		
		case KEY_VOLUP: //  
		
		if (Nul == 1)
		{
			if (level < 100 ) 
			{
				
				if (level < 10) 
				{
					level += 1;
				}
				else
				{
					level += 5;
				}
				levelT = level;
			}
			return APP_ConsumeEv(ev_st,  app);
		}	
		break;
		
		
		case KEY_0:
			Nul = 1;
		break;
		
		default:
			Nul = 0;
		break;
	}
	
	levelT = level;
	timeWaitT=0;
	
	
		if (timeWait != 0 && T != 1)	
		{
			APP_UtilStopTimer( app );
			APP_UtilStartCyclicalTimer( 1000,  1,  app );
			T = 1;
		}
		
	
		if (timeWait == 0 && timeActivity != 0) 
		{
			APP_UtilStopTimer( app );
			APP_UtilStartCyclicalTimer(timeActivity*1000,  3,  app);
			T = 3;
		}	

		
	

    if(exitN1 & exitN2 & exitN3 ) return destroyApp(ev_st, app);
    
    
    return RESULT_OK;
}

UINT32 HandleKeyrelease( EVENT_STACK_T *ev_st,  void *app )
{
	timeWaitT=0;
	if (bLock == 0) 
	{
		DAL_EnableDisplay( 0 ); //  
		HAPI_LP393X_disp_backlight_intensity(level); 
	}

	return RESULT_OK;
}

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
	
	if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 1) //    
	{
		timeWaitT ++;
		HAPI_LP393X_disp_backlight_intensity(levelT);
		
		DL_DbFeatureGetCurrentState( offsetLock, &bLock  ); //    
		
		if (bLock == 1 && timeWaitT == 3) 
		{
			HAPI_LP393X_disp_backlight_intensity(0);
			APP_UtilStopTimer( app );
			timeWaitT = 0;
			if (timeActivity != 0 && timeActivity > timeWait) 
			APP_UtilStartCyclicalTimer((timeActivity )*1000,  3,  app);
			T = 3;
		}
		else
		{
			if (timeWaitT >= timeWait ) 
			{
				APP_UtilStopTimer( app );
				APP_UtilStartCyclicalTimer( 100,  2,  app );
				T = 2;
				hPCAPwrite(0x15,0,3, 0); //  
			}
		}
	}
	
	if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 2) //     
	{
		
		if (levelT > levelMin)
		{
			levelT --;
			HAPI_LP393X_disp_backlight_intensity(levelT);
		}
		else
		{
			APP_UtilStopTimer( app );
			if (timeActivity != 0 && timeActivity > timeWait) 
			APP_UtilStartCyclicalTimer((timeActivity - timeWait)*1000,  3,  app);
			T = 3;
		}
	}
	
	 if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 3) //   
	{
			APP_UtilStopTimer( app );
			levelT=0;
			HAPI_LP393X_disp_backlight_intensity(levelT);
			DAL_DisableDisplay( 0 );
	} 
	
	return RESULT_OK;
}


UINT32 Call( EVENT_STACK_T *ev_st,  void *app )
{
	DAL_EnableDisplay( 0 ); //  
	return RESULT_OK;
}
