#define DEBUG_APP_NAME				"SynTime"

#include "SynTime.h"
#include "INIparser.h"
#include "..\dbg\dbg.h"


//    
socket_f *				socket = NULL;
socket_connect_f *		socket_connect = NULL;
socket_write_f *		socket_write = NULL;
socket_read_f *			socket_read = NULL;
socket_bind_f *			socket_bind = NULL;
socket_close_f *		socket_close = NULL;
socket_delete_f *		socket_delete = NULL;


HSOCK			g_socket;

char	Server[64] = "192.43.244.18"; //time.nist.gov 
//see others at http://tf.nist.gov/timefreq/service/time-servers.html
INT8    UTC=0;

UINT8   msg_status;

/*  .        */
const char app_name[APP_NAME_LEN] = DEBUG_APP_NAME;

//   http  2   ,     ,
//     GET  ,    
//  POST       "Content-Length",    
//char sock_write_data[128];


//     state-

/*    HW_STATE_ANY (   state) */
static EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{
	//      
	{ STATE_HANDLERS_END,		NULL				},
};

static EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
	{ STATE_HANDLERS_RESERVED,	HandleAPIAnsw		},	//      socket api. (evcode_base + 0)
	{ STATE_HANDLERS_RESERVED,	HandleSockAnsw		},	//      . (evcode_base + 1)

    { STATE_HANDLERS_END,		NULL				},
};

static EVENT_HANDLER_ENTRY_T msg_state_handlers[] =
{
    { EV_DIALOG_DONE,           ELF_Exit            },
    { STATE_HANDLERS_END,		NULL				},
};

/*   ,    -  .
	   ,   enum-e */
const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
	{ HW_STATE_ANY,			// State
	  NULL,					//    state
	  NULL,					//    state
	  any_state_handlers	//   
	},

	{ HW_STATE_MAIN,
	  MainStateEnter,
	  StateExit,
	  main_state_handlers
	},

    { HW_STATE_MSG,
	  MsgStateEnter,
	  StateExit,
	  msg_state_handlers
	}
};

UINT32 LdrFindEventHandlerTbl( EVENT_HANDLER_ENTRY_T *tbl,  EVENT_HANDLER_T *hfn )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].hfunc==hfn)	
			return tbl[i].code;

		i++;
	}

	return 0;
}

UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T *tbl,  UINT32 *base )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].code==STATE_HANDLERS_RESERVED)	
			tbl[i].code = (*base)++;

		i++;
	}
	return *base;
}

/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char * file_uri, char * param, UINT32 reserve )
{
	UINT32          status = RESULT_OK;
    WCHAR		    c_ini_uri[256];
    char            strUTC[4];
    UINT32			evcode_base = reserve;


    //   
    u_atou(file_uri, c_ini_uri);
	c_ini_uri[u_strlen(c_ini_uri)-3] = 0;
	u_strcat(c_ini_uri, L"ini");	

    if (OpenINI(c_ini_uri) == RESULT_OK) {
	    setSeparator('=');
	    ReadParamINI("Server", Server, 64, "192.43.244.18");
        ReadParamINI("UTC", strUTC, 4, "0");
        UTC = (INT8)strtol( strUTC,  NULL,  10 ); 
		dbg("Server = %s", Server);
        dbg("UTC = %s", strUTC);
		CloseINI();
	}

    //  
	LdrInitEventHandlersTbl((EVENT_HANDLER_ENTRY_T *)main_state_handlers, &evcode_base);

    /*   */
	status = APP_Register( &evcode_base,			//      
						   1,						// - ,     
						   state_handling_table,	//  
						   HW_STATE_MAX,			//  
						   (void*)ELF_Start );		// ,   


	LdrStartApp(evcode_base);	//  

	
	return 1;				//    ,  
}


UINT32 ELF_Start( EVENT_STACK_T *ev_st, REG_ID_T reg_id, void * reg_hdl )
{
	APP_ELF	*	app = NULL;
	UINT32		status = RESULT_OK;
	
	dbg("ELF_Start: Enter", NULL);
	
	if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK ) {
		return RESULT_FAIL; //     
	} else {


		app = (APP_ELF *)APP_InitAppData(  (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_ELF), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );

		dbg("ELF_Start: APP_InitAppData DONE, app = 0x%p", app);
		status = APP_Start( ev_st,
							&app->apt,
							HW_STATE_MAIN, //  
							state_handling_table,
							ELF_Exit,
							app_name,
							0 );
		dbg("ELF_Start: APP_Start DONE, status = %d", status);


		
		g_socket = HSOCK_INVALID;
	}

	dbg("ELF_Start: END", NULL);
	
	return RESULT_OK;
}


/*     */
UINT32 ELF_Exit( EVENT_STACK_T *ev_st, void *app )
{
	UINT32 status;

	dbg("ELF_Exit: Enter", NULL);


    if ( g_socket != HSOCK_INVALID ) {
            //  
            status = socket_close( g_socket );
			dbg("socket_close DONE, status = %d", status);
			status = socket_delete( g_socket );
			dbg("socket_delete DONE, status = %d", status);
	}

	
	/*    */
	status = APP_Exit( ev_st,(APPLICATION_T*) app, NULL );
	dbg("ELF_Exit: APP_Exit DONE, status = %d", status);
	
	dbg("ELF_Exit: call LdrUnloadELF... END", NULL);
	/*   */
	LdrUnloadELF(&Lib); // &Lib    
	
	return status;
}



/*    state */
UINT32 MainStateEnter( EVENT_STACK_T * ev_st, void * app, ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*)app;
	ADD_EVENT_DATA_T	    add_data;
    CONTENT_T               content;

    if(type!=ENTER_STATE_ENTER) return RESULT_OK;
	dbg("MainStateEnter: type = %d, app = 0x%p", type, app);

    UIS_MakeContentFromString( "MCs0",  &content,  LANG_SYNC_WITH_SERVER );
    papp->dialog = UIS_CreateTransientNotice( &papp->port,  &content,  NOTICE_TYPE_WAIT );
    if(papp->dialog == NULL) return RESULT_FAIL;


	//  API  SynSock
	add_data.data_tag = 0;
	add_data.data.params[0] = LdrFindEventHandlerTbl( main_state_handlers, HandleAPIAnsw );		//      
	SockReqAPI(add_data);
   
	
	return RESULT_OK;
}

/*    state */
UINT32 MsgStateEnter( EVENT_STACK_T * ev_st, void * app, ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*)app;
    CONTENT_T               content;

    if(type!=ENTER_STATE_ENTER) return RESULT_OK;
	dbg("MsgStateEnter: type = %d, app = 0x%p", type, app);

    if (msg_status==RESULT_FAIL) {
        UIS_MakeContentFromString( "MCs0",  &content,  LANG_ERROR );
        papp->dialog = UIS_CreateTransientNotice( &papp->port,  &content,  NOTICE_TYPE_FAIL );
    } else {
        UIS_MakeContentFromString( "MCs0",  &content,  LANG_COMPLETE );
        papp->dialog = UIS_CreateTransientNotice( &papp->port,  &content,  NOTICE_TYPE_OK );
    }

    
    if(papp->dialog == NULL) return RESULT_FAIL;

	
	return RESULT_OK;
}

UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

    if ( type == EXIT_STATE_SUSPEND )
        return RESULT_OK;

    dbg("StateExit", NULL);

	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}


UINT32 HandleAPIAnsw( EVENT_STACK_T * ev_st, void * app )
{
	EVENT_T *	event = AFW_GetEv(ev_st);
	int			i;
	
	dbg("APIAnsw: Enter", NULL);
	
	APP_ConsumeEv( ev_st, app );
	
	socket = (socket_f *)(event->data.params[0]);
	socket_connect = (socket_connect_f *)(event->data.params[1]);
	socket_write = (socket_write_f *)(event->data.params[2]);
	socket_read = (socket_read_f *)(event->data.params[3]);
	socket_bind = (socket_bind_f *)(event->data.params[4]);
	socket_close = (socket_close_f *)(event->data.params[5]);
	socket_delete = (socket_delete_f *)(event->data.params[6]);
	
	// ,    .  ,    
	for ( i=0; i<7; i++ ) {
		if ( event->data.params[i] == NULL ) {
			return ELF_Exit(ev_st,app);
		}
	}

    if ( g_socket != HSOCK_INVALID ) 
	            return RESULT_OK; //   

	     dbg("create socket...", NULL);
	    
	                //  ,  ,     
	                //        ,         
	        g_socket = socket(SOCK_TCP, LdrFindEventHandlerTbl( main_state_handlers, HandleSockAnsw ));

	        //      ,        
	        //  -     8
	        if ( g_socket == HSOCK_INVALID ) {
	            dbg("can't create socket", NULL);
                msg_status=RESULT_FAIL;
                return APP_UtilChangeState( HW_STATE_MSG,  ev_st,  app );
			}

	
	return RESULT_OK;
}

UINT32 HandleSockAnsw( EVENT_STACK_T *ev_st, void *app )
{
    //UINT32      status;
	EVENT_T *	event = AFW_GetEv(ev_st);
	UINT32		answ = event->data.params[0];
    char        request[128];
	char 		*data;
    UINT32		wr;
    INT32       len;

	
	if ( answ == SOCK_ANSW_CREATE ) {
		//  
		dbg("SockAnsw: CREATE, status = %d", event->data.params[1]);

       
        //  
        if ( g_socket != HSOCK_INVALID ) {
				if ( socket_connect(g_socket, Server, 13) != -1 ) {
					dbg("socket_connect OK...", NULL);
				} else {
					dbg("socket_connect ERROR", NULL);
                    msg_status=RESULT_FAIL;
                    return APP_UtilChangeState( HW_STATE_MSG,  ev_st,  app );
				}
		}
		
	} else if ( answ == SOCK_ANSW_READY ) {
		//    
		dbg("SockAnsw: READY", NULL);

        //    
        if ( g_socket != HSOCK_INVALID ) {

            strcpy(request, "\r\n");
            data = (char*)request;

                len = strlen(data);		//  
				while ( len > 0 ) {
					wr = socket_write(g_socket, data, len);
					dbg("socket_write DONE, %d", wr);
					if ( wr == -1 ) {
						//   
						dbg("socket is not ready %d", g_socket);
						break;
					} else if ( wr == 0 && len > 0 ) {
						//  ...
						dbg("can't write to socket", NULL);
						break;
					}
					len -= wr;
					data+= wr;
				}
		}
		
	} else if ( answ == SOCK_ANSW_DATA ) {
		//  
		dbg("SockAnsw: DATA", NULL);
		
		if ( g_socket != HSOCK_INVALID ) {
			len = 128;
				len = socket_read( g_socket, request, 128 );
                if (SyncTime(request) == RESULT_OK) {
                    msg_status=RESULT_OK;
                } else {
                    msg_status=RESULT_FAIL;
                }
				dbg("socket_read DONE, len = %d\n", len);
                return APP_UtilChangeState( HW_STATE_MSG,  ev_st,  app );
        }
		
	} else if ( answ == SOCK_ANSW_DELETE ) {
		//   - 
		dbg("SockAnsw: DELETE", NULL);
		g_socket = HSOCK_INVALID;
        msg_status=RESULT_FAIL;
        return APP_UtilChangeState( HW_STATE_MSG,  ev_st,  app );
        
		
	} else if ( answ == SOCK_ANSW_ERROR ) {
		// 
		dbg("SockAnsw: ERROR", NULL);
        msg_status=RESULT_FAIL;
        return APP_UtilChangeState( HW_STATE_MSG,  ev_st,  app );
	}
	
	return RESULT_OK;
}

UINT32 SyncTime(char *buf)
{
    UINT32      t0;
    UINT32      dy,dm,dd, th,tm,ts;
    UINT32      tt,l,h;
    CLK_DATE_T  date;
    CLK_TIME_T  time;
    int num;

    dbg("%s", buf);

    // Daytime Protocol (RFC-867) http://tf.nist.gov/service/its.htm
    //format ACTS : JJJJJ YR-MO-DA HH:MM:SS TT L H msADV UTC(NIST) OTM
    //example of ans: 54462 07-12-28 18:55:44 00 0 0 744.7 UTC(NIST) *
    num = sscanf (buf,"%d %d-%d-%d %d:%d:%d %d %d %d",&t0,&dy,&dm,&dd,&th,&tm,&ts,&tt,&l,&h);
    dbg("num = %d", num);
    if (h > 2 || num < 7) return RESULT_FAIL; //      :(   5 


    dbg("%d", t0);
    dbg("%d", dy);
    dbg("%d", dm);
    dbg("%d", dd);
    dbg("%d", th);
    dbg("%d", tm);
    dbg("%d", ts);

    date.year = 2000 + dy;
    date.month = dm;
    date.day = dd;

    if ((INT8)th + UTC < 0) {
        time.hour = 24 + th + UTC;
    } else if (th + UTC > 23) {
        time.hour = th + UTC - 24;
    } else {
        time.hour = th + UTC;
    }
    time.minute = tm;
    time.second = ts;


    DL_ClkSetDate( date );
    DL_ClkSetTime( time );

    return RESULT_OK;
}





