#ifndef FPAPARSER_H
#define FPAPARSER_H

#include <apps.h>

extern BOOL             Use_Undo;

typedef struct {
	char 		*name;
	char		*value;
} PARAM_INFO_T; //  

typedef struct {
	UINT32 		adress;
	BYTE		*bytes;
	UINT32		count_bytes;
} PARAM_CODE_T; //  

typedef struct {
	UINT32 		adress;
	BYTE		*bytes;
	UINT32		count_bytes;
} PARAM_UNDO_T; //  

typedef struct {
	PARAM_INFO_T	*info;
    UINT32          count_info;
	PARAM_CODE_T	*code;
    UINT32          count_code;
    PARAM_UNDO_T    *undo;
    UINT32          count_undo;
} FPA_FILE_T;

typedef enum {
    PARSE_OK,
    PARSE_FAIL,
    PARSE_FORMAT_FAIL,
    PARSE_MEM_FAIL,
    PARSE_FILE_FAIL

} RESULT_PARSE_T;

RESULT_PARSE_T ParseFpaFile(WCHAR *name, FPA_FILE_T *fpa_file);
RESULT_PARSE_T ParseBytes(BYTE *buf, UINT32 size, UINT32 cur_pos, PARAM_CODE_T *code, UINT32 *pos);
void FreeFpaFile(FPA_FILE_T *fpa_file);
UINT32 GetSymbolPosition(BYTE *buf, UINT32 size, UINT32 cur_pos, char c);
void * alloc(UINT32 size);
void CopyStr(char *dst, char *src, UINT32 num);
BOOL CmpStr(char *dst, char *src, UINT32 num);
#endif
