#include "fpaParser.h"
#include <dbg.h>

BOOL                    Use_Undo = true;

//  fpa 
RESULT_PARSE_T ParseFpaFile(WCHAR *name, FPA_FILE_T *fpa_file) 
{
    UINT32          status=PARSE_OK;
    FILE  	 		f;
    UINT32          r;
	BYTE 			*buf;
	UINT32			size;
	UINT32			i, j, k;
    UINT8			section=0;

    UINT32          n=0; //    
    char            temp_str[32]; //  


	//   
	f = DL_FsOpenFile(name, FILE_READ_MODE, 0);
    if (f == FILE_INVALID) return PARSE_FILE_FAIL; //    
	size = DL_FsGetFileSize(f);
	buf = alloc(size); //    
    if (!buf) return PARSE_MEM_FAIL; //    

	DL_FsReadFile(buf, 1, size, f, &r); //   
	DL_FsCloseFile(f);

    //  
	i=0;
    j=0;
	section=0;
    memset(fpa_file,0,sizeof(FPA_FILE_T));

	while (i<size) {

        if (buf[i] == 0x0A || buf[i] == 0x0D) { i++; continue; } // 

        //    '['
        if (buf[i] == '[') {
                //   
				if (CmpStr((char*)buf+i+1, "Patch_Info", 10)) {
                    dbg("Patch_Info", NULL);
                    section=1;
                } else if (CmpStr((char*)buf+i+1, "Patch_Code", 10)) {
                    dbg("Patch_Code", NULL);
                    section=2;
                } else if (CmpStr((char*)buf+i+1, "Patch_Undo", 10)) {
                    dbg("Patch_Undo", NULL);
                    if (Use_Undo) section=3;
                    else section=0;
                } else {
                    dbg("Unk", NULL);
                    section=0;
                }
                i = GetSymbolPosition(buf, size, i, 0x0A); //    
                if (!i) {status = PARSE_FORMAT_FAIL; break;} //   
                i++;
		}

		if (section == 1) { //  Patch_Info

            //  -   
            if (fpa_file->count_info == 0) {
                n=0;
                k=i;
                while(true) {
                    j = GetSymbolPosition(buf,size,k,0x0A);
                    if (j-k > 4) fpa_file->count_info++; //    
                    if (j == 0 || buf[j+1] == '[') break;
                    k=j+1;
                }
                dbg("count_info = %d", fpa_file->count_info);
                fpa_file->info = alloc(fpa_file->count_info*sizeof(PARAM_INFO_T)); //     
                if (fpa_file->info == NULL) return PARSE_MEM_FAIL;
            }
            
            j = GetSymbolPosition(buf,size,i,'='); //   
            if (j != 0) {
            //   
               fpa_file->info[n].name = alloc(j-i+1);
               if (!fpa_file->info[n].name) {status = PARSE_MEM_FAIL; break;}

               CopyStr((char*)(buf+i), fpa_file->info[n].name, j-i);
               dbg("name = %s", fpa_file->info[n].name);
               i = j+1;
               //   
               j = GetSymbolPosition(buf,size,i,0x0D);
               if (j == 0) j = size;
                   //   
                   fpa_file->info[n].value = alloc(j-i+1);
                   if (!fpa_file->info[n].value) {status = PARSE_MEM_FAIL; break;}

                   CopyStr((char*)(buf+i), fpa_file->info[n].value, j-i);
                   dbg("value = %s", fpa_file->info[n].value);
                   i = j+1;
                   n++;
            }
             

		} else if (section == 2) { //  Patch_Code

            //  -   
            if (fpa_file->count_code == 0) {
                n=0;
                k=i;
                while(true) {
                    j = GetSymbolPosition(buf,size,k,0x0A);
                    if (j == 0) j = size;
                    if (j-k > 4) fpa_file->count_code++;
                    if (j == size || buf[j+1] == '[') break;
                    k=j+1;
                }
                dbg("count_code = %d", fpa_file->count_code);
                fpa_file->code = alloc(fpa_file->count_code*sizeof(PARAM_CODE_T)); //     
                if (fpa_file->code == NULL) {status = PARSE_MEM_FAIL; break;}
            }

            j = GetSymbolPosition(buf,size,i,':'); //   
            if (j != 0){
               //  
               CopyStr((char*)(buf+i), temp_str, j-i);
               fpa_file->code[n].adress =  strtoul(temp_str, NULL, 16);
               dbg("num code = %d",n);
               dbg("adress = 0x%x", fpa_file->code[n].adress);
               i = j+1;
               //  
               status = ParseBytes(buf, size, i, fpa_file->code+n, &j);
               if (status == PARSE_MEM_FAIL) break;
               
               if (j == 0) j = size;
               i = j;
               n++;
            }

		} else if (section == 3) { //  Patch_Undo

            //  -   
            if (fpa_file->count_undo == 0) {
                n=0;
                k=i;
                while(true) {
                    j = GetSymbolPosition(buf,size,k,0x0A);
                    if (j == 0) j = size;
                    if (j-k > 4) fpa_file->count_undo++;
                    if (j == size || buf[j+1] == '[') break;
                    k=j+1;
                }
                dbg("count_undo = %d", fpa_file->count_undo);
                fpa_file->undo = alloc(fpa_file->count_undo*sizeof(PARAM_UNDO_T)); //     
                if (fpa_file->undo == NULL) {status = PARSE_MEM_FAIL; break;}
            }

            j = GetSymbolPosition(buf,size,i,':'); //   
            if (j != 0){
               //  
               CopyStr((char*)(buf+i), temp_str, j-i);
               fpa_file->undo[n].adress =  strtoul(temp_str, NULL, 16);
               dbg("num undo = %d",n);
               dbg("adress = 0x%x", fpa_file->undo[n].adress);
               i = j+1;
               //  
               status = ParseBytes(buf, size, i, (PARAM_CODE_T*)(fpa_file->undo+n), &j);
               if (status == PARSE_MEM_FAIL) break;
               
               if (j == 0) j = size;
               i = j;
               n++;
            }
		}

		i++;
	}
    
	free(buf);

    return status;
}



//   
RESULT_PARSE_T ParseBytes(BYTE *buf, UINT32 size, UINT32 cur_pos, PARAM_CODE_T *code, UINT32 *pos)
{
    UINT32 j=cur_pos;
    UINT32 n=0;
    UINT32 i=0;
    char   str_byte[4];

    //  -     
    while (true) {
        if (buf[j] == ';' || j >= size || buf[j] == 0x0D) break;  //  
        if (buf[j] == ' ') { j++; continue; } //  
        n++;
        j++;
    }
    code->count_bytes = n/2; //   -  
    dbg("count_bytes = %d",code->count_bytes);
    code->bytes = alloc(code->count_bytes);
    if (!code->bytes) return PARSE_MEM_FAIL;


    //  
    n=0;
    j=cur_pos;
    while (true) {
        if (buf[j] == ' ') { j++; continue; }; //  
        if (buf[j] == ';' || j >= size || buf[j] == 0x0D) {
            *pos = GetSymbolPosition(buf, size, j, 0x0A);
            return PARSE_OK;
        }

            str_byte[n]=buf[j]; //  
            if (n+1 > 1) {
                n=0;
                str_byte[2] = 0;
                code->bytes[i] = strtoul(str_byte,NULL,16);
                dbg("byte = 0x%x", code->bytes[i]);
                i++;
            } else { n++; }

        j++;
    }
}

//  
void FreeFpaFile(FPA_FILE_T *fpa_file)
{
    UINT32 i;

    dbg("Free FpaFile", NULL);

    if (fpa_file->info) {
        for (i=0; i < fpa_file->count_info; i++) {
            free(fpa_file->info[i].name);
            free(fpa_file->info[i].value);
        }
        free(fpa_file->info);
    }

    if (fpa_file->code) {
        for (i=0; i < fpa_file->count_code; i++) {
            free(fpa_file->code[i].bytes);
        }
        free(fpa_file->code);
    }

    if (fpa_file->undo) {
        for (i=0; i < fpa_file->count_undo; i++) {
            free(fpa_file->undo[i].bytes);
        }
        free(fpa_file->undo);
    }
}


//    c
UINT32 GetSymbolPosition(BYTE *buf, UINT32 size, UINT32 cur_pos, char c)
{
    int j=cur_pos;
    while(true) {
        if (j >= size) return 0; 
        if (buf[j] == c) return j; //  
        j++;
    }
}

//      
BOOL CmpStr(char *dst, char *src, UINT32 num)
{
    UINT32 i;
    for (i=0; i < num; i++) {
        if (tolower(dst[i]) != tolower(src[i])) break;
    }
    if (i >= num) return true;
    else return false;
}

//  
void CopyStr(char *dst, char *src, UINT32 num)
{
    UINT32 i;
    for (i=0; i < num; i++) src[i]=dst[i];
    src[i]=0;
}

//  
void * alloc(UINT32 size)
{
    INT32 er; 
    void *ptr; 
    ptr = suAllocMem( size, &er ); 
    if (er==0) return ptr; 
    else  return NULL;  
}
